/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.pqc.crypto.mceliece;

import cn.org.bjca.gaia.pqc.crypto.mceliece.McElieceCCA2PrivateKeyParameters;
import cn.org.bjca.gaia.pqc.crypto.mceliece.McElieceCCA2PublicKeyParameters;
import cn.org.bjca.gaia.pqc.math.linearalgebra.GF2Matrix;
import cn.org.bjca.gaia.pqc.math.linearalgebra.GF2Vector;
import cn.org.bjca.gaia.pqc.math.linearalgebra.GF2mField;
import cn.org.bjca.gaia.pqc.math.linearalgebra.GoppaCode;
import cn.org.bjca.gaia.pqc.math.linearalgebra.Permutation;
import cn.org.bjca.gaia.pqc.math.linearalgebra.PolynomialGF2mSmallM;
import cn.org.bjca.gaia.pqc.math.linearalgebra.Vector;

final class McElieceCCA2Primitives {
    private McElieceCCA2Primitives() {
    }

    public static GF2Vector encryptionPrimitive(McElieceCCA2PublicKeyParameters pubKey, GF2Vector m3, GF2Vector z) {
        GF2Matrix matrixG = pubKey.getG();
        Vector mG = matrixG.leftMultiplyLeftCompactForm(m3);
        return (GF2Vector)mG.add(z);
    }

    public static GF2Vector[] decryptionPrimitive(McElieceCCA2PrivateKeyParameters privKey, GF2Vector c) {
        int k = privKey.getK();
        Permutation p = privKey.getP();
        GF2mField field = privKey.getField();
        PolynomialGF2mSmallM gp = privKey.getGoppaPoly();
        GF2Matrix h2 = privKey.getH();
        PolynomialGF2mSmallM[] q = privKey.getQInv();
        Permutation pInv = p.computeInverse();
        GF2Vector cPInv = (GF2Vector)c.multiply(pInv);
        GF2Vector syndVec = (GF2Vector)h2.rightMultiply(cPInv);
        GF2Vector errors = GoppaCode.syndromeDecode(syndVec, field, gp, q);
        GF2Vector mG = (GF2Vector)cPInv.add(errors);
        mG = (GF2Vector)mG.multiply(p);
        errors = (GF2Vector)errors.multiply(p);
        GF2Vector m3 = mG.extractRightVector(k);
        return new GF2Vector[]{m3, errors};
    }
}

