/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.pqc.crypto.mceliece;

import cn.org.bjca.gaia.crypto.AsymmetricCipherKeyPair;
import cn.org.bjca.gaia.crypto.AsymmetricCipherKeyPairGenerator;
import cn.org.bjca.gaia.crypto.CryptoServicesRegistrar;
import cn.org.bjca.gaia.crypto.KeyGenerationParameters;
import cn.org.bjca.gaia.pqc.crypto.mceliece.McElieceCCA2KeyGenerationParameters;
import cn.org.bjca.gaia.pqc.crypto.mceliece.McElieceCCA2Parameters;
import cn.org.bjca.gaia.pqc.crypto.mceliece.McElieceCCA2PrivateKeyParameters;
import cn.org.bjca.gaia.pqc.crypto.mceliece.McElieceCCA2PublicKeyParameters;
import cn.org.bjca.gaia.pqc.math.linearalgebra.GF2Matrix;
import cn.org.bjca.gaia.pqc.math.linearalgebra.GF2mField;
import cn.org.bjca.gaia.pqc.math.linearalgebra.GoppaCode;
import cn.org.bjca.gaia.pqc.math.linearalgebra.Permutation;
import cn.org.bjca.gaia.pqc.math.linearalgebra.PolynomialGF2mSmallM;
import java.security.SecureRandom;

public class McElieceCCA2KeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    public static final String OID = "1.3.6.1.4.1.8301.3.1.3.4.2";
    private McElieceCCA2KeyGenerationParameters mcElieceCCA2Params;
    private int m;
    private int n;
    private int t;
    private int fieldPoly;
    private SecureRandom random;
    private boolean initialized = false;

    private void initializeDefault() {
        McElieceCCA2KeyGenerationParameters mcCCA2Params = new McElieceCCA2KeyGenerationParameters(CryptoServicesRegistrar.getSecureRandom(), new McElieceCCA2Parameters());
        this.init(mcCCA2Params);
    }

    @Override
    public void init(KeyGenerationParameters param) {
        this.mcElieceCCA2Params = (McElieceCCA2KeyGenerationParameters)param;
        this.random = CryptoServicesRegistrar.getSecureRandom();
        this.m = this.mcElieceCCA2Params.getParameters().getM();
        this.n = this.mcElieceCCA2Params.getParameters().getN();
        this.t = this.mcElieceCCA2Params.getParameters().getT();
        this.fieldPoly = this.mcElieceCCA2Params.getParameters().getFieldPoly();
        this.initialized = true;
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        if (!this.initialized) {
            this.initializeDefault();
        }
        GF2mField field = new GF2mField(this.m, this.fieldPoly);
        PolynomialGF2mSmallM gp = new PolynomialGF2mSmallM(field, this.t, 'I', this.random);
        GF2Matrix h2 = GoppaCode.createCanonicalCheckMatrix(field, gp);
        GoppaCode.MaMaPe mmp = GoppaCode.computeSystematicForm(h2, this.random);
        GF2Matrix shortH = mmp.getSecondMatrix();
        Permutation p = mmp.getPermutation();
        GF2Matrix shortG = (GF2Matrix)shortH.computeTranspose();
        int k = shortG.getNumRows();
        McElieceCCA2PublicKeyParameters pubKey = new McElieceCCA2PublicKeyParameters(this.n, this.t, shortG, this.mcElieceCCA2Params.getParameters().getDigest());
        McElieceCCA2PrivateKeyParameters privKey = new McElieceCCA2PrivateKeyParameters(this.n, k, field, gp, p, this.mcElieceCCA2Params.getParameters().getDigest());
        return new AsymmetricCipherKeyPair(pubKey, privKey);
    }
}

