/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.pqc.crypto.gmss;

import cn.org.bjca.gaia.crypto.Digest;
import cn.org.bjca.gaia.pqc.crypto.gmss.GMSSDigestProvider;
import cn.org.bjca.gaia.pqc.crypto.gmss.GMSSKeyParameters;
import cn.org.bjca.gaia.pqc.crypto.gmss.GMSSLeaf;
import cn.org.bjca.gaia.pqc.crypto.gmss.GMSSParameters;
import cn.org.bjca.gaia.pqc.crypto.gmss.GMSSRootCalc;
import cn.org.bjca.gaia.pqc.crypto.gmss.GMSSRootSig;
import cn.org.bjca.gaia.pqc.crypto.gmss.Treehash;
import cn.org.bjca.gaia.pqc.crypto.gmss.util.GMSSRandom;
import cn.org.bjca.gaia.pqc.crypto.gmss.util.WinternitzOTSignature;
import cn.org.bjca.gaia.util.Arrays;
import java.util.Vector;

public class GMSSPrivateKeyParameters
extends GMSSKeyParameters {
    private int[] index;
    private byte[][] currentSeeds;
    private byte[][] nextNextSeeds;
    private byte[][][] currentAuthPaths;
    private byte[][][] nextAuthPaths;
    private Treehash[][] currentTreehash;
    private Treehash[][] nextTreehash;
    private Vector[] currentStack;
    private Vector[] nextStack;
    private Vector[][] currentRetain;
    private Vector[][] nextRetain;
    private byte[][][] keep;
    private GMSSLeaf[] nextNextLeaf;
    private GMSSLeaf[] upperLeaf;
    private GMSSLeaf[] upperTreehashLeaf;
    private int[] minTreehash;
    private GMSSParameters gmssPS;
    private byte[][] nextRoot;
    private GMSSRootCalc[] nextNextRoot;
    private byte[][] currentRootSig;
    private GMSSRootSig[] nextRootSig;
    private GMSSDigestProvider digestProvider;
    private boolean used = false;
    private int[] heightOfTrees;
    private int[] otsIndex;
    private int[] K;
    private int numLayer;
    private Digest messDigestTrees;
    private int mdLength;
    private GMSSRandom gmssRandom;
    private int[] numLeafs;

    public GMSSPrivateKeyParameters(byte[][] currentSeed, byte[][] nextNextSeed, byte[][][] currentAuthPath, byte[][][] nextAuthPath, Treehash[][] currentTreehash, Treehash[][] nextTreehash, Vector[] currentStack, Vector[] nextStack, Vector[][] currentRetain, Vector[][] nextRetain, byte[][] nextRoot, byte[][] currentRootSig, GMSSParameters gmssParameterset, GMSSDigestProvider digestProvider) {
        this(null, currentSeed, nextNextSeed, currentAuthPath, nextAuthPath, null, currentTreehash, nextTreehash, currentStack, nextStack, currentRetain, nextRetain, null, null, null, null, nextRoot, null, currentRootSig, null, gmssParameterset, digestProvider);
    }

    public GMSSPrivateKeyParameters(int[] index, byte[][] currentSeeds, byte[][] nextNextSeeds, byte[][][] currentAuthPaths, byte[][][] nextAuthPaths, byte[][][] keep, Treehash[][] currentTreehash, Treehash[][] nextTreehash, Vector[] currentStack, Vector[] nextStack, Vector[][] currentRetain, Vector[][] nextRetain, GMSSLeaf[] nextNextLeaf, GMSSLeaf[] upperLeaf, GMSSLeaf[] upperTreehashLeaf, int[] minTreehash, byte[][] nextRoot, GMSSRootCalc[] nextNextRoot, byte[][] currentRootSig, GMSSRootSig[] nextRootSig, GMSSParameters gmssParameterset, GMSSDigestProvider digestProvider) {
        super(true, gmssParameterset);
        int i;
        this.messDigestTrees = digestProvider.get();
        this.mdLength = this.messDigestTrees.getDigestSize();
        this.gmssPS = gmssParameterset;
        this.otsIndex = gmssParameterset.getWinternitzParameter();
        this.K = gmssParameterset.getK();
        this.heightOfTrees = gmssParameterset.getHeightOfTrees();
        this.numLayer = this.gmssPS.getNumOfLayers();
        if (index == null) {
            this.index = new int[this.numLayer];
            for (i = 0; i < this.numLayer; ++i) {
                this.index[i] = 0;
            }
        } else {
            this.index = index;
        }
        this.currentSeeds = currentSeeds;
        this.nextNextSeeds = nextNextSeeds;
        this.currentAuthPaths = Arrays.clone(currentAuthPaths);
        this.nextAuthPaths = nextAuthPaths;
        if (keep == null) {
            this.keep = new byte[this.numLayer][][];
            for (i = 0; i < this.numLayer; ++i) {
                this.keep[i] = new byte[(int)Math.floor(this.heightOfTrees[i] / 2)][this.mdLength];
            }
        } else {
            this.keep = keep;
        }
        if (currentStack == null) {
            this.currentStack = new Vector[this.numLayer];
            for (i = 0; i < this.numLayer; ++i) {
                this.currentStack[i] = new Vector();
            }
        } else {
            this.currentStack = currentStack;
        }
        if (nextStack == null) {
            this.nextStack = new Vector[this.numLayer - 1];
            for (i = 0; i < this.numLayer - 1; ++i) {
                this.nextStack[i] = new Vector();
            }
        } else {
            this.nextStack = nextStack;
        }
        this.currentTreehash = currentTreehash;
        this.nextTreehash = nextTreehash;
        this.currentRetain = currentRetain;
        this.nextRetain = nextRetain;
        this.nextRoot = nextRoot;
        this.digestProvider = digestProvider;
        if (nextNextRoot == null) {
            this.nextNextRoot = new GMSSRootCalc[this.numLayer - 1];
            for (i = 0; i < this.numLayer - 1; ++i) {
                this.nextNextRoot[i] = new GMSSRootCalc(this.heightOfTrees[i + 1], this.K[i + 1], this.digestProvider);
            }
        } else {
            this.nextNextRoot = nextNextRoot;
        }
        this.currentRootSig = currentRootSig;
        this.numLeafs = new int[this.numLayer];
        for (i = 0; i < this.numLayer; ++i) {
            this.numLeafs[i] = 1 << this.heightOfTrees[i];
        }
        this.gmssRandom = new GMSSRandom(this.messDigestTrees);
        if (this.numLayer > 1) {
            if (nextNextLeaf == null) {
                this.nextNextLeaf = new GMSSLeaf[this.numLayer - 2];
                for (i = 0; i < this.numLayer - 2; ++i) {
                    this.nextNextLeaf[i] = new GMSSLeaf(digestProvider.get(), this.otsIndex[i + 1], this.numLeafs[i + 2], this.nextNextSeeds[i]);
                }
            } else {
                this.nextNextLeaf = nextNextLeaf;
            }
        } else {
            this.nextNextLeaf = new GMSSLeaf[0];
        }
        if (upperLeaf == null) {
            this.upperLeaf = new GMSSLeaf[this.numLayer - 1];
            for (i = 0; i < this.numLayer - 1; ++i) {
                this.upperLeaf[i] = new GMSSLeaf(digestProvider.get(), this.otsIndex[i], this.numLeafs[i + 1], this.currentSeeds[i]);
            }
        } else {
            this.upperLeaf = upperLeaf;
        }
        if (upperTreehashLeaf == null) {
            this.upperTreehashLeaf = new GMSSLeaf[this.numLayer - 1];
            for (i = 0; i < this.numLayer - 1; ++i) {
                this.upperTreehashLeaf[i] = new GMSSLeaf(digestProvider.get(), this.otsIndex[i], this.numLeafs[i + 1]);
            }
        } else {
            this.upperTreehashLeaf = upperTreehashLeaf;
        }
        if (minTreehash == null) {
            this.minTreehash = new int[this.numLayer - 1];
            for (i = 0; i < this.numLayer - 1; ++i) {
                this.minTreehash[i] = -1;
            }
        } else {
            this.minTreehash = minTreehash;
        }
        byte[] dummy = new byte[this.mdLength];
        byte[] OTSseed = new byte[this.mdLength];
        if (nextRootSig == null) {
            this.nextRootSig = new GMSSRootSig[this.numLayer - 1];
            for (int i2 = 0; i2 < this.numLayer - 1; ++i2) {
                System.arraycopy(currentSeeds[i2], 0, dummy, 0, this.mdLength);
                this.gmssRandom.nextSeed(dummy);
                OTSseed = this.gmssRandom.nextSeed(dummy);
                this.nextRootSig[i2] = new GMSSRootSig(digestProvider.get(), this.otsIndex[i2], this.heightOfTrees[i2 + 1]);
                this.nextRootSig[i2].initSign(OTSseed, nextRoot[i2]);
            }
        } else {
            this.nextRootSig = nextRootSig;
        }
    }

    private GMSSPrivateKeyParameters(GMSSPrivateKeyParameters original) {
        super(true, original.getParameters());
        this.index = Arrays.clone(original.index);
        this.currentSeeds = Arrays.clone(original.currentSeeds);
        this.nextNextSeeds = Arrays.clone(original.nextNextSeeds);
        this.currentAuthPaths = Arrays.clone(original.currentAuthPaths);
        this.nextAuthPaths = Arrays.clone(original.nextAuthPaths);
        this.currentTreehash = original.currentTreehash;
        this.nextTreehash = original.nextTreehash;
        this.currentStack = original.currentStack;
        this.nextStack = original.nextStack;
        this.currentRetain = original.currentRetain;
        this.nextRetain = original.nextRetain;
        this.keep = Arrays.clone(original.keep);
        this.nextNextLeaf = original.nextNextLeaf;
        this.upperLeaf = original.upperLeaf;
        this.upperTreehashLeaf = original.upperTreehashLeaf;
        this.minTreehash = original.minTreehash;
        this.gmssPS = original.gmssPS;
        this.nextRoot = Arrays.clone(original.nextRoot);
        this.nextNextRoot = original.nextNextRoot;
        this.currentRootSig = original.currentRootSig;
        this.nextRootSig = original.nextRootSig;
        this.digestProvider = original.digestProvider;
        this.heightOfTrees = original.heightOfTrees;
        this.otsIndex = original.otsIndex;
        this.K = original.K;
        this.numLayer = original.numLayer;
        this.messDigestTrees = original.messDigestTrees;
        this.mdLength = original.mdLength;
        this.gmssRandom = original.gmssRandom;
        this.numLeafs = original.numLeafs;
    }

    public boolean isUsed() {
        return this.used;
    }

    public void markUsed() {
        this.used = true;
    }

    public GMSSPrivateKeyParameters nextKey() {
        GMSSPrivateKeyParameters nKey = new GMSSPrivateKeyParameters(this);
        nKey.nextKey(this.gmssPS.getNumOfLayers() - 1);
        return nKey;
    }

    private void nextKey(int layer) {
        if (layer == this.numLayer - 1) {
            int n = layer;
            this.index[n] = this.index[n] + 1;
        }
        if (this.index[layer] == this.numLeafs[layer]) {
            if (this.numLayer != 1) {
                this.nextTree(layer);
                this.index[layer] = 0;
            }
        } else {
            this.updateKey(layer);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void nextTree(int layer) {
        if (layer > 0) {
            int n = layer - 1;
            this.index[n] = this.index[n] + 1;
            boolean lastTree = true;
            int z = layer;
            do {
                if (this.index[--z] >= this.numLeafs[z]) continue;
                lastTree = false;
            } while (lastTree && z > 0);
            if (!lastTree) {
                int i;
                this.gmssRandom.nextSeed(this.currentSeeds[layer]);
                this.nextRootSig[layer - 1].updateSign();
                if (layer > 1) {
                    this.nextNextLeaf[layer - 1 - 1] = this.nextNextLeaf[layer - 1 - 1].nextLeaf();
                }
                this.upperLeaf[layer - 1] = this.upperLeaf[layer - 1].nextLeaf();
                if (this.minTreehash[layer - 1] >= 0) {
                    this.upperTreehashLeaf[layer - 1] = this.upperTreehashLeaf[layer - 1].nextLeaf();
                    byte[] leaf = this.upperTreehashLeaf[layer - 1].getLeaf();
                    try {
                        this.currentTreehash[layer - 1][this.minTreehash[layer - 1]].update(this.gmssRandom, leaf);
                        if (!this.currentTreehash[layer - 1][this.minTreehash[layer - 1]].wasFinished()) {
                            // empty if block
                        }
                    }
                    catch (Exception e) {
                        System.out.println(e);
                    }
                }
                this.updateNextNextAuthRoot(layer);
                this.currentRootSig[layer - 1] = this.nextRootSig[layer - 1].getSig();
                for (i = 0; i < this.heightOfTrees[layer] - this.K[layer]; ++i) {
                    this.currentTreehash[layer][i] = this.nextTreehash[layer - 1][i];
                    this.nextTreehash[layer - 1][i] = this.nextNextRoot[layer - 1].getTreehash()[i];
                }
                for (i = 0; i < this.heightOfTrees[layer]; ++i) {
                    System.arraycopy(this.nextAuthPaths[layer - 1][i], 0, this.currentAuthPaths[layer][i], 0, this.mdLength);
                    System.arraycopy(this.nextNextRoot[layer - 1].getAuthPath()[i], 0, this.nextAuthPaths[layer - 1][i], 0, this.mdLength);
                }
                for (i = 0; i < this.K[layer] - 1; ++i) {
                    this.currentRetain[layer][i] = this.nextRetain[layer - 1][i];
                    this.nextRetain[layer - 1][i] = this.nextNextRoot[layer - 1].getRetain()[i];
                }
                this.currentStack[layer] = this.nextStack[layer - 1];
                this.nextStack[layer - 1] = this.nextNextRoot[layer - 1].getStack();
                this.nextRoot[layer - 1] = this.nextNextRoot[layer - 1].getRoot();
                byte[] OTSseed = new byte[this.mdLength];
                byte[] dummy = new byte[this.mdLength];
                System.arraycopy(this.currentSeeds[layer - 1], 0, dummy, 0, this.mdLength);
                OTSseed = this.gmssRandom.nextSeed(dummy);
                OTSseed = this.gmssRandom.nextSeed(dummy);
                OTSseed = this.gmssRandom.nextSeed(dummy);
                this.nextRootSig[layer - 1].initSign(OTSseed, this.nextRoot[layer - 1]);
                this.nextKey(layer - 1);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateKey(int layer) {
        this.computeAuthPaths(layer);
        if (layer > 0) {
            if (layer > 1) {
                this.nextNextLeaf[layer - 1 - 1] = this.nextNextLeaf[layer - 1 - 1].nextLeaf();
            }
            this.upperLeaf[layer - 1] = this.upperLeaf[layer - 1].nextLeaf();
            int t = (int)Math.floor((double)(this.getNumLeafs(layer) * 2) / (double)(this.heightOfTrees[layer - 1] - this.K[layer - 1]));
            if (this.index[layer] % t == 1) {
                if (this.index[layer] > 1 && this.minTreehash[layer - 1] >= 0) {
                    byte[] leaf = this.upperTreehashLeaf[layer - 1].getLeaf();
                    try {
                        this.currentTreehash[layer - 1][this.minTreehash[layer - 1]].update(this.gmssRandom, leaf);
                        if (!this.currentTreehash[layer - 1][this.minTreehash[layer - 1]].wasFinished()) {
                            // empty if block
                        }
                    }
                    catch (Exception e) {
                        System.out.println(e);
                    }
                }
                this.minTreehash[layer - 1] = this.getMinTreehashIndex(layer - 1);
                if (this.minTreehash[layer - 1] >= 0) {
                    byte[] seed = this.currentTreehash[layer - 1][this.minTreehash[layer - 1]].getSeedActive();
                    this.upperTreehashLeaf[layer - 1] = new GMSSLeaf(this.digestProvider.get(), this.otsIndex[layer - 1], t, seed);
                    this.upperTreehashLeaf[layer - 1] = this.upperTreehashLeaf[layer - 1].nextLeaf();
                }
            } else if (this.minTreehash[layer - 1] >= 0) {
                this.upperTreehashLeaf[layer - 1] = this.upperTreehashLeaf[layer - 1].nextLeaf();
            }
            this.nextRootSig[layer - 1].updateSign();
            if (this.index[layer] == 1) {
                this.nextNextRoot[layer - 1].initialize(new Vector());
            }
            this.updateNextNextAuthRoot(layer);
        }
    }

    private int getMinTreehashIndex(int layer) {
        int minTreehash = -1;
        for (int h2 = 0; h2 < this.heightOfTrees[layer] - this.K[layer]; ++h2) {
            if (!this.currentTreehash[layer][h2].wasInitialized() || this.currentTreehash[layer][h2].wasFinished()) continue;
            if (minTreehash == -1) {
                minTreehash = h2;
                continue;
            }
            if (this.currentTreehash[layer][h2].getLowestNodeHeight() >= this.currentTreehash[layer][minTreehash].getLowestNodeHeight()) continue;
            minTreehash = h2;
        }
        return minTreehash;
    }

    private void computeAuthPaths(int layer) {
        int Phi = this.index[layer];
        int H = this.heightOfTrees[layer];
        int K2 = this.K[layer];
        for (int i = 0; i < H - K2; ++i) {
            this.currentTreehash[layer][i].updateNextSeed(this.gmssRandom);
        }
        int Tau = this.heightOfPhi(Phi);
        byte[] OTSseed = new byte[this.mdLength];
        OTSseed = this.gmssRandom.nextSeed(this.currentSeeds[layer]);
        int L = Phi >>> Tau + 1 & 1;
        byte[] tempKeep = new byte[this.mdLength];
        if (Tau < H - 1 && L == 0) {
            System.arraycopy(this.currentAuthPaths[layer][Tau], 0, tempKeep, 0, this.mdLength);
        }
        byte[] help = new byte[this.mdLength];
        if (Tau == 0) {
            if (layer == this.numLayer - 1) {
                WinternitzOTSignature ots = new WinternitzOTSignature(OTSseed, this.digestProvider.get(), this.otsIndex[layer]);
                help = ots.getPublicKey();
            } else {
                byte[] dummy = new byte[this.mdLength];
                System.arraycopy(this.currentSeeds[layer], 0, dummy, 0, this.mdLength);
                this.gmssRandom.nextSeed(dummy);
                help = this.upperLeaf[layer].getLeaf();
                this.upperLeaf[layer].initLeafCalc(dummy);
            }
            System.arraycopy(help, 0, this.currentAuthPaths[layer][0], 0, this.mdLength);
        } else {
            byte[] toBeHashed = new byte[this.mdLength << 1];
            System.arraycopy(this.currentAuthPaths[layer][Tau - 1], 0, toBeHashed, 0, this.mdLength);
            System.arraycopy(this.keep[layer][(int)Math.floor((Tau - 1) / 2)], 0, toBeHashed, this.mdLength, this.mdLength);
            this.messDigestTrees.update(toBeHashed, 0, toBeHashed.length);
            this.currentAuthPaths[layer][Tau] = new byte[this.messDigestTrees.getDigestSize()];
            this.messDigestTrees.doFinal(this.currentAuthPaths[layer][Tau], 0);
            for (int i = 0; i < Tau; ++i) {
                int startPoint;
                if (i < H - K2) {
                    if (this.currentTreehash[layer][i].wasFinished()) {
                        System.arraycopy(this.currentTreehash[layer][i].getFirstNode(), 0, this.currentAuthPaths[layer][i], 0, this.mdLength);
                        this.currentTreehash[layer][i].destroy();
                    } else {
                        System.err.println("Treehash (" + layer + "," + i + ") not finished when needed in AuthPathComputation");
                    }
                }
                if (i < H - 1 && i >= H - K2 && this.currentRetain[layer][i - (H - K2)].size() > 0) {
                    System.arraycopy(this.currentRetain[layer][i - (H - K2)].lastElement(), 0, this.currentAuthPaths[layer][i], 0, this.mdLength);
                    this.currentRetain[layer][i - (H - K2)].removeElementAt(this.currentRetain[layer][i - (H - K2)].size() - 1);
                }
                if (i >= H - K2 || (startPoint = Phi + 3 * (1 << i)) >= this.numLeafs[layer]) continue;
                this.currentTreehash[layer][i].initialize();
            }
        }
        if (Tau < H - 1 && L == 0) {
            System.arraycopy(tempKeep, 0, this.keep[layer][(int)Math.floor(Tau / 2)], 0, this.mdLength);
        }
        if (layer == this.numLayer - 1) {
            for (int tmp = 1; tmp <= (H - K2) / 2; ++tmp) {
                int minTreehash = this.getMinTreehashIndex(layer);
                if (minTreehash < 0) continue;
                try {
                    byte[] seed = new byte[this.mdLength];
                    System.arraycopy(this.currentTreehash[layer][minTreehash].getSeedActive(), 0, seed, 0, this.mdLength);
                    byte[] seed2 = this.gmssRandom.nextSeed(seed);
                    WinternitzOTSignature ots = new WinternitzOTSignature(seed2, this.digestProvider.get(), this.otsIndex[layer]);
                    byte[] leaf = ots.getPublicKey();
                    this.currentTreehash[layer][minTreehash].update(this.gmssRandom, leaf);
                    continue;
                }
                catch (Exception e) {
                    System.out.println(e);
                }
            }
        } else {
            this.minTreehash[layer] = this.getMinTreehashIndex(layer);
        }
    }

    private int heightOfPhi(int Phi) {
        if (Phi == 0) {
            return -1;
        }
        int Tau = 0;
        int modul = 1;
        while (Phi % modul == 0) {
            modul *= 2;
            ++Tau;
        }
        return Tau - 1;
    }

    private void updateNextNextAuthRoot(int layer) {
        byte[] OTSseed = new byte[this.mdLength];
        OTSseed = this.gmssRandom.nextSeed(this.nextNextSeeds[layer - 1]);
        if (layer == this.numLayer - 1) {
            WinternitzOTSignature ots = new WinternitzOTSignature(OTSseed, this.digestProvider.get(), this.otsIndex[layer]);
            this.nextNextRoot[layer - 1].update(this.nextNextSeeds[layer - 1], ots.getPublicKey());
        } else {
            this.nextNextRoot[layer - 1].update(this.nextNextSeeds[layer - 1], this.nextNextLeaf[layer - 1].getLeaf());
            this.nextNextLeaf[layer - 1].initLeafCalc(this.nextNextSeeds[layer - 1]);
        }
    }

    public int[] getIndex() {
        return this.index;
    }

    public int getIndex(int i) {
        return this.index[i];
    }

    public byte[][] getCurrentSeeds() {
        return Arrays.clone(this.currentSeeds);
    }

    public byte[][][] getCurrentAuthPaths() {
        return Arrays.clone(this.currentAuthPaths);
    }

    public byte[] getSubtreeRootSig(int i) {
        return this.currentRootSig[i];
    }

    public GMSSDigestProvider getName() {
        return this.digestProvider;
    }

    public int getNumLeafs(int i) {
        return this.numLeafs[i];
    }
}

