/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.pqc.asn1;

import cn.org.bjca.gaia.asn1.ASN1EncodableVector;
import cn.org.bjca.gaia.asn1.ASN1Integer;
import cn.org.bjca.gaia.asn1.ASN1Object;
import cn.org.bjca.gaia.asn1.ASN1OctetString;
import cn.org.bjca.gaia.asn1.ASN1Primitive;
import cn.org.bjca.gaia.asn1.ASN1Sequence;
import cn.org.bjca.gaia.asn1.DEROctetString;
import cn.org.bjca.gaia.asn1.DERSequence;
import cn.org.bjca.gaia.pqc.math.linearalgebra.GF2Matrix;
import java.math.BigInteger;

public class McEliecePublicKey
extends ASN1Object {
    private final int n;
    private final int t;
    private final GF2Matrix g;

    public McEliecePublicKey(int n, int t, GF2Matrix g2) {
        this.n = n;
        this.t = t;
        this.g = new GF2Matrix(g2);
    }

    private McEliecePublicKey(ASN1Sequence seq) {
        BigInteger bigN = ((ASN1Integer)seq.getObjectAt(0)).getValue();
        this.n = bigN.intValue();
        BigInteger bigT = ((ASN1Integer)seq.getObjectAt(1)).getValue();
        this.t = bigT.intValue();
        this.g = new GF2Matrix(((ASN1OctetString)seq.getObjectAt(2)).getOctets());
    }

    public int getN() {
        return this.n;
    }

    public int getT() {
        return this.t;
    }

    public GF2Matrix getG() {
        return new GF2Matrix(this.g);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(new ASN1Integer(this.n));
        v.add(new ASN1Integer(this.t));
        v.add(new DEROctetString(this.g.getEncoded()));
        return new DERSequence(v);
    }

    public static McEliecePublicKey getInstance(Object o) {
        if (o instanceof McEliecePublicKey) {
            return (McEliecePublicKey)o;
        }
        if (o != null) {
            return new McEliecePublicKey(ASN1Sequence.getInstance(o));
        }
        return null;
    }
}

