/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.pkcs.jcajce;

import cn.org.bjca.gaia.asn1.ASN1Encodable;
import cn.org.bjca.gaia.asn1.ASN1ObjectIdentifier;
import cn.org.bjca.gaia.asn1.ASN1OctetString;
import cn.org.bjca.gaia.asn1.cryptopro.GOST28147Parameters;
import cn.org.bjca.gaia.asn1.misc.MiscObjectIdentifiers;
import cn.org.bjca.gaia.asn1.misc.ScryptParams;
import cn.org.bjca.gaia.asn1.pkcs.PBEParameter;
import cn.org.bjca.gaia.asn1.pkcs.PBES2Parameters;
import cn.org.bjca.gaia.asn1.pkcs.PBKDF2Params;
import cn.org.bjca.gaia.asn1.pkcs.PKCS12PBEParams;
import cn.org.bjca.gaia.asn1.pkcs.PKCSObjectIdentifiers;
import cn.org.bjca.gaia.asn1.x509.AlgorithmIdentifier;
import cn.org.bjca.gaia.crypto.PasswordConverter;
import cn.org.bjca.gaia.jcajce.PBKDF1Key;
import cn.org.bjca.gaia.jcajce.PKCS12KeyWithParameters;
import cn.org.bjca.gaia.jcajce.io.CipherInputStream;
import cn.org.bjca.gaia.jcajce.spec.GOST28147ParameterSpec;
import cn.org.bjca.gaia.jcajce.spec.PBKDF2KeySpec;
import cn.org.bjca.gaia.jcajce.spec.ScryptKeySpec;
import cn.org.bjca.gaia.jcajce.util.DefaultJcaJceHelper;
import cn.org.bjca.gaia.jcajce.util.JcaJceHelper;
import cn.org.bjca.gaia.jcajce.util.NamedJcaJceHelper;
import cn.org.bjca.gaia.jcajce.util.ProviderJcaJceHelper;
import cn.org.bjca.gaia.operator.DefaultSecretKeySizeProvider;
import cn.org.bjca.gaia.operator.InputDecryptor;
import cn.org.bjca.gaia.operator.InputDecryptorProvider;
import cn.org.bjca.gaia.operator.OperatorCreationException;
import cn.org.bjca.gaia.operator.SecretKeySizeProvider;
import java.io.InputStream;
import java.security.Key;
import java.security.Provider;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public class JcePKCSPBEInputDecryptorProviderBuilder {
    private JcaJceHelper helper = new DefaultJcaJceHelper();
    private boolean wrongPKCS12Zero = false;
    private SecretKeySizeProvider keySizeProvider = DefaultSecretKeySizeProvider.INSTANCE;

    public JcePKCSPBEInputDecryptorProviderBuilder setProvider(Provider provider) {
        this.helper = new ProviderJcaJceHelper(provider);
        return this;
    }

    public JcePKCSPBEInputDecryptorProviderBuilder setProvider(String providerName) {
        this.helper = new NamedJcaJceHelper(providerName);
        return this;
    }

    public JcePKCSPBEInputDecryptorProviderBuilder setTryWrongPKCS12Zero(boolean tryWrong) {
        this.wrongPKCS12Zero = tryWrong;
        return this;
    }

    public JcePKCSPBEInputDecryptorProviderBuilder setKeySizeProvider(SecretKeySizeProvider keySizeProvider) {
        this.keySizeProvider = keySizeProvider;
        return this;
    }

    public InputDecryptorProvider build(final char[] password) {
        return new InputDecryptorProvider(){
            private Cipher cipher;
            private AlgorithmIdentifier encryptionAlg;

            @Override
            public InputDecryptor get(AlgorithmIdentifier algorithmIdentifier) throws OperatorCreationException {
                block9: {
                    ASN1ObjectIdentifier algorithm = algorithmIdentifier.getAlgorithm();
                    try {
                        if (algorithm.on(PKCSObjectIdentifiers.pkcs_12PbeIds)) {
                            PKCS12PBEParams pbeParams = PKCS12PBEParams.getInstance(algorithmIdentifier.getParameters());
                            this.cipher = JcePKCSPBEInputDecryptorProviderBuilder.this.helper.createCipher(algorithm.getId());
                            this.cipher.init(2, new PKCS12KeyWithParameters(password, JcePKCSPBEInputDecryptorProviderBuilder.this.wrongPKCS12Zero, pbeParams.getIV(), pbeParams.getIterations().intValue()));
                            this.encryptionAlg = algorithmIdentifier;
                            break block9;
                        }
                        if (algorithm.equals(PKCSObjectIdentifiers.id_PBES2)) {
                            SecretKey key;
                            PBES2Parameters alg = PBES2Parameters.getInstance(algorithmIdentifier.getParameters());
                            if (MiscObjectIdentifiers.id_scrypt.equals(alg.getKeyDerivationFunc().getAlgorithm())) {
                                ScryptParams params = ScryptParams.getInstance(alg.getKeyDerivationFunc().getParameters());
                                AlgorithmIdentifier encScheme = AlgorithmIdentifier.getInstance(alg.getEncryptionScheme());
                                SecretKeyFactory keyFact = JcePKCSPBEInputDecryptorProviderBuilder.this.helper.createSecretKeyFactory("SCRYPT");
                                key = keyFact.generateSecret(new ScryptKeySpec(password, params.getSalt(), params.getCostParameter().intValue(), params.getBlockSize().intValue(), params.getParallelizationParameter().intValue(), JcePKCSPBEInputDecryptorProviderBuilder.this.keySizeProvider.getKeySize(encScheme)));
                            } else {
                                SecretKeyFactory keyFact = JcePKCSPBEInputDecryptorProviderBuilder.this.helper.createSecretKeyFactory(alg.getKeyDerivationFunc().getAlgorithm().getId());
                                PBKDF2Params func = PBKDF2Params.getInstance(alg.getKeyDerivationFunc().getParameters());
                                AlgorithmIdentifier encScheme = AlgorithmIdentifier.getInstance(alg.getEncryptionScheme());
                                key = func.isDefaultPrf() ? keyFact.generateSecret(new PBEKeySpec(password, func.getSalt(), func.getIterationCount().intValue(), JcePKCSPBEInputDecryptorProviderBuilder.this.keySizeProvider.getKeySize(encScheme))) : keyFact.generateSecret(new PBKDF2KeySpec(password, func.getSalt(), func.getIterationCount().intValue(), JcePKCSPBEInputDecryptorProviderBuilder.this.keySizeProvider.getKeySize(encScheme), func.getPrf()));
                            }
                            this.cipher = JcePKCSPBEInputDecryptorProviderBuilder.this.helper.createCipher(alg.getEncryptionScheme().getAlgorithm().getId());
                            this.encryptionAlg = AlgorithmIdentifier.getInstance(alg.getEncryptionScheme());
                            ASN1Encodable encParams = alg.getEncryptionScheme().getParameters();
                            if (encParams instanceof ASN1OctetString) {
                                this.cipher.init(2, (Key)key, new IvParameterSpec(ASN1OctetString.getInstance(encParams).getOctets()));
                            } else {
                                GOST28147Parameters gParams = GOST28147Parameters.getInstance(encParams);
                                this.cipher.init(2, (Key)key, new GOST28147ParameterSpec(gParams.getEncryptionParamSet(), gParams.getIV()));
                            }
                            break block9;
                        }
                        if (algorithm.equals(PKCSObjectIdentifiers.pbeWithMD5AndDES_CBC) || algorithm.equals(PKCSObjectIdentifiers.pbeWithSHA1AndDES_CBC)) {
                            PBEParameter pbeParams = PBEParameter.getInstance(algorithmIdentifier.getParameters());
                            this.cipher = JcePKCSPBEInputDecryptorProviderBuilder.this.helper.createCipher(algorithm.getId());
                            this.cipher.init(2, (Key)new PBKDF1Key(password, PasswordConverter.ASCII), new PBEParameterSpec(pbeParams.getSalt(), pbeParams.getIterationCount().intValue()));
                            break block9;
                        }
                        throw new OperatorCreationException("unable to create InputDecryptor: algorithm " + algorithm + " unknown.");
                    }
                    catch (Exception e) {
                        throw new OperatorCreationException("unable to create InputDecryptor: " + e.getMessage(), e);
                    }
                }
                return new InputDecryptor(){

                    @Override
                    public AlgorithmIdentifier getAlgorithmIdentifier() {
                        return encryptionAlg;
                    }

                    @Override
                    public InputStream getInputStream(InputStream input) {
                        return new CipherInputStream(input, cipher);
                    }
                };
            }
        };
    }
}

