/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.mozilla.jcajce;

import cn.org.bjca.gaia.asn1.x509.AlgorithmIdentifier;
import cn.org.bjca.gaia.asn1.x509.SubjectPublicKeyInfo;
import cn.org.bjca.gaia.jcajce.util.DefaultJcaJceHelper;
import cn.org.bjca.gaia.jcajce.util.JcaJceHelper;
import cn.org.bjca.gaia.jcajce.util.NamedJcaJceHelper;
import cn.org.bjca.gaia.jcajce.util.ProviderJcaJceHelper;
import cn.org.bjca.gaia.mozilla.SignedPublicKeyAndChallenge;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;

public class JcaSignedPublicKeyAndChallenge
extends SignedPublicKeyAndChallenge {
    JcaJceHelper helper = new DefaultJcaJceHelper();

    private JcaSignedPublicKeyAndChallenge(cn.org.bjca.gaia.asn1.mozilla.SignedPublicKeyAndChallenge struct, JcaJceHelper helper) {
        super(struct);
        this.helper = helper;
    }

    public JcaSignedPublicKeyAndChallenge(byte[] bytes) {
        super(bytes);
    }

    public JcaSignedPublicKeyAndChallenge setProvider(String providerName) {
        return new JcaSignedPublicKeyAndChallenge(this.spkacSeq, new NamedJcaJceHelper(providerName));
    }

    public JcaSignedPublicKeyAndChallenge setProvider(Provider provider) {
        return new JcaSignedPublicKeyAndChallenge(this.spkacSeq, new ProviderJcaJceHelper(provider));
    }

    public PublicKey getPublicKey() throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        try {
            SubjectPublicKeyInfo subjectPublicKeyInfo = this.spkacSeq.getPublicKeyAndChallenge().getSubjectPublicKeyInfo();
            X509EncodedKeySpec xspec = new X509EncodedKeySpec(subjectPublicKeyInfo.getEncoded());
            AlgorithmIdentifier keyAlg = subjectPublicKeyInfo.getAlgorithm();
            KeyFactory factory = this.helper.createKeyFactory(keyAlg.getAlgorithm().getId());
            return factory.generatePublic(xspec);
        }
        catch (Exception e) {
            throw new InvalidKeyException("error encoding public key");
        }
    }
}

