/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.jce.spec;

import cn.org.bjca.gaia.jcajce.provider.asymmetric.util.EC5Util;
import cn.org.bjca.gaia.math.ec.ECAlgorithms;
import cn.org.bjca.gaia.math.ec.ECCurve;
import cn.org.bjca.gaia.math.ec.ECPoint;
import cn.org.bjca.gaia.math.field.FiniteField;
import cn.org.bjca.gaia.math.field.Polynomial;
import cn.org.bjca.gaia.math.field.PolynomialExtensionField;
import cn.org.bjca.gaia.util.Arrays;
import java.math.BigInteger;
import java.security.spec.ECField;
import java.security.spec.ECFieldF2m;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.EllipticCurve;

public class ECNamedCurveSpec
extends ECParameterSpec {
    private String name;

    private static EllipticCurve convertCurve(ECCurve curve, byte[] seed) {
        ECField field = ECNamedCurveSpec.convertField(curve.getField());
        BigInteger a = curve.getA().toBigInteger();
        BigInteger b = curve.getB().toBigInteger();
        return new EllipticCurve(field, a, b, seed);
    }

    private static ECField convertField(FiniteField field) {
        if (ECAlgorithms.isFpField(field)) {
            return new ECFieldFp(field.getCharacteristic());
        }
        Polynomial poly = ((PolynomialExtensionField)field).getMinimalPolynomial();
        int[] exponents = poly.getExponentsPresent();
        int[] ks = Arrays.reverse(Arrays.copyOfRange(exponents, 1, exponents.length - 1));
        return new ECFieldF2m(poly.getDegree(), ks);
    }

    public ECNamedCurveSpec(String name, ECCurve curve, ECPoint g2, BigInteger n) {
        super(ECNamedCurveSpec.convertCurve(curve, null), EC5Util.convertPoint(g2), n, 1);
        this.name = name;
    }

    public ECNamedCurveSpec(String name, EllipticCurve curve, java.security.spec.ECPoint g2, BigInteger n) {
        super(curve, g2, n, 1);
        this.name = name;
    }

    public ECNamedCurveSpec(String name, ECCurve curve, ECPoint g2, BigInteger n, BigInteger h2) {
        super(ECNamedCurveSpec.convertCurve(curve, null), EC5Util.convertPoint(g2), n, h2.intValue());
        this.name = name;
    }

    public ECNamedCurveSpec(String name, EllipticCurve curve, java.security.spec.ECPoint g2, BigInteger n, BigInteger h2) {
        super(curve, g2, n, h2.intValue());
        this.name = name;
    }

    public ECNamedCurveSpec(String name, ECCurve curve, ECPoint g2, BigInteger n, BigInteger h2, byte[] seed) {
        super(ECNamedCurveSpec.convertCurve(curve, seed), EC5Util.convertPoint(g2), n, h2.intValue());
        this.name = name;
    }

    public String getName() {
        return this.name;
    }
}

