/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.jcajce.spec;

import cn.org.bjca.gaia.crypto.params.DHParameters;
import cn.org.bjca.gaia.crypto.params.DHValidationParameters;
import java.math.BigInteger;
import javax.crypto.spec.DHParameterSpec;

public class DHDomainParameterSpec
extends DHParameterSpec {
    private final BigInteger q;
    private final BigInteger j;
    private final int m;
    private DHValidationParameters validationParameters;

    public DHDomainParameterSpec(DHParameters domainParameters) {
        this(domainParameters.getP(), domainParameters.getQ(), domainParameters.getG(), domainParameters.getJ(), domainParameters.getM(), domainParameters.getL());
        this.validationParameters = domainParameters.getValidationParameters();
    }

    public DHDomainParameterSpec(BigInteger p, BigInteger q, BigInteger g2) {
        this(p, q, g2, null, 0);
    }

    public DHDomainParameterSpec(BigInteger p, BigInteger q, BigInteger g2, int l) {
        this(p, q, g2, null, l);
    }

    public DHDomainParameterSpec(BigInteger p, BigInteger q, BigInteger g2, BigInteger j, int l) {
        this(p, q, g2, j, 0, l);
    }

    public DHDomainParameterSpec(BigInteger p, BigInteger q, BigInteger g2, BigInteger j, int m3, int l) {
        super(p, g2, l);
        this.q = q;
        this.j = j;
        this.m = m3;
    }

    public BigInteger getQ() {
        return this.q;
    }

    public BigInteger getJ() {
        return this.j;
    }

    public int getM() {
        return this.m;
    }

    public DHParameters getDomainParameters() {
        return new DHParameters(this.getP(), this.getG(), this.q, this.m, this.getL(), this.j, this.validationParameters);
    }
}

