/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.dvcs;

import cn.org.bjca.gaia.asn1.x509.DigestInfo;
import cn.org.bjca.gaia.dvcs.DVCSException;
import cn.org.bjca.gaia.dvcs.MessageImprint;
import cn.org.bjca.gaia.operator.DigestCalculator;
import java.io.OutputStream;

public class MessageImprintBuilder {
    private final DigestCalculator digestCalculator;

    public MessageImprintBuilder(DigestCalculator digestCalculator) {
        this.digestCalculator = digestCalculator;
    }

    public MessageImprint build(byte[] message) throws DVCSException {
        try {
            OutputStream dOut = this.digestCalculator.getOutputStream();
            dOut.write(message);
            dOut.close();
            return new MessageImprint(new DigestInfo(this.digestCalculator.getAlgorithmIdentifier(), this.digestCalculator.getDigest()));
        }
        catch (Exception e) {
            throw new DVCSException("unable to build MessageImprint: " + e.getMessage(), e);
        }
    }
}

