/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.crypto.tls;

import cn.org.bjca.gaia.crypto.tls.SessionParameters;
import cn.org.bjca.gaia.crypto.tls.TlsSession;
import cn.org.bjca.gaia.util.Arrays;

class TlsSessionImpl
implements TlsSession {
    final byte[] sessionID;
    final SessionParameters sessionParameters;
    boolean resumable;

    TlsSessionImpl(byte[] sessionID, SessionParameters sessionParameters) {
        if (sessionID == null) {
            throw new IllegalArgumentException("'sessionID' cannot be null");
        }
        if (sessionID.length > 32) {
            throw new IllegalArgumentException("'sessionID' cannot be longer than 32 bytes");
        }
        this.sessionID = Arrays.clone(sessionID);
        this.sessionParameters = sessionParameters;
        this.resumable = sessionID.length > 0 && null != sessionParameters && sessionParameters.isExtendedMasterSecret();
    }

    @Override
    public synchronized SessionParameters exportSessionParameters() {
        return this.sessionParameters == null ? null : this.sessionParameters.copy();
    }

    @Override
    public synchronized byte[] getSessionID() {
        return this.sessionID;
    }

    @Override
    public synchronized void invalidate() {
        this.resumable = false;
    }

    @Override
    public synchronized boolean isResumable() {
        return this.resumable;
    }
}

