/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.crypto.tls;

import cn.org.bjca.gaia.crypto.CipherParameters;
import cn.org.bjca.gaia.crypto.CryptoException;
import cn.org.bjca.gaia.crypto.DSA;
import cn.org.bjca.gaia.crypto.Digest;
import cn.org.bjca.gaia.crypto.Signer;
import cn.org.bjca.gaia.crypto.digests.NullDigest;
import cn.org.bjca.gaia.crypto.params.AsymmetricKeyParameter;
import cn.org.bjca.gaia.crypto.params.ParametersWithRandom;
import cn.org.bjca.gaia.crypto.signers.DSADigestSigner;
import cn.org.bjca.gaia.crypto.tls.AbstractTlsSigner;
import cn.org.bjca.gaia.crypto.tls.SignatureAndHashAlgorithm;
import cn.org.bjca.gaia.crypto.tls.TlsUtils;

public abstract class TlsDSASigner
extends AbstractTlsSigner {
    @Override
    public byte[] generateRawSignature(SignatureAndHashAlgorithm algorithm, AsymmetricKeyParameter privateKey, byte[] hash) throws CryptoException {
        Signer signer = this.makeSigner(algorithm, true, true, new ParametersWithRandom(privateKey, this.context.getSecureRandom()));
        if (algorithm == null) {
            signer.update(hash, 16, 20);
        } else {
            signer.update(hash, 0, hash.length);
        }
        return signer.generateSignature();
    }

    @Override
    public boolean verifyRawSignature(SignatureAndHashAlgorithm algorithm, byte[] sigBytes, AsymmetricKeyParameter publicKey, byte[] hash) throws CryptoException {
        Signer signer = this.makeSigner(algorithm, true, false, publicKey);
        if (algorithm == null) {
            signer.update(hash, 16, 20);
        } else {
            signer.update(hash, 0, hash.length);
        }
        return signer.verifySignature(sigBytes);
    }

    @Override
    public Signer createSigner(SignatureAndHashAlgorithm algorithm, AsymmetricKeyParameter privateKey) {
        return this.makeSigner(algorithm, false, true, privateKey);
    }

    @Override
    public Signer createVerifyer(SignatureAndHashAlgorithm algorithm, AsymmetricKeyParameter publicKey) {
        return this.makeSigner(algorithm, false, false, publicKey);
    }

    protected CipherParameters makeInitParameters(boolean forSigning, CipherParameters cp) {
        return cp;
    }

    protected Signer makeSigner(SignatureAndHashAlgorithm algorithm, boolean raw, boolean forSigning, CipherParameters cp) {
        if (algorithm != null != TlsUtils.isTLSv12(this.context)) {
            throw new IllegalStateException();
        }
        if (algorithm != null && algorithm.getSignature() != this.getSignatureAlgorithm()) {
            throw new IllegalStateException();
        }
        short hashAlgorithm = algorithm == null ? (short)2 : (short)algorithm.getHash();
        Digest d = raw ? new NullDigest() : TlsUtils.createHash(hashAlgorithm);
        DSADigestSigner s2 = new DSADigestSigner(this.createDSAImpl(hashAlgorithm), d);
        s2.init(forSigning, this.makeInitParameters(forSigning, cp));
        return s2;
    }

    protected abstract short getSignatureAlgorithm();

    protected abstract DSA createDSAImpl(short var1);
}

