/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.crypto.tls;

import cn.org.bjca.gaia.crypto.tls.AbstractTlsClient;
import cn.org.bjca.gaia.crypto.tls.DefaultTlsCipherFactory;
import cn.org.bjca.gaia.crypto.tls.DefaultTlsDHVerifier;
import cn.org.bjca.gaia.crypto.tls.TlsAuthentication;
import cn.org.bjca.gaia.crypto.tls.TlsCipherFactory;
import cn.org.bjca.gaia.crypto.tls.TlsDHVerifier;
import cn.org.bjca.gaia.crypto.tls.TlsFatalAlert;
import cn.org.bjca.gaia.crypto.tls.TlsKeyExchange;
import cn.org.bjca.gaia.crypto.tls.TlsPSKIdentity;
import cn.org.bjca.gaia.crypto.tls.TlsPSKKeyExchange;
import cn.org.bjca.gaia.crypto.tls.TlsUtils;
import java.io.IOException;

public class PSKTlsClient
extends AbstractTlsClient {
    protected TlsDHVerifier dhVerifier;
    protected TlsPSKIdentity pskIdentity;

    public PSKTlsClient(TlsPSKIdentity pskIdentity) {
        this(new DefaultTlsCipherFactory(), pskIdentity);
    }

    public PSKTlsClient(TlsCipherFactory cipherFactory, TlsPSKIdentity pskIdentity) {
        this(cipherFactory, new DefaultTlsDHVerifier(), pskIdentity);
    }

    public PSKTlsClient(TlsCipherFactory cipherFactory, TlsDHVerifier dhVerifier, TlsPSKIdentity pskIdentity) {
        super(cipherFactory);
        this.dhVerifier = dhVerifier;
        this.pskIdentity = pskIdentity;
    }

    @Override
    public int[] getCipherSuites() {
        return new int[]{49207, 49205};
    }

    @Override
    public TlsKeyExchange getKeyExchange() throws IOException {
        int keyExchangeAlgorithm = TlsUtils.getKeyExchangeAlgorithm(this.selectedCipherSuite);
        switch (keyExchangeAlgorithm) {
            case 13: 
            case 14: 
            case 15: 
            case 24: {
                return this.createPSKKeyExchange(keyExchangeAlgorithm);
            }
        }
        throw new TlsFatalAlert(80);
    }

    @Override
    public TlsAuthentication getAuthentication() throws IOException {
        throw new TlsFatalAlert(80);
    }

    protected TlsKeyExchange createPSKKeyExchange(int keyExchange) {
        return new TlsPSKKeyExchange(keyExchange, this.supportedSignatureAlgorithms, this.pskIdentity, null, this.dhVerifier, null, this.namedCurves, this.clientECPointFormats, this.serverECPointFormats);
    }
}

