/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.crypto.tls;

import cn.org.bjca.gaia.crypto.BasicAgreement;
import cn.org.bjca.gaia.crypto.agreement.DHBasicAgreement;
import cn.org.bjca.gaia.crypto.agreement.ECDHBasicAgreement;
import cn.org.bjca.gaia.crypto.params.AsymmetricKeyParameter;
import cn.org.bjca.gaia.crypto.params.DHPrivateKeyParameters;
import cn.org.bjca.gaia.crypto.params.ECPrivateKeyParameters;
import cn.org.bjca.gaia.crypto.tls.AbstractTlsAgreementCredentials;
import cn.org.bjca.gaia.crypto.tls.Certificate;
import cn.org.bjca.gaia.util.BigIntegers;
import java.math.BigInteger;

public class DefaultTlsAgreementCredentials
extends AbstractTlsAgreementCredentials {
    protected Certificate certificate;
    protected AsymmetricKeyParameter privateKey;
    protected BasicAgreement basicAgreement;
    protected boolean truncateAgreement;

    public DefaultTlsAgreementCredentials(Certificate certificate, AsymmetricKeyParameter privateKey) {
        if (certificate == null) {
            throw new IllegalArgumentException("'certificate' cannot be null");
        }
        if (certificate.isEmpty()) {
            throw new IllegalArgumentException("'certificate' cannot be empty");
        }
        if (privateKey == null) {
            throw new IllegalArgumentException("'privateKey' cannot be null");
        }
        if (!privateKey.isPrivate()) {
            throw new IllegalArgumentException("'privateKey' must be private");
        }
        if (privateKey instanceof DHPrivateKeyParameters) {
            this.basicAgreement = new DHBasicAgreement();
            this.truncateAgreement = true;
        } else if (privateKey instanceof ECPrivateKeyParameters) {
            this.basicAgreement = new ECDHBasicAgreement();
            this.truncateAgreement = false;
        } else {
            throw new IllegalArgumentException("'privateKey' type not supported: " + privateKey.getClass().getName());
        }
        this.certificate = certificate;
        this.privateKey = privateKey;
    }

    @Override
    public Certificate getCertificate() {
        return this.certificate;
    }

    @Override
    public byte[] generateAgreement(AsymmetricKeyParameter peerPublicKey) {
        this.basicAgreement.init(this.privateKey);
        BigInteger agreementValue = this.basicAgreement.calculateAgreement(peerPublicKey);
        if (this.truncateAgreement) {
            return BigIntegers.asUnsignedByteArray(agreementValue);
        }
        return BigIntegers.asUnsignedByteArray(this.basicAgreement.getFieldSize(), agreementValue);
    }
}

