/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.crypto.signers;

import cn.org.bjca.gaia.crypto.CipherParameters;
import cn.org.bjca.gaia.crypto.CryptoException;
import cn.org.bjca.gaia.crypto.CryptoServicesRegistrar;
import cn.org.bjca.gaia.crypto.Digest;
import cn.org.bjca.gaia.crypto.Signer;
import cn.org.bjca.gaia.crypto.digests.SM3Digest;
import cn.org.bjca.gaia.crypto.params.ECDomainParameters;
import cn.org.bjca.gaia.crypto.params.ECKeyParameters;
import cn.org.bjca.gaia.crypto.params.ECPrivateKeyParameters;
import cn.org.bjca.gaia.crypto.params.ECPublicKeyParameters;
import cn.org.bjca.gaia.crypto.params.ParametersWithID;
import cn.org.bjca.gaia.crypto.params.ParametersWithRandom;
import cn.org.bjca.gaia.crypto.signers.DSAEncoding;
import cn.org.bjca.gaia.crypto.signers.DSAKCalculator;
import cn.org.bjca.gaia.crypto.signers.RandomDSAKCalculator;
import cn.org.bjca.gaia.crypto.signers.StandardDSAEncoding;
import cn.org.bjca.gaia.math.ec.ECAlgorithms;
import cn.org.bjca.gaia.math.ec.ECConstants;
import cn.org.bjca.gaia.math.ec.ECFieldElement;
import cn.org.bjca.gaia.math.ec.ECMultiplier;
import cn.org.bjca.gaia.math.ec.ECPoint;
import cn.org.bjca.gaia.math.ec.FixedPointCombMultiplier;
import cn.org.bjca.gaia.util.encoders.Hex;
import java.math.BigInteger;

public class SM2Signer
implements Signer,
ECConstants {
    private final DSAKCalculator kCalculator = new RandomDSAKCalculator();
    private final Digest digest;
    private final DSAEncoding encoding;
    private ECDomainParameters ecParams;
    private ECPoint pubPoint;
    private ECKeyParameters ecKey;
    private byte[] z;
    private byte[] hashData;

    public SM2Signer() {
        this(StandardDSAEncoding.INSTANCE, new SM3Digest());
    }

    public SM2Signer(Digest digest) {
        this(StandardDSAEncoding.INSTANCE, digest);
    }

    public SM2Signer(DSAEncoding encoding) {
        this.encoding = encoding;
        this.digest = new SM3Digest();
    }

    public SM2Signer(DSAEncoding encoding, Digest digest) {
        this.encoding = encoding;
        this.digest = digest;
    }

    @Override
    public void init(boolean forSigning, CipherParameters param) {
        byte[] userID;
        CipherParameters baseParam;
        if (param instanceof ParametersWithID) {
            baseParam = ((ParametersWithID)param).getParameters();
            userID = ((ParametersWithID)param).getID();
            if (userID.length >= 8192) {
                throw new IllegalArgumentException("SM2 user ID must be less than 2^16 bits long");
            }
        } else {
            baseParam = param;
            userID = Hex.decode("31323334353637383132333435363738");
        }
        if (forSigning) {
            if (baseParam instanceof ParametersWithRandom) {
                ParametersWithRandom rParam = (ParametersWithRandom)baseParam;
                this.ecKey = (ECKeyParameters)rParam.getParameters();
                this.ecParams = this.ecKey.getParameters();
                this.kCalculator.init(this.ecParams.getN(), rParam.getRandom());
            } else {
                this.ecKey = (ECKeyParameters)baseParam;
                this.ecParams = this.ecKey.getParameters();
                this.kCalculator.init(this.ecParams.getN(), CryptoServicesRegistrar.getSecureRandom());
            }
            this.pubPoint = this.createBasePointMultiplier().multiply(this.ecParams.getG(), ((ECPrivateKeyParameters)this.ecKey).getD()).normalize();
        } else {
            this.ecKey = (ECKeyParameters)baseParam;
            this.ecParams = this.ecKey.getParameters();
            this.pubPoint = ((ECPublicKeyParameters)this.ecKey).getQ();
        }
        this.z = this.getZ(userID);
        this.digest.update(this.z, 0, this.z.length);
    }

    public void initHashed(boolean forSigning, CipherParameters param) {
        CipherParameters baseParam;
        if (param instanceof ParametersWithID) {
            baseParam = ((ParametersWithID)param).getParameters();
            byte[] userID = ((ParametersWithID)param).getID();
            if (userID.length >= 8192) {
                throw new IllegalArgumentException("SM2 user ID must be less than 2^16 bits long");
            }
        } else {
            baseParam = param;
            byte[] userID = Hex.decode("31323334353637383132333435363738");
        }
        if (forSigning) {
            if (baseParam instanceof ParametersWithRandom) {
                ParametersWithRandom rParam = (ParametersWithRandom)baseParam;
                this.ecKey = (ECKeyParameters)rParam.getParameters();
                this.ecParams = this.ecKey.getParameters();
                this.kCalculator.init(this.ecParams.getN(), rParam.getRandom());
            } else {
                this.ecKey = (ECKeyParameters)baseParam;
                this.ecParams = this.ecKey.getParameters();
                this.kCalculator.init(this.ecParams.getN(), CryptoServicesRegistrar.getSecureRandom());
            }
            this.pubPoint = this.createBasePointMultiplier().multiply(this.ecParams.getG(), ((ECPrivateKeyParameters)this.ecKey).getD()).normalize();
        } else {
            this.ecKey = (ECKeyParameters)baseParam;
            this.ecParams = this.ecKey.getParameters();
            this.pubPoint = ((ECPublicKeyParameters)this.ecKey).getQ();
        }
    }

    public void updateHashed(byte[] b) {
        this.hashData = b;
    }

    @Override
    public void update(byte b) {
        this.digest.update(b);
    }

    @Override
    public void update(byte[] in, int off, int len) {
        this.digest.update(in, off, len);
    }

    @Override
    public boolean verifySignature(byte[] signature) {
        try {
            BigInteger[] rs = this.encoding.decode(this.ecParams.getN(), signature);
            return this.verifySignature(rs[0], rs[1]);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean verifyHashedSignature(byte[] signature) {
        try {
            BigInteger[] rs = this.encoding.decode(this.ecParams.getN(), signature);
            return this.verifyHashedSignature(rs[0], rs[1]);
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public void reset() {
        this.digest.reset();
        if (this.z != null) {
            this.digest.update(this.z, 0, this.z.length);
        }
    }

    public byte[] generateHashedSignature() throws CryptoException {
        BigInteger s2;
        BigInteger r;
        byte[] eHash = this.getHashData();
        BigInteger n = this.ecParams.getN();
        BigInteger e = this.calculateE(n, eHash);
        BigInteger d = ((ECPrivateKeyParameters)this.ecKey).getD();
        ECMultiplier basePointMultiplier = this.createBasePointMultiplier();
        while (true) {
            BigInteger k = this.kCalculator.nextK();
            ECPoint p = basePointMultiplier.multiply(this.ecParams.getG(), k).normalize();
            r = e.add(p.getAffineXCoord().toBigInteger()).mod(n);
            if (r.equals(ZERO) || r.add(k).equals(n)) continue;
            BigInteger dPlus1ModN = d.add(ONE).modInverse(n);
            s2 = k.subtract(r.multiply(d)).mod(n);
            if (!(s2 = dPlus1ModN.multiply(s2).mod(n)).equals(ZERO)) break;
        }
        try {
            return this.encoding.encode(this.ecParams.getN(), r, s2);
        }
        catch (Exception ex) {
            throw new CryptoException("unable to encode signature: " + ex.getMessage(), ex);
        }
    }

    @Override
    public byte[] generateSignature() throws CryptoException {
        BigInteger s2;
        BigInteger r;
        byte[] eHash = this.digestDoFinal();
        BigInteger n = this.ecParams.getN();
        BigInteger e = this.calculateE(n, eHash);
        BigInteger d = ((ECPrivateKeyParameters)this.ecKey).getD();
        ECMultiplier basePointMultiplier = this.createBasePointMultiplier();
        while (true) {
            BigInteger k = this.kCalculator.nextK();
            ECPoint p = basePointMultiplier.multiply(this.ecParams.getG(), k).normalize();
            r = e.add(p.getAffineXCoord().toBigInteger()).mod(n);
            if (r.equals(ZERO) || r.add(k).equals(n)) continue;
            BigInteger dPlus1ModN = d.add(ONE).modInverse(n);
            s2 = k.subtract(r.multiply(d)).mod(n);
            if (!(s2 = dPlus1ModN.multiply(s2).mod(n)).equals(ZERO)) break;
        }
        try {
            return this.encoding.encode(this.ecParams.getN(), r, s2);
        }
        catch (Exception ex) {
            throw new CryptoException("unable to encode signature: " + ex.getMessage(), ex);
        }
    }

    private boolean verifyHashedSignature(BigInteger r, BigInteger s2) {
        BigInteger n = this.ecParams.getN();
        if (r.compareTo(ONE) < 0 || r.compareTo(n) >= 0) {
            return false;
        }
        if (s2.compareTo(ONE) < 0 || s2.compareTo(n) >= 0) {
            return false;
        }
        byte[] eHash = this.getHashData();
        BigInteger e = this.calculateE(n, eHash);
        BigInteger t = r.add(s2).mod(n);
        if (t.equals(ZERO)) {
            return false;
        }
        ECPoint q = ((ECPublicKeyParameters)this.ecKey).getQ();
        ECPoint x1y1 = ECAlgorithms.sumOfTwoMultiplies(this.ecParams.getG(), s2, q, t).normalize();
        if (x1y1.isInfinity()) {
            return false;
        }
        BigInteger expectedR = e.add(x1y1.getAffineXCoord().toBigInteger()).mod(n);
        return expectedR.equals(r);
    }

    private boolean verifySignature(BigInteger r, BigInteger s2) {
        BigInteger n = this.ecParams.getN();
        if (r.compareTo(ONE) < 0 || r.compareTo(n) >= 0) {
            return false;
        }
        if (s2.compareTo(ONE) < 0 || s2.compareTo(n) >= 0) {
            return false;
        }
        byte[] eHash = this.digestDoFinal();
        BigInteger e = this.calculateE(n, eHash);
        BigInteger t = r.add(s2).mod(n);
        if (t.equals(ZERO)) {
            return false;
        }
        ECPoint q = ((ECPublicKeyParameters)this.ecKey).getQ();
        ECPoint x1y1 = ECAlgorithms.sumOfTwoMultiplies(this.ecParams.getG(), s2, q, t).normalize();
        if (x1y1.isInfinity()) {
            return false;
        }
        BigInteger expectedR = e.add(x1y1.getAffineXCoord().toBigInteger()).mod(n);
        return expectedR.equals(r);
    }

    private byte[] getHashData() {
        byte[] result = this.hashData;
        this.hashData = null;
        return result;
    }

    private byte[] digestDoFinal() {
        byte[] result = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(result, 0);
        this.reset();
        return result;
    }

    private byte[] getZ(byte[] userID) {
        this.digest.reset();
        this.addUserID(this.digest, userID);
        this.addFieldElement(this.digest, this.ecParams.getCurve().getA());
        this.addFieldElement(this.digest, this.ecParams.getCurve().getB());
        this.addFieldElement(this.digest, this.ecParams.getG().getAffineXCoord());
        this.addFieldElement(this.digest, this.ecParams.getG().getAffineYCoord());
        this.addFieldElement(this.digest, this.pubPoint.getAffineXCoord());
        this.addFieldElement(this.digest, this.pubPoint.getAffineYCoord());
        byte[] result = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(result, 0);
        return result;
    }

    private void addUserID(Digest digest, byte[] userID) {
        int len = userID.length * 8;
        digest.update((byte)(len >> 8 & 0xFF));
        digest.update((byte)(len & 0xFF));
        digest.update(userID, 0, userID.length);
    }

    private void addFieldElement(Digest digest, ECFieldElement v) {
        byte[] p = v.getEncoded();
        digest.update(p, 0, p.length);
    }

    protected ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }

    protected BigInteger calculateE(BigInteger n, byte[] message) {
        return new BigInteger(1, message);
    }
}

