/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.crypto.signers;

import cn.org.bjca.gaia.crypto.CipherParameters;
import cn.org.bjca.gaia.crypto.CryptoServicesRegistrar;
import cn.org.bjca.gaia.crypto.DSAExt;
import cn.org.bjca.gaia.crypto.params.GOST3410KeyParameters;
import cn.org.bjca.gaia.crypto.params.GOST3410Parameters;
import cn.org.bjca.gaia.crypto.params.GOST3410PrivateKeyParameters;
import cn.org.bjca.gaia.crypto.params.GOST3410PublicKeyParameters;
import cn.org.bjca.gaia.crypto.params.ParametersWithRandom;
import cn.org.bjca.gaia.util.BigIntegers;
import java.math.BigInteger;
import java.security.SecureRandom;

public class GOST3410Signer
implements DSAExt {
    GOST3410KeyParameters key;
    SecureRandom random;

    @Override
    public void init(boolean forSigning, CipherParameters param) {
        if (forSigning) {
            if (param instanceof ParametersWithRandom) {
                ParametersWithRandom rParam = (ParametersWithRandom)param;
                this.random = rParam.getRandom();
                this.key = (GOST3410PrivateKeyParameters)rParam.getParameters();
            } else {
                this.random = CryptoServicesRegistrar.getSecureRandom();
                this.key = (GOST3410PrivateKeyParameters)param;
            }
        } else {
            this.key = (GOST3410PublicKeyParameters)param;
        }
    }

    @Override
    public BigInteger getOrder() {
        return this.key.getParameters().getQ();
    }

    @Override
    public BigInteger[] generateSignature(byte[] message) {
        BigInteger k;
        byte[] mRev = new byte[message.length];
        for (int i = 0; i != mRev.length; ++i) {
            mRev[i] = message[mRev.length - 1 - i];
        }
        BigInteger m3 = new BigInteger(1, mRev);
        GOST3410Parameters params = this.key.getParameters();
        while ((k = BigIntegers.createRandomBigInteger(params.getQ().bitLength(), this.random)).compareTo(params.getQ()) >= 0) {
        }
        BigInteger r = params.getA().modPow(k, params.getP()).mod(params.getQ());
        BigInteger s2 = k.multiply(m3).add(((GOST3410PrivateKeyParameters)this.key).getX().multiply(r)).mod(params.getQ());
        BigInteger[] res = new BigInteger[]{r, s2};
        return res;
    }

    @Override
    public boolean verifySignature(byte[] message, BigInteger r, BigInteger s2) {
        byte[] mRev = new byte[message.length];
        for (int i = 0; i != mRev.length; ++i) {
            mRev[i] = message[mRev.length - 1 - i];
        }
        BigInteger m3 = new BigInteger(1, mRev);
        GOST3410Parameters params = this.key.getParameters();
        BigInteger zero = BigInteger.valueOf(0L);
        if (zero.compareTo(r) >= 0 || params.getQ().compareTo(r) <= 0) {
            return false;
        }
        if (zero.compareTo(s2) >= 0 || params.getQ().compareTo(s2) <= 0) {
            return false;
        }
        BigInteger v = m3.modPow(params.getQ().subtract(new BigInteger("2")), params.getQ());
        BigInteger z1 = s2.multiply(v).mod(params.getQ());
        BigInteger z2 = params.getQ().subtract(r).multiply(v).mod(params.getQ());
        z1 = params.getA().modPow(z1, params.getP());
        z2 = ((GOST3410PublicKeyParameters)this.key).getY().modPow(z2, params.getP());
        BigInteger u = z1.multiply(z2).mod(params.getP()).mod(params.getQ());
        return u.equals(r);
    }
}

