/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.crypto.signers;

import cn.org.bjca.gaia.crypto.CipherParameters;
import cn.org.bjca.gaia.crypto.CryptoServicesRegistrar;
import cn.org.bjca.gaia.crypto.DSAExt;
import cn.org.bjca.gaia.crypto.params.ECDomainParameters;
import cn.org.bjca.gaia.crypto.params.ECKeyParameters;
import cn.org.bjca.gaia.crypto.params.ECPrivateKeyParameters;
import cn.org.bjca.gaia.crypto.params.ECPublicKeyParameters;
import cn.org.bjca.gaia.crypto.params.ParametersWithRandom;
import cn.org.bjca.gaia.math.ec.ECAlgorithms;
import cn.org.bjca.gaia.math.ec.ECCurve;
import cn.org.bjca.gaia.math.ec.ECFieldElement;
import cn.org.bjca.gaia.math.ec.ECMultiplier;
import cn.org.bjca.gaia.math.ec.ECPoint;
import cn.org.bjca.gaia.math.ec.FixedPointCombMultiplier;
import cn.org.bjca.gaia.util.Arrays;
import cn.org.bjca.gaia.util.BigIntegers;
import java.math.BigInteger;
import java.security.SecureRandom;

public class DSTU4145Signer
implements DSAExt {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private ECKeyParameters key;
    private SecureRandom random;

    @Override
    public void init(boolean forSigning, CipherParameters param) {
        if (forSigning) {
            if (param instanceof ParametersWithRandom) {
                ParametersWithRandom rParam = (ParametersWithRandom)param;
                this.random = rParam.getRandom();
                param = rParam.getParameters();
            } else {
                this.random = CryptoServicesRegistrar.getSecureRandom();
            }
            this.key = (ECPrivateKeyParameters)param;
        } else {
            this.key = (ECPublicKeyParameters)param;
        }
    }

    @Override
    public BigInteger getOrder() {
        return this.key.getParameters().getN();
    }

    @Override
    public BigInteger[] generateSignature(byte[] message) {
        BigInteger s2;
        ECFieldElement y;
        BigInteger r;
        BigInteger e;
        ECFieldElement Fe;
        ECDomainParameters ec = this.key.getParameters();
        ECCurve curve = ec.getCurve();
        ECFieldElement h2 = DSTU4145Signer.hash2FieldElement(curve, message);
        if (h2.isZero()) {
            h2 = curve.fromBigInteger(ONE);
        }
        BigInteger n = ec.getN();
        BigInteger d = ((ECPrivateKeyParameters)this.key).getD();
        ECMultiplier basePointMultiplier = this.createBasePointMultiplier();
        do {
            e = DSTU4145Signer.generateRandomInteger(n, this.random);
        } while ((Fe = basePointMultiplier.multiply(ec.getG(), e).normalize().getAffineXCoord()).isZero() || (r = DSTU4145Signer.fieldElement2Integer(n, y = h2.multiply(Fe))).signum() == 0 || (s2 = r.multiply(d).add(e).mod(n)).signum() == 0);
        return new BigInteger[]{r, s2};
    }

    @Override
    public boolean verifySignature(byte[] message, BigInteger r, BigInteger s2) {
        ECPoint R;
        if (r.signum() <= 0 || s2.signum() <= 0) {
            return false;
        }
        ECDomainParameters parameters = this.key.getParameters();
        BigInteger n = parameters.getN();
        if (r.compareTo(n) >= 0 || s2.compareTo(n) >= 0) {
            return false;
        }
        ECCurve curve = parameters.getCurve();
        ECFieldElement h2 = DSTU4145Signer.hash2FieldElement(curve, message);
        if (h2.isZero()) {
            h2 = curve.fromBigInteger(ONE);
        }
        if ((R = ECAlgorithms.sumOfTwoMultiplies(parameters.getG(), s2, ((ECPublicKeyParameters)this.key).getQ(), r).normalize()).isInfinity()) {
            return false;
        }
        ECFieldElement y = h2.multiply(R.getAffineXCoord());
        return DSTU4145Signer.fieldElement2Integer(n, y).compareTo(r) == 0;
    }

    protected ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }

    private static BigInteger generateRandomInteger(BigInteger n, SecureRandom random) {
        return BigIntegers.createRandomBigInteger(n.bitLength() - 1, random);
    }

    private static ECFieldElement hash2FieldElement(ECCurve curve, byte[] hash) {
        byte[] data = Arrays.reverse(hash);
        return curve.fromBigInteger(DSTU4145Signer.truncate(new BigInteger(1, data), curve.getFieldSize()));
    }

    private static BigInteger fieldElement2Integer(BigInteger n, ECFieldElement fe) {
        return DSTU4145Signer.truncate(fe.toBigInteger(), n.bitLength() - 1);
    }

    private static BigInteger truncate(BigInteger x, int bitLength) {
        if (x.bitLength() > bitLength) {
            x = x.mod(ONE.shiftLeft(bitLength));
        }
        return x;
    }
}

