/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.crypto.params;

import cn.org.bjca.gaia.crypto.CipherParameters;
import cn.org.bjca.gaia.crypto.params.DHValidationParameters;
import java.math.BigInteger;

public class DHParameters
implements CipherParameters {
    private static final int DEFAULT_MINIMUM_LENGTH = 160;
    private BigInteger g;
    private BigInteger p;
    private BigInteger q;
    private BigInteger j;
    private int m;
    private int l;
    private DHValidationParameters validation;

    private static int getDefaultMParam(int lParam) {
        if (lParam == 0) {
            return 160;
        }
        return lParam < 160 ? lParam : 160;
    }

    public DHParameters(BigInteger p, BigInteger g2) {
        this(p, g2, null, 0);
    }

    public DHParameters(BigInteger p, BigInteger g2, BigInteger q) {
        this(p, g2, q, 0);
    }

    public DHParameters(BigInteger p, BigInteger g2, BigInteger q, int l) {
        this(p, g2, q, DHParameters.getDefaultMParam(l), l, null, null);
    }

    public DHParameters(BigInteger p, BigInteger g2, BigInteger q, int m3, int l) {
        this(p, g2, q, m3, l, null, null);
    }

    public DHParameters(BigInteger p, BigInteger g2, BigInteger q, BigInteger j, DHValidationParameters validation) {
        this(p, g2, q, 160, 0, j, validation);
    }

    public DHParameters(BigInteger p, BigInteger g2, BigInteger q, int m3, int l, BigInteger j, DHValidationParameters validation) {
        if (l != 0) {
            if (l > p.bitLength()) {
                throw new IllegalArgumentException("when l value specified, it must satisfy 2^(l-1) <= p");
            }
            if (l < m3) {
                throw new IllegalArgumentException("when l value specified, it may not be less than m value");
            }
        }
        if (m3 > p.bitLength()) {
            throw new IllegalArgumentException("unsafe p value so small specific l required");
        }
        this.g = g2;
        this.p = p;
        this.q = q;
        this.m = m3;
        this.l = l;
        this.j = j;
        this.validation = validation;
    }

    public BigInteger getP() {
        return this.p;
    }

    public BigInteger getG() {
        return this.g;
    }

    public BigInteger getQ() {
        return this.q;
    }

    public BigInteger getJ() {
        return this.j;
    }

    public int getM() {
        return this.m;
    }

    public int getL() {
        return this.l;
    }

    public DHValidationParameters getValidationParameters() {
        return this.validation;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DHParameters)) {
            return false;
        }
        DHParameters pm = (DHParameters)obj;
        if (this.getQ() != null ? !this.getQ().equals(pm.getQ()) : pm.getQ() != null) {
            return false;
        }
        return pm.getP().equals(this.p) && pm.getG().equals(this.g);
    }

    public int hashCode() {
        return this.getP().hashCode() ^ this.getG().hashCode() ^ (this.getQ() != null ? this.getQ().hashCode() : 0);
    }
}

