/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.crypto.kems;

import cn.org.bjca.gaia.crypto.CipherParameters;
import cn.org.bjca.gaia.crypto.DerivationFunction;
import cn.org.bjca.gaia.crypto.KeyEncapsulation;
import cn.org.bjca.gaia.crypto.params.KDFParameters;
import cn.org.bjca.gaia.crypto.params.KeyParameter;
import cn.org.bjca.gaia.crypto.params.RSAKeyParameters;
import cn.org.bjca.gaia.util.BigIntegers;
import java.math.BigInteger;
import java.security.SecureRandom;

public class RSAKeyEncapsulation
implements KeyEncapsulation {
    private static final BigInteger ZERO = BigInteger.valueOf(0L);
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private DerivationFunction kdf;
    private SecureRandom rnd;
    private RSAKeyParameters key;

    public RSAKeyEncapsulation(DerivationFunction kdf, SecureRandom rnd) {
        this.kdf = kdf;
        this.rnd = rnd;
    }

    @Override
    public void init(CipherParameters key) throws IllegalArgumentException {
        if (!(key instanceof RSAKeyParameters)) {
            throw new IllegalArgumentException("RSA key required");
        }
        this.key = (RSAKeyParameters)key;
    }

    @Override
    public CipherParameters encrypt(byte[] out, int outOff, int keyLen) throws IllegalArgumentException {
        if (this.key.isPrivate()) {
            throw new IllegalArgumentException("Public key required for encryption");
        }
        BigInteger n = this.key.getModulus();
        BigInteger e = this.key.getExponent();
        BigInteger r = BigIntegers.createRandomInRange(ZERO, n.subtract(ONE), this.rnd);
        BigInteger c = r.modPow(e, n);
        byte[] C2 = BigIntegers.asUnsignedByteArray((n.bitLength() + 7) / 8, c);
        System.arraycopy(C2, 0, out, outOff, C2.length);
        return this.generateKey(n, r, keyLen);
    }

    public CipherParameters encrypt(byte[] out, int keyLen) {
        return this.encrypt(out, 0, keyLen);
    }

    @Override
    public CipherParameters decrypt(byte[] in, int inOff, int inLen, int keyLen) throws IllegalArgumentException {
        if (!this.key.isPrivate()) {
            throw new IllegalArgumentException("Private key required for decryption");
        }
        BigInteger n = this.key.getModulus();
        BigInteger d = this.key.getExponent();
        byte[] C2 = new byte[inLen];
        System.arraycopy(in, inOff, C2, 0, C2.length);
        BigInteger c = new BigInteger(1, C2);
        BigInteger r = c.modPow(d, n);
        return this.generateKey(n, r, keyLen);
    }

    public CipherParameters decrypt(byte[] in, int keyLen) {
        return this.decrypt(in, 0, in.length, keyLen);
    }

    protected KeyParameter generateKey(BigInteger n, BigInteger r, int keyLen) {
        byte[] R = BigIntegers.asUnsignedByteArray((n.bitLength() + 7) / 8, r);
        this.kdf.init(new KDFParameters(R, null));
        byte[] K2 = new byte[keyLen];
        this.kdf.generateBytes(K2, 0, K2.length);
        return new KeyParameter(K2);
    }
}

