/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.crypto.generators;

import cn.org.bjca.gaia.crypto.DataLengthException;
import cn.org.bjca.gaia.crypto.DerivationFunction;
import cn.org.bjca.gaia.crypto.DerivationParameters;
import cn.org.bjca.gaia.crypto.Digest;
import cn.org.bjca.gaia.crypto.OutputLengthException;
import cn.org.bjca.gaia.crypto.params.MGFParameters;

public class MGF1BytesGenerator
implements DerivationFunction {
    private Digest digest;
    private byte[] seed;
    private int hLen;

    public MGF1BytesGenerator(Digest digest) {
        this.digest = digest;
        this.hLen = digest.getDigestSize();
    }

    @Override
    public void init(DerivationParameters param) {
        if (!(param instanceof MGFParameters)) {
            throw new IllegalArgumentException("MGF parameters required for MGF1Generator");
        }
        MGFParameters p = (MGFParameters)param;
        this.seed = p.getSeed();
    }

    public Digest getDigest() {
        return this.digest;
    }

    private void ItoOSP(int i, byte[] sp) {
        sp[0] = (byte)(i >>> 24);
        sp[1] = (byte)(i >>> 16);
        sp[2] = (byte)(i >>> 8);
        sp[3] = (byte)(i >>> 0);
    }

    @Override
    public int generateBytes(byte[] out, int outOff, int len) throws DataLengthException, IllegalArgumentException {
        if (out.length - len < outOff) {
            throw new OutputLengthException("output buffer too small");
        }
        byte[] hashBuf = new byte[this.hLen];
        byte[] C2 = new byte[4];
        int counter = 0;
        this.digest.reset();
        if (len > this.hLen) {
            do {
                this.ItoOSP(counter, C2);
                this.digest.update(this.seed, 0, this.seed.length);
                this.digest.update(C2, 0, C2.length);
                this.digest.doFinal(hashBuf, 0);
                System.arraycopy(hashBuf, 0, out, outOff + counter * this.hLen, this.hLen);
            } while (++counter < len / this.hLen);
        }
        if (counter * this.hLen < len) {
            this.ItoOSP(counter, C2);
            this.digest.update(this.seed, 0, this.seed.length);
            this.digest.update(C2, 0, C2.length);
            this.digest.doFinal(hashBuf, 0);
            System.arraycopy(hashBuf, 0, out, outOff + counter * this.hLen, len - counter * this.hLen);
        }
        return len;
    }
}

