/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.crypto.engines;

import cn.org.bjca.gaia.asn1.ASN1EncodableVector;
import cn.org.bjca.gaia.asn1.ASN1InputStream;
import cn.org.bjca.gaia.asn1.ASN1Integer;
import cn.org.bjca.gaia.asn1.ASN1Primitive;
import cn.org.bjca.gaia.asn1.ASN1Sequence;
import cn.org.bjca.gaia.asn1.DEROctetString;
import cn.org.bjca.gaia.asn1.DERSequence;
import cn.org.bjca.gaia.crypto.CipherParameters;
import cn.org.bjca.gaia.crypto.Digest;
import cn.org.bjca.gaia.crypto.InvalidCipherTextException;
import cn.org.bjca.gaia.crypto.digests.SM3Digest;
import cn.org.bjca.gaia.crypto.params.ECDomainParameters;
import cn.org.bjca.gaia.crypto.params.ECKeyParameters;
import cn.org.bjca.gaia.crypto.params.ECPrivateKeyParameters;
import cn.org.bjca.gaia.crypto.params.ECPublicKeyParameters;
import cn.org.bjca.gaia.crypto.params.ParametersWithRandom;
import cn.org.bjca.gaia.math.ec.ECFieldElement;
import cn.org.bjca.gaia.math.ec.ECMultiplier;
import cn.org.bjca.gaia.math.ec.ECPoint;
import cn.org.bjca.gaia.math.ec.FixedPointCombMultiplier;
import cn.org.bjca.gaia.util.Arrays;
import cn.org.bjca.gaia.util.BigIntegers;
import cn.org.bjca.gaia.util.Memoable;
import cn.org.bjca.gaia.util.Pack;
import java.io.IOException;
import java.math.BigInteger;
import java.security.SecureRandom;

public class SM2Engine {
    private final Digest digest;
    private final Mode mode;
    private boolean forEncryption;
    private ECKeyParameters ecKey;
    private ECDomainParameters ecParams;
    private int curveLength;
    private SecureRandom random;

    public SM2Engine() {
        this(new SM3Digest());
    }

    public SM2Engine(Mode mode) {
        this(new SM3Digest(), mode);
    }

    public SM2Engine(Digest digest) {
        this(digest, Mode.C1C2C3);
    }

    public SM2Engine(Digest digest, Mode mode) {
        if (mode == null) {
            throw new IllegalArgumentException("mode cannot be NULL");
        }
        this.digest = digest;
        this.mode = mode;
    }

    public void init(boolean forEncryption, CipherParameters param) {
        this.forEncryption = forEncryption;
        if (forEncryption) {
            ParametersWithRandom rParam = (ParametersWithRandom)param;
            this.ecKey = (ECKeyParameters)rParam.getParameters();
            this.ecParams = this.ecKey.getParameters();
            ECPoint s2 = ((ECPublicKeyParameters)this.ecKey).getQ().multiply(this.ecParams.getH());
            if (s2.isInfinity()) {
                throw new IllegalArgumentException("invalid key: [h]Q at infinity");
            }
            this.random = rParam.getRandom();
        } else {
            this.ecKey = (ECKeyParameters)param;
            this.ecParams = this.ecKey.getParameters();
        }
        this.curveLength = (this.ecParams.getCurve().getFieldSize() + 7) / 8;
    }

    public byte[] processBlock(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        if (this.forEncryption) {
            return this.encrypt(in, inOff, inLen);
        }
        return this.decrypt(in, inOff, inLen);
    }

    public byte[] processBlockDer(byte[] in, int inOff, int inLen) throws InvalidCipherTextException, IOException {
        if (this.forEncryption) {
            return this.encryptDer(in, inOff, inLen);
        }
        return this.decryptDer(in, inOff, inLen);
    }

    public int getOutputSize(int inputLen) {
        return 1 + 2 * this.curveLength + inputLen + this.digest.getDigestSize();
    }

    protected ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }

    private byte[] encrypt(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        ECPoint kPB;
        byte[] c1;
        byte[] c2 = new byte[inLen];
        System.arraycopy(in, inOff, c2, 0, c2.length);
        ECMultiplier multiplier = this.createBasePointMultiplier();
        do {
            BigInteger k = this.nextK();
            ECPoint c1P = multiplier.multiply(this.ecParams.getG(), k).normalize();
            c1 = c1P.getEncoded(false);
            kPB = ((ECPublicKeyParameters)this.ecKey).getQ().multiply(k).normalize();
            this.kdf(this.digest, kPB, c2);
        } while (this.notEncrypted(c2, in, inOff));
        byte[] c3 = new byte[this.digest.getDigestSize()];
        this.addFieldElement(this.digest, kPB.getAffineXCoord());
        this.digest.update(in, inOff, inLen);
        this.addFieldElement(this.digest, kPB.getAffineYCoord());
        this.digest.doFinal(c3, 0);
        switch (this.mode) {
            case C1C3C2: {
                return Arrays.concatenate(c1, c3, c2);
            }
        }
        return Arrays.concatenate(c1, c2, c3);
    }

    private byte[] encryptDer(byte[] in, int inOff, int inLen) throws InvalidCipherTextException, IOException {
        ECPoint kPB;
        ECPoint c1P;
        byte[] c2 = new byte[inLen];
        System.arraycopy(in, inOff, c2, 0, c2.length);
        ECMultiplier multiplier = this.createBasePointMultiplier();
        do {
            BigInteger k = this.nextK();
            c1P = multiplier.multiply(this.ecParams.getG(), k).normalize();
            byte[] c1 = c1P.getEncoded(false);
            kPB = ((ECPublicKeyParameters)this.ecKey).getQ().multiply(k).normalize();
            this.kdf(this.digest, kPB, c2);
        } while (this.notEncrypted(c2, in, inOff));
        byte[] c3 = new byte[this.digest.getDigestSize()];
        this.addFieldElement(this.digest, kPB.getAffineXCoord());
        this.digest.update(in, inOff, inLen);
        this.addFieldElement(this.digest, kPB.getAffineYCoord());
        this.digest.doFinal(c3, 0);
        ASN1EncodableVector enVector = new ASN1EncodableVector();
        ASN1Integer x = new ASN1Integer(c1P.getXCoord().toBigInteger());
        ASN1Integer y = new ASN1Integer(c1P.getYCoord().toBigInteger());
        DEROctetString hashOctStr = new DEROctetString(c3);
        DEROctetString enOctStr = new DEROctetString(c2);
        enVector.add(x);
        enVector.add(y);
        switch (this.mode) {
            case C1C3C2: {
                enVector.add(hashOctStr);
                enVector.add(enOctStr);
                return new DERSequence(enVector).getEncoded();
            }
        }
        enVector.add(enOctStr);
        enVector.add(hashOctStr);
        return new DERSequence(enVector).getEncoded();
    }

    private byte[] decrypt(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        byte[] c1 = new byte[this.curveLength * 2 + 1];
        System.arraycopy(in, inOff, c1, 0, c1.length);
        ECPoint c1P = this.ecParams.getCurve().decodePoint(c1);
        ECPoint s2 = c1P.multiply(this.ecParams.getH());
        if (s2.isInfinity()) {
            throw new InvalidCipherTextException("[h]C1 at infinity");
        }
        c1P = c1P.multiply(((ECPrivateKeyParameters)this.ecKey).getD()).normalize();
        int digestSize = this.digest.getDigestSize();
        byte[] c2 = new byte[inLen - c1.length - digestSize];
        if (this.mode == Mode.C1C3C2) {
            System.arraycopy(in, inOff + c1.length + digestSize, c2, 0, c2.length);
        } else {
            System.arraycopy(in, inOff + c1.length, c2, 0, c2.length);
        }
        this.kdf(this.digest, c1P, c2);
        byte[] c3 = new byte[this.digest.getDigestSize()];
        this.addFieldElement(this.digest, c1P.getAffineXCoord());
        this.digest.update(c2, 0, c2.length);
        this.addFieldElement(this.digest, c1P.getAffineYCoord());
        this.digest.doFinal(c3, 0);
        int check = 0;
        if (this.mode == Mode.C1C3C2) {
            for (int i = 0; i != c3.length; ++i) {
                check |= c3[i] ^ in[inOff + c1.length + i];
            }
        } else {
            for (int i = 0; i != c3.length; ++i) {
                check |= c3[i] ^ in[inOff + c1.length + c2.length + i];
            }
        }
        Arrays.fill(c1, (byte)0);
        Arrays.fill(c3, (byte)0);
        if (check != 0) {
            Arrays.fill(c2, (byte)0);
            throw new InvalidCipherTextException("invalid cipher text");
        }
        return c2;
    }

    private byte[] decryptDer(byte[] bCipher, int inOff, int inLen) throws InvalidCipherTextException, IOException {
        ASN1InputStream inStr = new ASN1InputStream(bCipher);
        ASN1Primitive obj = inStr.readObject();
        ASN1Sequence enSeq = ASN1Sequence.getInstance(obj);
        ASN1Primitive bXObj = enSeq.getObjectAt(0).toASN1Primitive();
        ASN1Integer x = (ASN1Integer)bXObj;
        byte[] bX = BigIntegers.asUnsignedByteArray(x.getValue());
        BigInteger bXx = new BigInteger(1, bX);
        ASN1Primitive bYObj = enSeq.getObjectAt(1).toASN1Primitive();
        ASN1Integer y = (ASN1Integer)bYObj;
        byte[] bY = BigIntegers.asUnsignedByteArray(y.getValue());
        BigInteger bYy = new BigInteger(1, bY);
        ASN1Primitive bHashObj = enSeq.getObjectAt(2).toASN1Primitive();
        DEROctetString hashOctStr = (DEROctetString)bHashObj;
        byte[] bHash = hashOctStr.getOctets();
        ASN1Primitive cObj = enSeq.getObjectAt(3).toASN1Primitive();
        DEROctetString cOctStr = (DEROctetString)cObj;
        byte[] c = cOctStr.getOctets();
        byte[] head = new byte[]{4};
        byte[] buf = new byte[64];
        System.arraycopy(bX, 0, buf, 32 - bX.length, bX.length);
        System.arraycopy(bY, 0, buf, 64 - bY.length, bY.length);
        byte[] point = Arrays.concatenate(head, buf);
        byte[] in = Arrays.concatenate(point, bHash, c);
        inLen = in.length;
        byte[] c1 = new byte[this.curveLength * 2 + 1];
        System.arraycopy(in, inOff, c1, 0, c1.length);
        ECPoint c1P = this.ecParams.getCurve().createPoint(bXx, bYy);
        ECPoint s2 = c1P.multiply(this.ecParams.getH());
        if (s2.isInfinity()) {
            throw new InvalidCipherTextException("[h]C1 at infinity");
        }
        c1P = c1P.multiply(((ECPrivateKeyParameters)this.ecKey).getD()).normalize();
        int digestSize = this.digest.getDigestSize();
        byte[] c2 = new byte[inLen - c1.length - digestSize];
        if (this.mode == Mode.C1C3C2) {
            System.arraycopy(in, inOff + c1.length + digestSize, c2, 0, c2.length);
        } else {
            System.arraycopy(in, inOff + c1.length, c2, 0, c2.length);
        }
        this.kdf(this.digest, c1P, c2);
        byte[] c3 = new byte[this.digest.getDigestSize()];
        this.addFieldElement(this.digest, c1P.getAffineXCoord());
        this.digest.update(c2, 0, c2.length);
        this.addFieldElement(this.digest, c1P.getAffineYCoord());
        this.digest.doFinal(c3, 0);
        int check = 0;
        if (this.mode == Mode.C1C3C2) {
            for (int i = 0; i != c3.length; ++i) {
                check |= c3[i] ^ in[inOff + c1.length + i];
            }
        } else {
            for (int i = 0; i != c3.length; ++i) {
                check |= c3[i] ^ in[inOff + c1.length + c2.length + i];
            }
        }
        Arrays.fill(c1, (byte)0);
        Arrays.fill(c3, (byte)0);
        if (check != 0) {
            Arrays.fill(c2, (byte)0);
            throw new InvalidCipherTextException("invalid cipher text");
        }
        return c2;
    }

    private boolean notEncrypted(byte[] encData, byte[] in, int inOff) {
        for (int i = 0; i != encData.length; ++i) {
            if (encData[i] == in[inOff + i]) continue;
            return false;
        }
        return true;
    }

    private void kdf(Digest digest, ECPoint c1, byte[] encData) {
        int digestSize = digest.getDigestSize();
        byte[] buf = new byte[Math.max(4, digestSize)];
        int off = 0;
        Memoable memo = null;
        Memoable copy = null;
        if (digest instanceof Memoable) {
            this.addFieldElement(digest, c1.getAffineXCoord());
            this.addFieldElement(digest, c1.getAffineYCoord());
            memo = (Memoable)((Object)digest);
            copy = memo.copy();
        }
        int ct = 0;
        while (off < encData.length) {
            if (memo != null) {
                memo.reset(copy);
            } else {
                this.addFieldElement(digest, c1.getAffineXCoord());
                this.addFieldElement(digest, c1.getAffineYCoord());
            }
            Pack.intToBigEndian(++ct, buf, 0);
            digest.update(buf, 0, 4);
            digest.doFinal(buf, 0);
            int xorLen = Math.min(digestSize, encData.length - off);
            this.xor(encData, buf, off, xorLen);
            off += xorLen;
        }
    }

    private void xor(byte[] data, byte[] kdfOut, int dOff, int dRemaining) {
        for (int i = 0; i != dRemaining; ++i) {
            int n = dOff + i;
            data[n] = (byte)(data[n] ^ kdfOut[i]);
        }
    }

    private BigInteger nextK() {
        BigInteger k;
        int qBitLength = this.ecParams.getN().bitLength();
        while ((k = BigIntegers.createRandomBigInteger(qBitLength, this.random)).equals(BigIntegers.ZERO) || k.compareTo(this.ecParams.getN()) >= 0) {
        }
        return k;
    }

    private void addFieldElement(Digest digest, ECFieldElement v) {
        byte[] p = BigIntegers.asUnsignedByteArray(this.curveLength, v.toBigInteger());
        digest.update(p, 0, p.length);
    }

    public static enum Mode {
        C1C2C3,
        C1C3C2;

    }
}

