/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.crypto.engines;

import cn.org.bjca.gaia.crypto.AsymmetricBlockCipher;
import cn.org.bjca.gaia.crypto.CipherParameters;
import cn.org.bjca.gaia.crypto.CryptoServicesRegistrar;
import cn.org.bjca.gaia.crypto.engines.RSACoreEngine;
import cn.org.bjca.gaia.crypto.params.ParametersWithRandom;
import cn.org.bjca.gaia.crypto.params.RSAKeyParameters;
import cn.org.bjca.gaia.crypto.params.RSAPrivateCrtKeyParameters;
import cn.org.bjca.gaia.util.BigIntegers;
import java.math.BigInteger;
import java.security.SecureRandom;

public class RSABlindedEngine
implements AsymmetricBlockCipher {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private RSACoreEngine core = new RSACoreEngine();
    private RSAKeyParameters key;
    private SecureRandom random;

    @Override
    public void init(boolean forEncryption, CipherParameters param) {
        this.core.init(forEncryption, param);
        if (param instanceof ParametersWithRandom) {
            ParametersWithRandom rParam = (ParametersWithRandom)param;
            this.key = (RSAKeyParameters)rParam.getParameters();
            this.random = rParam.getRandom();
        } else {
            this.key = (RSAKeyParameters)param;
            this.random = CryptoServicesRegistrar.getSecureRandom();
        }
    }

    @Override
    public int getInputBlockSize() {
        return this.core.getInputBlockSize();
    }

    @Override
    public int getOutputBlockSize() {
        return this.core.getOutputBlockSize();
    }

    @Override
    public byte[] processBlock(byte[] in, int inOff, int inLen) {
        BigInteger result;
        if (this.key == null) {
            throw new IllegalStateException("RSA engine not initialised");
        }
        BigInteger input = this.core.convertInput(in, inOff, inLen);
        if (this.key instanceof RSAPrivateCrtKeyParameters) {
            RSAPrivateCrtKeyParameters k = (RSAPrivateCrtKeyParameters)this.key;
            BigInteger e = k.getPublicExponent();
            if (e != null) {
                BigInteger rInv;
                BigInteger m3 = k.getModulus();
                BigInteger r = BigIntegers.createRandomInRange(ONE, m3.subtract(ONE), this.random);
                BigInteger blindedInput = r.modPow(e, m3).multiply(input).mod(m3);
                BigInteger blindedResult = this.core.processBlock(blindedInput);
                result = blindedResult.multiply(rInv = r.modInverse(m3)).mod(m3);
                if (!input.equals(result.modPow(e, m3))) {
                    throw new IllegalStateException("RSA engine faulty decryption/signing detected");
                }
            } else {
                result = this.core.processBlock(input);
            }
        } else {
            result = this.core.processBlock(input);
        }
        return this.core.convertOutput(result);
    }
}

