/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.crypto.engines;

import cn.org.bjca.gaia.crypto.CipherParameters;
import cn.org.bjca.gaia.crypto.engines.GOST28147Engine;
import cn.org.bjca.gaia.crypto.engines.GOST28147WrapEngine;
import cn.org.bjca.gaia.crypto.modes.GCFBBlockCipher;
import cn.org.bjca.gaia.crypto.params.KeyParameter;
import cn.org.bjca.gaia.crypto.params.ParametersWithIV;
import cn.org.bjca.gaia.crypto.params.ParametersWithRandom;
import cn.org.bjca.gaia.crypto.params.ParametersWithSBox;
import cn.org.bjca.gaia.crypto.params.ParametersWithUKM;
import cn.org.bjca.gaia.util.Pack;

public class CryptoProWrapEngine
extends GOST28147WrapEngine {
    @Override
    public void init(boolean forWrapping, CipherParameters param) {
        KeyParameter kParam;
        if (param instanceof ParametersWithRandom) {
            ParametersWithRandom pr = (ParametersWithRandom)param;
            param = pr.getParameters();
        }
        ParametersWithUKM pU = (ParametersWithUKM)param;
        byte[] sBox = null;
        if (pU.getParameters() instanceof ParametersWithSBox) {
            kParam = (KeyParameter)((ParametersWithSBox)pU.getParameters()).getParameters();
            sBox = ((ParametersWithSBox)pU.getParameters()).getSBox();
        } else {
            kParam = (KeyParameter)pU.getParameters();
        }
        kParam = new KeyParameter(CryptoProWrapEngine.cryptoProDiversify(kParam.getKey(), pU.getUKM(), sBox));
        if (sBox != null) {
            super.init(forWrapping, new ParametersWithUKM(new ParametersWithSBox(kParam, sBox), pU.getUKM()));
        } else {
            super.init(forWrapping, new ParametersWithUKM(kParam, pU.getUKM()));
        }
    }

    private static byte[] cryptoProDiversify(byte[] K2, byte[] ukm, byte[] sBox) {
        for (int i = 0; i != 8; ++i) {
            int sOn = 0;
            int sOff = 0;
            for (int j = 0; j != 8; ++j) {
                int kj = Pack.littleEndianToInt(K2, j * 4);
                if (CryptoProWrapEngine.bitSet(ukm[i], j)) {
                    sOn += kj;
                    continue;
                }
                sOff += kj;
            }
            byte[] s2 = new byte[8];
            Pack.intToLittleEndian(sOn, s2, 0);
            Pack.intToLittleEndian(sOff, s2, 4);
            GCFBBlockCipher c = new GCFBBlockCipher(new GOST28147Engine());
            c.init(true, new ParametersWithIV(new ParametersWithSBox(new KeyParameter(K2), sBox), s2));
            c.processBlock(K2, 0, K2, 0);
            c.processBlock(K2, 8, K2, 8);
            c.processBlock(K2, 16, K2, 16);
            c.processBlock(K2, 24, K2, 24);
        }
        return K2;
    }

    private static boolean bitSet(byte v, int bitNo) {
        return (v & 1 << bitNo) != 0;
    }
}

