/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.cert.crmf.jcajce;

import cn.org.bjca.gaia.asn1.x509.AlgorithmIdentifier;
import cn.org.bjca.gaia.cert.crmf.CRMFException;
import cn.org.bjca.gaia.cert.crmf.PKMACValuesCalculator;
import cn.org.bjca.gaia.cert.crmf.jcajce.CRMFHelper;
import cn.org.bjca.gaia.jcajce.util.DefaultJcaJceHelper;
import cn.org.bjca.gaia.jcajce.util.NamedJcaJceHelper;
import cn.org.bjca.gaia.jcajce.util.ProviderJcaJceHelper;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.Provider;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class JcePKMACValuesCalculator
implements PKMACValuesCalculator {
    private MessageDigest digest;
    private Mac mac;
    private CRMFHelper helper = new CRMFHelper(new DefaultJcaJceHelper());

    public JcePKMACValuesCalculator setProvider(Provider provider) {
        this.helper = new CRMFHelper(new ProviderJcaJceHelper(provider));
        return this;
    }

    public JcePKMACValuesCalculator setProvider(String providerName) {
        this.helper = new CRMFHelper(new NamedJcaJceHelper(providerName));
        return this;
    }

    @Override
    public void setup(AlgorithmIdentifier digAlg, AlgorithmIdentifier macAlg) throws CRMFException {
        this.digest = this.helper.createDigest(digAlg.getAlgorithm());
        this.mac = this.helper.createMac(macAlg.getAlgorithm());
    }

    @Override
    public byte[] calculateDigest(byte[] data) {
        return this.digest.digest(data);
    }

    @Override
    public byte[] calculateMac(byte[] pwd, byte[] data) throws CRMFException {
        try {
            this.mac.init(new SecretKeySpec(pwd, this.mac.getAlgorithm()));
            return this.mac.doFinal(data);
        }
        catch (GeneralSecurityException e) {
            throw new CRMFException("failure in setup: " + e.getMessage(), e);
        }
    }
}

