/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.cert.crmf.jcajce;

import cn.org.bjca.gaia.asn1.crmf.EncryptedValue;
import cn.org.bjca.gaia.asn1.pkcs.PrivateKeyInfo;
import cn.org.bjca.gaia.cert.crmf.CRMFException;
import cn.org.bjca.gaia.cert.crmf.EncryptedValueBuilder;
import cn.org.bjca.gaia.cert.jcajce.JcaX509CertificateHolder;
import cn.org.bjca.gaia.operator.KeyWrapper;
import cn.org.bjca.gaia.operator.OutputEncryptor;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;

public class JcaEncryptedValueBuilder
extends EncryptedValueBuilder {
    public JcaEncryptedValueBuilder(KeyWrapper wrapper, OutputEncryptor encryptor) {
        super(wrapper, encryptor);
    }

    public EncryptedValue build(X509Certificate certificate) throws CertificateEncodingException, CRMFException {
        return this.build(new JcaX509CertificateHolder(certificate));
    }

    public EncryptedValue build(PrivateKey privateKey) throws CertificateEncodingException, CRMFException {
        return this.build(PrivateKeyInfo.getInstance(privateKey.getEncoded()));
    }
}

