/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.cert.crmf;

import cn.org.bjca.gaia.asn1.cms.EnvelopedData;
import cn.org.bjca.gaia.asn1.crmf.CRMFObjectIdentifiers;
import cn.org.bjca.gaia.asn1.crmf.EncKeyWithID;
import cn.org.bjca.gaia.asn1.crmf.EncryptedKey;
import cn.org.bjca.gaia.asn1.crmf.PKIArchiveOptions;
import cn.org.bjca.gaia.asn1.pkcs.PrivateKeyInfo;
import cn.org.bjca.gaia.asn1.x509.GeneralName;
import cn.org.bjca.gaia.cert.crmf.PKIArchiveControl;
import cn.org.bjca.gaia.cms.CMSEnvelopedData;
import cn.org.bjca.gaia.cms.CMSEnvelopedDataGenerator;
import cn.org.bjca.gaia.cms.CMSException;
import cn.org.bjca.gaia.cms.CMSProcessableByteArray;
import cn.org.bjca.gaia.cms.RecipientInfoGenerator;
import cn.org.bjca.gaia.operator.OutputEncryptor;
import java.io.IOException;

public class PKIArchiveControlBuilder {
    private CMSEnvelopedDataGenerator envGen;
    private CMSProcessableByteArray keyContent;

    public PKIArchiveControlBuilder(PrivateKeyInfo privateKeyInfo, GeneralName generalName) {
        EncKeyWithID encKeyWithID = new EncKeyWithID(privateKeyInfo, generalName);
        try {
            this.keyContent = new CMSProcessableByteArray(CRMFObjectIdentifiers.id_ct_encKeyWithID, encKeyWithID.getEncoded());
        }
        catch (IOException e) {
            throw new IllegalStateException("unable to encode key and general name info");
        }
        this.envGen = new CMSEnvelopedDataGenerator();
    }

    public PKIArchiveControlBuilder addRecipientGenerator(RecipientInfoGenerator recipientGen) {
        this.envGen.addRecipientInfoGenerator(recipientGen);
        return this;
    }

    public PKIArchiveControl build(OutputEncryptor contentEncryptor) throws CMSException {
        CMSEnvelopedData envContent = this.envGen.generate(this.keyContent, contentEncryptor);
        EnvelopedData envD = EnvelopedData.getInstance(envContent.toASN1Structure().getContent());
        return new PKIArchiveControl(new PKIArchiveOptions(new EncryptedKey(envD)));
    }
}

