/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.assemb.util;

import cn.org.bjca.gaia.assemb.exception.PkiException;
import cn.org.bjca.gaia.assemb.param.BjcaKey;
import cn.org.bjca.gaia.assemb.util.FileUtil;
import cn.org.bjca.gaia.assemb.util.KeyPairUtil;
import cn.org.bjca.gaia.util.encoders.Base64;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;

public class JksUtil {
    public void jksGenerator(String filePath, String jksAlias, BjcaKey privateKey, String storePassword, String keyPassword, String cert) throws PkiException {
        if (!privateKey.getKeyType().equals("RSA_Private")) {
            throw new PkiException("11012001", "\u6784\u9020JKS\u5931\u8d25\u4e0d\u652f\u6301\u7684\u7b97\u6cd5\u7c7b\u578b" + privateKey.getKeyType());
        }
        FileOutputStream fos = null;
        ByteArrayInputStream inStream = null;
        X509Certificate x509Certificate = null;
        try {
            inStream = new ByteArrayInputStream(Base64.decode(cert));
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            x509Certificate = (X509Certificate)cf.generateCertificate(inStream);
        }
        catch (Exception e) {
            throw new PkiException("11012001", "\u6784\u9020JKS\u5931\u8d25,\u89e3\u6790\u8bc1\u4e66\u5931\u8d25", e);
        }
        finally {
            try {
                if (inStream != null) {
                    ((InputStream)inStream).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        Key key = KeyPairUtil.convertKey(privateKey);
        Certificate[] caCertChain = new X509Certificate[]{x509Certificate};
        try {
            KeyStore ks1 = KeyStore.getInstance("JKS");
            ks1.load(null, null);
            ks1.setKeyEntry(jksAlias, key, keyPassword.toCharArray(), caCertChain);
            String dirPath = FileUtil.getDirPathFromFilePath(filePath);
            FileUtil.confirmDir(dirPath);
            fos = new FileOutputStream(filePath);
            ks1.store(fos, storePassword.toCharArray());
        }
        catch (Exception e) {
            throw new PkiException("11012001", "\u6784\u9020JKS\u5931\u8d25 ", e);
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public String exportJksCertificate(byte[] jksByte, String storePassword, String keyAlias) throws PkiException {
        Certificate cert = null;
        try {
            KeyStore keyStore = KeyStore.getInstance("JKS");
            ByteArrayInputStream byteInStream = new ByteArrayInputStream(jksByte);
            keyStore.load(byteInStream, storePassword.toCharArray());
            cert = keyStore.getCertificate(keyAlias);
            return Base64.toBase64String(cert.getEncoded());
        }
        catch (Exception e) {
            throw new PkiException("11012003", "\u4eceJKS\u4e2d\u89e3\u6790\u8bc1\u4e66\u5931\u8d25 ", e);
        }
    }

    public BjcaKey exportJksKey(byte[] jksByte, String storePassword, String keyPassword, String keyAlias) throws PkiException {
        BjcaKey bjcaKey = null;
        try {
            KeyStore keyStore = KeyStore.getInstance("JKS");
            ByteArrayInputStream byteInStream = new ByteArrayInputStream(jksByte);
            keyStore.load(byteInStream, storePassword.toCharArray());
            PrivateKey priKey = (PrivateKey)keyStore.getKey(keyAlias, keyPassword.toCharArray());
            if (!priKey.getAlgorithm().equals("RSA")) {
                throw new PkiException("11012002", "\u4eceJKS\u4e2d\u89e3\u6790\u79c1\u94a5\u5931\u8d25\u4e0d\u652f\u6301\u7684\u7b97\u6cd5\u7c7b\u578b" + priKey.getAlgorithm());
            }
            bjcaKey = new BjcaKey("RSA_Private", priKey.getEncoded());
        }
        catch (Exception e) {
            throw new PkiException("11012002", "\u4eceJKS\u4e2d\u89e3\u6790\u79c1\u94a5\u5931\u8d25 ", e);
        }
        return bjcaKey;
    }

    public ArrayList exportJksAlias(byte[] jksByte, String storePassword) throws PkiException {
        ArrayList<String> aliasList = null;
        try {
            aliasList = new ArrayList<String>();
            KeyStore keyStore = KeyStore.getInstance("JKS");
            ByteArrayInputStream byteInStream = new ByteArrayInputStream(jksByte);
            keyStore.load(byteInStream, storePassword.toCharArray());
            Enumeration<String> aliaseList = keyStore.aliases();
            while (aliaseList.hasMoreElements()) {
                String alis = aliaseList.nextElement();
                aliasList.add(alis.trim());
            }
        }
        catch (Exception e) {
            throw new PkiException("11012004", "\u4eceJKS\u4e2d\u89e3\u6790ALIAS\u522b\u540d\u5931\u8d25 ", e);
        }
        return aliasList;
    }

    public static void main(String[] args) throws PkiException {
        String jks = "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";
        JksUtil jksUtil = new JksUtil();
        BjcaKey privateKey = jksUtil.exportJksKey(Base64.decode(jks), "9TDawUEiG1rWMg==", "9TDawUEiG1rWMg==", "4342112");
        System.out.println(Base64.toBase64String(privateKey.getKey()));
        String jks2048 = "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";
        BjcaKey privateKey2048 = jksUtil.exportJksKey(Base64.decode(jks2048), "q/KPlYIdgogCwg==", "q/KPlYIdgogCwg==", "2702152");
        String certificate = jksUtil.exportJksCertificate(Base64.decode(jks2048), "q/KPlYIdgogCwg==", "2702152");
        System.out.println(Base64.toBase64String(privateKey2048.getKey()));
        jksUtil.jksGenerator("C:\\Users\\wct\\Desktop\\test.jks", "12322366", privateKey2048, "11111111", "22222222", certificate);
        String jskss = "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";
        BjcaKey privateKey11 = jksUtil.exportJksKey(Base64.decode(jskss), "22222222", "11111111", "12322366");
        System.out.println(Base64.toBase64String(privateKey11.getKey()));
        String s2 = jksUtil.exportJksCertificate(Base64.decode(jskss), "22222222", "12322366");
        System.out.println(s2);
        ArrayList arrayList = jksUtil.exportJksAlias(Base64.decode(jskss), "22222222");
        System.out.println(arrayList.get(0));
    }
}

