/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.assemb.structure;

import cn.org.bjca.gaia.asn1.ASN1EncodableVector;
import cn.org.bjca.gaia.asn1.ASN1Object;
import cn.org.bjca.gaia.asn1.ASN1Primitive;
import cn.org.bjca.gaia.asn1.ASN1Sequence;
import cn.org.bjca.gaia.asn1.DERBitString;
import cn.org.bjca.gaia.asn1.DERSequence;
import cn.org.bjca.gaia.asn1.DLSequence;
import cn.org.bjca.gaia.asn1.x509.AlgorithmIdentifier;
import cn.org.bjca.gaia.assemb.structure.SM2Cipher;
import cn.org.bjca.gaia.util.encoders.Base64;
import java.io.IOException;

public class Sm2EnvelopedKey
extends ASN1Object {
    private ASN1Sequence seq;
    private AlgorithmIdentifier symAlgId;
    private SM2Cipher symEncryptedKey;
    private DERBitString sm2PublicKey;
    private DERBitString sm2EncPrivateKey;

    public Sm2EnvelopedKey(byte[] encoded) throws IOException {
        DLSequence dl = (DLSequence)ASN1Primitive.fromByteArray(encoded);
        this.symAlgId = AlgorithmIdentifier.getInstance(dl.getObjectAt(0));
        this.symEncryptedKey = new SM2Cipher(dl.getObjectAt(1).toASN1Primitive().getEncoded());
        this.sm2PublicKey = (DERBitString)dl.getObjectAt(2);
        this.sm2EncPrivateKey = (DERBitString)dl.getObjectAt(3);
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.symAlgId);
        v.add(this.symEncryptedKey);
        v.add(this.sm2PublicKey);
        v.add(this.sm2EncPrivateKey);
        this.seq = new DERSequence(v);
    }

    public Sm2EnvelopedKey(AlgorithmIdentifier symAlgId, SM2Cipher symEncryptedKey, DERBitString sm2PublicKey, DERBitString sm2EncPrivateKey) {
        this.symAlgId = symAlgId;
        this.symEncryptedKey = symEncryptedKey;
        this.sm2PublicKey = sm2PublicKey;
        this.sm2EncPrivateKey = sm2EncPrivateKey;
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(symAlgId);
        v.add(symEncryptedKey);
        v.add(sm2PublicKey);
        v.add(sm2EncPrivateKey);
        this.seq = new DERSequence(v);
    }

    @Override
    public byte[] getEncoded() throws IOException {
        return this.seq.getEncoded();
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return this.seq;
    }

    public AlgorithmIdentifier getSymAlgId() {
        return this.symAlgId;
    }

    public SM2Cipher getSymEncryptedKey() {
        return this.symEncryptedKey;
    }

    public DERBitString getSm2PublicKey() {
        return this.sm2PublicKey;
    }

    public DERBitString getSm2EncPrivateKey() {
        return this.sm2EncPrivateKey;
    }

    public static void main(String[] args) throws IOException {
        String sm2Cipher = "MIHxMAwGCCqBHM9VAWgBBQAwegIhAKdTx0cFw5aPmPYUv5ms4ujyEDscvbo3KKqJEq+WqlMJAiEAzQ1tJ9XbkWxPy6PjpeWpqhR0aBHer131+tdnCUjIfJEEIEENvS8wryH+CUKFtVfZVpWGSUng1Np+570rgu6wC8OpBBCyXgpGc+UbXJmNdtBWa0okA0IABER3/E01ZrGhN3gJQ5gWCU/6bqpAz2slokssyFgHa3yJR59H3m1QTlR98Um87YZPoP/l6B0QGt7KsdxqpfiEqPcDIQBhTDwXPeR4QOnjnU4G6bu0/ZejoVdaPYulgqA1K0QwAA==";
        Sm2EnvelopedKey sm2EnvelopedKey = new Sm2EnvelopedKey(Base64.decode(sm2Cipher));
        System.out.println(sm2Cipher.equalsIgnoreCase(Base64.toBase64String(sm2EnvelopedKey.seq.getEncoded())));
    }
}

