/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.assemb.security;

import cn.org.bjca.gaia.assemb.base.CommonJni;
import cn.org.bjca.gaia.assemb.base.GaiaProvider;
import cn.org.bjca.gaia.assemb.base.JeProvider;
import cn.org.bjca.gaia.assemb.exception.PkiException;
import java.util.concurrent.ConcurrentHashMap;

public class Gaia {
    public static final String BJCA_JE_PROVIDER = "BJCAJE";
    public static final String BJCA_SO_PROVIDER = "BJCASO";
    public static final String SANSEC_CARD_PROVIDER = "SANSEC_CARD";
    public static final String FISHMAN_CARD_PROVIDER = "FISHMAN_CARD";
    public static final String BJCA_CARD_PROVIDER = "BJCA_CARD";
    private static volatile Gaia gaia = null;
    private static ConcurrentHashMap<String, GaiaProvider> providerTable = new ConcurrentHashMap();

    private Gaia() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Gaia getInstance() {
        if (gaia != null) return gaia;
        Class<Gaia> clazz = Gaia.class;
        synchronized (Gaia.class) {
            if (gaia != null) return gaia;
            gaia = new Gaia();
            // ** MonitorExit[var0] (shouldn't be in output)
            return gaia;
        }
    }

    public boolean initProvider(String providerName) throws PkiException {
        try {
            if (providerTable.containsKey(providerName)) {
                return true;
            }
            if (BJCA_JE_PROVIDER.equals(providerName)) {
                JeProvider jeProvider = JeProvider.getInstance();
                providerTable.put(providerName, jeProvider);
                return true;
            }
            if (BJCA_SO_PROVIDER.equals(providerName) || SANSEC_CARD_PROVIDER.equals(providerName) || FISHMAN_CARD_PROVIDER.equals(providerName) || BJCA_CARD_PROVIDER.equals(providerName)) {
                CommonJni commonJni = new CommonJni(providerName);
                providerTable.put(providerName, commonJni);
                return true;
            }
            throw new PkiException("11000001", "\u521d\u59cb\u5316\u52a0\u5bc6\u8bbe\u5907\u5931\u8d25 \u4e0d\u652f\u6301\u7684Provider\u7c7b\u578b " + providerName);
        }
        catch (Exception e) {
            throw new PkiException("11000001", "\u521d\u59cb\u5316\u52a0\u5bc6\u8bbe\u5907\u5931\u8d25 " + providerName, e);
        }
    }

    public GaiaProvider openProvider(String providerName) throws PkiException {
        GaiaProvider gaiaProvider = providerTable.get(providerName);
        if (gaiaProvider == null) {
            throw new PkiException("11000002", "\u5bc6\u7801\u8bbe\u5907\u672a\u8fdb\u884c\u521d\u59cb\u5316 " + providerName);
        }
        return gaiaProvider;
    }
}

