/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.assemb.generator;

import cn.org.bjca.gaia.asn1.ASN1EncodableVector;
import cn.org.bjca.gaia.asn1.ASN1InputStream;
import cn.org.bjca.gaia.asn1.ASN1Integer;
import cn.org.bjca.gaia.asn1.ASN1ObjectIdentifier;
import cn.org.bjca.gaia.asn1.DERNull;
import cn.org.bjca.gaia.asn1.DEROctetString;
import cn.org.bjca.gaia.asn1.DERSequence;
import cn.org.bjca.gaia.asn1.DERSet;
import cn.org.bjca.gaia.asn1.DERTaggedObject;
import cn.org.bjca.gaia.asn1.pkcs.IssuerAndSerialNumber;
import cn.org.bjca.gaia.asn1.x509.AlgorithmIdentifier;
import cn.org.bjca.gaia.asn1.x509.Certificate;
import cn.org.bjca.gaia.assemb.constant.AlgConstant;
import cn.org.bjca.gaia.assemb.param.AlgPolicy;
import java.io.ByteArrayInputStream;
import java.security.cert.CRL;
import java.security.cert.X509CRL;

public class Pkcs7Generator {
    public byte[] getEncoded(AlgPolicy alg, Certificate[] certChain, CRL[] crlList, byte[] signedData, byte[] contentData) throws Exception {
        String algPolicy = alg.getPolicyType();
        int version = 1;
        int signerversion = 1;
        Certificate signCert = certChain[0];
        String hashAlg = AlgConstant.convertSignAlgToHashAlg(algPolicy);
        ASN1ObjectIdentifier hashOid = AlgConstant.convertAlgNameToOid(hashAlg);
        ASN1ObjectIdentifier encryptOid = AlgConstant.convertAlgNameToSignOid(algPolicy);
        ASN1ObjectIdentifier dataOid = AlgConstant.convertAlgToPkcs7DataOid(algPolicy);
        ASN1ObjectIdentifier signDataOid = AlgConstant.convertAlgNameToPkcs7SignDataOid(algPolicy);
        ASN1EncodableVector digestV = new ASN1EncodableVector();
        AlgorithmIdentifier a = new AlgorithmIdentifier(hashOid, DERNull.INSTANCE);
        digestV.add(a);
        DERSet digestSet = new DERSet(digestV);
        ASN1EncodableVector certV = new ASN1EncodableVector();
        for (int i = 0; i < certChain.length; ++i) {
            Certificate certTemp = certChain[i];
            certV.add(certTemp);
        }
        DERSet certSet = new DERSet(certV);
        ASN1EncodableVector contentV = new ASN1EncodableVector();
        contentV.add(dataOid);
        if (contentData != null) {
            DEROctetString octets = new DEROctetString(contentData);
            DERTaggedObject tagged = new DERTaggedObject(0, octets);
            contentV.add(tagged);
        }
        DERSequence contentSeq = new DERSequence(contentV);
        ASN1EncodableVector signInfoV = new ASN1EncodableVector();
        signInfoV.add(new ASN1Integer(signerversion));
        IssuerAndSerialNumber isAnds = new IssuerAndSerialNumber(signCert.getIssuer(), signCert.getSerialNumber().getPositiveValue());
        signInfoV.add(isAnds);
        signInfoV.add(new AlgorithmIdentifier(hashOid, DERNull.INSTANCE));
        signInfoV.add(new AlgorithmIdentifier(encryptOid, DERNull.INSTANCE));
        signInfoV.add(new DEROctetString(signedData));
        DERSequence signInfoSeq = new DERSequence(signInfoV);
        DERSet signInfoSet = new DERSet(signInfoSeq);
        ASN1EncodableVector body = new ASN1EncodableVector();
        body.add(new ASN1Integer(version));
        body.add(digestSet);
        body.add(contentSeq);
        body.add(new DERTaggedObject(false, 0, certSet));
        if (crlList != null) {
            ASN1EncodableVector crlV = new ASN1EncodableVector();
            for (int i = 0; i < crlList.length; ++i) {
                ASN1InputStream t = new ASN1InputStream(new ByteArrayInputStream(((X509CRL)crlList[i]).getEncoded()));
                crlV.add(t.readObject());
            }
            DERSequence crlSeq = new DERSequence(crlV);
            DERSet crlSet = new DERSet(crlSeq);
            body.add(new DERTaggedObject(false, 1, crlSet));
        }
        body.add(signInfoSet);
        DERSequence bodySeq = new DERSequence(body);
        ASN1EncodableVector whole = new ASN1EncodableVector();
        whole.add(signDataOid);
        whole.add(new DERTaggedObject(0, bodySeq));
        DERSequence wholeSeq = new DERSequence(whole);
        return wholeSeq.getEncoded();
    }

    public byte[] getAttributeEncoded(AlgPolicy alg, Certificate[] certChain, CRL[] crlList, byte[] signedData, ASN1EncodableVector attrVector) throws Exception {
        String algPolicy = alg.getPolicyType();
        int version = 1;
        int signerversion = 1;
        Certificate signCert = certChain[0];
        String hashAlg = AlgConstant.convertSignAlgToHashAlg(algPolicy);
        ASN1ObjectIdentifier hashOid = AlgConstant.convertAlgNameToOid(hashAlg);
        ASN1ObjectIdentifier encryptOid = AlgConstant.convertAlgNameToSignOid(algPolicy);
        ASN1ObjectIdentifier dataOid = AlgConstant.convertAlgToPkcs7DataOid(algPolicy);
        ASN1ObjectIdentifier signDataOid = AlgConstant.convertAlgNameToPkcs7SignDataOid(algPolicy);
        ASN1EncodableVector digestV = new ASN1EncodableVector();
        AlgorithmIdentifier a = new AlgorithmIdentifier(hashOid, DERNull.INSTANCE);
        digestV.add(a);
        DERSet digestSet = new DERSet(digestV);
        ASN1EncodableVector certV = new ASN1EncodableVector();
        for (int i = 0; i < certChain.length; ++i) {
            Certificate certTemp = certChain[i];
            certV.add(certTemp);
        }
        DERSet certSet = new DERSet(certV);
        ASN1EncodableVector contentV = new ASN1EncodableVector();
        contentV.add(dataOid);
        DERSequence contentSeq = new DERSequence(contentV);
        ASN1EncodableVector signInfoV = new ASN1EncodableVector();
        signInfoV.add(new ASN1Integer(signerversion));
        IssuerAndSerialNumber isAnds = new IssuerAndSerialNumber(signCert.getIssuer(), signCert.getSerialNumber().getPositiveValue());
        signInfoV.add(isAnds);
        signInfoV.add(new AlgorithmIdentifier(hashOid, DERNull.INSTANCE));
        DERSet attributeSequence = new DERSet(attrVector);
        DERTaggedObject derTaggedObject = new DERTaggedObject(false, 0, attributeSequence);
        signInfoV.add(derTaggedObject);
        signInfoV.add(new AlgorithmIdentifier(encryptOid, DERNull.INSTANCE));
        signInfoV.add(new DEROctetString(signedData));
        DERSequence signInfoSeq = new DERSequence(signInfoV);
        DERSet signInfoSet = new DERSet(signInfoSeq);
        ASN1EncodableVector body = new ASN1EncodableVector();
        body.add(new ASN1Integer(version));
        body.add(digestSet);
        body.add(contentSeq);
        body.add(new DERTaggedObject(false, 0, certSet));
        if (crlList != null) {
            ASN1EncodableVector crlV = new ASN1EncodableVector();
            for (int i = 0; i < crlList.length; ++i) {
                ASN1InputStream t = new ASN1InputStream(new ByteArrayInputStream(((X509CRL)crlList[i]).getEncoded()));
                crlV.add(t.readObject());
            }
            DERSequence crlSeq = new DERSequence(crlV);
            DERSet crlSet = new DERSet(crlSeq);
            body.add(new DERTaggedObject(false, 1, crlSet));
        }
        body.add(signInfoSet);
        DERSequence bodySeq = new DERSequence(body);
        ASN1EncodableVector whole = new ASN1EncodableVector();
        whole.add(signDataOid);
        whole.add(new DERTaggedObject(0, bodySeq));
        DERSequence wholeSeq = new DERSequence(whole);
        return wholeSeq.getEncoded();
    }
}

