/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.assemb.base;

import cn.org.bjca.gaia.asn1.ASN1EncodableVector;
import cn.org.bjca.gaia.asn1.ASN1Integer;
import cn.org.bjca.gaia.asn1.ASN1ObjectIdentifier;
import cn.org.bjca.gaia.asn1.DERNull;
import cn.org.bjca.gaia.asn1.DERSequence;
import cn.org.bjca.gaia.asn1.nist.NISTObjectIdentifiers;
import cn.org.bjca.gaia.asn1.oiw.OIWObjectIdentifiers;
import cn.org.bjca.gaia.asn1.x509.AlgorithmIdentifier;
import cn.org.bjca.gaia.asn1.x509.DigestInfo;
import cn.org.bjca.gaia.asn1.x9.ECNamedCurveTable;
import cn.org.bjca.gaia.asn1.x9.X9ECParameters;
import cn.org.bjca.gaia.assemb.base.FPEType;
import cn.org.bjca.gaia.assemb.base.GaiaProvider;
import cn.org.bjca.gaia.assemb.constant.AlgConstant;
import cn.org.bjca.gaia.assemb.exception.PkiException;
import cn.org.bjca.gaia.assemb.param.AlgPolicy;
import cn.org.bjca.gaia.assemb.param.BjcaKey;
import cn.org.bjca.gaia.assemb.param.BjcaKeyPair;
import cn.org.bjca.gaia.assemb.param.IVParam;
import cn.org.bjca.gaia.assemb.param.SM3Param;
import cn.org.bjca.gaia.assemb.util.ByteArrayUtil;
import cn.org.bjca.gaia.assemb.util.KeyPairUtil;
import cn.org.bjca.gaia.crypto.digests.SHA1Digest;
import cn.org.bjca.gaia.crypto.digests.SHA256Digest;
import cn.org.bjca.gaia.crypto.digests.SM3Digest;
import cn.org.bjca.gaia.crypto.engines.SM2Engine;
import cn.org.bjca.gaia.crypto.macs.HMac;
import cn.org.bjca.gaia.crypto.params.AsymmetricKeyParameter;
import cn.org.bjca.gaia.crypto.params.ECPrivateKeyParameters;
import cn.org.bjca.gaia.crypto.params.ECPublicKeyParameters;
import cn.org.bjca.gaia.crypto.params.KeyParameter;
import cn.org.bjca.gaia.crypto.params.ParametersWithRandom;
import cn.org.bjca.gaia.crypto.signers.SM2Signer;
import cn.org.bjca.gaia.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import cn.org.bjca.gaia.jcajce.provider.asymmetric.ec.BCECPublicKey;
import cn.org.bjca.gaia.jcajce.provider.asymmetric.util.ECUtil;
import cn.org.bjca.gaia.jcajce.spec.AEADParameterSpec;
import cn.org.bjca.gaia.jce.provider.BJCAJEProvider;
import cn.org.bjca.gaia.math.ec.ECCurve;
import cn.org.bjca.gaia.math.ec.ECPoint;
import cn.org.bjca.gaia.util.BigIntegers;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.spec.ECGenParameterSpec;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public class JeProvider
implements GaiaProvider {
    private static volatile JeProvider jeProvider = null;
    private final X9ECParameters x9ECParameters = ECNamedCurveTable.getByName("sm2p256v1");
    private final BigInteger x9N = this.x9ECParameters.getN();
    private final ECPoint x9G = this.x9ECParameters.getG();
    private final ECCurve curve = this.x9ECParameters.getCurve();

    private JeProvider() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JeProvider getInstance() {
        if (jeProvider != null) return jeProvider;
        Class<JeProvider> clazz = JeProvider.class;
        synchronized (JeProvider.class) {
            if (jeProvider != null) return jeProvider;
            jeProvider = new JeProvider();
            Security.addProvider(new BJCAJEProvider());
            // ** MonitorExit[var0] (shouldn't be in output)
            return jeProvider;
        }
    }

    @Override
    public BjcaKeyPair genKeyPair(AlgPolicy algPolicy, int keyLen) throws PkiException {
        BjcaKey bjcaPubKey;
        BjcaKey bjcaPrvKey = null;
        String policyType = algPolicy.getPolicyType();
        if (!(policyType.equals("RSA") || policyType.equals("SM2") || policyType.equals("ED25519"))) {
            throw new PkiException("11001002", "\u4ea7\u751f\u975e\u5bf9\u79f0\u5bc6\u94a5\u5bf9\u5931\u8d25 \u6a21\u5757\u4e0d\u652f\u6301\u6b64\u79cd\u64cd\u4f5c " + policyType);
        }
        byte[][] keyPair = this.genKeyPair(policyType, keyLen);
        byte[] pubKeyEncoded = keyPair[0];
        byte[] prvKeyEncoded = keyPair[1];
        if (policyType.equals("RSA")) {
            bjcaPubKey = new BjcaKey("RSA_Public", pubKeyEncoded);
            bjcaPrvKey = new BjcaKey("RSA_Private", prvKeyEncoded);
        } else if (policyType.equals("SM2")) {
            bjcaPubKey = new BjcaKey("SM2_Public", pubKeyEncoded);
            bjcaPrvKey = new BjcaKey("SM2_Private", prvKeyEncoded);
        } else {
            bjcaPubKey = new BjcaKey("ED25519_PUB", pubKeyEncoded);
            bjcaPrvKey = new BjcaKey("ED25519_PRI", prvKeyEncoded);
        }
        return new BjcaKeyPair(bjcaPubKey, bjcaPrvKey);
    }

    @Override
    public BjcaKey genSymmKey(AlgPolicy algPolicy, int keyLen) throws PkiException {
        String policyType = algPolicy.getPolicyType();
        if (!(policyType.equals("DESede") || policyType.equals("AES") || policyType.equals("SM4"))) {
            throw new PkiException("11001001", "\u4ea7\u751f\u5bf9\u79f0\u5bc6\u94a5\u64cd\u4f5c\u5931\u8d25 \u6a21\u5757\u4e0d\u652f\u6301\u6b64\u79cd\u64cd\u4f5c " + policyType);
        }
        try {
            KeyGenerator keyGen = KeyGenerator.getInstance(policyType, "BJCAJE");
            keyGen.init(keyLen);
            SecretKey key = keyGen.generateKey();
            return new BjcaKey(key.getAlgorithm(), key.getEncoded());
        }
        catch (Exception ex) {
            throw new PkiException("11001001", "\u4ea7\u751f\u5bf9\u79f0\u5bc6\u94a5\u64cd\u4f5c\u5931\u8d25 " + policyType + " " + keyLen, ex);
        }
    }

    @Override
    public byte[] signHashedData(AlgPolicy algPolicy, byte[] hash, BjcaKey privateKey) throws PkiException {
        String policyType = algPolicy.getPolicyType();
        if (!AlgConstant.signAlgs.contains(policyType)) {
            throw new PkiException("11001009", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25 \u6a21\u5757\u4e0d\u652f\u6301\u6b64\u79cd\u64cd\u4f5c " + policyType);
        }
        byte[] signValue = null;
        if (AlgConstant.rsaSignAlgs.contains(policyType)) {
            ASN1ObjectIdentifier hashOid = null;
            if ("SHA256WithRSA".equals(policyType)) {
                hashOid = NISTObjectIdentifiers.id_sha256;
            } else if ("SHA1WithRSA".equals(policyType)) {
                hashOid = OIWObjectIdentifiers.idSHA1;
            } else if ("SHA224WithRSA".equals(policyType)) {
                hashOid = NISTObjectIdentifiers.id_sha224;
            } else if ("SHA384WithRSA".equals(policyType)) {
                hashOid = NISTObjectIdentifiers.id_sha384;
            } else if ("SHA512WithRSA".equals(policyType)) {
                hashOid = NISTObjectIdentifiers.id_sha512;
            }
            Signature localSignature = null;
            try {
                byte[] derHash = JeProvider.derEncode(hashOid, hash);
                localSignature = Signature.getInstance("RSA", "BJCAJE");
                PrivateKey priKey = (PrivateKey)KeyPairUtil.convertKey(privateKey);
                localSignature.initSign(priKey);
                localSignature.update(derHash);
                signValue = localSignature.sign();
            }
            catch (Exception e) {
                throw new PkiException("11001009", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", e);
            }
        } else if (AlgConstant.sm2SignAlgs.contains(policyType)) {
            SM2Signer sm2Signer = new SM2Signer();
            try {
                BCECPrivateKey bcECPrivateKey = (BCECPrivateKey)KeyPairUtil.convertKey(privateKey);
                AsymmetricKeyParameter localECPrivateKeyParameters = ECUtil.generatePrivateKeyParameter(bcECPrivateKey);
                sm2Signer.initHashed(true, localECPrivateKeyParameters);
                sm2Signer.updateHashed(hash);
                signValue = sm2Signer.generateHashedSignature();
            }
            catch (Exception e) {
                throw new PkiException("11001009", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", e);
            }
        } else {
            throw new PkiException("11001009", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25 \u6a21\u5757\u4e0d\u652f\u6301\u6b64\u79cd\u64cd\u4f5c " + policyType);
        }
        return signValue;
    }

    @Override
    public byte[] signData(AlgPolicy algPolicy, byte[] dataInput, BjcaKey privateKey) throws PkiException {
        byte[] signValue = new byte[]{};
        try {
            AlgPolicy hashAlg = null;
            if (algPolicy.getPolicyType().toUpperCase().contains("SM3")) {
                hashAlg = new AlgPolicy("SM3", algPolicy.getParam());
            } else if (algPolicy.getPolicyType().toUpperCase().contains("SHA1")) {
                hashAlg = new AlgPolicy("SHA1");
            } else if (algPolicy.getPolicyType().toUpperCase().contains("SHA256")) {
                hashAlg = new AlgPolicy("SHA256");
            } else if (algPolicy.getPolicyType().toUpperCase().contains("SHA224")) {
                hashAlg = new AlgPolicy("SHA224");
            } else if (algPolicy.getPolicyType().toUpperCase().contains("SHA384")) {
                hashAlg = new AlgPolicy("SHA384");
            } else if (algPolicy.getPolicyType().toUpperCase().contains("SHA512")) {
                hashAlg = new AlgPolicy("SHA512");
            } else {
                throw new PkiException("\u4e0d\u652f\u6301\u7684\u7b97\u6cd5\u7c7b\u578b");
            }
            byte[] hashdData = this.hash(hashAlg, dataInput);
            signValue = this.signHashedData(algPolicy, hashdData, privateKey);
        }
        catch (PkiException e) {
            throw new PkiException("11001009", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", e);
        }
        return signValue;
    }

    @Override
    public boolean verifySignData(AlgPolicy algPolicy, byte[] dataInput, byte[] sign, BjcaKey publicKey) throws PkiException {
        String policyType = algPolicy.getPolicyType();
        if (!AlgConstant.signAlgs.contains(policyType)) {
            throw new PkiException("11001010", "\u9a8c\u8bc1\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25 \u6a21\u5757\u4e0d\u652f\u6301\u6b64\u79cd\u64cd\u4f5c " + policyType);
        }
        boolean verifySign = false;
        if (AlgConstant.rsaSignAlgs.contains(policyType)) {
            Signature localSignature = null;
            try {
                localSignature = Signature.getInstance(policyType, "BJCAJE");
                PublicKey pubKey = (PublicKey)KeyPairUtil.convertKey(publicKey);
                localSignature.initVerify(pubKey);
                localSignature.update(dataInput);
                verifySign = localSignature.verify(sign);
            }
            catch (Exception e) {
                throw new PkiException("11001010", "\u9a8c\u8bc1\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", e);
            }
        } else {
            if (AlgConstant.sm2SignAlgs.contains(policyType)) {
                try {
                    Signature verifier = Signature.getInstance(policyType, "BJCAJE");
                    PublicKey pubKey = (PublicKey)KeyPairUtil.convertKey(publicKey);
                    verifier.initVerify(pubKey);
                    verifier.update(dataInput);
                    return verifier.verify(sign);
                }
                catch (Exception e) {
                    throw new PkiException("11001010", "\u9a8c\u8bc1\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", e);
                }
            }
            throw new PkiException("11001010", "\u9a8c\u8bc1\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25 \u6a21\u5757\u4e0d\u652f\u6301\u6b64\u79cd\u64cd\u4f5c " + policyType);
        }
        return verifySign;
    }

    @Override
    public boolean verifySignHashedData(AlgPolicy algPolicy, byte[] hash, byte[] signature, BjcaKey publicKey) throws PkiException {
        String policyType = algPolicy.getPolicyType();
        if (!AlgConstant.signAlgs.contains(policyType)) {
            throw new PkiException("11001010", "\u9a8c\u8bc1\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25 \u6a21\u5757\u4e0d\u652f\u6301\u6b64\u79cd\u64cd\u4f5c " + policyType);
        }
        boolean verifySign = false;
        if (AlgConstant.rsaSignAlgs.contains(policyType)) {
            ASN1ObjectIdentifier hashOid = null;
            if ("SHA256WithRSA".equals(policyType)) {
                hashOid = NISTObjectIdentifiers.id_sha256;
            } else if ("SHA1WithRSA".equals(policyType)) {
                hashOid = OIWObjectIdentifiers.idSHA1;
            } else if ("SHA224WithRSA".equals(policyType)) {
                hashOid = NISTObjectIdentifiers.id_sha224;
            } else if ("SHA384WithRSA".equals(policyType)) {
                hashOid = NISTObjectIdentifiers.id_sha384;
            } else if ("SHA512WithRSA".equals(policyType)) {
                hashOid = NISTObjectIdentifiers.id_sha512;
            }
            Signature localSignature = null;
            try {
                byte[] derHash = JeProvider.derEncode(hashOid, hash);
                localSignature = Signature.getInstance("RSA", "BJCAJE");
                PublicKey pubKey = (PublicKey)KeyPairUtil.convertKey(publicKey);
                localSignature.initVerify(pubKey);
                localSignature.update(derHash);
                verifySign = localSignature.verify(signature);
            }
            catch (Exception e) {
                throw new PkiException("11001010", "\u9a8c\u8bc1\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", e);
            }
        } else if (AlgConstant.sm2SignAlgs.contains(policyType)) {
            SM2Signer sm2Signer = new SM2Signer();
            try {
                BCECPublicKey bcECPublicKey = (BCECPublicKey)KeyPairUtil.convertKey(publicKey);
                AsymmetricKeyParameter localECPublicKeyParameters = ECUtil.generatePublicKeyParameter(bcECPublicKey);
                sm2Signer.initHashed(false, localECPublicKeyParameters);
                sm2Signer.updateHashed(hash);
                verifySign = sm2Signer.verifyHashedSignature(signature);
            }
            catch (InvalidKeyException e) {
                throw new PkiException("11001010", "\u9a8c\u8bc1\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", e);
            }
        } else {
            throw new PkiException("11001010", "\u9a8c\u8bc1\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25 \u6a21\u5757\u4e0d\u652f\u6301\u6b64\u79cd\u64cd\u4f5c " + policyType);
        }
        return verifySign;
    }

    @Override
    public byte[] hash(AlgPolicy algPolicy, byte[] dataInput) throws PkiException {
        String policyType = algPolicy.getPolicyType();
        if (!AlgConstant.hashAlgs.contains(policyType)) {
            throw new PkiException("11001006", "\u6458\u8981\u64cd\u4f5c\u5931\u8d25 \u6a21\u5757\u4e0d\u652f\u6301\u6b64\u79cd\u64cd\u4f5c " + policyType);
        }
        MessageDigest md = null;
        byte[] retHash = null;
        if (AlgConstant.rsaHashAlgs.contains(policyType)) {
            try {
                md = MessageDigest.getInstance(policyType);
                md.update(dataInput);
                retHash = md.digest();
            }
            catch (Exception e) {
                throw new PkiException("11001006", "\u6458\u8981\u64cd\u4f5c\u5931\u8d25", e);
            }
        } else if (AlgConstant.sm2HashAlgs.contains(policyType)) {
            byte[] bHash = new byte[32];
            try {
                SM3Digest sm3 = new SM3Digest();
                if (algPolicy.getParam() != null) {
                    SM3Param sm3Param = (SM3Param)algPolicy.getParam();
                    byte[] publicKey = sm3Param.getPubKey();
                    byte[] id = sm3Param.getId();
                    byte[] derPub = KeyPairUtil.getDerPublickey(publicKey);
                    X9ECParameters x9 = ECNamedCurveTable.getByName("sm2p256v1");
                    ECPoint publicPoint = x9.getCurve().decodePoint(derPub);
                    BigInteger affineX = publicPoint.getXCoord().toBigInteger();
                    BigInteger affineY = publicPoint.getYCoord().toBigInteger();
                    sm3.addId(affineX, affineY, id);
                    sm3.update(dataInput, 0, dataInput.length);
                    sm3.doFinal(bHash, 0);
                } else {
                    sm3.update(dataInput, 0, dataInput.length);
                    sm3.doFinal(bHash, 0);
                }
                retHash = bHash;
            }
            catch (Exception e) {
                throw new PkiException("11001006", "\u6458\u8981\u64cd\u4f5c\u5931\u8d25", e);
            }
        } else {
            throw new PkiException("11001006", "\u6458\u8981\u64cd\u4f5c\u5931\u8d25 \u6a21\u5757\u4e0d\u652f\u6301\u6b64\u79cd\u64cd\u4f5c " + policyType);
        }
        return retHash;
    }

    @Override
    public byte[] hash(AlgPolicy algPolicy, InputStream dataInput, int bufferSize) throws PkiException {
        String policyType = algPolicy.getPolicyType();
        if (!AlgConstant.hashAlgs.contains(policyType)) {
            throw new PkiException("11001006", "\u6458\u8981\u64cd\u4f5c\u5931\u8d25 \u6a21\u5757\u4e0d\u652f\u6301\u6b64\u79cd\u64cd\u4f5c " + policyType);
        }
        if (bufferSize <= 0) {
            bufferSize = 0x100000;
        }
        MessageDigest md = null;
        byte[] retHash = null;
        if (AlgConstant.rsaHashAlgs.contains(policyType)) {
            try {
                md = MessageDigest.getInstance(policyType);
                byte[] buffer = new byte[bufferSize];
                int i = 0;
                while ((i = dataInput.read(buffer)) > 0) {
                    md.update(buffer, 0, i);
                }
                retHash = md.digest();
                dataInput.close();
            }
            catch (Exception e) {
                throw new PkiException("11001006", "\u6458\u8981\u64cd\u4f5c\u5931\u8d25", e);
            }
        } else if (AlgConstant.sm2HashAlgs.contains(policyType)) {
            byte[] bHash = new byte[32];
            try {
                SM3Digest sm3 = new SM3Digest();
                if (algPolicy.getParam() != null) {
                    SM3Param sm3Param = (SM3Param)algPolicy.getParam();
                    byte[] publicKey = sm3Param.getPubKey();
                    byte[] id = sm3Param.getId();
                    byte[] derPub = KeyPairUtil.getDerPublickey(publicKey);
                    X9ECParameters x9 = ECNamedCurveTable.getByName("sm2p256v1");
                    ECPoint publicPoint = x9.getCurve().decodePoint(derPub);
                    BigInteger affineX = publicPoint.getXCoord().toBigInteger();
                    BigInteger affineY = publicPoint.getYCoord().toBigInteger();
                    sm3.addId(affineX, affineY, id);
                }
                byte[] buffer = new byte[bufferSize];
                int i = 0;
                while ((i = dataInput.read(buffer)) > 0) {
                    sm3.update(buffer, 0, i);
                }
                sm3.doFinal(bHash, 0);
                retHash = bHash;
                dataInput.close();
            }
            catch (Exception e) {
                throw new PkiException("11001006", "\u6458\u8981\u64cd\u4f5c\u5931\u8d25", e);
            }
        } else {
            throw new PkiException("11001006", "\u6458\u8981\u64cd\u4f5c\u5931\u8d25 \u6a21\u5757\u4e0d\u652f\u6301\u6b64\u79cd\u64cd\u4f5c " + policyType);
        }
        return retHash;
    }

    @Override
    public byte[] encrypt(AlgPolicy algPolicy, BjcaKey key, byte[] dataInput) throws PkiException {
        boolean asymAlgSupport;
        String policyType = algPolicy.getPolicyType();
        boolean bl = asymAlgSupport = policyType.equals("RSA/ECB/PKCS1PADDING") || policyType.equals("SM2") || policyType.equals("RSA/NONE/NOPADDING");
        if (!AlgConstant.checkSymmEncDecAlg(policyType) && !asymAlgSupport) {
            throw new PkiException("11001004", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25 \u4e0d\u652f\u6301\u7684\u7b97\u6cd5\u7c7b\u578b " + policyType);
        }
        try {
            return this.doCipher(algPolicy, key, true, dataInput);
        }
        catch (Exception ex) {
            throw new PkiException("11001004", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25 " + policyType, ex);
        }
    }

    @Override
    public byte[] decrypt(AlgPolicy algPolicy, BjcaKey key, byte[] encryptedData) throws PkiException {
        boolean asymAlgSupport;
        String policyType = algPolicy.getPolicyType();
        boolean bl = asymAlgSupport = policyType.equals("RSA/ECB/PKCS1PADDING") || policyType.equals("SM2") || policyType.equals("RSA/NONE/NOPADDING");
        if (!AlgConstant.checkSymmEncDecAlg(policyType) && !asymAlgSupport) {
            throw new PkiException("11001005", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25 \u4e0d\u652f\u6301\u7684\u7b97\u6cd5\u7c7b\u578b " + policyType);
        }
        try {
            return this.doCipher(algPolicy, key, false, encryptedData);
        }
        catch (Exception ex) {
            throw new PkiException("11001005", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25 " + policyType, ex);
        }
    }

    @Override
    public boolean encrypt(AlgPolicy algPolicy, BjcaKey key, InputStream dataInput, OutputStream outputStream, int bufferSize) throws PkiException {
        String policyType = algPolicy.getPolicyType();
        if (!AlgConstant.checkSymmEncDecAlg(policyType)) {
            throw new PkiException("11001004", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25 \u4e0d\u652f\u6301\u7684\u7b97\u6cd5\u7c7b\u578b " + policyType);
        }
        try {
            return this.doCipher(algPolicy, key, true, dataInput, outputStream, bufferSize);
        }
        catch (Exception ex) {
            throw new PkiException("11001004", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25 " + policyType, ex);
        }
    }

    @Override
    public boolean decrypt(AlgPolicy algPolicy, BjcaKey key, InputStream encryptedData, OutputStream outputStream, int bufferSize) throws PkiException {
        String policyType = algPolicy.getPolicyType();
        if (!AlgConstant.checkSymmEncDecAlg(policyType)) {
            throw new PkiException("11001005", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25 \u4e0d\u652f\u6301\u7684\u7b97\u6cd5\u7c7b\u578b " + policyType);
        }
        try {
            return this.doCipher(algPolicy, key, false, encryptedData, outputStream, bufferSize);
        }
        catch (Exception ex) {
            throw new PkiException("11001005", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25 " + policyType, ex);
        }
    }

    private byte[][] genKeyPair(String algName, int keyLen) throws PkiException {
        byte[][] keyPair = new byte[2][];
        if ("RSA".equals(algName) || "ED25519".equals(algName)) {
            KeyPairGenerator keyGen = null;
            try {
                keyGen = KeyPairGenerator.getInstance(algName, "BJCAJE");
                keyGen.initialize(keyLen);
                KeyPair rsaKeyPair = keyGen.generateKeyPair();
                keyPair[0] = rsaKeyPair.getPublic().getEncoded();
                keyPair[1] = rsaKeyPair.getPrivate().getEncoded();
            }
            catch (Exception e) {
                throw new PkiException("11001002", "\u4ea7\u751f\u975e\u5bf9\u79f0\u5bc6\u94a5\u5bf9\u5931\u8d25", e);
            }
        } else if ("SM2".equals(algName)) {
            try {
                ECGenParameterSpec sm2Spec = new ECGenParameterSpec("sm2p256v1");
                KeyPairGenerator gen = null;
                gen = KeyPairGenerator.getInstance("EC", "BJCAJE");
                gen.initialize(sm2Spec, new SecureRandom());
                KeyPair sm2KeyPair = gen.generateKeyPair();
                BCECPublicKey ecPublicKey = (BCECPublicKey)sm2KeyPair.getPublic();
                BCECPrivateKey ecPrivateKey = (BCECPrivateKey)sm2KeyPair.getPrivate();
                byte[] key = new byte[65];
                byte[] bD = null;
                byte[] bX = null;
                byte[] bY = null;
                bD = BigIntegers.asUnsignedByteArray(ecPrivateKey.getD());
                bX = BigIntegers.asUnsignedByteArray(ecPublicKey.getQ().getXCoord().toBigInteger());
                bY = BigIntegers.asUnsignedByteArray(ecPublicKey.getQ().getYCoord().toBigInteger());
                byte[] first = new byte[]{4};
                System.arraycopy(first, 0, key, 0, 1);
                System.arraycopy(bX, 0, key, 33 - bX.length, bX.length);
                System.arraycopy(bY, 0, key, 65 - bY.length, bY.length);
                keyPair[0] = key;
                keyPair[1] = bD;
            }
            catch (Exception e) {
                throw new PkiException("11001002", "\u4ea7\u751f\u975e\u5bf9\u79f0\u5bc6\u94a5\u5bf9\u5931\u8d25", e);
            }
        } else {
            throw new PkiException("11001002", "\u4ea7\u751f\u975e\u5bf9\u79f0\u5bc6\u94a5\u5bf9\u5931\u8d25 \u6a21\u5757\u4e0d\u652f\u6301\u6b64\u79cd\u64cd\u4f5c " + algName);
        }
        return keyPair;
    }

    private byte[] doCipher(AlgPolicy algPolicy, BjcaKey bjcaKey, boolean isEncrypt, byte[] data) throws Exception {
        String policyType = algPolicy.getPolicyType();
        byte[] ret = null;
        if (policyType.equals("SM2")) {
            SM2Engine sm2Engine = new SM2Engine(SM2Engine.Mode.C1C3C2);
            if (isEncrypt) {
                BCECPublicKey localECPublicKey = (BCECPublicKey)KeyPairUtil.convertKey(bjcaKey);
                ECPublicKeyParameters ecPublicKeyParameters = new ECPublicKeyParameters(localECPublicKey.getQ(), KeyPairUtil.ecDomainParameters);
                sm2Engine.init(true, new ParametersWithRandom(ecPublicKeyParameters, new SecureRandom()));
            } else {
                BCECPrivateKey localECPrivateKey = (BCECPrivateKey)KeyPairUtil.convertKey(bjcaKey);
                ECPrivateKeyParameters ecPrivateKeyParameters = new ECPrivateKeyParameters(localECPrivateKey.getD(), KeyPairUtil.ecDomainParameters);
                sm2Engine.init(false, ecPrivateKeyParameters);
            }
            ret = sm2Engine.processBlockDer(data, 0, data.length);
        } else {
            Cipher cipher = Cipher.getInstance(policyType, "BJCAJE");
            int cipherMode = 0;
            cipherMode = isEncrypt ? 1 : 2;
            if (this.checkPolicyTypeIv(policyType)) {
                IVParam cbcParam = (IVParam)algPolicy.getParam();
                if (cbcParam == null) {
                    throw new PkiException("IVParam\u53c2\u6570\u4e3a\u7a7a");
                }
                IvParameterSpec iv = new IvParameterSpec(cbcParam.getIv());
                cipher.init(cipherMode, KeyPairUtil.convertKey(bjcaKey), iv);
            } else {
                cipher.init(cipherMode, KeyPairUtil.convertKey(bjcaKey));
            }
            ret = cipher.doFinal(data);
        }
        if (ret == null) {
            throw new PkiException("\u8fd0\u7b97\u7ed3\u679c\u4e3a\u7a7a");
        }
        return ret;
    }

    private boolean doCipher(AlgPolicy algPolicy, BjcaKey bjcaKey, boolean isEncrypt, InputStream inputStream, OutputStream outputStream, int bufferSize) throws PkiException {
        String policyType = algPolicy.getPolicyType();
        int cipherMode = 0;
        cipherMode = isEncrypt ? 1 : 2;
        try {
            int len;
            Cipher cipher = Cipher.getInstance(policyType, "BJCAJE");
            if (this.checkPolicyTypeIv(policyType)) {
                if (algPolicy.getParam() == null) {
                    throw new PkiException("policyType= " + policyType + " ,IVParam\u53c2\u6570\u4e3a\u7a7a");
                }
                IVParam cbcParam = (IVParam)algPolicy.getParam();
                IvParameterSpec iv = new IvParameterSpec(cbcParam.getIv());
                cipher.init(cipherMode, KeyPairUtil.convertKey(bjcaKey), iv);
            } else {
                cipher.init(cipherMode, KeyPairUtil.convertKey(bjcaKey));
            }
            CipherInputStream cis = new CipherInputStream(inputStream, cipher);
            byte[] inBytes = new byte[bufferSize];
            while ((len = cis.read(inBytes)) != -1) {
                outputStream.write(inBytes, 0, len);
            }
            inputStream.close();
            cis.close();
            outputStream.close();
        }
        catch (Exception e) {
            throw new PkiException("\u6d41\u65b9\u5f0f\u52a0\u89e3\u5bc6\u5931\u8d25\uff01", e);
        }
        return true;
    }

    @Override
    public byte[] genRandom(int length) throws PkiException {
        byte[] newRan = null;
        try {
            newRan = new byte[length];
            SecureRandom rand = new SecureRandom();
            rand.nextBytes(newRan);
        }
        catch (Exception e) {
            throw new PkiException("11003003", "\u4ea7\u751f\u968f\u673a\u6570\u5931\u8d25 length =" + length, e);
        }
        return newRan;
    }

    @Override
    public byte[] backupAllKey(byte[] passwd) throws PkiException {
        throw new PkiException("11001020", "\u5907\u4efd\u8bbe\u5907\u5185\u6240\u6709\u5bc6\u94a5\u5931\u8d25 \u6a21\u5757\u4e0d\u652f\u6301\u6b64\u79cd\u64cd\u4f5c");
    }

    @Override
    public boolean restoreAllKey(byte[] backupInfo, byte[] passwd) throws PkiException {
        throw new PkiException("11001021", "\u6062\u590d\u8bbe\u5907\u5185\u6240\u6709\u5bc6\u94a5\u5931\u8d25 \u6a21\u5757\u4e0d\u652f\u6301\u6b64\u79cd\u64cd\u4f5c");
    }

    @Override
    public byte[] mac(AlgPolicy algPolicy, byte[] key, byte[] msg) throws PkiException {
        String policyType = algPolicy.getPolicyType();
        if (!("HMac-SHA1".equals(policyType) || "HMac-SHA256".equals(policyType) || "HMac-SM3".equals(policyType))) {
            throw new PkiException("11001011", "Hmac\u6d88\u606f\u6458\u8981\u5931\u8d25\u4e0d\u652f\u6301\u7684\u7b97\u6cd5\u7c7b\u578b " + policyType);
        }
        HMac hmac = null;
        byte[] resBuf = null;
        hmac = policyType.equals("HMac-SHA1") ? new HMac(new SHA1Digest()) : (policyType.equals("HMac-SHA256") ? new HMac(new SHA256Digest()) : new HMac(new SM3Digest()));
        resBuf = new byte[hmac.getMacSize()];
        hmac.init(new KeyParameter(key));
        hmac.update(msg, 0, msg.length);
        hmac.doFinal(resBuf, 0);
        return resBuf;
    }

    @Override
    public byte[] mac(AlgPolicy algPolicy, byte[] key, InputStream dataInput, int bufferSize) throws PkiException {
        String policyType = algPolicy.getPolicyType();
        if (!("HMac-SHA1".equals(policyType) || "HMac-SHA256".equals(policyType) || "HMac-SM3".equals(policyType))) {
            throw new PkiException("11001011", "Hmac\u6d88\u606f\u6458\u8981\u5931\u8d25\u4e0d\u652f\u6301\u7684\u7b97\u6cd5\u7c7b\u578b " + policyType);
        }
        HMac hmac = null;
        byte[] resBuf = null;
        hmac = policyType.equals("HMac-SHA1") ? new HMac(new SHA1Digest()) : (policyType.equals("HMac-SHA256") ? new HMac(new SHA256Digest()) : new HMac(new SM3Digest()));
        resBuf = new byte[hmac.getMacSize()];
        hmac.init(new KeyParameter(key));
        try {
            byte[] buffer = new byte[bufferSize];
            int i = 0;
            while ((i = dataInput.read(buffer)) > 0) {
                hmac.update(buffer, 0, i);
            }
            hmac.doFinal(resBuf, 0);
            dataInput.close();
        }
        catch (Exception e) {
            throw new PkiException("11001011", "Hmac\u6d88\u606f\u6458\u8981\u5931\u8d25 policyType =" + policyType, e);
        }
        return resBuf;
    }

    @Override
    public byte[] generateRangeRandom(byte[] range) {
        BigInteger ranks;
        BigInteger d = BigInteger.ZERO;
        BigInteger bigInteger = ranks = ByteArrayUtil.isEmpty(range) ? this.x9N : new BigInteger(1, range);
        while ((d = new BigInteger(256, new SecureRandom())).equals(BigInteger.ZERO) || d.compareTo(ranks) >= 0) {
        }
        return d.toByteArray();
    }

    @Override
    public byte[] bigIntegerModAdd(byte[] a, byte[] b, byte[] m3) {
        BigInteger x1 = ByteArrayUtil.byteArray2BigInteger(a);
        BigInteger e = ByteArrayUtil.byteArray2BigInteger(b);
        BigInteger x9N = ByteArrayUtil.byteArray2BigInteger(m3);
        BigInteger r = x1.add(e).mod(x9N);
        return r.toByteArray();
    }

    @Override
    public byte[] bigIntegerModSub(byte[] a, byte[] b, byte[] m3) {
        BigInteger a1 = ByteArrayUtil.byteArray2BigInteger(a);
        BigInteger r = ByteArrayUtil.byteArray2BigInteger(b);
        BigInteger x9N = ByteArrayUtil.byteArray2BigInteger(m3);
        BigInteger s2 = a1.subtract(r).mod(x9N);
        return s2.toByteArray();
    }

    @Override
    public byte[] bigIntegerModMul(byte[] a, byte[] b, byte[] m3) {
        BigInteger dc = ByteArrayUtil.byteArray2BigInteger(a);
        BigInteger k2 = ByteArrayUtil.byteArray2BigInteger(b);
        BigInteger x9N = ByteArrayUtil.byteArray2BigInteger(m3);
        return dc.multiply(k2).mod(x9N).toByteArray();
    }

    @Override
    public byte[] bigIntegerModExp(byte[] a, byte[] b, byte[] m3) {
        BigInteger be = ByteArrayUtil.byteArray2BigInteger(a);
        BigInteger bdPart = ByteArrayUtil.byteArray2BigInteger(b);
        BigInteger pubKeyModule = ByteArrayUtil.byteArray2BigInteger(m3);
        BigInteger br = be.modPow(bdPart, pubKeyModule);
        return br.toByteArray();
    }

    @Override
    public byte[] bigIntegerModInverse(byte[] a, byte[] m3) {
        BigInteger bd = ByteArrayUtil.byteArray2BigInteger(a);
        BigInteger x9N = ByteArrayUtil.byteArray2BigInteger(m3);
        BigInteger bigInteger = bd.modInverse(x9N);
        return bigInteger.toByteArray();
    }

    @Override
    public byte[] SM2PointMul(byte[] a, byte[] k) {
        ECPoint point = ByteArrayUtil.isEmpty(a) ? this.x9G : this.curve.decodePoint(a);
        BigInteger bk = ByteArrayUtil.byteArray2BigInteger(k);
        ECPoint P = point.multiply(bk).normalize();
        return P.getEncoded(false);
    }

    @Override
    public byte[] SM2PointAdd(byte[] a, byte[] b) {
        ECPoint aPoint = ByteArrayUtil.isEmpty(a) ? this.x9G : this.curve.decodePoint(a);
        ECPoint bPoint = ByteArrayUtil.isEmpty(b) ? this.x9G : this.curve.decodePoint(b);
        ECPoint p = aPoint.add(bPoint).normalize();
        return p.getEncoded(false);
    }

    @Override
    public byte[] SM2PointSub(byte[] a, byte[] b) {
        ECPoint aecPoint = ByteArrayUtil.isEmpty(a) ? this.x9G : this.curve.decodePoint(a);
        ECPoint becPoint = ByteArrayUtil.isEmpty(b) ? this.x9G : this.curve.decodePoint(b);
        ECPoint ab = aecPoint.subtract(becPoint).normalize();
        return ab.getEncoded(false);
    }

    public static byte[] derEncode(ASN1ObjectIdentifier paramASN1ObjectIdentifier, byte[] hash) throws IOException {
        AlgorithmIdentifier localAlgorithmIdentifier = new AlgorithmIdentifier(paramASN1ObjectIdentifier, DERNull.INSTANCE);
        DigestInfo localDigestInfo = new DigestInfo(localAlgorithmIdentifier, hash);
        return localDigestInfo.getEncoded("DER");
    }

    @Override
    public byte[] SemServerGenerateSM2Key(byte[] ds, byte[] pc) {
        byte[] dn = this.bigIntegerModInverse(ds, this.x9N.toByteArray());
        byte[] pdn = this.SM2PointMul(pc, dn);
        return this.SM2PointSub(pdn, null);
    }

    @Override
    public byte[] SemServerSM2SignFinal(byte[] ds, byte[] k1, byte[] r, byte[] s2, byte[] s3) throws PkiException {
        try {
            BigInteger rInteger = ByteArrayUtil.byteArray2BigInteger(r);
            byte[] n = this.x9N.toByteArray();
            byte[] data1 = this.bigIntegerModMul(ds, k1, n);
            byte[] data2 = this.bigIntegerModMul(data1, s2, n);
            byte[] bytes = this.bigIntegerModMul(ds, s3, n);
            byte[] bytes1 = this.bigIntegerModAdd(data2, bytes, n);
            byte[] sBytes = this.bigIntegerModSub(bytes1, r, n);
            BigInteger s4 = ByteArrayUtil.byteArray2BigInteger(sBytes);
            ASN1EncodableVector signedData = new ASN1EncodableVector();
            signedData.add(new ASN1Integer(rInteger));
            signedData.add(new ASN1Integer(s4));
            DERSequence signedDataSequence = new DERSequence(signedData);
            return signedDataSequence.getEncoded();
        }
        catch (Exception e) {
            throw new PkiException("11001012", "SM2\u534f\u540c\u7b7e\u540d,\u5408\u6210\u7b7e\u540d\u5931\u8d25", e);
        }
    }

    @Override
    public byte[] encrypt(AlgPolicy algPolicy, BjcaKey key, byte[] dataInput, int nonceLen, byte[] assData, int tagLen) throws PkiException {
        boolean asymAlgSupport;
        String policyType = algPolicy.getPolicyType();
        boolean bl = asymAlgSupport = policyType.equals("RSA/ECB/PKCS1PADDING") || policyType.equals("SM2") || policyType.equals("RSA/NONE/NOPADDING");
        if (!AlgConstant.checkSymmEncDecAlg(policyType) && !asymAlgSupport) {
            throw new PkiException("11001004", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25 \u4e0d\u652f\u6301\u7684\u7b97\u6cd5\u7c7b\u578b " + policyType);
        }
        try {
            return this.doCipher(algPolicy, key, true, dataInput, nonceLen, assData, tagLen);
        }
        catch (Exception ex) {
            throw new PkiException("11001004", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25 " + policyType, ex);
        }
    }

    @Override
    public byte[] decrypt(AlgPolicy algPolicy, BjcaKey key, byte[] encryptedData, int nonceLen, byte[] assData, int tagLen) throws PkiException {
        boolean asymAlgSupport;
        String policyType = algPolicy.getPolicyType();
        boolean bl = asymAlgSupport = policyType.equals("RSA/ECB/PKCS1PADDING") || policyType.equals("SM2") || policyType.equals("RSA/NONE/NOPADDING");
        if (!AlgConstant.checkSymmEncDecAlg(policyType) && !asymAlgSupport) {
            throw new PkiException("11001005", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25 \u4e0d\u652f\u6301\u7684\u7b97\u6cd5\u7c7b\u578b " + policyType);
        }
        try {
            return this.doCipher(algPolicy, key, false, encryptedData, nonceLen, assData, tagLen);
        }
        catch (Exception ex) {
            throw new PkiException("11001005", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25 " + policyType, ex);
        }
    }

    @Override
    public boolean encrypt(AlgPolicy algPolicy, BjcaKey key, InputStream dataInput, OutputStream outputStream, int bufferSize, int nonceLen, byte[] assData, int tagLen) throws PkiException {
        String policyType = algPolicy.getPolicyType();
        if (!AlgConstant.checkSymmEncDecAlg(policyType)) {
            throw new PkiException("11001004", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25 \u4e0d\u652f\u6301\u7684\u7b97\u6cd5\u7c7b\u578b " + policyType);
        }
        try {
            return this.doCipher(algPolicy, key, true, dataInput, outputStream, bufferSize, nonceLen, assData, tagLen);
        }
        catch (Exception ex) {
            throw new PkiException("11001004", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25 " + policyType, ex);
        }
    }

    @Override
    public boolean decrypt(AlgPolicy algPolicy, BjcaKey key, InputStream dataInput, OutputStream outputStream, int bufferSize, int nonceLen, byte[] assData, int tagLen) throws PkiException {
        String policyType = algPolicy.getPolicyType();
        if (!AlgConstant.checkSymmEncDecAlg(policyType)) {
            throw new PkiException("11001005", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25 \u4e0d\u652f\u6301\u7684\u7b97\u6cd5\u7c7b\u578b " + policyType);
        }
        try {
            return this.doCipher(algPolicy, key, false, dataInput, outputStream, bufferSize, nonceLen, assData, tagLen);
        }
        catch (Exception ex) {
            throw new PkiException("11001005", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25 " + policyType, ex);
        }
    }

    @Override
    public BjcaKeyPair genKeyPairSM9(AlgPolicy algPolicy, byte[] userIDA) throws PkiException {
        throw new PkiException("11001002", "\u4ea7\u751f\u975e\u5bf9\u79f0\u5bc6\u94a5\u5bf9\u5931\u8d25 \u6a21\u5757\u4e0d\u652f\u6301\u6b64\u79cd\u64cd\u4f5c");
    }

    @Override
    public byte[] signDataSM9(AlgPolicy algPolicy, byte[] dataInput, BjcaKeyPair bjcaKeyPair) throws PkiException {
        throw new PkiException("11001009", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25 \u6a21\u5757\u4e0d\u652f\u6301\u6b64\u79cd\u64cd\u4f5c");
    }

    @Override
    public boolean verifySignDataSM9(AlgPolicy algPolicy, byte[] dataInput, byte[] sign, BjcaKey publicKey) throws PkiException {
        throw new PkiException("11001010", "\u9a8c\u8bc1\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25 \u6a21\u5757\u4e0d\u652f\u6301\u6b64\u79cd\u64cd\u4f5c");
    }

    @Override
    public byte[] encryptSM9(AlgPolicy algPolicy, BjcaKey key, byte[] dataInput) throws PkiException {
        throw new PkiException("11001004", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25 \u6a21\u5757\u4e0d\u652f\u6301\u6b64\u79cd\u64cd\u4f5c");
    }

    @Override
    public byte[] decryptSM9(AlgPolicy algPolicy, BjcaKeyPair bjcaKeyPair, byte[] encryptedData) throws PkiException {
        throw new PkiException("11001006", "\u6458\u8981\u64cd\u4f5c\u5931\u8d25 \u6a21\u5757\u4e0d\u652f\u6301\u6b64\u79cd\u64cd\u4f5c");
    }

    @Override
    public byte[][] sm9WrapKey(BjcaKey pubKey, int keylen) throws PkiException {
        throw new PkiException("11001013", "SM9\u5bc6\u94a5\u5c01\u88c5\u5931\u8d25 \u6a21\u5757\u4e0d\u652f\u6301\u6b64\u79cd\u64cd\u4f5c");
    }

    @Override
    public byte[] sm9UnWrapKey(BjcaKeyPair bjcaKeyPair, int keylen, byte[] wrapKey) throws PkiException {
        throw new PkiException("11001014", "SM9\u5bc6\u94a5\u89e3\u5c01\u5931\u8d25 \u6a21\u5757\u4e0d\u652f\u6301\u6b64\u79cd\u64cd\u4f5c");
    }

    @Override
    public Map sm9ExchangeKeyInitiatorRequest(BjcaKeyPair bjcaKeyPairA, BjcaKey bjcaKeyB, int SKALen) throws PkiException {
        throw new PkiException("11001015", "SM9\u5bc6\u94a5\u534f\u5546\u5931\u8d25 \u6a21\u5757\u4e0d\u652f\u6301\u6b64\u79cd\u64cd\u4f5c");
    }

    @Override
    public byte[][] sm9ExchangeKeyResponder(BjcaKeyPair bjcaKeyPairB, BjcaKey bjcaKeyA, int SKALen, byte[] ra) throws PkiException {
        throw new PkiException("11001015", "SM9\u5bc6\u94a5\u534f\u5546\u5931\u8d25 \u6a21\u5757\u4e0d\u652f\u6301\u6b64\u79cd\u64cd\u4f5c");
    }

    @Override
    public byte[][] sm9ExchangeKeyInitiatorComputeKey(BjcaKeyPair bjcaKeyPairA, BjcaKey bjcaKeyB, int SKALen, byte[] rb, byte[] sb, Map map) throws PkiException {
        throw new PkiException("11001015", "SM9\u5bc6\u94a5\u534f\u5546\u5931\u8d25 \u6a21\u5757\u4e0d\u652f\u6301\u6b64\u79cd\u64cd\u4f5c");
    }

    public boolean checkPolicyTypeIv(String policyType) {
        return policyType.contains("CBC") || policyType.contains("EEA3") || policyType.contains("CCM") || policyType.contains("GCM") || policyType.contains("CFB") || policyType.contains("OFB") || policyType.contains("CTR");
    }

    private byte[] doCipher(AlgPolicy algPolicy, BjcaKey bjcaKey, boolean isEncrypt, byte[] data, int nonceLen, byte[] assData, int tagLen) throws Exception {
        String policyType = algPolicy.getPolicyType();
        byte[] ret = null;
        if (policyType.equals("SM2")) {
            SM2Engine sm2Engine = new SM2Engine(SM2Engine.Mode.C1C3C2);
            if (isEncrypt) {
                BCECPublicKey localECPublicKey = (BCECPublicKey)KeyPairUtil.convertKey(bjcaKey);
                ECPublicKeyParameters ecPublicKeyParameters = new ECPublicKeyParameters(localECPublicKey.getQ(), KeyPairUtil.ecDomainParameters);
                sm2Engine.init(true, new ParametersWithRandom(ecPublicKeyParameters, new SecureRandom()));
            } else {
                BCECPrivateKey localECPrivateKey = (BCECPrivateKey)KeyPairUtil.convertKey(bjcaKey);
                ECPrivateKeyParameters ecPrivateKeyParameters = new ECPrivateKeyParameters(localECPrivateKey.getD(), KeyPairUtil.ecDomainParameters);
                sm2Engine.init(false, ecPrivateKeyParameters);
            }
            ret = sm2Engine.processBlockDer(data, 0, data.length);
        } else {
            Cipher cipher = Cipher.getInstance(policyType, "BJCAJE");
            int cipherMode = 0;
            cipherMode = isEncrypt ? 1 : 2;
            if (this.checkPolicyTypeIv(policyType)) {
                IVParam cbcParam = (IVParam)algPolicy.getParam();
                if (cbcParam == null) {
                    throw new PkiException("IVParam\u53c2\u6570\u4e3a\u7a7a");
                }
                if (policyType.contains("GCM") || policyType.contains("CCM")) {
                    byte[] nonce = new byte[nonceLen];
                    System.arraycopy(cbcParam.getIv(), 0, nonce, 0, nonceLen);
                    AEADParameterSpec iv = new AEADParameterSpec(nonce, tagLen * 8, assData);
                    cipher.init(cipherMode, KeyPairUtil.convertKey(bjcaKey), iv);
                } else {
                    IvParameterSpec iv = new IvParameterSpec(cbcParam.getIv());
                    cipher.init(cipherMode, KeyPairUtil.convertKey(bjcaKey), iv);
                }
            } else {
                cipher.init(cipherMode, KeyPairUtil.convertKey(bjcaKey));
            }
            ret = cipher.doFinal(data);
        }
        if (ret == null) {
            throw new PkiException("\u8fd0\u7b97\u7ed3\u679c\u4e3a\u7a7a");
        }
        return ret;
    }

    private boolean doCipher(AlgPolicy algPolicy, BjcaKey bjcaKey, boolean isEncrypt, InputStream inputStream, OutputStream outputStream, int bufferSize, int nonceLen, byte[] assData, int tagLen) throws PkiException {
        String policyType = algPolicy.getPolicyType();
        int cipherMode = 0;
        cipherMode = isEncrypt ? 1 : 2;
        try {
            int len;
            Cipher cipher = Cipher.getInstance(policyType, "BJCAJE");
            if (this.checkPolicyTypeIv(policyType)) {
                if (algPolicy.getParam() == null) {
                    throw new PkiException("policyType= " + policyType + " ,IVParam\u53c2\u6570\u4e3a\u7a7a");
                }
                IVParam cbcParam = (IVParam)algPolicy.getParam();
                if (policyType.contains("GCM") || policyType.contains("CCM")) {
                    byte[] nonce = new byte[nonceLen];
                    System.arraycopy(cbcParam.getIv(), 0, nonce, 0, nonceLen);
                    AEADParameterSpec iv = new AEADParameterSpec(nonce, tagLen * 8, assData);
                    cipher.init(cipherMode, KeyPairUtil.convertKey(bjcaKey), iv);
                } else {
                    IvParameterSpec iv = new IvParameterSpec(cbcParam.getIv());
                    cipher.init(cipherMode, KeyPairUtil.convertKey(bjcaKey), iv);
                }
            } else {
                cipher.init(cipherMode, KeyPairUtil.convertKey(bjcaKey));
            }
            CipherInputStream cis = new CipherInputStream(inputStream, cipher);
            byte[] inBytes = new byte[bufferSize];
            while ((len = cis.read(inBytes)) != -1) {
                outputStream.write(inBytes, 0, len);
            }
            inputStream.close();
            cis.close();
            outputStream.close();
        }
        catch (Exception e) {
            throw new PkiException("\u6d41\u65b9\u5f0f\u52a0\u89e3\u5bc6\u5931\u8d25\uff01", e);
        }
        return true;
    }

    @Override
    public byte[] signDataED25519(AlgPolicy algPolicy, byte[] dataInput, BjcaKey privateKey) throws PkiException {
        throw new PkiException("11001022", "\u6a21\u5757\u4e0d\u652f\u6301\u6b64\u79cd\u64cd\u4f5c ED25519\u7b97\u6cd5\u6682\u4e0d\u652f\u6301");
    }

    @Override
    public boolean verifySignedDataED25519(AlgPolicy algPolicy, byte[] dataInput, byte[] signature, BjcaKey publicKey) throws PkiException {
        throw new PkiException("11001013", "SM9\u5bc6\u94a5\u5c01\u88c5\u5931\u8d25 \u6a21\u5757\u4e0d\u652f\u6301\u6b64\u79cd\u64cd\u4f5c");
    }

    @Override
    public byte[] semV2ClientG1(byte[] dc, byte[] r) {
        return this.bigIntegerModMul(dc, r, this.x9N.toByteArray());
    }

    @Override
    public byte[] semV2ClientG2() {
        return this.generateRangeRandom(null);
    }

    @Override
    public byte[] semV2ClientG3(byte[] dcc, byte[] t) {
        BigInteger tBigInteger = ByteArrayUtil.byteArray2BigInteger(t);
        BigInteger dccBigInteger = ByteArrayUtil.byteArray2BigInteger(dcc);
        return dccBigInteger.modInverse(this.x9N).multiply(tBigInteger).toByteArray();
    }

    @Override
    public byte[] semV2ServerG4(byte[] w, byte[] r, byte[] ds) {
        BigInteger dsBigInteger = ByteArrayUtil.byteArray2BigInteger(ds);
        BigInteger wBigInteger = ByteArrayUtil.byteArray2BigInteger(w);
        BigInteger rBigInteger = ByteArrayUtil.byteArray2BigInteger(r);
        return rBigInteger.modInverse(this.x9N).multiply(wBigInteger).multiply(dsBigInteger).toByteArray();
    }

    @Override
    public byte[] semV2Client2CalcDCS(byte[] dc, byte[] dcc) {
        BigInteger dcBigInteger = ByteArrayUtil.byteArray2BigInteger(dc);
        BigInteger dccBigInteger = ByteArrayUtil.byteArray2BigInteger(dcc);
        return dccBigInteger.modInverse(this.x9N).multiply(dcBigInteger).toByteArray();
    }

    @Override
    public byte[] semV2Server2CalcDSS(byte[] ds, byte[] dcs) {
        return this.bigIntegerModMul(ds, dcs, this.x9N.toByteArray());
    }

    @Override
    public String fpeEncrypt(AlgPolicy algPolicy, BjcaKey key, String dataInput, FPEType type, byte[] tweak) throws PkiException {
        throw new PkiException("004", "\u6a21\u5757\u4e0d\u652f\u6301\u6b64\u79cd\u64cd\u4f5c");
    }

    @Override
    public String fpeDecrypt(AlgPolicy algPolicy, BjcaKey key, String dataInput, FPEType type, byte[] tweak) throws PkiException {
        throw new PkiException("004", "\u6a21\u5757\u4e0d\u652f\u6301\u6b64\u79cd\u64cd\u4f5c");
    }

    @Override
    public int[] fpeEncrypt(AlgPolicy algPolicy, BjcaKey key, int[] dataInput, int radix, byte[] tweak) throws PkiException {
        throw new PkiException("004", "\u6a21\u5757\u4e0d\u652f\u6301\u6b64\u79cd\u64cd\u4f5c");
    }

    @Override
    public int[] fpeDecrypt(AlgPolicy algPolicy, BjcaKey key, int[] dataInput, int radix, byte[] tweak) throws PkiException {
        throw new PkiException("004", "\u6a21\u5757\u4e0d\u652f\u6301\u6b64\u79cd\u64cd\u4f5c");
    }
}

