/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.assemb.base;

import cn.org.bjca.gaia.assemb.base.CommonJniAsymKey;
import cn.org.bjca.gaia.assemb.base.CommonJniHash;
import cn.org.bjca.gaia.assemb.base.CommonJniHmac;
import cn.org.bjca.gaia.assemb.base.CommonJniSM9Data;
import cn.org.bjca.gaia.assemb.base.CommonJniSymKey;
import cn.org.bjca.gaia.assemb.base.FPEType;
import cn.org.bjca.gaia.assemb.base.GaiaProvider;
import cn.org.bjca.gaia.assemb.base.SCFJniHost;
import cn.org.bjca.gaia.assemb.constant.AlgConstant;
import cn.org.bjca.gaia.assemb.exception.PkiException;
import cn.org.bjca.gaia.assemb.param.AlgPolicy;
import cn.org.bjca.gaia.assemb.param.BjcaKey;
import cn.org.bjca.gaia.assemb.param.BjcaKeyPair;
import cn.org.bjca.gaia.assemb.param.GenKeyParam;
import cn.org.bjca.gaia.assemb.param.IVParam;
import cn.org.bjca.gaia.assemb.param.SM3Param;
import cn.org.bjca.gaia.assemb.util.ByteArrayUtil;
import cn.org.bjca.gaia.assemb.util.KeyPairUtil;
import cn.org.bjca.gaia.util.encoders.Base64;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class CommonJni
implements GaiaProvider {
    public static int SCF_DEVICE_SOFT = 1;
    public static int SCF_DEVICE_SANSEC = 2;
    public static int SCF_DEVICE_FISHMAN = 3;
    public static int SCF_DEVICE_BJCA = 4;
    public static int SCF_SYMM_ENCRYPT = 1;
    public static int SCF_SYMM_DECRYPT = 0;
    public static int SCF_KEY_TYPE_ENC = 1;
    public static int SCF_KEY_TYPE_SIGN = 2;
    public static int SCF_SYMM_NOPADDING = 0;
    public static int SCF_SYMM_PKCS5PADDING = 1;
    public static int SCF_SYMM_PKCS7PADDING = 2;
    public static int SGD_SM1_ECB = 257;
    public static int SGD_SM1_CBC = 258;
    public static int SGD_SM1_CFB = 260;
    public static int SGD_SM1_OFB = 264;
    public static int SGD_SM1_MAC = 272;
    public static int SGD_SM1_CTR = 288;
    public static int SGD_SSF33_ECB = 513;
    public static int SGD_SSF33_CBC = 514;
    public static int SGD_SSF33_CFB = 516;
    public static int SGD_SSF33_OFB = 520;
    public static int SGD_SSF33_MAC = 528;
    public static int SGD_SSF33_CTR = 544;
    public static int SGD_SM4_ECB = 1025;
    public static int SGD_SM4_CBC = 1026;
    public static int SGD_SM4_CFB = 1028;
    public static int SGD_SM4_OFB = 1032;
    public static int SGD_SM4_MAC = 1040;
    public static int SGD_SM4_CTR = 1056;
    public static int SGD_SM4_BC = 1088;
    public static int SGD_SM4_OFBNLF = 1152;
    public static int SGD_SM4_XTS = 0x1000400;
    public static int SGD_SM4_GCM = 0x2000400;
    public static int SGD_SM4_CCM = 0x4000400;
    public static int SGD_ZUC_EEA3 = 2049;
    public static int SGD_ZUC_EIA3 = 2050;
    public static int SGD_AES_ECB = 0x10000401;
    public static int SGD_AES_CBC = 268436482;
    public static int SGD_AES_CFB = 0x10000404;
    public static int SGD_AES_OFB = 268436488;
    public static int SGD_AES_MAC = 0x10000410;
    public static int SGD_AES_CTR = 268436512;
    public static int SGD_SM1_FPE = 0x8000100;
    public static int SGD_SSF33_FPE = 0x8000200;
    public static int SGD_SM4_FPE = 0x8000400;
    public static int SGD_AES_FPE = 402654208;
    public static int SGD_AES_BC = 0x10000440;
    public static int SGD_AES_OFBNLF = 268436608;
    public static int SGD_AES_XTS = 0x11000400;
    public static int SGD_AES_GCM = 301990912;
    public static int SGD_AES_CCM = 0x14000400;
    public static int SGD_3DES_ECB = 0x10000801;
    public static int SGD_3DES_CBC = 268437506;
    public static int SGD_3DES_CFB = 268437508;
    public static int SGD_3DES_OFB = 0x10000808;
    public static int SGD_3DES_MAC = 0x10000810;
    public static int SGD_RSA = 65536;
    public static int SGD_SM2 = 131328;
    public static int SGD_SM2_1 = 131584;
    public static int SGD_SM2_2 = 132096;
    public static int SGD_SM2_3 = 133120;
    public static int SGD_SM9 = 262400;
    public static int SGD_SM9_1 = 262656;
    public static int SGD_SM9_2 = 263168;
    public static int SGD_SM9_3 = 264192;
    public static int SGD_SM3 = 1;
    public static int SGD_SHA1 = 2;
    public static int SGD_SHA256 = 4;
    public static int SGD_SHA224 = 8;
    public static int SGD_SHA384 = 16;
    public static int SGD_SHA512 = 32;
    public static int SGD_SM3_RSA = 65537;
    public static int SGD_SHA1_RSA = 65538;
    public static int SGD_SHA256_RSA = 65540;
    public static int SGD_SM3_SM2 = 131585;
    public static int SGD_SM3_SM9 = 262657;
    public static int SGD_ED25519 = 0x10010000;
    static SCFJniHost jnihost_ = null;
    private long hdev_ = 0L;
    private boolean bOpened_ = false;
    public static byte[][] masterSignKeySM9 = null;
    public static byte[][] masterExchangeKeySM9 = null;
    public static byte[][] masterEncryptKeySM9 = null;
    private int deviceType = 0;

    public static void initializeInstance() {
        if (jnihost_ != null) {
            return;
        }
        jnihost_ = SCFJniHost.getInstance();
    }

    public static void terminateInstance() {
        if (jnihost_ != null) {
            SCFJniHost.Release();
            jnihost_ = null;
        }
    }

    public CommonJni() throws Exception {
        if (jnihost_ == null) {
            throw new Exception("Can not get CommonJni instance!");
        }
    }

    public CommonJni(int deviceType) throws Exception {
        if (jnihost_ == null) {
            throw new Exception("Can not get CommonJni instance!");
        }
        if (!this.openDevice(deviceType)) {
            throw new Exception("Can openDevice(deviceType:" + deviceType + ")!");
        }
    }

    public CommonJni(String providerName) throws Exception {
        if (jnihost_ == null) {
            throw new PkiException("11000001", "\u521d\u59cb\u5316\u52a0\u5bc6\u8bbe\u5907\u5931\u8d25 ");
        }
        if (providerName.equals("BJCASO")) {
            this.bOpened_ = this.openDevice(SCF_DEVICE_SOFT);
            this.deviceType = SCF_DEVICE_SOFT;
        } else if (providerName.equals("SANSEC_CARD")) {
            this.bOpened_ = this.openDevice(SCF_DEVICE_SANSEC);
            this.deviceType = SCF_DEVICE_SANSEC;
        } else if (providerName.equals("FISHMAN_CARD")) {
            this.bOpened_ = this.openDevice(SCF_DEVICE_FISHMAN);
            this.deviceType = SCF_DEVICE_FISHMAN;
        } else if (providerName.equals("BJCA_CARD")) {
            this.bOpened_ = this.openDevice(SCF_DEVICE_BJCA);
            this.deviceType = SCF_DEVICE_BJCA;
        }
        if (!this.bOpened_) {
            throw new PkiException("11000002", "\u5bc6\u7801\u8bbe\u5907\u672a\u8fdb\u884c\u521d\u59cb\u5316 ");
        }
    }

    public String getVersion() {
        return jnihost_.getSCFVersion();
    }

    public boolean setParam(String key, String value) {
        return jnihost_.setSCFParam(key, value);
    }

    public boolean openDevice(int deviceType) {
        this.hdev_ = jnihost_.openDevice(deviceType);
        if (this.hdev_ == 0L) {
            return false;
        }
        this.bOpened_ = true;
        return true;
    }

    public boolean closeDevice() {
        this.bOpened_ = false;
        return jnihost_.closeDevice(this.hdev_);
    }

    public byte[] generateRandom(int length) {
        if (!this.bOpened_) {
            return null;
        }
        return jnihost_.generateRandom(this.hdev_, length);
    }

    public CommonJniAsymKey genKeyPair(int algId, int keyLen) {
        if (!this.bOpened_) {
            return null;
        }
        long hAsymKey = jnihost_.genKeyPair(this.hdev_, algId, keyLen);
        if (hAsymKey == 0L) {
            return null;
        }
        return new CommonJniAsymKey(jnihost_, hAsymKey);
    }

    public CommonJniAsymKey createAsymKeyFromPubKey(byte[] pubKey) {
        if (!this.bOpened_) {
            return null;
        }
        long hAsymKey = jnihost_.createAsymObjectFromPubKey(this.hdev_, pubKey);
        if (hAsymKey == 0L) {
            return null;
        }
        return new CommonJniAsymKey(jnihost_, hAsymKey);
    }

    public CommonJniAsymKey createAsymKeyFromPriKey(byte[] priKey) {
        if (!this.bOpened_) {
            return null;
        }
        long hAsymKey = jnihost_.createAsymObjectFromPriKey(this.hdev_, priKey);
        if (hAsymKey == 0L) {
            return null;
        }
        return new CommonJniAsymKey(jnihost_, hAsymKey);
    }

    public CommonJniAsymKey createAsymKeyFromKeyIndex(int algId, int keyIndex) {
        if (!this.bOpened_) {
            return null;
        }
        long hAsymKey = jnihost_.createAsymObjectFromKeyIndex(this.hdev_, algId, keyIndex);
        if (hAsymKey == 0L) {
            return null;
        }
        return new CommonJniAsymKey(jnihost_, hAsymKey);
    }

    public CommonJniHmac createHmac(int hashAlgor, byte[] key) {
        if (!this.bOpened_) {
            return null;
        }
        long hHmac = jnihost_.createHmacObject(this.hdev_, hashAlgor, key);
        if (hHmac == 0L) {
            return null;
        }
        return new CommonJniHmac(jnihost_, hHmac);
    }

    public CommonJniHash createHash(int hashAlgor, byte[] pubKey, byte[] userId) {
        if (!this.bOpened_) {
            return null;
        }
        long hHash = jnihost_.createHashObject(this.hdev_, hashAlgor, pubKey, userId);
        if (hHash == 0L) {
            return null;
        }
        return new CommonJniHash(jnihost_, hHash);
    }

    public CommonJniSymKey createSymKeyFromKey(int symAlgor, int padType, int encType, byte[] key, byte[] iv) {
        if (!this.bOpened_) {
            return null;
        }
        long hSymKey = jnihost_.createSymObjectFromKey(this.hdev_, symAlgor, padType, encType, key, iv);
        if (hSymKey == 0L) {
            return null;
        }
        return new CommonJniSymKey(jnihost_, hSymKey);
    }

    public CommonJniSymKey createSymKeyFromKeyIndex(int symAlgor, int padType, int encType, int keyIndex, byte[] iv) {
        if (!this.bOpened_) {
            return null;
        }
        long hSymKey = jnihost_.createSymObjectFromKeyIndex(this.hdev_, symAlgor, padType, encType, keyIndex, iv);
        if (hSymKey == 0L) {
            return null;
        }
        return new CommonJniSymKey(jnihost_, hSymKey);
    }

    public boolean checkSymAlgIsAEAD(int symAlgor) {
        return symAlgor == SGD_SM4_GCM || symAlgor == SGD_SM4_CCM || symAlgor == SGD_AES_GCM || symAlgor == SGD_AES_CCM;
    }

    public byte[] genSymmKey(int algId, int keyLen) {
        return this.generateRandom(keyLen);
    }

    private int getKeyMaxNumber(int keyType) {
        if (!this.bOpened_) {
            return 0;
        }
        String keyInfo = jnihost_.getKeyMaxNumber(this.hdev_);
        if (keyInfo == null) {
            return 0;
        }
        String[] strArr = keyInfo.split(",");
        if (strArr.length != 3) {
            return 0;
        }
        return Integer.parseInt(strArr[keyType]);
    }

    public int getDeviceMaxSymKeyNumber() {
        return this.getKeyMaxNumber(0);
    }

    public int getDeviceMaxSM2KeyNumber() {
        return this.getKeyMaxNumber(1);
    }

    public int getDeviceMaxRSAKeyNumber() {
        return this.getKeyMaxNumber(2);
    }

    private int[] enumAsymmKeyInDevice(String keyType) {
        if (!this.bOpened_) {
            return null;
        }
        String keyInfo = jnihost_.enumAsymKeyInDevice(this.hdev_);
        if (keyInfo == null) {
            return null;
        }
        String[] strArr = keyInfo.split("&&&");
        if (strArr.length == 0) {
            return new int[0];
        }
        int[] allKeyArray = new int[strArr.length];
        int expectCount = 0;
        for (String s2 : strArr) {
            String[] keyInfoArray = s2.split("\\|");
            if (keyInfoArray.length != 3 || !keyInfoArray[1].equals(keyType)) continue;
            allKeyArray[expectCount++] = Integer.parseInt(keyInfoArray[0]);
        }
        int[] returnArray = new int[expectCount];
        System.arraycopy(allKeyArray, 0, returnArray, 0, expectCount);
        return returnArray;
    }

    public int[] enumSymKeyInDevice() {
        if (!this.bOpened_) {
            return null;
        }
        String keyInfo = jnihost_.enumSymKeyInDevice(this.hdev_);
        if (keyInfo == null) {
            return null;
        }
        String[] strArr = keyInfo.split("&&&");
        if (strArr.length == 0) {
            return new int[0];
        }
        int[] allKeyArray = new int[strArr.length];
        int expectCount = 0;
        for (String s2 : strArr) {
            String[] keyInfoArray = s2.split("\\|");
            if (keyInfoArray.length != 3) continue;
            allKeyArray[expectCount++] = Integer.parseInt(keyInfoArray[0]);
        }
        int[] returnArray = new int[expectCount];
        System.arraycopy(allKeyArray, 0, returnArray, 0, expectCount);
        return returnArray;
    }

    public int[] enumRSAKeyInDevice() {
        return this.enumAsymmKeyInDevice("RSA");
    }

    public int[] enumSM2KeyInDevice() {
        return this.enumAsymmKeyInDevice("SM2");
    }

    public boolean generateSymKeyInDevice(int keyIndex, int keyLen) {
        if (!this.bOpened_) {
            return false;
        }
        return jnihost_.generateSymKeyInDevice(this.hdev_, keyIndex, keyLen);
    }

    public boolean importSymKeyToDevice(int keyIndex, byte[] key) {
        if (!this.bOpened_) {
            return false;
        }
        return jnihost_.importSymKeyToDevice(this.hdev_, keyIndex, key);
    }

    public boolean deleteSymKeyFromDevice(int keyIndex) {
        if (!this.bOpened_) {
            return false;
        }
        return jnihost_.deleteSymKeyFromDevice(this.hdev_, keyIndex);
    }

    public byte[] backupSymKeyFromDevice(int keyIndex, byte[] passwd) {
        if (!this.bOpened_) {
            return null;
        }
        return jnihost_.backupSymKeyFromDevice(this.hdev_, keyIndex, passwd);
    }

    public boolean restoreSymKeyToDevice(int keyIndex, byte[] backupInfo, byte[] passwd) {
        if (!this.bOpened_) {
            return false;
        }
        return jnihost_.restoreSymKeyToDevice(this.hdev_, keyIndex, backupInfo, passwd);
    }

    public boolean generateKeyPairInDevice(int keyIndex, int asymAlgor, int keySize) {
        if (!this.bOpened_) {
            return false;
        }
        return jnihost_.generateKeyPairInDevice(this.hdev_, keyIndex, asymAlgor, keySize);
    }

    public boolean importKeyPairToDevice(int keyIndex, int asymAlgor, byte[] priKey, byte[] pubKey) {
        if (!this.bOpened_) {
            return false;
        }
        return jnihost_.importKeyPairToDevice(this.hdev_, keyIndex, asymAlgor, priKey, pubKey);
    }

    public boolean deleteKeyPairFromDevice(int keyIndex, int asymAlgor) {
        if (!this.bOpened_) {
            return false;
        }
        return jnihost_.deleteKeyPairFromDevice(this.hdev_, keyIndex, asymAlgor);
    }

    public byte[] backupKeypairFromDevice(int keyIndex, int asymAlgor, byte[] passwd) {
        if (!this.bOpened_) {
            return null;
        }
        return jnihost_.backupKeypairFromDevice(this.hdev_, keyIndex, asymAlgor, passwd);
    }

    public boolean restoreKeyPairToDevice(int keyIndex, byte[] backupInfo, byte[] passwd) {
        if (!this.bOpened_) {
            return false;
        }
        return jnihost_.restoreKeyPairToDevice(this.hdev_, keyIndex, backupInfo, passwd);
    }

    public byte[] exportPubicKeyFromDevice(int keyIndex, int keyUsage, int asymAlgor) {
        if (!this.bOpened_) {
            return null;
        }
        return jnihost_.exportPubicKeyFromDevice(this.hdev_, keyIndex, keyUsage, asymAlgor);
    }

    public byte[] backupAllKeyFromDevice(byte[] passwd) {
        if (!this.bOpened_) {
            return null;
        }
        return jnihost_.backupAllKeyFromDevice(this.hdev_, passwd);
    }

    public boolean restoreAllKeyToDevice(byte[] backupInfo, byte[] passwd) {
        if (!this.bOpened_) {
            return false;
        }
        return jnihost_.restoreAllKeyToDevice(this.hdev_, backupInfo, passwd);
    }

    @Override
    public byte[] generateRangeRandom(byte[] range) {
        if (!this.bOpened_) {
            return null;
        }
        return jnihost_.generateRangeRandom(this.hdev_, range);
    }

    @Override
    public byte[] bigIntegerModAdd(byte[] a, byte[] b, byte[] m3) {
        if (!this.bOpened_) {
            return null;
        }
        return jnihost_.bigIntegerModAdd(this.hdev_, a, b, m3);
    }

    @Override
    public byte[] bigIntegerModSub(byte[] a, byte[] b, byte[] m3) {
        if (!this.bOpened_) {
            return null;
        }
        return jnihost_.bigIntegerModSub(this.hdev_, a, b, m3);
    }

    @Override
    public byte[] bigIntegerModMul(byte[] a, byte[] b, byte[] m3) {
        if (!this.bOpened_) {
            return null;
        }
        return jnihost_.bigIntegerModMul(this.hdev_, a, b, m3);
    }

    @Override
    public byte[] bigIntegerModExp(byte[] a, byte[] b, byte[] m3) {
        if (!this.bOpened_) {
            return null;
        }
        return jnihost_.bigIntegerModExp(this.hdev_, a, b, m3);
    }

    @Override
    public byte[] bigIntegerModInverse(byte[] a, byte[] m3) {
        if (!this.bOpened_) {
            return null;
        }
        return jnihost_.bigIntegerModInverse(this.hdev_, a, m3);
    }

    @Override
    public byte[] SM2PointMul(byte[] a, byte[] k) {
        if (!this.bOpened_) {
            return null;
        }
        return jnihost_.SM2PointMul(this.hdev_, a, k);
    }

    @Override
    public byte[] SM2PointAdd(byte[] a, byte[] b) {
        if (!this.bOpened_) {
            return null;
        }
        return jnihost_.SM2PointAdd(this.hdev_, a, b);
    }

    @Override
    public byte[] SM2PointSub(byte[] a, byte[] b) {
        if (!this.bOpened_) {
            return null;
        }
        return jnihost_.SM2PointSub(this.hdev_, a, b);
    }

    @Override
    public byte[] SemServerGenerateSM2Key(byte[] ds, byte[] pc) {
        if (!this.bOpened_) {
            return null;
        }
        return jnihost_.SemServerGenerateSM2Key(this.hdev_, pc, ds);
    }

    @Override
    public byte[] SemServerSM2SignFinal(byte[] ds, byte[] k1, byte[] r, byte[] s2, byte[] s3) {
        if (!this.bOpened_) {
            return null;
        }
        return jnihost_.SemServerSM2SignFinal(this.hdev_, ds, k1, r, s2, s3);
    }

    public byte[] SM9GetPublicKeyFromSecret(int sm9Algor, byte[] masterSecret) {
        if (!this.bOpened_) {
            return null;
        }
        return jnihost_.sm9GetPublicKeyFromSecret(this.hdev_, sm9Algor, masterSecret);
    }

    public byte[] SM9GenerateUserKey(int sm9Algor, byte[] masterSecret, byte[] userId) {
        if (!this.bOpened_) {
            return null;
        }
        return jnihost_.sm9GenerateUserKey(this.hdev_, sm9Algor, masterSecret, userId);
    }

    public CommonJniAsymKey SM9CreateAsymObjectFromAlgorithm(int sm9Algor) {
        if (!this.bOpened_) {
            return null;
        }
        long hAsymKey = jnihost_.sm9createAsymObjectFromAlgorithm(this.hdev_, sm9Algor);
        if (hAsymKey == 0L) {
            return null;
        }
        return new CommonJniAsymKey(jnihost_, hAsymKey);
    }

    public CommonJniAsymKey SM9CreateAsymObjectFromPriKey(int sm9Algor, byte[] priKey) {
        if (!this.bOpened_) {
            return null;
        }
        long hAsymKey = jnihost_.sm9createAsymObjectFromPriKey(this.hdev_, sm9Algor, priKey);
        if (hAsymKey == 0L) {
            return null;
        }
        return new CommonJniAsymKey(jnihost_, hAsymKey);
    }

    @Override
    public byte[] semV2ClientG1(byte[] dc, byte[] r) {
        if (!this.bOpened_) {
            return null;
        }
        return jnihost_.SemV2ClientG1(this.hdev_, dc, r);
    }

    @Override
    public byte[] semV2ClientG2() {
        if (!this.bOpened_) {
            return null;
        }
        return jnihost_.SemV2ClientG2(this.hdev_);
    }

    @Override
    public byte[] semV2ClientG3(byte[] dcc, byte[] t) {
        if (!this.bOpened_) {
            return null;
        }
        return jnihost_.SemV2ClientG3(this.hdev_, dcc, t);
    }

    @Override
    public byte[] semV2ServerG4(byte[] w, byte[] r, byte[] ds) {
        if (!this.bOpened_) {
            return null;
        }
        return jnihost_.SemV2ServerG4(this.hdev_, w, r, ds);
    }

    @Override
    public byte[] semV2Client2CalcDCS(byte[] dc, byte[] dcc) {
        if (!this.bOpened_) {
            return null;
        }
        return jnihost_.SemV2Client2CalcDCS(this.hdev_, dc, dcc);
    }

    @Override
    public byte[] semV2Server2CalcDSS(byte[] ds, byte[] dcs) {
        if (!this.bOpened_) {
            return null;
        }
        return jnihost_.SemV2Server2CalcDSS(this.hdev_, ds, dcs);
    }

    public CommonJniAsymKey createAsymObjectFromED25519PubKey(byte[] pubKey) {
        if (!this.bOpened_) {
            return null;
        }
        long hAsymKey = jnihost_.createAsymObjectFromED25519PubKey(this.hdev_, pubKey);
        if (hAsymKey == 0L) {
            return null;
        }
        return new CommonJniAsymKey(jnihost_, hAsymKey);
    }

    public CommonJniAsymKey createAsymObjectFromED25519PriKey(byte[] priKey) {
        if (!this.bOpened_) {
            return null;
        }
        long hAsymKey = jnihost_.createAsymObjectFromED25519PriKey(this.hdev_, priKey);
        if (hAsymKey == 0L) {
            return null;
        }
        return new CommonJniAsymKey(jnihost_, hAsymKey);
    }

    private static void printHex(String label, byte[] src) {
        if (label.length() > 0) {
            System.out.println(label + " :");
        }
        if (src == null || src.length == 0) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder("");
        for (int i = 0; i < src.length; ++i) {
            int v = src[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
            if ((i + 1) % 16 != 0) continue;
            stringBuilder.append('\n');
        }
        System.out.println(stringBuilder.toString().toUpperCase());
    }

    private static void printHex(byte[] src) {
        if (src == null || src.length == 0) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder("");
        for (byte b : src) {
            int v = b & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
        }
        System.out.print(stringBuilder.toString().toUpperCase());
    }

    @Override
    public BjcaKeyPair genKeyPair(AlgPolicy algPolicy, int keyLen) throws PkiException {
        String policyType = algPolicy.getPolicyType();
        if (!(policyType.equals("RSA") || policyType.equals("SM2") || policyType.equals("ED25519"))) {
            throw new PkiException("11004002", "\u4ea7\u751f\u975e\u5bf9\u79f0\u5bc6\u94a5\u5bf9\u5931\u8d25 \u6a21\u5757\u4e0d\u652f\u6301\u6b64\u79cd\u64cd\u4f5c " + policyType);
        }
        int algId = AlgConstant.convertAlgNameToJniId(policyType);
        BjcaKey bjcaPriKey = null;
        BjcaKey bjcaPubKey = null;
        if (this.deviceType == SCF_DEVICE_SOFT) {
            CommonJniAsymKey key = this.genKeyPair(algId, keyLen);
            if (key == null) {
                throw new PkiException("11002002", "\u4ea7\u751f\u975e\u5bf9\u79f0\u5bc6\u94a5\u5bf9\u5931\u8d25 " + policyType + " " + keyLen);
            }
            byte[] pubKey = key.getPublicKey();
            byte[] priKey = key.getPrivateKey();
            key.destroy();
            if (policyType.equals("RSA")) {
                pubKey = KeyPairUtil.convertRsaP1PubKeyToP8(pubKey);
                priKey = KeyPairUtil.convertRsaP1PriKeyToP8(priKey);
                bjcaPubKey = new BjcaKey("RSA_Public", pubKey);
                bjcaPriKey = new BjcaKey("RSA_Private", priKey);
            } else if (policyType.equals("SM2")) {
                bjcaPubKey = new BjcaKey("SM2_Public", pubKey);
                bjcaPriKey = new BjcaKey("SM2_Private", priKey);
            } else {
                bjcaPubKey = new BjcaKey("ED25519_Public", pubKey);
                bjcaPriKey = new BjcaKey("ED25519_Private", priKey);
            }
        } else {
            if (algPolicy.getParam() == null) {
                throw new PkiException("11003002", "\u4ea7\u751f\u975e\u5bf9\u79f0\u5bc6\u94a5\u5bf9\u5931\u8d25 \u7f3a\u5c11\u64cd\u4f5c\u53c2\u6570\u9519\u8bef GenKeyParam is null");
            }
            GenKeyParam genKeyParam = (GenKeyParam)algPolicy.getParam();
            if (genKeyParam.isInCard()) {
                int index = genKeyParam.getKeyIndex();
                boolean genIn = this.generateKeyPairInDevice(index, algId, keyLen);
                if (!genIn) {
                    throw new PkiException("11003002", "\u4ea7\u751f\u975e\u5bf9\u79f0\u5bc6\u94a5\u5bf9\u5931\u8d25 " + policyType);
                }
                byte[] pubKey = this.exportPubicKeyFromDevice(index, SCF_KEY_TYPE_SIGN, algId);
                if (policyType.equals("RSA")) {
                    pubKey = KeyPairUtil.convertRsaP1PubKeyToP8(pubKey);
                    bjcaPubKey = new BjcaKey("RSA_Public", pubKey);
                    bjcaPriKey = new BjcaKey("RSA_Private", index);
                } else {
                    bjcaPubKey = new BjcaKey("SM2_Public", pubKey);
                    bjcaPriKey = new BjcaKey("SM2_Private", index);
                }
            } else {
                CommonJniAsymKey key = this.genKeyPair(algId, keyLen);
                if (key == null) {
                    throw new PkiException("11003002", "\u4ea7\u751f\u975e\u5bf9\u79f0\u5bc6\u94a5\u5bf9\u5931\u8d25 " + policyType + " " + keyLen);
                }
                byte[] pubKey = key.getPublicKey();
                byte[] priKey = key.getPrivateKey();
                key.destroy();
                if (policyType.equals("RSA")) {
                    pubKey = KeyPairUtil.convertRsaP1PubKeyToP8(pubKey);
                    priKey = KeyPairUtil.convertRsaP1PriKeyToP8(priKey);
                    bjcaPubKey = new BjcaKey("RSA_Public", pubKey);
                    bjcaPriKey = new BjcaKey("RSA_Private", priKey);
                } else {
                    bjcaPubKey = new BjcaKey("SM2_Public", pubKey);
                    bjcaPriKey = new BjcaKey("SM2_Private", priKey);
                }
            }
        }
        return new BjcaKeyPair(bjcaPubKey, bjcaPriKey);
    }

    @Override
    public BjcaKey genSymmKey(AlgPolicy algPolicy, int keyLen) throws PkiException {
        String policyType = algPolicy.getPolicyType();
        if (!(policyType.equals("DESede") || policyType.equals("AES") || policyType.equals("SM4") || policyType.equals("ZUC"))) {
            throw new PkiException("11004001", "\u4ea7\u751f\u5bf9\u79f0\u5bc6\u94a5\u64cd\u4f5c\u5931\u8d25 \u6a21\u5757\u4e0d\u652f\u6301\u6b64\u79cd\u64cd\u4f5c " + policyType);
        }
        int algId = AlgConstant.convertAlgNameToJniId(policyType);
        BjcaKey bjcaKey = null;
        int randomLen = keyLen / 8;
        if (this.deviceType == SCF_DEVICE_SOFT) {
            byte[] key = this.genSymmKey(algId, randomLen);
            if (key == null) {
                throw new PkiException("11002001", "\u4ea7\u751f\u5bf9\u79f0\u5bc6\u94a5\u64cd\u4f5c\u5931\u8d25 " + policyType + " " + keyLen);
            }
            bjcaKey = new BjcaKey(policyType, key);
        } else {
            GenKeyParam genKeyParam = (GenKeyParam)algPolicy.getParam();
            if (genKeyParam == null) {
                throw new PkiException("11003099", "\u7f3a\u5c11\u64cd\u4f5c\u53c2\u6570\u9519\u8bef GenKeyParam is null");
            }
            if (genKeyParam.isInCard()) {
                int index = genKeyParam.getKeyIndex();
                boolean ret = this.generateSymKeyInDevice(index, randomLen);
                if (!ret) {
                    throw new PkiException("11003001", "\u4ea7\u751f\u5bf9\u79f0\u5bc6\u94a5\u64cd\u4f5c\u5931\u8d25 " + ret);
                }
                bjcaKey = new BjcaKey(policyType, index);
            } else {
                byte[] key = this.genSymmKey(algId, randomLen);
                if (key == null) {
                    throw new PkiException("11003001", "\u4ea7\u751f\u5bf9\u79f0\u5bc6\u94a5\u64cd\u4f5c\u5931\u8d25 ");
                }
                bjcaKey = new BjcaKey(policyType, key);
            }
        }
        return bjcaKey;
    }

    @Override
    public byte[] signDataSM9(AlgPolicy algPolicy, byte[] dataInput, BjcaKeyPair bjcaKeyPair) throws PkiException {
        String policyType = algPolicy.getPolicyType();
        BjcaKey privateKey = bjcaKeyPair.getPrivateKey();
        BjcaKey publicKey = bjcaKeyPair.getPublicKey();
        if (!("SM3WithSM9".equals(policyType) && "SM9_Sign_Private".equals(privateKey.getKeyType()) && "SM9_Sign_Public".equals(publicKey.getKeyType()))) {
            throw new PkiException("11004009", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25 \u6a21\u5757\u4e0d\u652f\u6301\u6b64\u79cd\u64cd\u4f5c " + policyType);
        }
        int algId = AlgConstant.convertAlgNameToJniId("SM9_Sign");
        int sm3 = AlgConstant.convertAlgNameToJniId("SM3");
        CommonJniAsymKey userSignKey = this.SM9CreateAsymObjectFromPriKey(algId, privateKey.getKey());
        if (userSignKey == null) {
            throw new PkiException("11004009", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25 " + policyType + "SGD_SM9 SM9CreateAsymObjectFromPriKey error");
        }
        AlgPolicy algPolicyMaster = new AlgPolicy("SM9_Sign");
        byte[][] masterKey = this.genKeyPairSM9Master(algPolicyMaster);
        if (!userSignKey.sm9SetMasterPublicKey(masterKey[0], publicKey.getKey())) {
            throw new PkiException("11004009", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25 " + policyType + "SGD_SM9 sm9SetMasterPublicKey error");
        }
        byte[] pbSignature = null;
        if (dataInput.length <= 1024) {
            pbSignature = userSignKey.sm9SignData(sm3, dataInput);
        } else {
            if (!userSignKey.sm9SignInit(sm3)) {
                throw new PkiException("11004009", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25 " + policyType + "SGD_SM9 sm9SignInit error");
            }
            int size = dataInput.length;
            int len = 1024;
            int x = size / len;
            int y = size % len;
            int start = 0;
            for (int i = 0; i < x; ++i) {
                start = i * len;
                if (userSignKey.sm9SignUpdate(dataInput, start, len)) continue;
                throw new PkiException("11004009", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25 " + policyType + "SGD_SM9 sm9SignUpdate error");
            }
            if (y != 0 && !userSignKey.sm9SignUpdate(dataInput, start += len, y)) {
                throw new PkiException("11004009", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25 " + policyType + "SGD_SM9 sm9SignUpdate error");
            }
            pbSignature = userSignKey.sm9SignFinal();
            if (pbSignature == null) {
                throw new PkiException("11004009", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25 " + policyType + "SGD_SM9 sm9SignFinal error");
            }
        }
        if (pbSignature == null) {
            throw new PkiException("11004009", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25 " + policyType + "SGD_SM9 sm9SignData error");
        }
        userSignKey.destroy();
        return pbSignature;
    }

    public byte[][] genKeyPairSM9Master(AlgPolicy algPolicy) throws PkiException {
        Object result = null;
        String policyType = algPolicy.getPolicyType();
        if (!(policyType.equals("SM9_Sign") || policyType.equals("SM9_Exchange") || policyType.equals("SM9_Encrypt"))) {
            throw new PkiException("11004002", "\u4ea7\u751f\u975e\u5bf9\u79f0\u5bc6\u94a5\u5bf9\u5931\u8d25 \u6a21\u5757\u4e0d\u652f\u6301\u6b64\u79cd\u64cd\u4f5c " + policyType);
        }
        result = policyType.equals("SM9_Sign") ? masterSignKeySM9 : (policyType.equals("SM9_Exchange") ? masterExchangeKeySM9 : masterEncryptKeySM9);
        if (result == null) {
            result = new byte[2][];
            int algId = AlgConstant.convertAlgNameToJniId(policyType);
            CommonJniAsymKey masterKey = this.genKeyPair(algId, 0);
            if (masterKey == null) {
                throw new PkiException("11002002", "\u4ea7\u751f\u975e\u5bf9\u79f0\u5bc6\u94a5\u5bf9\u5931\u8d25 " + policyType + "SGD_SM9 masterKey error");
            }
            byte[] masterPriKey = masterKey.getPrivateKey();
            if (masterPriKey == null) {
                throw new PkiException("11002002", "\u4ea7\u751f\u975e\u5bf9\u79f0\u5bc6\u94a5\u5bf9\u5931\u8d25 " + policyType + "SGD_SM9 masterPriKey error");
            }
            byte[] masterPubKey = masterKey.getPublicKey();
            if (masterPubKey == null) {
                throw new PkiException("11002002", "\u4ea7\u751f\u975e\u5bf9\u79f0\u5bc6\u94a5\u5bf9\u5931\u8d25 " + policyType + "SGD_SM9 masterPubKey error");
            }
            byte[] masterPubKey2 = this.SM9GetPublicKeyFromSecret(algId, masterPriKey);
            if (masterPubKey2 == null || !Arrays.equals(masterPubKey, masterPubKey2)) {
                throw new PkiException("11002002", "\u4ea7\u751f\u975e\u5bf9\u79f0\u5bc6\u94a5\u5bf9\u5931\u8d25 " + policyType + "SGD_SM9 SM9GetPublicKeyFromSecret error");
            }
            result[0] = masterPubKey;
            result[1] = masterPriKey;
            if (policyType.equals("SM9_Sign")) {
                masterSignKeySM9 = result;
            } else if (policyType.equals("SM9_Exchange")) {
                masterExchangeKeySM9 = result;
            } else {
                masterEncryptKeySM9 = result;
            }
            masterKey.destroy();
        }
        return result;
    }

    @Override
    public boolean verifySignDataSM9(AlgPolicy algPolicy, byte[] dataInput, byte[] sign, BjcaKey publicKey) throws PkiException {
        String policyType = algPolicy.getPolicyType();
        if (!"SM3WithSM9".equals(policyType) || !"SM9_Sign_Public".equals(publicKey.getKeyType())) {
            throw new PkiException("11004010", "\u9a8c\u8bc1\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25 \u6a21\u5757\u4e0d\u652f\u6301\u6b64\u79cd\u64cd\u4f5c " + policyType);
        }
        boolean verifySignRet = false;
        int algId = AlgConstant.convertAlgNameToJniId("SM9_Sign");
        CommonJniAsymKey userVerifyKey = this.SM9CreateAsymObjectFromAlgorithm(algId);
        if (userVerifyKey == null) {
            throw new PkiException("11004010", "\u9a8c\u8bc1\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25 " + policyType + "SGD_SM9 SM9CreateAsymObjectFromAlgorithm error");
        }
        AlgPolicy algPolicyMaster = new AlgPolicy("SM9_Sign");
        int sm3 = AlgConstant.convertAlgNameToJniId("SM3");
        byte[][] masterKey = this.genKeyPairSM9Master(algPolicyMaster);
        if (!userVerifyKey.sm9SetMasterPublicKey(masterKey[0], publicKey.getKey())) {
            throw new PkiException("11004010", "\u9a8c\u8bc1\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25 " + policyType + "SGD_SM9 sm9SetMasterPublicKey error");
        }
        if (dataInput.length <= 1024) {
            verifySignRet = userVerifyKey.sm9VerifySignData(sm3, dataInput, sign);
        } else {
            if (!userVerifyKey.sm9VerifyInit(sm3)) {
                throw new PkiException("11004010", "\u9a8c\u8bc1\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25 " + policyType + "SGD_SM9 sm9VerifyInit error");
            }
            int size = dataInput.length;
            int len = 1024;
            int x = size / len;
            int y = size % len;
            int start = 0;
            for (int i = 0; i < x; ++i) {
                start = i * len;
                if (userVerifyKey.sm9VerifyUpdate(dataInput, start, len)) continue;
                throw new PkiException("11004010", "\u9a8c\u8bc1\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25 " + policyType + "SGD_SM9 sm9VerifyUpdate error");
            }
            if (y != 0 && !userVerifyKey.sm9VerifyUpdate(dataInput, start += len, y)) {
                throw new PkiException("11004010", "\u9a8c\u8bc1\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25 " + policyType + "SGD_SM9 sm9VerifyUpdate error");
            }
            verifySignRet = userVerifyKey.sm9VerifyFinal(sign);
            if (!verifySignRet) {
                throw new PkiException("11004010", "\u9a8c\u8bc1\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25 " + policyType + "SGD_SM9 sm9VerifyFinal error");
            }
        }
        userVerifyKey.destroy();
        return verifySignRet;
    }

    @Override
    public byte[] signHashedData(AlgPolicy algPolicy, byte[] hash, BjcaKey privateKey) throws PkiException {
        String policyType = algPolicy.getPolicyType();
        if (!AlgConstant.signAlgs.contains(policyType)) {
            throw new PkiException("11004009", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25 \u6a21\u5757\u4e0d\u652f\u6301\u6b64\u79cd\u64cd\u4f5c " + policyType);
        }
        byte[] signValue = null;
        int keyId = privateKey.getKeyID();
        byte[] prikey = privateKey.getKey();
        int algId = AlgConstant.convertAlgNameToJniId(AlgConstant.convertSignAlgToHashAlgc(policyType));
        if (this.deviceType == SCF_DEVICE_SOFT || this.deviceType != SCF_DEVICE_SOFT && keyId == -1) {
            CommonJniAsymKey asymKeyFromPriKey;
            if (AlgConstant.rsaSignAlgs.contains(policyType)) {
                prikey = KeyPairUtil.convertRsaP8PriKeyToP1(prikey);
            }
            if ((asymKeyFromPriKey = this.createAsymKeyFromPriKey(prikey)) == null) {
                throw new PkiException("11004009", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25 \u521b\u5efa\u7b7e\u540d\u5bf9\u8c61\u5931\u8d25 " + policyType);
            }
            signValue = asymKeyFromPriKey.signHash(algId, hash);
            asymKeyFromPriKey.destroy();
        } else {
            int keyType = AlgConstant.convertAlgNameToJniId(policyType.toUpperCase().contains("RSA") ? "RSA" : "SM2");
            CommonJniAsymKey asymKeyFromKeyIndex = this.createAsymKeyFromKeyIndex(keyType, keyId);
            if (asymKeyFromKeyIndex == null) {
                throw new PkiException("11003009", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25 \u521b\u5efa\u7b7e\u540d\u5bf9\u8c61\u5931\u8d25 " + policyType);
            }
            signValue = asymKeyFromKeyIndex.signHash(algId, hash);
            asymKeyFromKeyIndex.destroy();
        }
        if (signValue == null) {
            throw new PkiException("11004009", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25 " + policyType);
        }
        return signValue;
    }

    @Override
    public boolean verifySignHashedData(AlgPolicy algPolicy, byte[] hash, byte[] signature, BjcaKey publicKey) throws PkiException {
        String policyType = algPolicy.getPolicyType();
        if (!AlgConstant.signAlgs.contains(policyType)) {
            throw new PkiException("11004010", "\u9a8c\u8bc1\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25 \u6a21\u5757\u4e0d\u652f\u6301\u6b64\u79cd\u64cd\u4f5c " + policyType);
        }
        boolean verifySignRet = false;
        int keyId = publicKey.getKeyID();
        byte[] pubKey = publicKey.getKey();
        int algId = AlgConstant.convertAlgNameToJniId(AlgConstant.convertSignAlgToHashAlgc(policyType));
        if (this.deviceType == SCF_DEVICE_SOFT || this.deviceType != SCF_DEVICE_SOFT && keyId == -1) {
            CommonJniAsymKey asymKeyFromPubKey;
            if (AlgConstant.rsaSignAlgs.contains(policyType)) {
                pubKey = KeyPairUtil.convertRsaP8PubKeyToP1(pubKey);
            }
            if (AlgConstant.sm2SignAlgs.contains(policyType)) {
                pubKey = KeyPairUtil.getDerPublickey(pubKey);
            }
            if ((asymKeyFromPubKey = this.createAsymKeyFromPubKey(pubKey)) == null) {
                throw new PkiException("11002010", "\u9a8c\u8bc1\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25 \u521b\u5efa\u7b7e\u540d\u5bf9\u8c61\u5931\u8d25 " + policyType);
            }
            verifySignRet = asymKeyFromPubKey.verifySignedHash(algId, hash, signature);
            asymKeyFromPubKey.destroy();
        } else {
            CommonJniAsymKey asymKeyFromKeyIndex = this.createAsymKeyFromKeyIndex(algId, keyId);
            if (asymKeyFromKeyIndex == null) {
                throw new PkiException("11003010", "\u9a8c\u8bc1\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25 \u521b\u5efa\u7b7e\u540d\u5bf9\u8c61\u5931\u8d25 " + policyType);
            }
            verifySignRet = asymKeyFromKeyIndex.verifySignedHash(algId, hash, signature);
            asymKeyFromKeyIndex.destroy();
        }
        return verifySignRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] signDataED25519(AlgPolicy algPolicy, byte[] dataInput, BjcaKey privateKey) throws PkiException {
        if (algPolicy.getPolicyType().equals("ED25519") && privateKey.getKeyType().equals("ED25519_Private")) {
            CommonJniAsymKey priKey = null;
            try {
                priKey = this.createAsymObjectFromED25519PriKey(privateKey.getKey());
                byte[] byArray = priKey.ED25519SignData(dataInput);
                return byArray;
            }
            finally {
                if (priKey != null) {
                    priKey.destroy();
                }
            }
        }
        throw new PkiException("11002009", "\u4e0d\u652f\u6301\u7684\u7b97\u6cd5\u7c7b\u578b");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean verifySignedDataED25519(AlgPolicy algPolicy, byte[] dataInput, byte[] signature, BjcaKey publicKey) throws PkiException {
        if (algPolicy.getPolicyType().equals("ED25519") && publicKey.getKeyType().equals("ED25519_Public")) {
            CommonJniAsymKey pubKey = null;
            try {
                pubKey = this.createAsymObjectFromED25519PubKey(publicKey.getKey());
                boolean bl = pubKey.ED25519VerifySignedData(dataInput, signature);
                return bl;
            }
            finally {
                if (pubKey != null) {
                    pubKey.destroy();
                }
            }
        }
        throw new PkiException("11002009", "\u4e0d\u652f\u6301\u7684\u7b97\u6cd5\u7c7b\u578b");
    }

    @Override
    public byte[] signData(AlgPolicy algPolicy, byte[] dataInput, BjcaKey bjcaKey) throws PkiException {
        AlgPolicy hashAlg = null;
        if (algPolicy.getPolicyType().toUpperCase().contains("SM3")) {
            hashAlg = new AlgPolicy("SM3", algPolicy.getParam());
        } else if (algPolicy.getPolicyType().toUpperCase().contains("SHA1")) {
            hashAlg = new AlgPolicy("SHA1");
        } else if (algPolicy.getPolicyType().toUpperCase().contains("SHA256")) {
            hashAlg = new AlgPolicy("SHA256");
        } else if (algPolicy.getPolicyType().toUpperCase().contains("SHA224")) {
            hashAlg = new AlgPolicy("SHA224");
        } else if (algPolicy.getPolicyType().toUpperCase().contains("SHA384")) {
            hashAlg = new AlgPolicy("SHA384");
        } else if (algPolicy.getPolicyType().toUpperCase().contains("SHA512")) {
            hashAlg = new AlgPolicy("SHA512");
        } else {
            throw new PkiException("\u4e0d\u652f\u6301\u7684\u7b97\u6cd5\u7c7b\u578b");
        }
        byte[] hashedData = this.hash(hashAlg, dataInput);
        byte[] bytes = this.signHashedData(algPolicy, hashedData, bjcaKey);
        return bytes;
    }

    @Override
    public boolean verifySignData(AlgPolicy algPolicy, byte[] dataInput, byte[] sign, BjcaKey publicKey) throws PkiException {
        AlgPolicy hashAlg = null;
        if (algPolicy.getPolicyType().toUpperCase().contains("SM3")) {
            hashAlg = new AlgPolicy("SM3", algPolicy.getParam());
        } else if (algPolicy.getPolicyType().toUpperCase().contains("SHA1")) {
            hashAlg = new AlgPolicy("SHA1");
        } else if (algPolicy.getPolicyType().toUpperCase().contains("SHA256")) {
            hashAlg = new AlgPolicy("SHA256");
        } else if (algPolicy.getPolicyType().toUpperCase().contains("SHA224")) {
            hashAlg = new AlgPolicy("SHA224");
        } else if (algPolicy.getPolicyType().toUpperCase().contains("SHA384")) {
            hashAlg = new AlgPolicy("SHA384");
        } else if (algPolicy.getPolicyType().toUpperCase().contains("SHA512")) {
            hashAlg = new AlgPolicy("SHA512");
        } else {
            throw new PkiException("\u4e0d\u652f\u6301\u7684\u7b97\u6cd5\u7c7b\u578b");
        }
        byte[] hashdData = this.hash(hashAlg, dataInput);
        return this.verifySignHashedData(algPolicy, hashdData, sign, publicKey);
    }

    @Override
    public byte[] hash(AlgPolicy algPolicy, byte[] dataInput) throws PkiException {
        CommonJniHash hashOb;
        String policyType = algPolicy.getPolicyType();
        if (!AlgConstant.hashAlgs.contains(policyType)) {
            throw new PkiException("11004006", "\u6458\u8981\u64cd\u4f5c\u5931\u8d25 \u6a21\u5757\u4e0d\u652f\u6301\u6b64\u79cd\u64cd\u4f5c " + policyType);
        }
        int algId = AlgConstant.convertAlgNameToJniId(policyType);
        byte[] retHash = null;
        byte[] publicKey = null;
        byte[] id = null;
        if (AlgConstant.sm2HashAlgs.contains(policyType) && algPolicy.getParam() != null) {
            SM3Param sm3Param = (SM3Param)algPolicy.getParam();
            publicKey = sm3Param.getPubKey();
            id = sm3Param.getId();
        }
        if ((hashOb = this.createHash(algId, publicKey, id)) == null) {
            throw new PkiException("11004006", "\u6458\u8981\u64cd\u4f5c\u5931\u8d25\u521b\u5efa\u6458\u8981\u5bf9\u8c61\u5931\u8d25 policyType =" + policyType);
        }
        retHash = hashOb.hash(dataInput);
        hashOb.destroy();
        if (retHash == null) {
            throw new PkiException("11004006", "\u6458\u8981\u64cd\u4f5c\u5931\u8d25 policyType =" + policyType);
        }
        return retHash;
    }

    @Override
    public byte[] hash(AlgPolicy algPolicy, InputStream dataInput, int bufferSize) throws PkiException {
        CommonJniHash hashOb;
        String policyType = algPolicy.getPolicyType();
        if (!AlgConstant.hashAlgs.contains(policyType)) {
            throw new PkiException("11004006", "\u6458\u8981\u64cd\u4f5c\u5931\u8d25 \u6a21\u5757\u4e0d\u652f\u6301\u6b64\u79cd\u64cd\u4f5c " + policyType);
        }
        int algId = AlgConstant.convertAlgNameToJniId(policyType);
        byte[] retHash = null;
        byte[] publicKey = null;
        byte[] id = null;
        if (AlgConstant.sm2HashAlgs.contains(policyType) && algPolicy.getParam() != null) {
            SM3Param sm3Param = (SM3Param)algPolicy.getParam();
            publicKey = sm3Param.getPubKey();
            id = sm3Param.getId();
        }
        if ((hashOb = this.createHash(algId, publicKey, id)) == null) {
            throw new PkiException("11004006", "\u6458\u8981\u64cd\u4f5c\u5931\u8d25\u521b\u5efa\u6458\u8981\u5bf9\u8c61\u5931\u8d25 policyType =" + policyType);
        }
        try {
            byte[] buffer = new byte[bufferSize];
            int i = 0;
            while ((i = dataInput.read(buffer)) > 0) {
                hashOb.hashUpdate(buffer, 0, i);
            }
            retHash = hashOb.hashFinal();
            hashOb.destroy();
            dataInput.close();
        }
        catch (Exception e) {
            throw new PkiException("11004006", "\u6458\u8981\u64cd\u4f5c\u5931\u8d25", e);
        }
        if (retHash == null) {
            throw new PkiException("11004006", "\u6458\u8981\u64cd\u4f5c\u5931\u8d25 policyType =" + policyType);
        }
        return retHash;
    }

    @Override
    public Map sm9ExchangeKeyInitiatorRequest(BjcaKeyPair bjcaKeyPairA, BjcaKey bjcaKeyB, int SKALen) throws PkiException {
        BjcaKey privateKey = bjcaKeyPairA.getPrivateKey();
        BjcaKey publicKey = bjcaKeyPairA.getPublicKey();
        if (!("SM9_Exchange_Private".equals(privateKey.getKeyType()) && "SM9_Exchange_Public".equals(publicKey.getKeyType()) && "SM9_Exchange_Public".equals(bjcaKeyB.getKeyType()))) {
            throw new PkiException("11004015", "SM9\u5bc6\u94a5\u534f\u5546\u5931\u8d25 \u6a21\u5757\u4e0d\u652f\u6301\u6b64\u79cd\u64cd\u4f5c");
        }
        int algId = AlgConstant.convertAlgNameToJniId("SM9_Exchange");
        CommonJniAsymKey userAExchangeKey = this.SM9CreateAsymObjectFromPriKey(algId, privateKey.getKey());
        if (userAExchangeKey == null) {
            throw new PkiException("11004015", "SM9\u5bc6\u94a5\u534f\u5546\u5931\u8d25 SGD_SM9 SM9CreateAsymObjectFromPriKey error");
        }
        AlgPolicy algPolicyMaster = new AlgPolicy("SM9_Exchange");
        byte[][] masterKey = this.genKeyPairSM9Master(algPolicyMaster);
        if (!userAExchangeKey.sm9SetMasterPublicKey(masterKey[0], publicKey.getKey())) {
            throw new PkiException("11004015", "SM9\u5bc6\u94a5\u534f\u5546\u5931\u8d25 SGD_SM9 sm9SetMasterPublicKey error");
        }
        CommonJniSM9Data userASM9Data = userAExchangeKey.sm9ExchangeKeyInitiatorRequest(bjcaKeyB.getKey(), SKALen);
        if (userASM9Data == null) {
            throw new PkiException("11004015", "SM9\u5bc6\u94a5\u534f\u5546\u5931\u8d25 SGD_SM9 sm9ExchangeKeyInitiatorRequest error");
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("userASM9Data", userASM9Data);
        hashMap.put("userAExchangeKey", userAExchangeKey);
        return hashMap;
    }

    @Override
    public byte[][] sm9ExchangeKeyResponder(BjcaKeyPair bjcaKeyPairB, BjcaKey bjcaKeyA, int SKALen, byte[] ra) throws PkiException {
        BjcaKey privateKey = bjcaKeyPairB.getPrivateKey();
        BjcaKey publicKey = bjcaKeyPairB.getPublicKey();
        byte[][] result = new byte[4][];
        if (!("SM9_Exchange_Private".equals(privateKey.getKeyType()) && "SM9_Exchange_Public".equals(publicKey.getKeyType()) && "SM9_Exchange_Public".equals(bjcaKeyA.getKeyType()))) {
            throw new PkiException("11004015", "SM9\u5bc6\u94a5\u534f\u5546\u5931\u8d25 \u6a21\u5757\u4e0d\u652f\u6301\u6b64\u79cd\u64cd\u4f5c");
        }
        int algId = AlgConstant.convertAlgNameToJniId("SM9_Exchange");
        int sm3 = AlgConstant.convertAlgNameToJniId("SM3");
        CommonJniAsymKey userBExchangeKey = this.SM9CreateAsymObjectFromPriKey(algId, privateKey.getKey());
        if (userBExchangeKey == null) {
            throw new PkiException("11004015", "SM9\u5bc6\u94a5\u534f\u5546\u5931\u8d25 SGD_SM9 SM9CreateAsymObjectFromPriKey error");
        }
        AlgPolicy algPolicyMaster = new AlgPolicy("SM9_Exchange");
        byte[][] masterKey = this.genKeyPairSM9Master(algPolicyMaster);
        if (!userBExchangeKey.sm9SetMasterPublicKey(masterKey[0], publicKey.getKey())) {
            throw new PkiException("11004015", "SM9\u5bc6\u94a5\u534f\u5546\u5931\u8d25 SGD_SM9 sm9SetMasterPublicKey error");
        }
        CommonJniSM9Data userBSM9Data = userBExchangeKey.sm9ExchangeKeyResponder(sm3, bjcaKeyA.getKey(), ra, SKALen);
        if (userBSM9Data == null) {
            throw new PkiException("11004015", "SM9\u5bc6\u94a5\u534f\u5546\u5931\u8d25 SGD_SM9 sm9ExchangeKeyResponder error");
        }
        result[0] = userBSM9Data.getRB();
        result[1] = userBSM9Data.getSB();
        result[2] = userBSM9Data.getS2();
        result[3] = userBSM9Data.getSKB();
        userBSM9Data.destroy();
        userBExchangeKey.destroy();
        return result;
    }

    @Override
    public byte[][] sm9ExchangeKeyInitiatorComputeKey(BjcaKeyPair bjcaKeyPairA, BjcaKey bjcaKeyB, int SKALen, byte[] rb, byte[] sb, Map map) throws PkiException {
        BjcaKey privateKey = bjcaKeyPairA.getPrivateKey();
        BjcaKey publicKey = bjcaKeyPairA.getPublicKey();
        byte[][] result = new byte[2][];
        if (!("SM9_Exchange_Private".equals(privateKey.getKeyType()) && "SM9_Exchange_Public".equals(publicKey.getKeyType()) && "SM9_Exchange_Public".equals(bjcaKeyB.getKeyType()) && map != null)) {
            throw new PkiException("11004015", "SM9\u5bc6\u94a5\u534f\u5546\u5931\u8d25 \u6a21\u5757\u4e0d\u652f\u6301\u6b64\u79cd\u64cd\u4f5c");
        }
        int sm3 = AlgConstant.convertAlgNameToJniId("SM3");
        CommonJniAsymKey userAExchangeKey = (CommonJniAsymKey)map.get("userAExchangeKey");
        if (userAExchangeKey == null) {
            throw new PkiException("11004015", "SM9\u5bc6\u94a5\u534f\u5546\u5931\u8d25 SGD_SM9 SM9CreateAsymObjectFromPriKey error");
        }
        CommonJniSM9Data userASM9Data = (CommonJniSM9Data)map.get("userASM9Data");
        if (userASM9Data == null) {
            throw new PkiException("11004015", "SM9\u5bc6\u94a5\u534f\u5546\u5931\u8d25 SGD_SM9 sm9ExchangeKeyInitiatorRequest error");
        }
        if (!userASM9Data.sm9ExchangeKeyInitiatorComputeKey(sm3, bjcaKeyB.getKey(), rb, sb)) {
            throw new PkiException("11004015", "SM9\u5bc6\u94a5\u534f\u5546\u5931\u8d25 SGD_SM9 sm9ExchangeKeyInitiatorComputeKey error");
        }
        result[0] = userASM9Data.getSA();
        result[1] = userASM9Data.getSKA();
        userASM9Data.destroy();
        userAExchangeKey.destroy();
        return result;
    }

    @Override
    public byte[][] sm9WrapKey(BjcaKey pubKey, int keylen) throws PkiException {
        if (!"SM9_Encrypt_Public".equals(pubKey.getKeyType())) {
            throw new PkiException("11004013", "SM9\u5bc6\u94a5\u5c01\u88c5\u5931\u8d25 \u6a21\u5757\u4e0d\u652f\u6301\u6b64\u79cd\u64cd\u4f5c");
        }
        byte[][] result = new byte[2][];
        byte[] userIDA = pubKey.getKey();
        int algId = AlgConstant.convertAlgNameToJniId("SM9_Encrypt");
        CommonJniAsymKey userEncryptKey = this.SM9CreateAsymObjectFromAlgorithm(algId);
        if (userEncryptKey == null) {
            throw new PkiException("11004013", "SM9\u5bc6\u94a5\u5c01\u88c5\u5931\u8d25 SGD_SM9 SM9CreateAsymObjectFromAlgorithm error");
        }
        AlgPolicy algPolicyMaster = new AlgPolicy("SM9_Encrypt");
        byte[][] masterKey = this.genKeyPairSM9Master(algPolicyMaster);
        if (!userEncryptKey.sm9SetMasterPublicKey(masterKey[0], userIDA)) {
            throw new PkiException("11004013", "SM9\u5bc6\u94a5\u5c01\u88c5\u5931\u8d25 SGD_SM9 sm9SetMasterPublicKey error");
        }
        int sm3 = AlgConstant.convertAlgNameToJniId("SM3");
        CommonJniSM9Data sm9CipherData = userEncryptKey.sm9WrapKey(sm3, userIDA, keylen);
        if (sm9CipherData == null) {
            throw new PkiException("11004013", "SM9\u5bc6\u94a5\u5c01\u88c5\u5931\u8d25 SGD_SM9 sm9WrapKey error");
        }
        byte[] key = sm9CipherData.getKey();
        byte[] wrapKey = sm9CipherData.getWrapKey();
        result[0] = key;
        result[1] = wrapKey;
        userEncryptKey.destroy();
        return result;
    }

    @Override
    public byte[] sm9UnWrapKey(BjcaKeyPair bjcaKeyPair, int keylen, byte[] wrapKey) throws PkiException {
        BjcaKey privateKey = bjcaKeyPair.getPrivateKey();
        BjcaKey publicKey = bjcaKeyPair.getPublicKey();
        if (!"SM9_Encrypt_Private".equals(privateKey.getKeyType()) || !"SM9_Encrypt_Public".equals(publicKey.getKeyType())) {
            throw new PkiException("11004014", "SM9\u5bc6\u94a5\u89e3\u5c01\u5931\u8d25 \u6a21\u5757\u4e0d\u652f\u6301\u6b64\u79cd\u64cd\u4f5c");
        }
        int algId = AlgConstant.convertAlgNameToJniId("SM9_Encrypt");
        int sm3 = AlgConstant.convertAlgNameToJniId("SM3");
        CommonJniAsymKey userDecryptKey = this.SM9CreateAsymObjectFromPriKey(algId, privateKey.getKey());
        if (userDecryptKey == null) {
            throw new PkiException("11004014", "SM9\u5bc6\u94a5\u89e3\u5c01\u5931\u8d25 SGD_SM9 SM9CreateAsymObjectFromPriKey error");
        }
        AlgPolicy algPolicyMaster = new AlgPolicy("SM9_Encrypt");
        byte[][] masterKey = this.genKeyPairSM9Master(algPolicyMaster);
        if (!userDecryptKey.sm9SetMasterPublicKey(masterKey[0], publicKey.getKey())) {
            throw new PkiException("11004014", "SM9\u5bc6\u94a5\u89e3\u5c01\u5931\u8d25 SGD_SM9 sm9SetMasterPublicKey error");
        }
        byte[] pbKey = userDecryptKey.sm9UnWrapKey(sm3, wrapKey, keylen);
        if (pbKey == null) {
            throw new PkiException("11004014", "SM9\u5bc6\u94a5\u89e3\u5c01\u5931\u8d25 SGD_SM9 sm9UnWrapKey error");
        }
        userDecryptKey.destroy();
        return pbKey;
    }

    @Override
    public byte[] encryptSM9(AlgPolicy algPolicy, BjcaKey key, byte[] dataInput) throws PkiException {
        String policyType = algPolicy.getPolicyType();
        if (!"SM9_BLK".equals(policyType) && !"SM9_XOR".equals(policyType)) {
            throw new PkiException("11004004", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25 \u6a21\u5757\u4e0d\u652f\u6301\u6b64\u79cd\u64cd\u4f5c " + policyType);
        }
        if (!"SM9_Encrypt_Public".equals(key.getKeyType())) {
            throw new PkiException("11004004", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25 \u6a21\u5757\u4e0d\u652f\u6301\u6b64\u79cd\u64cd\u4f5c " + policyType);
        }
        int algId = AlgConstant.convertAlgNameToJniId("SM9_Encrypt");
        int sm3 = AlgConstant.convertAlgNameToJniId("SM3");
        int sm4 = AlgConstant.convertAlgNameToJniId("SM4");
        byte[] pbCipher = null;
        CommonJniAsymKey userEncryptKey = this.SM9CreateAsymObjectFromAlgorithm(algId);
        if (userEncryptKey == null) {
            throw new PkiException("11004004", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25 " + policyType + "SGD_SM9 SM9CreateAsymObjectFromAlgorithm error");
        }
        AlgPolicy algPolicyMaster = new AlgPolicy("SM9_Encrypt");
        byte[][] masterKey = this.genKeyPairSM9Master(algPolicyMaster);
        if (!userEncryptKey.sm9SetMasterPublicKey(masterKey[0], key.getKey())) {
            throw new PkiException("11004004", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25 " + policyType + "SGD_SM9 sm9SetMasterPublicKey error");
        }
        pbCipher = "SM9_BLK".equals(policyType) ? userEncryptKey.sm9EncryptXor(sm3, key.getKey(), dataInput) : userEncryptKey.sm9EncryptBlk(sm3, sm4, key.getKey(), null, dataInput);
        if (pbCipher == null) {
            throw new PkiException("11004004", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25 " + policyType + "SGD_SM9 sm9Encrypt error");
        }
        userEncryptKey.destroy();
        return pbCipher;
    }

    @Override
    public byte[] decryptSM9(AlgPolicy algPolicy, BjcaKeyPair bjcaKeyPair, byte[] encryptedData) throws PkiException {
        String policyType = algPolicy.getPolicyType();
        BjcaKey key = bjcaKeyPair.getPrivateKey();
        BjcaKey publicKey = bjcaKeyPair.getPublicKey();
        if (!"SM9_BLK".equals(policyType) && !"SM9_XOR".equals(policyType)) {
            throw new PkiException("11004005", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25 \u6a21\u5757\u4e0d\u652f\u6301\u6b64\u79cd\u64cd\u4f5c " + policyType);
        }
        if (!"SM9_Encrypt_Private".equals(key.getKeyType()) || !"SM9_Encrypt_Public".equals(publicKey.getKeyType())) {
            throw new PkiException("11004005", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25 \u6a21\u5757\u4e0d\u652f\u6301\u6b64\u79cd\u64cd\u4f5c " + policyType);
        }
        int algId = AlgConstant.convertAlgNameToJniId("SM9_Encrypt");
        int sm3 = AlgConstant.convertAlgNameToJniId("SM3");
        int sm4 = AlgConstant.convertAlgNameToJniId("SM4");
        byte[] pbDecrypt = null;
        CommonJniAsymKey userDecryptKey = this.SM9CreateAsymObjectFromPriKey(algId, key.getKey());
        if (userDecryptKey == null) {
            throw new PkiException("11004005", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25 " + policyType + "SGD_SM9 SM9CreateAsymObjectFromPriKey error");
        }
        AlgPolicy algPolicyMaster = new AlgPolicy("SM9_Encrypt");
        byte[][] masterKey = this.genKeyPairSM9Master(algPolicyMaster);
        if (!userDecryptKey.sm9SetMasterPublicKey(masterKey[0], publicKey.getKey())) {
            throw new PkiException("11004005", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25 " + policyType + "SGD_SM9 sm9SetMasterPublicKey error");
        }
        pbDecrypt = "SM9_BLK".equals(policyType) ? userDecryptKey.sm9DecryptXor(sm3, encryptedData) : userDecryptKey.sm9DecryptBlk(sm3, sm4, encryptedData);
        if (pbDecrypt == null) {
            throw new PkiException("11004005", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25 " + policyType + "SGD_SM9 sm9Decrypt error");
        }
        userDecryptKey.destroy();
        return pbDecrypt;
    }

    @Override
    public byte[] encrypt(AlgPolicy algPolicy, BjcaKey key, byte[] dataInput) throws PkiException {
        String policyType = algPolicy.getPolicyType();
        if (!AlgConstant.checkSymmEncDecAlg(policyType) && !AlgConstant.checkAsymEncDecAlg(policyType)) {
            throw new PkiException("11004004", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25 \u4e0d\u652f\u6301\u7684\u7b97\u6cd5\u7c7b\u578b " + policyType);
        }
        int algId = AlgConstant.convertAlgNameToJniId(policyType);
        byte[] encryptKey = key.getKey();
        int keyId = key.getKeyID();
        byte[] ret = null;
        byte[] iv = null;
        if (this.checkPolicyTypeIv(policyType)) {
            if (algPolicy.getParam() == null) {
                throw new PkiException("11004004", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25 \u7f3a\u5c11\u64cd\u4f5c\u53c2\u6570\u9519\u8bef policyType =" + policyType + " ivParam is null");
            }
            IVParam ivParam = (IVParam)algPolicy.getParam();
            iv = ivParam.getIv();
        }
        if (this.deviceType == SCF_DEVICE_SOFT || this.deviceType != SCF_DEVICE_SOFT && keyId == -1) {
            if (encryptKey == null) {
                throw new PkiException("11004004", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25 \u7f3a\u5c11\u64cd\u4f5c\u53c2\u6570\u9519\u8bef encryptKey is null");
            }
            if (policyType.equals("RSA/ECB/PKCS1PADDING") || policyType.equals("SM2")) {
                encryptKey = policyType.equals("RSA/ECB/PKCS1PADDING") ? KeyPairUtil.convertRsaP8PubKeyToP1(encryptKey) : KeyPairUtil.getDerPublickey(encryptKey);
                CommonJniAsymKey asymKeyFromPubKey = this.createAsymKeyFromPubKey(encryptKey);
                ret = asymKeyFromPubKey.publicKeyEncrypt(dataInput);
                asymKeyFromPubKey.destroy();
            } else {
                int paddingId = AlgConstant.convertAlgNameToJniPaddingId(policyType);
                CommonJniSymKey symKeyFromKey = this.createSymKeyFromKey(algId, paddingId, SCF_SYMM_ENCRYPT, encryptKey, iv);
                ret = symKeyFromKey.symEncrypt(dataInput);
                symKeyFromKey.destroy();
            }
        } else if (policyType.equals("RSA/ECB/PKCS1PADDING") || policyType.equals("SM2")) {
            CommonJniAsymKey asymKeyFromKeyIndex = this.createAsymKeyFromKeyIndex(algId, keyId);
            ret = asymKeyFromKeyIndex.publicKeyEncrypt(dataInput);
            asymKeyFromKeyIndex.destroy();
        } else {
            int paddingId = AlgConstant.convertAlgNameToJniPaddingId(policyType);
            CommonJniSymKey symKeyFromKey = this.createSymKeyFromKeyIndex(algId, paddingId, SCF_SYMM_ENCRYPT, keyId, iv);
            ret = symKeyFromKey.symEncrypt(dataInput);
            symKeyFromKey.destroy();
        }
        if (ret == null) {
            throw new PkiException("11004004", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25 policyType =" + policyType + ", keyId= " + keyId + ", result is null");
        }
        return ret;
    }

    @Override
    public byte[] encrypt(AlgPolicy algPolicy, BjcaKey key, byte[] dataInput, int nonceLen, byte[] assData, int tagLen) throws PkiException {
        String policyType = algPolicy.getPolicyType();
        if (!AlgConstant.checkSymmEncDecAlg(policyType) && !AlgConstant.checkAsymEncDecAlg(policyType)) {
            throw new PkiException("11004004", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25 \u4e0d\u652f\u6301\u7684\u7b97\u6cd5\u7c7b\u578b " + policyType);
        }
        int algId = AlgConstant.convertAlgNameToJniId(policyType);
        byte[] encryptKey = key.getKey();
        int keyId = key.getKeyID();
        byte[] ret = null;
        byte[] iv = null;
        if (this.checkPolicyTypeIv(policyType)) {
            if (algPolicy.getParam() == null) {
                throw new PkiException("11004004", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25 \u7f3a\u5c11\u64cd\u4f5c\u53c2\u6570\u9519\u8bef policyType =" + policyType + " ivParam is null");
            }
            IVParam ivParam = (IVParam)algPolicy.getParam();
            iv = ivParam.getIv();
        }
        if (this.deviceType == SCF_DEVICE_SOFT || this.deviceType != SCF_DEVICE_SOFT && keyId == -1) {
            if (encryptKey == null) {
                throw new PkiException("11004004", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25 \u7f3a\u5c11\u64cd\u4f5c\u53c2\u6570\u9519\u8bef encryptKey is null");
            }
            if (policyType.equals("RSA/ECB/PKCS1PADDING") || policyType.equals("SM2")) {
                encryptKey = policyType.equals("RSA/ECB/PKCS1PADDING") ? KeyPairUtil.convertRsaP8PubKeyToP1(encryptKey) : KeyPairUtil.getDerPublickey(encryptKey);
                CommonJniAsymKey asymKeyFromPubKey = this.createAsymKeyFromPubKey(encryptKey);
                ret = asymKeyFromPubKey.publicKeyEncrypt(dataInput);
                asymKeyFromPubKey.destroy();
            } else {
                int paddingId = AlgConstant.convertAlgNameToJniPaddingId(policyType);
                CommonJniSymKey symKeyFromKey = this.createSymKeyFromKey(algId, paddingId, SCF_SYMM_ENCRYPT, encryptKey, iv);
                if (this.checkSymAlgIsAEAD(algId) && !symKeyFromKey.symSetEncryptAEADParameters(nonceLen, assData, tagLen)) {
                    throw new PkiException("11004004", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25 policyType =" + policyType + ", keyId= " + keyId + ", symSetEncryptAEADParameters error");
                }
                ret = symKeyFromKey.symEncrypt(dataInput);
                byte[] pbTag = null;
                if (this.checkSymAlgIsAEAD(algId)) {
                    pbTag = symKeyFromKey.symGetAEADTag();
                    if (pbTag == null) {
                        throw new PkiException("11004004", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25 policyType =" + policyType + ", keyId= " + keyId + ", symGetAEADTag is null");
                    }
                    ret = ByteArrayUtil.mergeBytes(ret, pbTag);
                }
                symKeyFromKey.destroy();
            }
        } else if (policyType.equals("RSA/ECB/PKCS1PADDING") || policyType.equals("SM2")) {
            CommonJniAsymKey asymKeyFromKeyIndex = this.createAsymKeyFromKeyIndex(algId, keyId);
            ret = asymKeyFromKeyIndex.publicKeyEncrypt(dataInput);
            asymKeyFromKeyIndex.destroy();
        } else {
            int paddingId = AlgConstant.convertAlgNameToJniPaddingId(policyType);
            CommonJniSymKey symKeyFromKey = this.createSymKeyFromKeyIndex(algId, paddingId, SCF_SYMM_ENCRYPT, keyId, iv);
            ret = symKeyFromKey.symEncrypt(dataInput);
            symKeyFromKey.destroy();
        }
        if (ret == null) {
            throw new PkiException("11004004", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25 policyType =" + policyType + ", keyId= " + keyId + ", result is null");
        }
        return ret;
    }

    @Override
    public byte[] decrypt(AlgPolicy algPolicy, BjcaKey key, byte[] encryptedData) throws PkiException {
        String policyType = algPolicy.getPolicyType();
        if (!AlgConstant.checkSymmEncDecAlg(policyType) && !AlgConstant.checkAsymEncDecAlg(policyType)) {
            throw new PkiException("11004005", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25 \u4e0d\u652f\u6301\u7684\u7b97\u6cd5\u7c7b\u578b " + policyType);
        }
        int algId = AlgConstant.convertAlgNameToJniId(policyType);
        byte[] encryptKey = key.getKey();
        int keyId = key.getKeyID();
        byte[] ret = null;
        byte[] iv = null;
        if (this.checkPolicyTypeIv(policyType)) {
            if (algPolicy.getParam() == null) {
                throw new PkiException("11004005", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25 \u7f3a\u5c11\u64cd\u4f5c\u53c2\u6570\u9519\u8bef policyType =" + policyType + " ivParam is null");
            }
            IVParam ivParam = (IVParam)algPolicy.getParam();
            iv = ivParam.getIv();
        }
        if (this.deviceType == SCF_DEVICE_SOFT || this.deviceType != SCF_DEVICE_SOFT && keyId == -1) {
            if (encryptKey == null) {
                throw new PkiException("11004005", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25 encryptKey is null");
            }
            if (policyType.equals("RSA/ECB/PKCS1PADDING") || policyType.equals("SM2")) {
                CommonJniAsymKey asymKeyFromPriKey;
                if (policyType.equals("RSA/ECB/PKCS1PADDING")) {
                    encryptKey = KeyPairUtil.convertRsaP8PriKeyToP1(encryptKey);
                }
                if ((asymKeyFromPriKey = this.createAsymKeyFromPriKey(encryptKey)) == null) {
                    throw new PkiException("11004005", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25 \u521b\u5efa\u52a0\u5bc6\u5bf9\u8c61\u5931\u8d25 asymKeyFromPriKey is null");
                }
                ret = asymKeyFromPriKey.privateKeyDecrypt(encryptedData);
                asymKeyFromPriKey.destroy();
            } else {
                int paddingId = AlgConstant.convertAlgNameToJniPaddingId(policyType);
                CommonJniSymKey symKeyFromKey = this.createSymKeyFromKey(algId, paddingId, SCF_SYMM_DECRYPT, encryptKey, iv);
                if (symKeyFromKey == null) {
                    throw new PkiException("11004005", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25 \u521b\u5efa\u52a0\u5bc6\u5bf9\u8c61\u5931\u8d25 symKeyFromKey is null");
                }
                ret = symKeyFromKey.symDecrypt(encryptedData);
                symKeyFromKey.destroy();
            }
        } else if (policyType.equals("RSA/ECB/PKCS1PADDING") || policyType.equals("SM2")) {
            CommonJniAsymKey asymKeyFromKeyIndex = this.createAsymKeyFromKeyIndex(algId, keyId);
            if (asymKeyFromKeyIndex == null) {
                throw new PkiException("11004005", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25 \u521b\u5efa\u52a0\u5bc6\u5bf9\u8c61\u5931\u8d25 asymKeyFromKeyIndex is null");
            }
            ret = asymKeyFromKeyIndex.privateKeyDecrypt(encryptedData);
            asymKeyFromKeyIndex.destroy();
        } else {
            int paddingId = AlgConstant.convertAlgNameToJniPaddingId(policyType);
            CommonJniSymKey symKeyFromKeyIndex = this.createSymKeyFromKeyIndex(algId, paddingId, SCF_SYMM_DECRYPT, keyId, iv);
            if (symKeyFromKeyIndex == null) {
                throw new PkiException("11004005", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25 \u521b\u5efa\u52a0\u5bc6\u5bf9\u8c61\u5931\u8d25 symKeyFromKeyIndex is null");
            }
            ret = symKeyFromKeyIndex.symDecrypt(encryptedData);
            symKeyFromKeyIndex.destroy();
        }
        if (ret == null) {
            throw new PkiException("11004005", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25 policyType =" + policyType + ", keyId= " + keyId + ", result is null");
        }
        return ret;
    }

    @Override
    public byte[] decrypt(AlgPolicy algPolicy, BjcaKey key, byte[] encryptedData, int nonceLen, byte[] assData, int tagLen) throws PkiException {
        String policyType = algPolicy.getPolicyType();
        if (!AlgConstant.checkSymmEncDecAlg(policyType) && !AlgConstant.checkAsymEncDecAlg(policyType)) {
            throw new PkiException("11004005", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25 \u4e0d\u652f\u6301\u7684\u7b97\u6cd5\u7c7b\u578b " + policyType);
        }
        int algId = AlgConstant.convertAlgNameToJniId(policyType);
        byte[] encryptKey = key.getKey();
        int keyId = key.getKeyID();
        byte[] ret = null;
        byte[] iv = null;
        if (this.checkPolicyTypeIv(policyType)) {
            if (algPolicy.getParam() == null) {
                throw new PkiException("11004005", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25 \u7f3a\u5c11\u64cd\u4f5c\u53c2\u6570\u9519\u8bef policyType =" + policyType + " ivParam is null");
            }
            IVParam ivParam = (IVParam)algPolicy.getParam();
            iv = ivParam.getIv();
        }
        if (this.deviceType == SCF_DEVICE_SOFT || this.deviceType != SCF_DEVICE_SOFT && keyId == -1) {
            if (encryptKey == null) {
                throw new PkiException("11004005", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25 encryptKey is null");
            }
            if (policyType.equals("RSA/ECB/PKCS1PADDING") || policyType.equals("SM2")) {
                CommonJniAsymKey asymKeyFromPriKey;
                if (policyType.equals("RSA/ECB/PKCS1PADDING")) {
                    encryptKey = KeyPairUtil.convertRsaP8PriKeyToP1(encryptKey);
                }
                if ((asymKeyFromPriKey = this.createAsymKeyFromPriKey(encryptKey)) == null) {
                    throw new PkiException("11004005", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25 \u521b\u5efa\u52a0\u5bc6\u5bf9\u8c61\u5931\u8d25 asymKeyFromPriKey is null");
                }
                ret = asymKeyFromPriKey.privateKeyDecrypt(encryptedData);
                asymKeyFromPriKey.destroy();
            } else {
                int paddingId = AlgConstant.convertAlgNameToJniPaddingId(policyType);
                CommonJniSymKey symKeyFromKey = this.createSymKeyFromKey(algId, paddingId, SCF_SYMM_DECRYPT, encryptKey, iv);
                if (symKeyFromKey == null) {
                    throw new PkiException("11004005", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25 \u521b\u5efa\u52a0\u5bc6\u5bf9\u8c61\u5931\u8d25 symKeyFromKey is null");
                }
                if (this.checkSymAlgIsAEAD(algId)) {
                    byte[][] bytes = ByteArrayUtil.splitBytes(encryptedData, tagLen);
                    if (!symKeyFromKey.symSetDecryptAEADParameters(nonceLen, assData, bytes[1])) {
                        throw new PkiException("11004005", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25 policyType =" + policyType + ", keyId= " + keyId + ", symSetDecryptAEADParameters error");
                    }
                    encryptedData = bytes[0];
                }
                ret = symKeyFromKey.symDecrypt(encryptedData);
                symKeyFromKey.destroy();
            }
        } else if (policyType.equals("RSA/ECB/PKCS1PADDING") || policyType.equals("SM2")) {
            CommonJniAsymKey asymKeyFromKeyIndex = this.createAsymKeyFromKeyIndex(algId, keyId);
            if (asymKeyFromKeyIndex == null) {
                throw new PkiException("11004005", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25 \u521b\u5efa\u52a0\u5bc6\u5bf9\u8c61\u5931\u8d25 asymKeyFromKeyIndex is null");
            }
            ret = asymKeyFromKeyIndex.privateKeyDecrypt(encryptedData);
            asymKeyFromKeyIndex.destroy();
        } else {
            int paddingId = AlgConstant.convertAlgNameToJniPaddingId(policyType);
            CommonJniSymKey symKeyFromKeyIndex = this.createSymKeyFromKeyIndex(algId, paddingId, SCF_SYMM_DECRYPT, keyId, iv);
            if (symKeyFromKeyIndex == null) {
                throw new PkiException("11004005", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25 \u521b\u5efa\u52a0\u5bc6\u5bf9\u8c61\u5931\u8d25 symKeyFromKeyIndex is null");
            }
            ret = symKeyFromKeyIndex.symDecrypt(encryptedData);
            symKeyFromKeyIndex.destroy();
        }
        if (ret == null) {
            throw new PkiException("11004005", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25 policyType =" + policyType + ", keyId= " + keyId + ", result is null");
        }
        return ret;
    }

    @Override
    public boolean encrypt(AlgPolicy algPolicy, BjcaKey key, InputStream dataInput, OutputStream outputStream, int bufferSize) throws PkiException {
        String policyType = algPolicy.getPolicyType();
        if (!AlgConstant.checkSymmEncDecAlg(policyType)) {
            throw new PkiException("11004004", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25 \u4e0d\u652f\u6301\u7684\u7b97\u6cd5\u7c7b\u578b " + policyType);
        }
        int algId = AlgConstant.convertAlgNameToJniId(policyType);
        byte[] encryptKey = key.getKey();
        int keyId = key.getKeyID();
        byte[] iv = null;
        if (this.checkPolicyTypeIv(policyType)) {
            if (algPolicy.getParam() == null) {
                throw new PkiException("11004004", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25 \u7f3a\u5c11\u64cd\u4f5c\u53c2\u6570\u9519\u8bef policyType =" + policyType + " ivParam is null");
            }
            IVParam ivParam = (IVParam)algPolicy.getParam();
            iv = ivParam.getIv();
        }
        CommonJniSymKey symKeyFromKey = null;
        int paddingId = AlgConstant.convertAlgNameToJniPaddingId(policyType);
        if (this.deviceType == SCF_DEVICE_SOFT || this.deviceType != SCF_DEVICE_SOFT && keyId == -1) {
            if (encryptKey == null) {
                throw new PkiException("11004004", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25 \u7f3a\u5c11\u64cd\u4f5c\u53c2\u6570\u9519\u8bef encryptKey is null");
            }
            symKeyFromKey = this.createSymKeyFromKey(algId, paddingId, SCF_SYMM_ENCRYPT, encryptKey, iv);
        } else {
            symKeyFromKey = this.createSymKeyFromKeyIndex(algId, paddingId, SCF_SYMM_ENCRYPT, keyId, iv);
        }
        if (symKeyFromKey == null) {
            throw new PkiException("11004004", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25 \u521b\u5efa\u52a0\u5bc6\u5bf9\u8c61\u5931\u8d25 createSymKeyFromKey is null");
        }
        try {
            byte[] tmpData = null;
            byte[] buffer = new byte[bufferSize];
            int i = 0;
            while ((i = dataInput.read(buffer)) > 0) {
                tmpData = symKeyFromKey.symEncryptUpdate(buffer, 0, i);
                outputStream.write(tmpData, 0, tmpData.length);
            }
            tmpData = symKeyFromKey.symEncryptFinal();
            outputStream.write(tmpData, 0, tmpData.length);
            symKeyFromKey.destroy();
        }
        catch (Exception e) {
            throw new PkiException("11004004", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25 ", e);
        }
        return true;
    }

    @Override
    public boolean encrypt(AlgPolicy algPolicy, BjcaKey key, InputStream dataInput, OutputStream outputStream, int bufferSize, int nonceLen, byte[] assData, int tagLen) throws PkiException {
        String policyType = algPolicy.getPolicyType();
        if (!AlgConstant.checkSymmEncDecAlg(policyType)) {
            throw new PkiException("11004004", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25 \u4e0d\u652f\u6301\u7684\u7b97\u6cd5\u7c7b\u578b " + policyType);
        }
        int algId = AlgConstant.convertAlgNameToJniId(policyType);
        byte[] encryptKey = key.getKey();
        int keyId = key.getKeyID();
        byte[] iv = null;
        if (this.checkPolicyTypeIv(policyType)) {
            if (algPolicy.getParam() == null) {
                throw new PkiException("11004004", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25 \u7f3a\u5c11\u64cd\u4f5c\u53c2\u6570\u9519\u8bef policyType =" + policyType + " ivParam is null");
            }
            IVParam ivParam = (IVParam)algPolicy.getParam();
            iv = ivParam.getIv();
        }
        CommonJniSymKey symKeyFromKey = null;
        int paddingId = AlgConstant.convertAlgNameToJniPaddingId(policyType);
        if (this.deviceType == SCF_DEVICE_SOFT || this.deviceType != SCF_DEVICE_SOFT && keyId == -1) {
            if (encryptKey == null) {
                throw new PkiException("11004004", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25 \u7f3a\u5c11\u64cd\u4f5c\u53c2\u6570\u9519\u8bef encryptKey is null");
            }
            symKeyFromKey = this.createSymKeyFromKey(algId, paddingId, SCF_SYMM_ENCRYPT, encryptKey, iv);
        } else {
            symKeyFromKey = this.createSymKeyFromKeyIndex(algId, paddingId, SCF_SYMM_ENCRYPT, keyId, iv);
        }
        if (symKeyFromKey == null) {
            throw new PkiException("11004004", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25 \u521b\u5efa\u52a0\u5bc6\u5bf9\u8c61\u5931\u8d25 createSymKeyFromKey is null");
        }
        if (this.checkSymAlgIsAEAD(algId) && !symKeyFromKey.symSetEncryptAEADParameters(nonceLen, assData, tagLen)) {
            throw new PkiException("11004004", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25 policyType =" + policyType + ", keyId= " + keyId + ", symSetEncryptAEADParameters error");
        }
        try {
            byte[] tmpData = null;
            byte[] buffer = new byte[bufferSize];
            int i = 0;
            ArrayList<byte[]> bytes = new ArrayList<byte[]>();
            while ((i = dataInput.read(buffer)) > 0) {
                tmpData = symKeyFromKey.symEncryptUpdate(buffer, 0, i);
                bytes.add(tmpData);
            }
            tmpData = symKeyFromKey.symEncryptFinal();
            bytes.add(tmpData);
            byte[] pbTag = null;
            if (this.checkSymAlgIsAEAD(algId) && (pbTag = symKeyFromKey.symGetAEADTag()) == null) {
                throw new PkiException("11004004", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25 policyType =" + policyType + ", keyId= " + keyId + ", symGetAEADTag is null");
            }
            for (byte[] b1 : bytes) {
                if (b1 == null) continue;
                outputStream.write(b1, 0, b1.length);
            }
            if (this.checkSymAlgIsAEAD(algId) && pbTag != null) {
                outputStream.write(pbTag, 0, pbTag.length);
            }
            bytes.clear();
            symKeyFromKey.destroy();
        }
        catch (Exception e) {
            throw new PkiException("11004004", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25 ", e);
        }
        return true;
    }

    @Override
    public boolean decrypt(AlgPolicy algPolicy, BjcaKey key, InputStream dataInput, OutputStream outputStream, int bufferSize) throws PkiException {
        String policyType = algPolicy.getPolicyType();
        if (!AlgConstant.checkSymmEncDecAlg(policyType)) {
            throw new PkiException("11004005", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25 \u4e0d\u652f\u6301\u7684\u7b97\u6cd5\u7c7b\u578b " + policyType);
        }
        int algId = AlgConstant.convertAlgNameToJniId(policyType);
        int paddingId = AlgConstant.convertAlgNameToJniPaddingId(policyType);
        byte[] encryptKey = key.getKey();
        int keyId = key.getKeyID();
        byte[] iv = null;
        if (this.checkPolicyTypeIv(policyType)) {
            if (algPolicy.getParam() == null) {
                throw new PkiException("11004005", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25 \u7f3a\u5c11\u64cd\u4f5c\u53c2\u6570\u9519\u8bef policyType =" + policyType + " ivParam is null");
            }
            IVParam ivParam = (IVParam)algPolicy.getParam();
            iv = ivParam.getIv();
        }
        CommonJniSymKey commonJniSymKey = null;
        if (this.deviceType == SCF_DEVICE_SOFT || this.deviceType != SCF_DEVICE_SOFT && keyId == -1) {
            if (encryptKey == null) {
                throw new PkiException("11004005", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25 decryptKey is null");
            }
            commonJniSymKey = this.createSymKeyFromKey(algId, paddingId, SCF_SYMM_DECRYPT, encryptKey, iv);
        } else {
            commonJniSymKey = this.createSymKeyFromKeyIndex(algId, paddingId, SCF_SYMM_DECRYPT, keyId, iv);
        }
        if (commonJniSymKey == null) {
            throw new PkiException("11004005", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25 \u521b\u5efa\u52a0\u5bc6\u5bf9\u8c61\u5931\u8d25 symKeyFromKeyIndex is null");
        }
        try {
            byte[] tmpData = null;
            byte[] buffer = new byte[bufferSize];
            int i = 0;
            while ((i = dataInput.read(buffer)) > 0) {
                tmpData = commonJniSymKey.symDecryptUpdate(buffer, 0, i);
                outputStream.write(tmpData, 0, tmpData.length);
            }
            tmpData = commonJniSymKey.symDecryptFinal();
            outputStream.write(tmpData, 0, tmpData.length);
            commonJniSymKey.destroy();
        }
        catch (Exception e) {
            throw new PkiException("11004005", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25 ", e);
        }
        return true;
    }

    @Override
    public boolean decrypt(AlgPolicy algPolicy, BjcaKey key, InputStream dataInput, OutputStream outputStream, int bufferSize, int nonceLen, byte[] assData, int tagLen) throws PkiException {
        String policyType = algPolicy.getPolicyType();
        if (!AlgConstant.checkSymmEncDecAlg(policyType)) {
            throw new PkiException("11004005", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25 \u4e0d\u652f\u6301\u7684\u7b97\u6cd5\u7c7b\u578b " + policyType);
        }
        int algId = AlgConstant.convertAlgNameToJniId(policyType);
        int paddingId = AlgConstant.convertAlgNameToJniPaddingId(policyType);
        byte[] encryptKey = key.getKey();
        int keyId = key.getKeyID();
        byte[] iv = null;
        if (this.checkPolicyTypeIv(policyType)) {
            if (algPolicy.getParam() == null) {
                throw new PkiException("11004005", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25 \u7f3a\u5c11\u64cd\u4f5c\u53c2\u6570\u9519\u8bef policyType =" + policyType + " ivParam is null");
            }
            IVParam ivParam = (IVParam)algPolicy.getParam();
            iv = ivParam.getIv();
        }
        CommonJniSymKey commonJniSymKey = null;
        if (this.deviceType == SCF_DEVICE_SOFT || this.deviceType != SCF_DEVICE_SOFT && keyId == -1) {
            if (encryptKey == null) {
                throw new PkiException("11004005", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25 decryptKey is null");
            }
            commonJniSymKey = this.createSymKeyFromKey(algId, paddingId, SCF_SYMM_DECRYPT, encryptKey, iv);
        } else {
            commonJniSymKey = this.createSymKeyFromKeyIndex(algId, paddingId, SCF_SYMM_DECRYPT, keyId, iv);
        }
        if (commonJniSymKey == null) {
            throw new PkiException("11004005", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25 \u521b\u5efa\u52a0\u5bc6\u5bf9\u8c61\u5931\u8d25 symKeyFromKeyIndex is null");
        }
        byte[] tmpData = null;
        byte[] buffer = new byte[bufferSize];
        int i = 0;
        ArrayList<byte[]> bytes = new ArrayList<byte[]>();
        try {
            while ((i = dataInput.read(buffer)) > 0) {
                byte[] tmp = new byte[i];
                System.arraycopy(buffer, 0, tmp, 0, i);
                bytes.add(tmp);
            }
        }
        catch (Exception e) {
            throw new PkiException("11004005", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25 ", e);
        }
        if (this.checkSymAlgIsAEAD(algId)) {
            byte[] tag = new byte[tagLen];
            boolean tlen = false;
            try {
                int size = bytes.size() - 1;
                byte[] bytesSize = (byte[])bytes.get(size);
                if (bytesSize.length > tagLen) {
                    byte[][] bytesDataTag = ByteArrayUtil.splitBytes(bytesSize, tagLen);
                    System.arraycopy(bytesDataTag[1], 0, tag, 0, tagLen);
                    bytes.set(size, bytesDataTag[0]);
                } else if (bytesSize.length == tagLen) {
                    System.arraycopy(bytesSize, 0, tag, 0, tagLen);
                    bytes.remove(size);
                } else {
                    byte[] bytes1 = (byte[])bytes.get(size - 1);
                    byte[][] bytesDataTag = ByteArrayUtil.splitBytes(bytes1, tagLen - bytesSize.length);
                    byte[] bytes2 = ByteArrayUtil.mergeBytes(bytesDataTag[1], bytesSize);
                    System.arraycopy(bytes2[1], 0, tag, 0, tagLen);
                    bytes.set(size - 1, bytesDataTag[0]);
                    bytes.remove(size);
                }
            }
            catch (Exception e) {
                throw new PkiException("11004005", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25 ", e);
            }
            if (!commonJniSymKey.symSetDecryptAEADParameters(nonceLen, assData, tag)) {
                throw new PkiException("11004005", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25 policyType =" + policyType + ", keyId= " + keyId + ", symSetDecryptAEADParameters error");
            }
        }
        try {
            for (int j = 0; j < bytes.size(); ++j) {
                byte[] b1 = (byte[])bytes.get(j);
                if (b1 == null) continue;
                tmpData = commonJniSymKey.symDecryptUpdate(b1, 0, b1.length);
                outputStream.write(tmpData, 0, tmpData.length);
            }
            tmpData = commonJniSymKey.symDecryptFinal();
            outputStream.write(tmpData, 0, tmpData.length);
            commonJniSymKey.destroy();
        }
        catch (Exception e) {
            throw new PkiException("11004005", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25 ", e);
        }
        return true;
    }

    @Override
    public byte[] genRandom(int length) throws PkiException {
        byte[] random = this.generateRandom(length);
        if (random == null) {
            throw new PkiException("11003003", "\u4ea7\u751f\u968f\u673a\u6570\u5931\u8d25 length =" + length);
        }
        return random;
    }

    @Override
    public byte[] backupAllKey(byte[] passwd) throws PkiException {
        if (this.deviceType == SCF_DEVICE_SOFT) {
            throw new PkiException("11002020", "\u5907\u4efd\u8bbe\u5907\u5185\u6240\u6709\u5bc6\u94a5\u5931\u8d25 \u6a21\u5757\u4e0d\u652f\u6301\u6b64\u79cd\u64cd\u4f5c");
        }
        byte[] backInfo = this.backupAllKeyFromDevice(passwd);
        if (backInfo == null) {
            throw new PkiException("11003020", "\u5907\u4efd\u8bbe\u5907\u5185\u6240\u6709\u5bc6\u94a5\u5931\u8d25 Base64Passwd= " + Base64.toBase64String(passwd));
        }
        return backInfo;
    }

    @Override
    public boolean restoreAllKey(byte[] backupInfo, byte[] passwd) throws PkiException {
        if (this.deviceType == SCF_DEVICE_SOFT) {
            throw new PkiException("11002021", "\u6062\u590d\u8bbe\u5907\u5185\u6240\u6709\u5bc6\u94a5\u5931\u8d25 \u6a21\u5757\u4e0d\u652f\u6301\u6b64\u79cd\u64cd\u4f5c");
        }
        return this.restoreAllKeyToDevice(backupInfo, passwd);
    }

    @Override
    public byte[] mac(AlgPolicy algPolicy, byte[] key, byte[] msg) throws PkiException {
        String policyType = algPolicy.getPolicyType();
        if (!(policyType.equals("HMac-SHA1") || policyType.equals("HMac-SHA256") || policyType.equals("HMac-SM3"))) {
            throw new PkiException("11004011", "Hmac\u6d88\u606f\u6458\u8981\u5931\u8d25\u4e0d\u652f\u6301\u7684\u7b97\u6cd5\u7c7b\u578b policyType =" + policyType);
        }
        int hmacAlgId = AlgConstant.convertAlgNameToJniId(policyType);
        CommonJniHmac hmac = this.createHmac(hmacAlgId, key);
        if (hmac == null) {
            throw new PkiException("11004011", "Hmac\u6d88\u606f\u6458\u8981\u5931\u8d25CommonJni.createHmac error! policyType =" + policyType);
        }
        byte[] res = null;
        try {
            res = hmac.hmac(msg);
            hmac.destroy();
        }
        catch (Exception e) {
            throw new PkiException("11004011", "Hmac\u6d88\u606f\u6458\u8981\u5931\u8d25 policyType =" + policyType, e);
        }
        if (res == null) {
            throw new PkiException("11004006", "\u6458\u8981\u64cd\u4f5c\u5931\u8d25 policyType =" + policyType);
        }
        return res;
    }

    @Override
    public byte[] mac(AlgPolicy algPolicy, byte[] key, InputStream dataInput, int bufferSize) throws PkiException {
        String policyType = algPolicy.getPolicyType();
        if (!(policyType.equals("HMac-SHA1") || policyType.equals("HMac-SHA256") || policyType.equals("HMac-SM3"))) {
            throw new PkiException("11004011", "Hmac\u6d88\u606f\u6458\u8981\u5931\u8d25\u4e0d\u652f\u6301\u7684\u7b97\u6cd5\u7c7b\u578b,policyType =" + policyType);
        }
        int hmacAlgId = AlgConstant.convertAlgNameToJniId(policyType);
        CommonJniHmac hmac = this.createHmac(hmacAlgId, key);
        if (hmac == null) {
            throw new PkiException("11004011", "Hmac\u6d88\u606f\u6458\u8981\u5931\u8d25CommonJni.createHmac error! policyType =" + policyType);
        }
        byte[] res = null;
        try {
            byte[] buffer = new byte[bufferSize];
            int i = 0;
            while ((i = dataInput.read(buffer)) > 0) {
                hmac.hmacUpdate(buffer, 0, i);
            }
            res = hmac.hmacFinal();
            hmac.destroy();
            dataInput.close();
        }
        catch (Exception e) {
            throw new PkiException("11004011", "Hmac\u6d88\u606f\u6458\u8981\u5931\u8d25 policyType =" + policyType, e);
        }
        if (res == null) {
            throw new PkiException("11004006", "\u6458\u8981\u64cd\u4f5c\u5931\u8d25 policyType =" + policyType);
        }
        return res;
    }

    public static byte[] checkStatusAndGetRet(byte[] result) {
        if (result.length >= 4) {
            int rv = ByteArrayUtil.getFirstIntFromByteArray(result, 0);
            if (rv != 0) {
                return null;
            }
            byte[] ret = new byte[result.length - 4];
            System.arraycopy(result, 4, ret, 0, result.length - 4);
            return ret;
        }
        return null;
    }

    public boolean checkPolicyTypeIv(String policyType) {
        return policyType.contains("CBC") || policyType.contains("EEA3") || policyType.contains("CCM") || policyType.contains("GCM") || policyType.contains("CFB") || policyType.contains("OFB") || policyType.contains("CTR");
    }

    @Override
    public BjcaKeyPair genKeyPairSM9(AlgPolicy algPolicy, byte[] userIDA) throws PkiException {
        byte[][] masterKey = this.genKeyPairSM9Master(algPolicy);
        String policyType = algPolicy.getPolicyType();
        int algId = AlgConstant.convertAlgNameToJniId(policyType);
        byte[] userPriKey = this.SM9GenerateUserKey(algId, masterKey[1], userIDA);
        if (userPriKey == null) {
            throw new PkiException("11002002", "\u4ea7\u751f\u975e\u5bf9\u79f0\u5bc6\u94a5\u5bf9\u5931\u8d25 " + policyType + "SGD_SM9 userPriKey error");
        }
        BjcaKey bjcaPriKey = null;
        BjcaKey bjcaPubKey = null;
        if (policyType.equals("SM9_Sign")) {
            bjcaPubKey = new BjcaKey("SM9_Sign_Public", userIDA);
            bjcaPriKey = new BjcaKey("SM9_Sign_Private", userPriKey);
        } else if (policyType.equals("SM9_Exchange")) {
            bjcaPubKey = new BjcaKey("SM9_Exchange_Public", userIDA);
            bjcaPriKey = new BjcaKey("SM9_Exchange_Private", userPriKey);
        } else {
            bjcaPubKey = new BjcaKey("SM9_Encrypt_Public", userIDA);
            bjcaPriKey = new BjcaKey("SM9_Encrypt_Private", userPriKey);
        }
        return new BjcaKeyPair(bjcaPubKey, bjcaPriKey);
    }

    @Override
    public String fpeEncrypt(AlgPolicy algPolicy, BjcaKey key, String dataInput, FPEType type, byte[] tweak) throws PkiException {
        String policyType = algPolicy.getPolicyType();
        if (!AlgConstant.checkSymmFPEAlg(policyType)) {
            throw new PkiException("11004004", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25 \u4e0d\u652f\u6301\u7684\u7b97\u6cd5\u7c7b\u578b " + policyType);
        }
        int algId = AlgConstant.convertAlgNameToJniId(policyType);
        byte[] encryptKey = key.getKey();
        int keyId = key.getKeyID();
        byte[] iv = null;
        if (this.checkPolicyTypeIv(policyType)) {
            if (algPolicy.getParam() == null) {
                throw new PkiException("11004004", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25 \u7f3a\u5c11\u64cd\u4f5c\u53c2\u6570\u9519\u8bef policyType =" + policyType + " ivParam is null");
            }
            IVParam ivParam = (IVParam)algPolicy.getParam();
            iv = ivParam.getIv();
        }
        if (this.deviceType == SCF_DEVICE_SOFT || keyId == -1) {
            if (encryptKey == null) {
                throw new PkiException("11004004", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25 \u7f3a\u5c11\u64cd\u4f5c\u53c2\u6570\u9519\u8bef encryptKey is null");
            }
            CommonJniSymKey symKeyFromKey = this.createSymKeyFromKey(algId, 0, SCF_SYMM_ENCRYPT, encryptKey, iv);
            String encryptData = symKeyFromKey.FPEDataEncrypt(dataInput, tweak, type.getType());
            symKeyFromKey.destroy();
            if (encryptData == null) {
                throw new PkiException("11004004", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25 " + policyType);
            }
            return encryptData;
        }
        throw new PkiException("11004004", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25 \u6a21\u5757\u4e0d\u652f\u6301\u6b64\u79cd\u64cd\u4f5c " + policyType);
    }

    @Override
    public String fpeDecrypt(AlgPolicy algPolicy, BjcaKey key, String dataInput, FPEType type, byte[] tweak) throws PkiException {
        String policyType = algPolicy.getPolicyType();
        if (!AlgConstant.checkSymmFPEAlg(policyType)) {
            throw new PkiException("11004004", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25 \u4e0d\u652f\u6301\u7684\u7b97\u6cd5\u7c7b\u578b " + policyType);
        }
        int algId = AlgConstant.convertAlgNameToJniId(policyType);
        byte[] encryptKey = key.getKey();
        int keyId = key.getKeyID();
        byte[] iv = null;
        if (this.checkPolicyTypeIv(policyType)) {
            if (algPolicy.getParam() == null) {
                throw new PkiException("11004004", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25 \u7f3a\u5c11\u64cd\u4f5c\u53c2\u6570\u9519\u8bef policyType =" + policyType + " ivParam is null");
            }
            IVParam ivParam = (IVParam)algPolicy.getParam();
            iv = ivParam.getIv();
        }
        if (this.deviceType == SCF_DEVICE_SOFT || keyId == -1) {
            if (encryptKey == null) {
                throw new PkiException("11004004", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25 \u7f3a\u5c11\u64cd\u4f5c\u53c2\u6570\u9519\u8bef encryptKey is null");
            }
            CommonJniSymKey symKeyFromKey = this.createSymKeyFromKey(algId, 0, SCF_SYMM_ENCRYPT, encryptKey, iv);
            String encryptData = symKeyFromKey.FPEDataDecrypt(dataInput, tweak, type.getType());
            symKeyFromKey.destroy();
            if (encryptData == null) {
                throw new PkiException("11004005", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25 " + policyType);
            }
            return encryptData;
        }
        throw new PkiException("11004005", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25 \u6a21\u5757\u4e0d\u652f\u6301\u6b64\u79cd\u64cd\u4f5c " + policyType);
    }

    @Override
    public int[] fpeEncrypt(AlgPolicy algPolicy, BjcaKey key, int[] dataInput, int radix, byte[] tweak) throws PkiException {
        if (radix < 2) {
            throw new PkiException("11004004", "\u64cd\u4f5c\u53c2\u6570\u9519\u8bef " + radix);
        }
        String policyType = algPolicy.getPolicyType();
        if (!AlgConstant.checkSymmFPEAlg(policyType)) {
            throw new PkiException("11004004", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25 \u4e0d\u652f\u6301\u7684\u7b97\u6cd5\u7c7b\u578b " + policyType);
        }
        int algId = AlgConstant.convertAlgNameToJniId(policyType);
        byte[] encryptKey = key.getKey();
        int keyId = key.getKeyID();
        byte[] iv = null;
        if (this.checkPolicyTypeIv(policyType)) {
            if (algPolicy.getParam() == null) {
                throw new PkiException("11004004", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25 \u7f3a\u5c11\u64cd\u4f5c\u53c2\u6570\u9519\u8bef policyType =" + policyType + " ivParam is null");
            }
            IVParam ivParam = (IVParam)algPolicy.getParam();
            iv = ivParam.getIv();
        }
        if (this.deviceType == SCF_DEVICE_SOFT || keyId == -1) {
            if (encryptKey == null) {
                throw new PkiException("11004004", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25 \u7f3a\u5c11\u64cd\u4f5c\u53c2\u6570\u9519\u8bef encryptKey is null");
            }
            CommonJniSymKey symKeyFromKey = this.createSymKeyFromKey(algId, 0, SCF_SYMM_ENCRYPT, encryptKey, iv);
            int[] encryptData = symKeyFromKey.FPERawEncrypt(dataInput, tweak, radix);
            symKeyFromKey.destroy();
            if (encryptData == null) {
                throw new PkiException("11004004", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25 " + policyType);
            }
            return encryptData;
        }
        throw new PkiException("11004004", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25 \u6a21\u5757\u4e0d\u652f\u6301\u6b64\u79cd\u64cd\u4f5c " + policyType);
    }

    @Override
    public int[] fpeDecrypt(AlgPolicy algPolicy, BjcaKey key, int[] dataInput, int radix, byte[] tweak) throws PkiException {
        if (radix < 2) {
            throw new PkiException("11004005", "\u64cd\u4f5c\u53c2\u6570\u9519\u8bef " + radix);
        }
        String policyType = algPolicy.getPolicyType();
        if (!AlgConstant.checkSymmFPEAlg(policyType)) {
            throw new PkiException("11004005", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25 \u4e0d\u652f\u6301\u7684\u7b97\u6cd5\u7c7b\u578b " + policyType);
        }
        int algId = AlgConstant.convertAlgNameToJniId(policyType);
        byte[] encryptKey = key.getKey();
        int keyId = key.getKeyID();
        byte[] iv = null;
        if (this.checkPolicyTypeIv(policyType)) {
            if (algPolicy.getParam() == null) {
                throw new PkiException("11004005", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25 \u7f3a\u5c11\u64cd\u4f5c\u53c2\u6570\u9519\u8bef policyType =" + policyType + " ivParam is null");
            }
            IVParam ivParam = (IVParam)algPolicy.getParam();
            iv = ivParam.getIv();
        }
        if (this.deviceType == SCF_DEVICE_SOFT || keyId == -1) {
            if (encryptKey == null) {
                throw new PkiException("11004005", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25 \u7f3a\u5c11\u64cd\u4f5c\u53c2\u6570\u9519\u8bef encryptKey is null");
            }
            CommonJniSymKey symKeyFromKey = this.createSymKeyFromKey(algId, 0, SCF_SYMM_ENCRYPT, encryptKey, iv);
            int[] encryptData = symKeyFromKey.FPERawDecrypt(dataInput, tweak, radix);
            symKeyFromKey.destroy();
            if (encryptData == null) {
                throw new PkiException("11004005", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25 " + policyType);
            }
            return encryptData;
        }
        throw new PkiException("11004005", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25 \u6a21\u5757\u4e0d\u652f\u6301\u6b64\u79cd\u64cd\u4f5c " + policyType);
    }

    static {
        CommonJni.initializeInstance();
    }
}

