/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.asn1.x9;

import cn.org.bjca.gaia.asn1.ASN1Object;
import cn.org.bjca.gaia.asn1.ASN1OctetString;
import cn.org.bjca.gaia.asn1.ASN1Primitive;
import cn.org.bjca.gaia.asn1.DEROctetString;
import cn.org.bjca.gaia.asn1.x9.X9IntegerConverter;
import cn.org.bjca.gaia.math.ec.ECFieldElement;
import java.math.BigInteger;

public class X9FieldElement
extends ASN1Object {
    protected ECFieldElement f;
    private static X9IntegerConverter converter = new X9IntegerConverter();

    public X9FieldElement(ECFieldElement f) {
        this.f = f;
    }

    public X9FieldElement(BigInteger p, ASN1OctetString s2) {
        this(new ECFieldElement.Fp(p, new BigInteger(1, s2.getOctets())));
    }

    public X9FieldElement(int m3, int k1, int k2, int k3, ASN1OctetString s2) {
        this(new ECFieldElement.F2m(m3, k1, k2, k3, new BigInteger(1, s2.getOctets())));
    }

    public ECFieldElement getValue() {
        return this.f;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        int byteCount = converter.getByteLength(this.f);
        byte[] paddedBigInteger = converter.integerToBytes(this.f.toBigInteger(), byteCount);
        return new DEROctetString(paddedBigInteger);
    }
}

