/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.asn1.crmf;

import cn.org.bjca.gaia.asn1.ASN1EncodableVector;
import cn.org.bjca.gaia.asn1.ASN1Object;
import cn.org.bjca.gaia.asn1.ASN1OctetString;
import cn.org.bjca.gaia.asn1.ASN1Primitive;
import cn.org.bjca.gaia.asn1.ASN1Sequence;
import cn.org.bjca.gaia.asn1.DEROctetString;
import cn.org.bjca.gaia.asn1.DERSequence;
import cn.org.bjca.gaia.asn1.cms.IssuerAndSerialNumber;
import cn.org.bjca.gaia.util.Arrays;

public class DhSigStatic
extends ASN1Object {
    private final IssuerAndSerialNumber issuerAndSerial;
    private final ASN1OctetString hashValue;

    public DhSigStatic(byte[] hashValue) {
        this(null, hashValue);
    }

    public DhSigStatic(IssuerAndSerialNumber issuerAndSerial, byte[] hashValue) {
        this.issuerAndSerial = issuerAndSerial;
        this.hashValue = new DEROctetString(Arrays.clone(hashValue));
    }

    public static DhSigStatic getInstance(Object o) {
        if (o instanceof DhSigStatic) {
            return (DhSigStatic)o;
        }
        if (o != null) {
            return new DhSigStatic(ASN1Sequence.getInstance(o));
        }
        return null;
    }

    private DhSigStatic(ASN1Sequence seq) {
        if (seq.size() == 1) {
            this.issuerAndSerial = null;
            this.hashValue = ASN1OctetString.getInstance(seq.getObjectAt(0));
        } else if (seq.size() == 2) {
            this.issuerAndSerial = IssuerAndSerialNumber.getInstance(seq.getObjectAt(0));
            this.hashValue = ASN1OctetString.getInstance(seq.getObjectAt(1));
        } else {
            throw new IllegalArgumentException("sequence wrong length for DhSigStatic");
        }
    }

    public IssuerAndSerialNumber getIssuerAndSerial() {
        return this.issuerAndSerial;
    }

    public byte[] getHashValue() {
        return Arrays.clone(this.hashValue.getOctets());
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        if (this.issuerAndSerial != null) {
            v.add(this.issuerAndSerial);
        }
        v.add(this.hashValue);
        return new DERSequence(v);
    }
}

