/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.asn1.cmc;

import cn.org.bjca.gaia.asn1.ASN1Encodable;
import cn.org.bjca.gaia.asn1.ASN1Object;
import cn.org.bjca.gaia.asn1.ASN1Primitive;
import cn.org.bjca.gaia.asn1.ASN1Sequence;
import cn.org.bjca.gaia.asn1.DERSequence;
import cn.org.bjca.gaia.asn1.cmc.OtherMsg;
import cn.org.bjca.gaia.asn1.cmc.TaggedAttribute;
import cn.org.bjca.gaia.asn1.cmc.TaggedContentInfo;
import cn.org.bjca.gaia.asn1.cmc.TaggedRequest;

public class PKIData
extends ASN1Object {
    private final TaggedAttribute[] controlSequence;
    private final TaggedRequest[] reqSequence;
    private final TaggedContentInfo[] cmsSequence;
    private final OtherMsg[] otherMsgSequence;

    public PKIData(TaggedAttribute[] controlSequence, TaggedRequest[] reqSequence, TaggedContentInfo[] cmsSequence, OtherMsg[] otherMsgSequence) {
        this.controlSequence = this.copy(controlSequence);
        this.reqSequence = this.copy(reqSequence);
        this.cmsSequence = this.copy(cmsSequence);
        this.otherMsgSequence = this.copy(otherMsgSequence);
    }

    private PKIData(ASN1Sequence seq) {
        int t;
        if (seq.size() != 4) {
            throw new IllegalArgumentException("Sequence not 4 elements.");
        }
        ASN1Sequence s2 = (ASN1Sequence)seq.getObjectAt(0);
        this.controlSequence = new TaggedAttribute[s2.size()];
        for (t = 0; t < this.controlSequence.length; ++t) {
            this.controlSequence[t] = TaggedAttribute.getInstance(s2.getObjectAt(t));
        }
        s2 = (ASN1Sequence)seq.getObjectAt(1);
        this.reqSequence = new TaggedRequest[s2.size()];
        for (t = 0; t < this.reqSequence.length; ++t) {
            this.reqSequence[t] = TaggedRequest.getInstance(s2.getObjectAt(t));
        }
        s2 = (ASN1Sequence)seq.getObjectAt(2);
        this.cmsSequence = new TaggedContentInfo[s2.size()];
        for (t = 0; t < this.cmsSequence.length; ++t) {
            this.cmsSequence[t] = TaggedContentInfo.getInstance(s2.getObjectAt(t));
        }
        s2 = (ASN1Sequence)seq.getObjectAt(3);
        this.otherMsgSequence = new OtherMsg[s2.size()];
        for (t = 0; t < this.otherMsgSequence.length; ++t) {
            this.otherMsgSequence[t] = OtherMsg.getInstance(s2.getObjectAt(t));
        }
    }

    public static PKIData getInstance(Object src) {
        if (src instanceof PKIData) {
            return (PKIData)src;
        }
        if (src != null) {
            return new PKIData(ASN1Sequence.getInstance(src));
        }
        return null;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return new DERSequence(new ASN1Encodable[]{new DERSequence(this.controlSequence), new DERSequence(this.reqSequence), new DERSequence(this.cmsSequence), new DERSequence(this.otherMsgSequence)});
    }

    public TaggedAttribute[] getControlSequence() {
        return this.copy(this.controlSequence);
    }

    private TaggedAttribute[] copy(TaggedAttribute[] taggedAtts) {
        TaggedAttribute[] tmp = new TaggedAttribute[taggedAtts.length];
        System.arraycopy(taggedAtts, 0, tmp, 0, tmp.length);
        return tmp;
    }

    public TaggedRequest[] getReqSequence() {
        return this.copy(this.reqSequence);
    }

    private TaggedRequest[] copy(TaggedRequest[] taggedReqs) {
        TaggedRequest[] tmp = new TaggedRequest[taggedReqs.length];
        System.arraycopy(taggedReqs, 0, tmp, 0, tmp.length);
        return tmp;
    }

    public TaggedContentInfo[] getCmsSequence() {
        return this.copy(this.cmsSequence);
    }

    private TaggedContentInfo[] copy(TaggedContentInfo[] taggedConts) {
        TaggedContentInfo[] tmp = new TaggedContentInfo[taggedConts.length];
        System.arraycopy(taggedConts, 0, tmp, 0, tmp.length);
        return tmp;
    }

    public OtherMsg[] getOtherMsgSequence() {
        return this.copy(this.otherMsgSequence);
    }

    private OtherMsg[] copy(OtherMsg[] otherMsgs) {
        OtherMsg[] tmp = new OtherMsg[otherMsgs.length];
        System.arraycopy(otherMsgs, 0, tmp, 0, tmp.length);
        return tmp;
    }
}

