/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.asn1;

import cn.org.bjca.gaia.asn1.ASN1OctetString;
import cn.org.bjca.gaia.asn1.ASN1OutputStream;
import cn.org.bjca.gaia.asn1.ASN1Primitive;
import cn.org.bjca.gaia.asn1.ASN1String;
import cn.org.bjca.gaia.asn1.ASN1TaggedObject;
import cn.org.bjca.gaia.asn1.StreamUtil;
import cn.org.bjca.gaia.util.Arrays;
import cn.org.bjca.gaia.util.Strings;
import java.io.IOException;

public class DERGeneralString
extends ASN1Primitive
implements ASN1String {
    private final byte[] string;

    public static DERGeneralString getInstance(Object obj) {
        if (obj == null || obj instanceof DERGeneralString) {
            return (DERGeneralString)obj;
        }
        if (obj instanceof byte[]) {
            try {
                return (DERGeneralString)DERGeneralString.fromByteArray((byte[])obj);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("encoding error in getInstance: " + e.toString());
            }
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static DERGeneralString getInstance(ASN1TaggedObject obj, boolean explicit) {
        ASN1Primitive o = obj.getObject();
        if (explicit || o instanceof DERGeneralString) {
            return DERGeneralString.getInstance(o);
        }
        return new DERGeneralString(((ASN1OctetString)o).getOctets());
    }

    DERGeneralString(byte[] string) {
        this.string = string;
    }

    public DERGeneralString(String string) {
        this.string = Strings.toByteArray(string);
    }

    @Override
    public String getString() {
        return Strings.fromByteArray(this.string);
    }

    public String toString() {
        return this.getString();
    }

    public byte[] getOctets() {
        return Arrays.clone(this.string);
    }

    @Override
    boolean isConstructed() {
        return false;
    }

    @Override
    int encodedLength() {
        return 1 + StreamUtil.calculateBodyLength(this.string.length) + this.string.length;
    }

    @Override
    void encode(ASN1OutputStream out) throws IOException {
        out.writeEncoded(27, this.string);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.string);
    }

    @Override
    boolean asn1Equals(ASN1Primitive o) {
        if (!(o instanceof DERGeneralString)) {
            return false;
        }
        DERGeneralString s2 = (DERGeneralString)o;
        return Arrays.areEqual(this.string, s2.string);
    }
}

