/*
 * Decompiled with CFR 0.152.
 */
package api.tools;

import api.tools.PdfVoucherType;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.text.PDFTextStripper;

public class PdfXbrlUtil {
    public static PdfVoucherType extractVoucherTypeFromPDF(String pdfFile) {
        String text = PdfXbrlUtil.pdf2Text(pdfFile);
        System.out.println(text);
        PdfVoucherType pt = PdfXbrlUtil.voucherType(text);
        System.out.println((Object)pt);
        return pt;
    }

    public static String pdf2Text(String pdfFile) {
        try {
            PDDocument doc = PDDocument.load(new File(pdfFile));
            PDFTextStripper textStripper = new PDFTextStripper();
            textStripper.setSortByPosition(true);
            String allText = textStripper.getText(doc);
            allText = allText.replaceAll(" ", "").replaceAll("\u3000", "").replaceAll("\uff08", "(").replaceAll("\uff09", ")").replaceAll("\uffe5", "\u00a5").replaceAll("\uff1a", ":").replaceAll("\u00a0", "");
            allText = allText.replaceAll("\uff1a", ":");
            return allText;
        }
        catch (Exception ex) {
            throw new RuntimeException("\u8bfb\u53d6pdf\u6587\u4ef6\u51fa\u9519:" + ex.getMessage());
        }
    }

    public static PdfVoucherType voucherType(String pdfText) {
        System.out.println("===========\u63d0\u53d6\u53d1\u7968\u6807\u9898 \u68c0\u6d4b\u8d22\u653f\u7968\u636e================");
        String czpjRegex = "\\S*\u7968\u636e.*\u7535\u5b50";
        Pattern czpjPattern = Pattern.compile(czpjRegex);
        Matcher czpjMatcher = czpjPattern.matcher(pdfText);
        if (czpjMatcher.find()) {
            return PdfVoucherType.CZ_EI;
        }
        System.out.println("===========\u63d0\u53d6\u53d1\u7968\u6807\u9898 \u68c0\u6d4b\u975e\u7a0e\u6536\u5165\u4e00\u822c\u7f34\u6b3e\u4e66================");
        String rr3 = "\\S*\u975e\u7a0e\u6536\u5165\u4e00\u822c\u7f34\u6b3e\u4e66";
        Pattern p3 = Pattern.compile(rr3);
        Matcher m3 = p3.matcher(pdfText);
        if (m3.find()) {
            return PdfVoucherType.NO_TAX_INCOME;
        }
        System.out.println("===========\u63d0\u53d6\u53d1\u7968\u53f7\u7801\u7b49================");
        String reg = "\u7535\u5b50\u53d1\u7968(?<dzfp>\\S*)|\u53d1\u7968\u53f7\u7801:(?<fphm20>\\d{20})|\u673a\u5668\u7f16\u53f7:(?<jqbh>\\d{12})|\u53d1\u7968\u4ee3\u7801:(?<fpdm>\\d{12})|\u53d1\u7968\u53f7\u7801:(?<fphm>\\d{8})|\u5f00\u7968\u65e5\u671f:(?<kprq>\\d{4}\u5e74\\d{2}\u6708\\d{2}\u65e5)|\u6821\u9a8c\u7801:(?<jym>\\d{20})";
        Pattern pattern = Pattern.compile(reg);
        Matcher matcher = pattern.matcher(pdfText);
        while (matcher.find()) {
            String groupText = matcher.group(0);
            System.out.println(groupText);
            if (matcher.group("dzfp") != null) {
                System.out.println("===========\u7535\u5b50\u53d1\u7968================");
                String fphm20 = "\u53d1\u7968\u53f7\u7801:\\d{20}";
                Pattern fphm20Pattern = Pattern.compile(fphm20);
                Matcher fphm20Matcher = fphm20Pattern.matcher(groupText);
                if (!fphm20Matcher.find()) continue;
                System.out.println("===========\u7535\u5b50\u53d1\u7968 \u53d1\u7968\u53f7\u780120\u4f4d\u7684\u662f\u6570\u7535\u7968================");
                return PdfVoucherType.DIGITAL_INVOICE;
            }
            if (matcher.group("jqbh") != null) {
                System.out.println("===========\u673a\u5668\u7f16\u53f7================");
                continue;
            }
            if (matcher.group("fpdm") != null) {
                System.out.println("===========\u53d1\u7968\u4ee3\u7801================");
                continue;
            }
            if (matcher.group("fphm") != null) {
                System.out.println("===========\u53d1\u7968\u53f7\u78018\u4f4d\u7684\u662f\u589e\u503c\u7a0e\u7535\u5b50\u666e\u901a\u53d1\u7968================");
                continue;
            }
            if (matcher.group("fphm20") != null) {
                System.out.println("===========\u53d1\u7968\u53f7\u780120\u4f4d\u7684\u662f\u6570\u7535\u7968================");
                return PdfVoucherType.DIGITAL_INVOICE;
            }
            if (matcher.group("kprq") != null) {
                System.out.println("===========\u5f00\u7968\u65e5\u671f================");
                continue;
            }
            if (matcher.group("jym") == null) continue;
            System.out.println("===========\u6821\u9a8c\u7801================");
        }
        return PdfVoucherType.NOT_SUPPORT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String writeToTempFile(byte[] xmlBytes) throws IOException {
        String outFilePath = System.getProperty("java.io.tmpdir") + File.separator + PdfXbrlUtil.czpjTmpFileName();
        System.out.println("\u8d22\u653f\u7535\u5b50\u7968\u636e\u4e34\u65f6\u6587\u4ef6\u540d:" + outFilePath);
        File file = new File(outFilePath);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            fos.write(xmlBytes);
        }
        catch (IOException e) {
            System.out.println("\u8d22\u653f\u7535\u5b50\u7968\u636e\u4e34\u65f6\u6587\u4ef6\u4fdd\u5b58\u5931\u8d25" + e);
        }
        finally {
            if (null != fos) {
                fos.close();
            }
        }
        return outFilePath;
    }

    private static String czpjTmpFileName() {
        LocalDateTime localDateTime = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
        String formattedDateTime = localDateTime.format(formatter);
        UUID uuid = UUID.randomUUID();
        String uuidString = uuid.toString().replace("-", "");
        return String.format("czei_%s_%s.xml", formattedDateTime, uuidString);
    }
}

