/*
 * Decompiled with CFR 0.152.
 */
package api.tools;

import api.VoucherFileInfo;
import com.pansoft.xbrl.xbrljson.util.CleanPathUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentNameDictionary;
import org.apache.pdfbox.pdmodel.PDEmbeddedFilesNameTreeNode;
import org.apache.pdfbox.pdmodel.common.PDNameTreeNode;
import org.apache.pdfbox.pdmodel.common.filespecification.PDComplexFileSpecification;
import org.apache.pdfbox.pdmodel.common.filespecification.PDEmbeddedFile;

public class PDFTool {
    private static Logger log = Logger.getLogger(PDFTool.class.toString());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VoucherFileInfo extractXBRLFileFromPDF(String pdfPath, String xbrlFileName, String outputFile) {
        PDDocument document = null;
        try {
            document = PDDocument.load(new File(pdfPath));
            PDDocumentNameDictionary namesDictionary = new PDDocumentNameDictionary(document.getDocumentCatalog());
            PDEmbeddedFilesNameTreeNode efTree = namesDictionary.getEmbeddedFiles();
            if (efTree != null) {
                Map<String, PDComplexFileSpecification> names = efTree.getNames();
                if (names != null) {
                    VoucherFileInfo voucherFileInfo = PDFTool.extractFiles(names, xbrlFileName, outputFile);
                    return voucherFileInfo;
                }
                List kids = efTree.getKids();
                Iterator iterator = kids.iterator();
                if (iterator.hasNext()) {
                    PDNameTreeNode node = iterator.next();
                    names = node.getNames();
                    VoucherFileInfo voucherFileInfo = PDFTool.extractFiles(names, xbrlFileName, outputFile);
                    return voucherFileInfo;
                }
            }
        }
        catch (IOException e) {
            log.info("Exception while trying to read pdf document - " + e);
        }
        finally {
            try {
                document.close();
            }
            catch (IOException e) {
                log.info(e.toString());
            }
        }
        return null;
    }

    private static VoucherFileInfo extractFiles(Map<String, PDComplexFileSpecification> names, String attachName, String outputFile) throws IOException {
        for (Map.Entry<String, PDComplexFileSpecification> entry : names.entrySet()) {
            PDComplexFileSpecification fileSpec = entry.getValue();
            String filename = fileSpec.getFile();
            if (!attachName.equals(filename)) continue;
            PDEmbeddedFile embeddedFile = PDFTool.getEmbeddedFile(fileSpec);
            return PDFTool.extractFile(filename, embeddedFile, outputFile);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static VoucherFileInfo extractFile(String attachFilename, PDEmbeddedFile embeddedFile, String outputFile) throws IOException {
        VoucherFileInfo voucherFileInfo = new VoucherFileInfo();
        voucherFileInfo.setVoucherType("ntrev_gpm_issuer");
        String outFilePath = outputFile;
        if (outFilePath == null || "".equals(outFilePath)) {
            outFilePath = System.getProperty("java.io.tmpdir") + File.separator + attachFilename;
        }
        outFilePath = CleanPathUtil.cleanString(outFilePath);
        File file = new File(outFilePath);
        log.info("Writing " + outFilePath);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            fos.write(embeddedFile.toByteArray());
        }
        catch (IOException e) {
            log.info("Exception while trying to read pdf document - " + e);
        }
        finally {
            if (null != fos) {
                fos.close();
            }
        }
        voucherFileInfo.setXbrlFilePath(outFilePath);
        return voucherFileInfo;
    }

    private static PDEmbeddedFile getEmbeddedFile(PDComplexFileSpecification fileSpec) {
        PDEmbeddedFile embeddedFile = null;
        if (fileSpec != null) {
            embeddedFile = fileSpec.getEmbeddedFileUnicode();
            if (embeddedFile == null) {
                embeddedFile = fileSpec.getEmbeddedFileDos();
            }
            if (embeddedFile == null) {
                embeddedFile = fileSpec.getEmbeddedFileMac();
            }
            if (embeddedFile == null) {
                embeddedFile = fileSpec.getEmbeddedFileUnix();
            }
            if (embeddedFile == null) {
                embeddedFile = fileSpec.getEmbeddedFile();
            }
        }
        return embeddedFile;
    }
}

