/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec.custom.sec;

import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECFieldElement;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.custom.sec.SecP256R1Field;
import org.bouncycastle.math.ec.custom.sec.SecP256R1FieldElement;
import org.bouncycastle.math.raw.Nat;
import org.bouncycastle.math.raw.Nat256;

public class SecP256R1Point
extends ECPoint.AbstractFp {
    SecP256R1Point(ECCurve eCCurve, ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        super(eCCurve, eCFieldElement, eCFieldElement2);
    }

    SecP256R1Point(ECCurve eCCurve, ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray) {
        super(eCCurve, eCFieldElement, eCFieldElement2, eCFieldElementArray);
    }

    protected ECPoint detach() {
        return new SecP256R1Point(null, this.getAffineXCoord(), this.getAffineYCoord());
    }

    public ECPoint add(ECPoint eCPoint) {
        int[] nArray;
        int[] nArray2;
        int[] nArray3;
        int[] nArray4;
        if (this.isInfinity()) {
            return eCPoint;
        }
        if (eCPoint.isInfinity()) {
            return this;
        }
        if (this == eCPoint) {
            return this.twice();
        }
        ECCurve eCCurve = this.getCurve();
        SecP256R1FieldElement secP256R1FieldElement = (SecP256R1FieldElement)this.x;
        SecP256R1FieldElement secP256R1FieldElement2 = (SecP256R1FieldElement)this.y;
        SecP256R1FieldElement secP256R1FieldElement3 = (SecP256R1FieldElement)eCPoint.getXCoord();
        SecP256R1FieldElement secP256R1FieldElement4 = (SecP256R1FieldElement)eCPoint.getYCoord();
        SecP256R1FieldElement secP256R1FieldElement5 = (SecP256R1FieldElement)this.zs[0];
        SecP256R1FieldElement secP256R1FieldElement6 = (SecP256R1FieldElement)eCPoint.getZCoord(0);
        int[] nArray5 = Nat256.createExt();
        int[] nArray6 = Nat256.create();
        int[] nArray7 = Nat256.create();
        int[] nArray8 = Nat256.create();
        boolean bl = secP256R1FieldElement5.isOne();
        if (bl) {
            nArray4 = secP256R1FieldElement3.x;
            nArray3 = secP256R1FieldElement4.x;
        } else {
            nArray3 = nArray7;
            SecP256R1Field.square((int[])secP256R1FieldElement5.x, (int[])nArray3);
            nArray4 = nArray6;
            SecP256R1Field.multiply((int[])nArray3, (int[])secP256R1FieldElement3.x, (int[])nArray4);
            SecP256R1Field.multiply((int[])nArray3, (int[])secP256R1FieldElement5.x, (int[])nArray3);
            SecP256R1Field.multiply((int[])nArray3, (int[])secP256R1FieldElement4.x, (int[])nArray3);
        }
        boolean bl2 = secP256R1FieldElement6.isOne();
        if (bl2) {
            nArray2 = secP256R1FieldElement.x;
            nArray = secP256R1FieldElement2.x;
        } else {
            nArray = nArray8;
            SecP256R1Field.square((int[])secP256R1FieldElement6.x, (int[])nArray);
            nArray2 = nArray5;
            SecP256R1Field.multiply((int[])nArray, (int[])secP256R1FieldElement.x, (int[])nArray2);
            SecP256R1Field.multiply((int[])nArray, (int[])secP256R1FieldElement6.x, (int[])nArray);
            SecP256R1Field.multiply((int[])nArray, (int[])secP256R1FieldElement2.x, (int[])nArray);
        }
        int[] nArray9 = Nat256.create();
        SecP256R1Field.subtract((int[])nArray2, (int[])nArray4, (int[])nArray9);
        int[] nArray10 = nArray6;
        SecP256R1Field.subtract((int[])nArray, (int[])nArray3, (int[])nArray10);
        if (Nat256.isZero((int[])nArray9)) {
            if (Nat256.isZero((int[])nArray10)) {
                return this.twice();
            }
            return eCCurve.getInfinity();
        }
        int[] nArray11 = nArray7;
        SecP256R1Field.square((int[])nArray9, (int[])nArray11);
        int[] nArray12 = Nat256.create();
        SecP256R1Field.multiply((int[])nArray11, (int[])nArray9, (int[])nArray12);
        int[] nArray13 = nArray7;
        SecP256R1Field.multiply((int[])nArray11, (int[])nArray2, (int[])nArray13);
        SecP256R1Field.negate((int[])nArray12, (int[])nArray12);
        Nat256.mul((int[])nArray, (int[])nArray12, (int[])nArray5);
        int n = Nat256.addBothTo((int[])nArray13, (int[])nArray13, (int[])nArray12);
        SecP256R1Field.reduce32((int)n, (int[])nArray12);
        SecP256R1FieldElement secP256R1FieldElement7 = new SecP256R1FieldElement(nArray8);
        SecP256R1Field.square((int[])nArray10, (int[])secP256R1FieldElement7.x);
        SecP256R1Field.subtract((int[])secP256R1FieldElement7.x, (int[])nArray12, (int[])secP256R1FieldElement7.x);
        SecP256R1FieldElement secP256R1FieldElement8 = new SecP256R1FieldElement(nArray12);
        SecP256R1Field.subtract((int[])nArray13, (int[])secP256R1FieldElement7.x, (int[])secP256R1FieldElement8.x);
        SecP256R1Field.multiplyAddToExt((int[])secP256R1FieldElement8.x, (int[])nArray10, (int[])nArray5);
        SecP256R1Field.reduce((int[])nArray5, (int[])secP256R1FieldElement8.x);
        SecP256R1FieldElement secP256R1FieldElement9 = new SecP256R1FieldElement(nArray9);
        if (!bl) {
            SecP256R1Field.multiply((int[])secP256R1FieldElement9.x, (int[])secP256R1FieldElement5.x, (int[])secP256R1FieldElement9.x);
        }
        if (!bl2) {
            SecP256R1Field.multiply((int[])secP256R1FieldElement9.x, (int[])secP256R1FieldElement6.x, (int[])secP256R1FieldElement9.x);
        }
        ECFieldElement[] eCFieldElementArray = new ECFieldElement[]{secP256R1FieldElement9};
        return new SecP256R1Point(eCCurve, (ECFieldElement)secP256R1FieldElement7, (ECFieldElement)secP256R1FieldElement8, eCFieldElementArray);
    }

    public ECPoint twice() {
        if (this.isInfinity()) {
            return this;
        }
        ECCurve eCCurve = this.getCurve();
        SecP256R1FieldElement secP256R1FieldElement = (SecP256R1FieldElement)this.y;
        if (secP256R1FieldElement.isZero()) {
            return eCCurve.getInfinity();
        }
        SecP256R1FieldElement secP256R1FieldElement2 = (SecP256R1FieldElement)this.x;
        SecP256R1FieldElement secP256R1FieldElement3 = (SecP256R1FieldElement)this.zs[0];
        int[] nArray = Nat256.create();
        int[] nArray2 = Nat256.create();
        int[] nArray3 = Nat256.create();
        SecP256R1Field.square((int[])secP256R1FieldElement.x, (int[])nArray3);
        int[] nArray4 = Nat256.create();
        SecP256R1Field.square((int[])nArray3, (int[])nArray4);
        boolean bl = secP256R1FieldElement3.isOne();
        int[] nArray5 = secP256R1FieldElement3.x;
        if (!bl) {
            nArray5 = nArray2;
            SecP256R1Field.square((int[])secP256R1FieldElement3.x, (int[])nArray5);
        }
        SecP256R1Field.subtract((int[])secP256R1FieldElement2.x, (int[])nArray5, (int[])nArray);
        int[] nArray6 = nArray2;
        SecP256R1Field.add((int[])secP256R1FieldElement2.x, (int[])nArray5, (int[])nArray6);
        SecP256R1Field.multiply((int[])nArray6, (int[])nArray, (int[])nArray6);
        int n = Nat256.addBothTo((int[])nArray6, (int[])nArray6, (int[])nArray6);
        SecP256R1Field.reduce32((int)n, (int[])nArray6);
        int[] nArray7 = nArray3;
        SecP256R1Field.multiply((int[])nArray3, (int[])secP256R1FieldElement2.x, (int[])nArray7);
        n = Nat.shiftUpBits((int)8, (int[])nArray7, (int)2, (int)0);
        SecP256R1Field.reduce32((int)n, (int[])nArray7);
        n = Nat.shiftUpBits((int)8, (int[])nArray4, (int)3, (int)0, (int[])nArray);
        SecP256R1Field.reduce32((int)n, (int[])nArray);
        SecP256R1FieldElement secP256R1FieldElement4 = new SecP256R1FieldElement(nArray4);
        SecP256R1Field.square((int[])nArray6, (int[])secP256R1FieldElement4.x);
        SecP256R1Field.subtract((int[])secP256R1FieldElement4.x, (int[])nArray7, (int[])secP256R1FieldElement4.x);
        SecP256R1Field.subtract((int[])secP256R1FieldElement4.x, (int[])nArray7, (int[])secP256R1FieldElement4.x);
        SecP256R1FieldElement secP256R1FieldElement5 = new SecP256R1FieldElement(nArray7);
        SecP256R1Field.subtract((int[])nArray7, (int[])secP256R1FieldElement4.x, (int[])secP256R1FieldElement5.x);
        SecP256R1Field.multiply((int[])secP256R1FieldElement5.x, (int[])nArray6, (int[])secP256R1FieldElement5.x);
        SecP256R1Field.subtract((int[])secP256R1FieldElement5.x, (int[])nArray, (int[])secP256R1FieldElement5.x);
        SecP256R1FieldElement secP256R1FieldElement6 = new SecP256R1FieldElement(nArray6);
        SecP256R1Field.twice((int[])secP256R1FieldElement.x, (int[])secP256R1FieldElement6.x);
        if (!bl) {
            SecP256R1Field.multiply((int[])secP256R1FieldElement6.x, (int[])secP256R1FieldElement3.x, (int[])secP256R1FieldElement6.x);
        }
        return new SecP256R1Point(eCCurve, (ECFieldElement)secP256R1FieldElement4, (ECFieldElement)secP256R1FieldElement5, new ECFieldElement[]{secP256R1FieldElement6});
    }

    public ECPoint twicePlus(ECPoint eCPoint) {
        if (this == eCPoint) {
            return this.threeTimes();
        }
        if (this.isInfinity()) {
            return eCPoint;
        }
        if (eCPoint.isInfinity()) {
            return this.twice();
        }
        ECFieldElement eCFieldElement = this.y;
        if (eCFieldElement.isZero()) {
            return eCPoint;
        }
        return this.twice().add(eCPoint);
    }

    public ECPoint threeTimes() {
        if (this.isInfinity() || this.y.isZero()) {
            return this;
        }
        return this.twice().add((ECPoint)this);
    }

    public ECPoint negate() {
        if (this.isInfinity()) {
            return this;
        }
        return new SecP256R1Point(this.curve, this.x, this.y.negate(), this.zs);
    }
}

