/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec.custom.gm;

import java.math.BigInteger;
import org.bouncycastle.math.ec.ECFieldElement;
import org.bouncycastle.math.ec.custom.gm.SM2P256V1Field;
import org.bouncycastle.math.raw.Nat256;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;

public class SM2P256V1FieldElement
extends ECFieldElement.AbstractFp {
    public static final BigInteger Q = new BigInteger(1, Hex.decodeStrict((String)"FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFF"));
    protected int[] x;

    public SM2P256V1FieldElement(BigInteger bigInteger) {
        if (bigInteger == null || bigInteger.signum() < 0 || bigInteger.compareTo(Q) >= 0) {
            throw new IllegalArgumentException("x value invalid for SM2P256V1FieldElement");
        }
        this.x = SM2P256V1Field.fromBigInteger((BigInteger)bigInteger);
    }

    public SM2P256V1FieldElement() {
        this.x = Nat256.create();
    }

    protected SM2P256V1FieldElement(int[] nArray) {
        this.x = nArray;
    }

    public boolean isZero() {
        return Nat256.isZero((int[])this.x);
    }

    public boolean isOne() {
        return Nat256.isOne((int[])this.x);
    }

    public boolean testBitZero() {
        return Nat256.getBit((int[])this.x, (int)0) == 1;
    }

    public BigInteger toBigInteger() {
        return Nat256.toBigInteger((int[])this.x);
    }

    public String getFieldName() {
        return "SM2P256V1Field";
    }

    public int getFieldSize() {
        return Q.bitLength();
    }

    public ECFieldElement add(ECFieldElement eCFieldElement) {
        int[] nArray = Nat256.create();
        SM2P256V1Field.add((int[])this.x, (int[])((SM2P256V1FieldElement)eCFieldElement).x, (int[])nArray);
        return new SM2P256V1FieldElement(nArray);
    }

    public ECFieldElement addOne() {
        int[] nArray = Nat256.create();
        SM2P256V1Field.addOne((int[])this.x, (int[])nArray);
        return new SM2P256V1FieldElement(nArray);
    }

    public ECFieldElement subtract(ECFieldElement eCFieldElement) {
        int[] nArray = Nat256.create();
        SM2P256V1Field.subtract((int[])this.x, (int[])((SM2P256V1FieldElement)eCFieldElement).x, (int[])nArray);
        return new SM2P256V1FieldElement(nArray);
    }

    public ECFieldElement multiply(ECFieldElement eCFieldElement) {
        int[] nArray = Nat256.create();
        SM2P256V1Field.multiply((int[])this.x, (int[])((SM2P256V1FieldElement)eCFieldElement).x, (int[])nArray);
        return new SM2P256V1FieldElement(nArray);
    }

    public ECFieldElement divide(ECFieldElement eCFieldElement) {
        int[] nArray = Nat256.create();
        SM2P256V1Field.inv((int[])((SM2P256V1FieldElement)eCFieldElement).x, (int[])nArray);
        SM2P256V1Field.multiply((int[])nArray, (int[])this.x, (int[])nArray);
        return new SM2P256V1FieldElement(nArray);
    }

    public ECFieldElement negate() {
        int[] nArray = Nat256.create();
        SM2P256V1Field.negate((int[])this.x, (int[])nArray);
        return new SM2P256V1FieldElement(nArray);
    }

    public ECFieldElement square() {
        int[] nArray = Nat256.create();
        SM2P256V1Field.square((int[])this.x, (int[])nArray);
        return new SM2P256V1FieldElement(nArray);
    }

    public ECFieldElement invert() {
        int[] nArray = Nat256.create();
        SM2P256V1Field.inv((int[])this.x, (int[])nArray);
        return new SM2P256V1FieldElement(nArray);
    }

    public ECFieldElement sqrt() {
        int[] nArray = this.x;
        if (Nat256.isZero((int[])nArray) || Nat256.isOne((int[])nArray)) {
            return this;
        }
        int[] nArray2 = Nat256.create();
        SM2P256V1Field.square((int[])nArray, (int[])nArray2);
        SM2P256V1Field.multiply((int[])nArray2, (int[])nArray, (int[])nArray2);
        int[] nArray3 = Nat256.create();
        SM2P256V1Field.squareN((int[])nArray2, (int)2, (int[])nArray3);
        SM2P256V1Field.multiply((int[])nArray3, (int[])nArray2, (int[])nArray3);
        int[] nArray4 = Nat256.create();
        SM2P256V1Field.squareN((int[])nArray3, (int)2, (int[])nArray4);
        SM2P256V1Field.multiply((int[])nArray4, (int[])nArray2, (int[])nArray4);
        int[] nArray5 = nArray2;
        SM2P256V1Field.squareN((int[])nArray4, (int)6, (int[])nArray5);
        SM2P256V1Field.multiply((int[])nArray5, (int[])nArray4, (int[])nArray5);
        int[] nArray6 = Nat256.create();
        SM2P256V1Field.squareN((int[])nArray5, (int)12, (int[])nArray6);
        SM2P256V1Field.multiply((int[])nArray6, (int[])nArray5, (int[])nArray6);
        int[] nArray7 = nArray5;
        SM2P256V1Field.squareN((int[])nArray6, (int)6, (int[])nArray7);
        SM2P256V1Field.multiply((int[])nArray7, (int[])nArray4, (int[])nArray7);
        int[] nArray8 = nArray4;
        SM2P256V1Field.square((int[])nArray7, (int[])nArray8);
        SM2P256V1Field.multiply((int[])nArray8, (int[])nArray, (int[])nArray8);
        int[] nArray9 = nArray6;
        SM2P256V1Field.squareN((int[])nArray8, (int)31, (int[])nArray9);
        int[] nArray10 = nArray7;
        SM2P256V1Field.multiply((int[])nArray9, (int[])nArray8, (int[])nArray10);
        SM2P256V1Field.squareN((int[])nArray9, (int)32, (int[])nArray9);
        SM2P256V1Field.multiply((int[])nArray9, (int[])nArray10, (int[])nArray9);
        SM2P256V1Field.squareN((int[])nArray9, (int)62, (int[])nArray9);
        SM2P256V1Field.multiply((int[])nArray9, (int[])nArray10, (int[])nArray9);
        SM2P256V1Field.squareN((int[])nArray9, (int)4, (int[])nArray9);
        SM2P256V1Field.multiply((int[])nArray9, (int[])nArray3, (int[])nArray9);
        SM2P256V1Field.squareN((int[])nArray9, (int)32, (int[])nArray9);
        SM2P256V1Field.multiply((int[])nArray9, (int[])nArray, (int[])nArray9);
        SM2P256V1Field.squareN((int[])nArray9, (int)62, (int[])nArray9);
        int[] nArray11 = nArray3;
        SM2P256V1Field.square((int[])nArray9, (int[])nArray11);
        return Nat256.eq((int[])nArray, (int[])nArray11) ? new SM2P256V1FieldElement(nArray9) : null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SM2P256V1FieldElement)) {
            return false;
        }
        SM2P256V1FieldElement sM2P256V1FieldElement = (SM2P256V1FieldElement)object;
        return Nat256.eq((int[])this.x, (int[])sM2P256V1FieldElement.x);
    }

    public int hashCode() {
        return Q.hashCode() ^ Arrays.hashCode((int[])this.x, (int)0, (int)8);
    }
}

