/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec;

import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Hashtable;
import java.util.Random;
import org.bouncycastle.math.ec.ECAlgorithms;
import org.bouncycastle.math.ec.ECConstants;
import org.bouncycastle.math.ec.ECFieldElement;
import org.bouncycastle.math.ec.ECLookupTable;
import org.bouncycastle.math.ec.ECMultiplier;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.GLVMultiplier;
import org.bouncycastle.math.ec.PreCompCallback;
import org.bouncycastle.math.ec.PreCompInfo;
import org.bouncycastle.math.ec.Tnaf;
import org.bouncycastle.math.ec.WNafL2RMultiplier;
import org.bouncycastle.math.ec.WTauNafMultiplier;
import org.bouncycastle.math.ec.endo.ECEndomorphism;
import org.bouncycastle.math.ec.endo.GLVEndomorphism;
import org.bouncycastle.math.field.FiniteField;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.Integers;

public abstract class ECCurve {
    public static final int COORD_AFFINE = 0;
    public static final int COORD_HOMOGENEOUS = 1;
    public static final int COORD_JACOBIAN = 2;
    public static final int COORD_JACOBIAN_CHUDNOVSKY = 3;
    public static final int COORD_JACOBIAN_MODIFIED = 4;
    public static final int COORD_LAMBDA_AFFINE = 5;
    public static final int COORD_LAMBDA_PROJECTIVE = 6;
    public static final int COORD_SKEWED = 7;
    protected FiniteField field;
    protected ECFieldElement a;
    protected ECFieldElement b;
    protected BigInteger order;
    protected BigInteger cofactor;
    protected int coord = 0;
    protected ECEndomorphism endomorphism = null;
    protected ECMultiplier multiplier = null;

    public static int[] getAllCoordinateSystems() {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7};
    }

    protected ECCurve(FiniteField finiteField) {
        this.field = finiteField;
    }

    public abstract int getFieldSize();

    public abstract ECFieldElement fromBigInteger(BigInteger var1);

    public abstract boolean isValidFieldElement(BigInteger var1);

    public abstract ECFieldElement randomFieldElement(SecureRandom var1);

    public abstract ECFieldElement randomFieldElementMult(SecureRandom var1);

    public synchronized Config configure() {
        return new Config(this, this.coord, this.endomorphism, this.multiplier);
    }

    public ECPoint validatePoint(BigInteger bigInteger, BigInteger bigInteger2) {
        ECPoint eCPoint = this.createPoint(bigInteger, bigInteger2);
        if (!eCPoint.isValid()) {
            throw new IllegalArgumentException("Invalid point coordinates");
        }
        return eCPoint;
    }

    public ECPoint createPoint(BigInteger bigInteger, BigInteger bigInteger2) {
        return this.createRawPoint(this.fromBigInteger(bigInteger), this.fromBigInteger(bigInteger2));
    }

    protected abstract ECCurve cloneCurve();

    protected abstract ECPoint createRawPoint(ECFieldElement var1, ECFieldElement var2);

    protected abstract ECPoint createRawPoint(ECFieldElement var1, ECFieldElement var2, ECFieldElement[] var3);

    protected ECMultiplier createDefaultMultiplier() {
        if (this.endomorphism instanceof GLVEndomorphism) {
            return new GLVMultiplier(this, (GLVEndomorphism)this.endomorphism);
        }
        return new WNafL2RMultiplier();
    }

    public boolean supportsCoordinateSystem(int n) {
        return n == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreCompInfo getPreCompInfo(ECPoint eCPoint, String string) {
        Hashtable hashtable;
        this.checkPoint(eCPoint);
        Object object = eCPoint;
        synchronized (object) {
            hashtable = eCPoint.preCompTable;
        }
        if (null == hashtable) {
            return null;
        }
        object = hashtable;
        synchronized (object) {
            return (PreCompInfo)hashtable.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreCompInfo precompute(ECPoint eCPoint, String string, PreCompCallback preCompCallback) {
        Hashtable<String, PreCompInfo> hashtable;
        this.checkPoint(eCPoint);
        Object object = eCPoint;
        synchronized (object) {
            hashtable = eCPoint.preCompTable;
            if (null == hashtable) {
                eCPoint.preCompTable = hashtable = new Hashtable<String, PreCompInfo>(4);
            }
        }
        object = hashtable;
        synchronized (object) {
            PreCompInfo preCompInfo = (PreCompInfo)hashtable.get(string);
            PreCompInfo preCompInfo2 = preCompCallback.precompute(preCompInfo);
            if (preCompInfo2 != preCompInfo) {
                hashtable.put(string, preCompInfo2);
            }
            return preCompInfo2;
        }
    }

    public ECPoint importPoint(ECPoint eCPoint) {
        if (this == eCPoint.getCurve()) {
            return eCPoint;
        }
        if (eCPoint.isInfinity()) {
            return this.getInfinity();
        }
        eCPoint = eCPoint.normalize();
        return this.createPoint(eCPoint.getXCoord().toBigInteger(), eCPoint.getYCoord().toBigInteger());
    }

    public void normalizeAll(ECPoint[] eCPointArray) {
        this.normalizeAll(eCPointArray, 0, eCPointArray.length, null);
    }

    public void normalizeAll(ECPoint[] eCPointArray, int n, int n2, ECFieldElement eCFieldElement) {
        int n3;
        this.checkPoints(eCPointArray, n, n2);
        switch (this.getCoordinateSystem()) {
            case 0: 
            case 5: {
                if (eCFieldElement != null) {
                    throw new IllegalArgumentException("'iso' not valid for affine coordinates");
                }
                return;
            }
        }
        ECFieldElement[] eCFieldElementArray = new ECFieldElement[n2];
        int[] nArray = new int[n2];
        int n4 = 0;
        for (n3 = 0; n3 < n2; ++n3) {
            ECPoint eCPoint = eCPointArray[n + n3];
            if (null == eCPoint || eCFieldElement == null && eCPoint.isNormalized()) continue;
            eCFieldElementArray[n4] = eCPoint.getZCoord(0);
            nArray[n4++] = n + n3;
        }
        if (n4 == 0) {
            return;
        }
        ECAlgorithms.montgomeryTrick((ECFieldElement[])eCFieldElementArray, (int)0, (int)n4, (ECFieldElement)eCFieldElement);
        for (n3 = 0; n3 < n4; ++n3) {
            int n5 = nArray[n3];
            eCPointArray[n5] = eCPointArray[n5].normalize(eCFieldElementArray[n3]);
        }
    }

    public abstract ECPoint getInfinity();

    public FiniteField getField() {
        return this.field;
    }

    public ECFieldElement getA() {
        return this.a;
    }

    public ECFieldElement getB() {
        return this.b;
    }

    public BigInteger getOrder() {
        return this.order;
    }

    public BigInteger getCofactor() {
        return this.cofactor;
    }

    public int getCoordinateSystem() {
        return this.coord;
    }

    protected abstract ECPoint decompressPoint(int var1, BigInteger var2);

    public ECEndomorphism getEndomorphism() {
        return this.endomorphism;
    }

    public ECMultiplier getMultiplier() {
        if (this.multiplier == null) {
            this.multiplier = this.createDefaultMultiplier();
        }
        return this.multiplier;
    }

    public ECPoint decodePoint(byte[] byArray) {
        ECPoint eCPoint = null;
        int n = (this.getFieldSize() + 7) / 8;
        byte by = byArray[0];
        switch (by) {
            case 0: {
                if (byArray.length != 1) {
                    throw new IllegalArgumentException("Incorrect length for infinity encoding");
                }
                eCPoint = this.getInfinity();
                break;
            }
            case 2: 
            case 3: {
                if (byArray.length != n + 1) {
                    throw new IllegalArgumentException("Incorrect length for compressed encoding");
                }
                int n2 = by & 1;
                BigInteger bigInteger = BigIntegers.fromUnsignedByteArray(byArray, 1, n);
                eCPoint = this.decompressPoint(n2, bigInteger);
                if (eCPoint.implIsValid(true, true)) break;
                throw new IllegalArgumentException("Invalid point");
            }
            case 4: {
                if (byArray.length != 2 * n + 1) {
                    throw new IllegalArgumentException("Incorrect length for uncompressed encoding");
                }
                BigInteger bigInteger = BigIntegers.fromUnsignedByteArray(byArray, 1, n);
                BigInteger bigInteger2 = BigIntegers.fromUnsignedByteArray(byArray, 1 + n, n);
                eCPoint = this.validatePoint(bigInteger, bigInteger2);
                break;
            }
            case 6: 
            case 7: {
                if (byArray.length != 2 * n + 1) {
                    throw new IllegalArgumentException("Incorrect length for hybrid encoding");
                }
                BigInteger bigInteger = BigIntegers.fromUnsignedByteArray(byArray, 1, n);
                BigInteger bigInteger3 = BigIntegers.fromUnsignedByteArray(byArray, 1 + n, n);
                if (bigInteger3.testBit(0) != (by == 7)) {
                    throw new IllegalArgumentException("Inconsistent Y coordinate in hybrid encoding");
                }
                eCPoint = this.validatePoint(bigInteger, bigInteger3);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid point encoding 0x" + Integer.toString(by, 16));
            }
        }
        if (by != 0 && eCPoint.isInfinity()) {
            throw new IllegalArgumentException("Invalid infinity encoding");
        }
        return eCPoint;
    }

    public ECLookupTable createCacheSafeLookupTable(ECPoint[] eCPointArray, int n, int n2) {
        int n3 = this.getFieldSize() + 7 >>> 3;
        byte[] byArray = new byte[n2 * n3 * 2];
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            ECPoint eCPoint = eCPointArray[n + i];
            byte[] byArray2 = eCPoint.getRawXCoord().toBigInteger().toByteArray();
            byte[] byArray3 = eCPoint.getRawYCoord().toBigInteger().toByteArray();
            int n5 = byArray2.length > n3 ? 1 : 0;
            int n6 = byArray2.length - n5;
            int n7 = byArray3.length > n3 ? 1 : 0;
            int n8 = byArray3.length - n7;
            System.arraycopy(byArray2, n5, byArray, n4 + n3 - n6, n6);
            System.arraycopy(byArray3, n7, byArray, (n4 += n3) + n3 - n8, n8);
            n4 += n3;
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    protected void checkPoint(ECPoint eCPoint) {
        if (null == eCPoint || this != eCPoint.getCurve()) {
            throw new IllegalArgumentException("'point' must be non-null and on this curve");
        }
    }

    protected void checkPoints(ECPoint[] eCPointArray) {
        this.checkPoints(eCPointArray, 0, eCPointArray.length);
    }

    protected void checkPoints(ECPoint[] eCPointArray, int n, int n2) {
        if (eCPointArray == null) {
            throw new IllegalArgumentException("'points' cannot be null");
        }
        if (n < 0 || n2 < 0 || n > eCPointArray.length - n2) {
            throw new IllegalArgumentException("invalid range specified for 'points'");
        }
        for (int i = 0; i < n2; ++i) {
            ECPoint eCPoint = eCPointArray[n + i];
            if (null == eCPoint || this == eCPoint.getCurve()) continue;
            throw new IllegalArgumentException("'points' entries must be null or on this curve");
        }
    }

    public boolean equals(ECCurve eCCurve) {
        return this == eCCurve || null != eCCurve && this.getField().equals(eCCurve.getField()) && this.getA().toBigInteger().equals(eCCurve.getA().toBigInteger()) && this.getB().toBigInteger().equals(eCCurve.getB().toBigInteger());
    }

    public boolean equals(Object object) {
        return this == object || object instanceof ECCurve && this.equals((ECCurve)object);
    }

    public int hashCode() {
        return this.getField().hashCode() ^ Integers.rotateLeft((int)this.getA().toBigInteger().hashCode(), (int)8) ^ Integers.rotateLeft((int)this.getB().toBigInteger().hashCode(), (int)16);
    }

    public static class F2m
    extends ECCurve {
        private static final int F2M_DEFAULT_COORDS = 0;
        private int m;
        private int k1;
        private int k2;
        private int k3;
        private BigInteger n;
        private BigInteger h;
        private ECPoint.F2m infinity;
        private byte mu = 0;
        private BigInteger[] si = null;

        public F2m(int n, int n2, BigInteger bigInteger, BigInteger bigInteger2) {
            this(n, n2, 0, 0, bigInteger, bigInteger2, null, null);
        }

        public F2m(int n, int n2, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
            this(n, n2, 0, 0, bigInteger, bigInteger2, bigInteger3, bigInteger4);
        }

        public F2m(int n, int n2, int n3, int n4, BigInteger bigInteger, BigInteger bigInteger2) {
            this(n, n2, n3, n4, bigInteger, bigInteger2, null, null);
        }

        public F2m(int n, int n2, int n3, int n4, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
            this.m = n;
            this.k1 = n2;
            this.k2 = n3;
            this.k3 = n4;
            this.n = bigInteger3;
            this.h = bigInteger4;
            if (n2 == 0) {
                throw new IllegalArgumentException("k1 must be > 0");
            }
            if (n3 == 0) {
                if (n4 != 0) {
                    throw new IllegalArgumentException("k3 must be 0 if k2 == 0");
                }
            } else {
                if (n3 <= n2) {
                    throw new IllegalArgumentException("k2 must be > k1");
                }
                if (n4 <= n3) {
                    throw new IllegalArgumentException("k3 must be > k2");
                }
            }
            this.infinity = new ECPoint.F2m(this, null, null);
            this.a = this.fromBigInteger(bigInteger);
            this.b = this.fromBigInteger(bigInteger2);
            this.coord = 0;
        }

        protected F2m(int n, int n2, int n3, int n4, ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, BigInteger bigInteger, BigInteger bigInteger2) {
            this.m = n;
            this.k1 = n2;
            this.k2 = n3;
            this.k3 = n4;
            this.n = bigInteger;
            this.h = bigInteger2;
            this.infinity = new ECPoint.F2m(this, null, null);
            this.a = eCFieldElement;
            this.b = eCFieldElement2;
            this.coord = 0;
        }

        protected ECCurve cloneCurve() {
            return new F2m(this.m, this.k1, this.k2, this.k3, this.a, this.b, this.n, this.h);
        }

        public boolean supportsCoordinateSystem(int n) {
            switch (n) {
                case 0: 
                case 1: 
                case 6: {
                    return true;
                }
            }
            return false;
        }

        protected ECMultiplier createDefaultMultiplier() {
            if (this.isKoblitz()) {
                return new WTauNafMultiplier();
            }
            return super.createDefaultMultiplier();
        }

        public int getFieldSize() {
            return this.m;
        }

        public ECFieldElement fromBigInteger(BigInteger bigInteger) {
            return new ECFieldElement.F2m(this.m, this.k1, this.k2, this.k3, bigInteger);
        }

        public ECPoint createPoint(BigInteger bigInteger, BigInteger bigInteger2, boolean bl) {
            ECFieldElement eCFieldElement = this.fromBigInteger(bigInteger);
            ECFieldElement eCFieldElement2 = this.fromBigInteger(bigInteger2);
            switch (this.getCoordinateSystem()) {
                case 5: 
                case 6: {
                    if (eCFieldElement.isZero()) break;
                    eCFieldElement2 = eCFieldElement2.divide(eCFieldElement).add(eCFieldElement);
                    break;
                }
            }
            return this.createRawPoint(eCFieldElement, eCFieldElement2, bl);
        }

        protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, boolean bl) {
            return new ECPoint.F2m((ECCurve)this, eCFieldElement, eCFieldElement2, bl);
        }

        public ECPoint getInfinity() {
            return this.infinity;
        }

        public boolean isKoblitz() {
            return this.n != null && this.h != null && this.a.bitLength() <= 1 && this.b.bitLength() == 1;
        }

        synchronized byte getMu() {
            if (this.mu == 0) {
                this.mu = Tnaf.getMu(this);
            }
            return this.mu;
        }

        synchronized BigInteger[] getSi() {
            if (this.si == null) {
                this.si = Tnaf.getSi(this);
            }
            return this.si;
        }

        protected ECPoint decompressPoint(int n, BigInteger bigInteger) {
            ECFieldElement eCFieldElement = this.fromBigInteger(bigInteger);
            ECFieldElement eCFieldElement2 = null;
            if (eCFieldElement.isZero()) {
                eCFieldElement2 = (ECFieldElement.F2m)this.b;
                for (int i = 0; i < this.m - 1; ++i) {
                    eCFieldElement2 = eCFieldElement2.square();
                }
            } else {
                ECFieldElement eCFieldElement3 = eCFieldElement.add(this.a).add(this.b.multiply(eCFieldElement.square().invert()));
                ECFieldElement eCFieldElement4 = this.solveQuadraticEquation(eCFieldElement3);
                if (eCFieldElement4 == null) {
                    throw new IllegalArgumentException("Invalid point compression");
                }
                if (eCFieldElement4.testBitZero() != (n == 1)) {
                    eCFieldElement4 = eCFieldElement4.addOne();
                }
                eCFieldElement2 = eCFieldElement.multiply(eCFieldElement4);
                switch (this.getCoordinateSystem()) {
                    case 5: 
                    case 6: {
                        eCFieldElement2 = eCFieldElement2.divide(eCFieldElement).add(eCFieldElement);
                        break;
                    }
                }
            }
            return new ECPoint.F2m((ECCurve)this, eCFieldElement, eCFieldElement2, true);
        }

        private ECFieldElement solveQuadraticEquation(ECFieldElement eCFieldElement) {
            if (eCFieldElement.isZero()) {
                return eCFieldElement;
            }
            ECFieldElement eCFieldElement2 = this.fromBigInteger(ECConstants.ZERO);
            ECFieldElement eCFieldElement3 = null;
            ECFieldElement eCFieldElement4 = null;
            Random random = new Random();
            do {
                ECFieldElement eCFieldElement5 = this.fromBigInteger(new BigInteger(this.m, random));
                eCFieldElement3 = eCFieldElement2;
                ECFieldElement eCFieldElement6 = eCFieldElement;
                for (int i = 1; i <= this.m - 1; ++i) {
                    ECFieldElement eCFieldElement7 = eCFieldElement6.square();
                    eCFieldElement3 = eCFieldElement3.square().add(eCFieldElement7.multiply(eCFieldElement5));
                    eCFieldElement6 = eCFieldElement7.add(eCFieldElement);
                }
                if (eCFieldElement6.isZero()) continue;
                return null;
            } while ((eCFieldElement4 = eCFieldElement3.square().add(eCFieldElement3)).isZero());
            return eCFieldElement3;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof F2m)) {
                return false;
            }
            F2m f2m = (F2m)object;
            return this.m == f2m.m && this.k1 == f2m.k1 && this.k2 == f2m.k2 && this.k3 == f2m.k3 && this.a.equals(f2m.a) && this.b.equals(f2m.b);
        }

        public int hashCode() {
            return this.a.hashCode() ^ this.b.hashCode() ^ this.m ^ this.k1 ^ this.k2 ^ this.k3;
        }

        public int getM() {
            return this.m;
        }

        public boolean isTrinomial() {
            return this.k2 == 0 && this.k3 == 0;
        }

        public int getK1() {
            return this.k1;
        }

        public int getK2() {
            return this.k2;
        }

        public int getK3() {
            return this.k3;
        }

        public BigInteger getN() {
            return this.n;
        }

        public BigInteger getH() {
            return this.h;
        }
    }

    public static class Fp
    extends ECCurve {
        private static final int FP_DEFAULT_COORDS = 4;
        BigInteger q;
        BigInteger r;
        ECPoint.Fp infinity;

        public Fp(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
            this.q = bigInteger;
            this.r = ECFieldElement.Fp.calculateResidue(bigInteger);
            this.infinity = new ECPoint.Fp(this, null, null);
            this.a = this.fromBigInteger(bigInteger2);
            this.b = this.fromBigInteger(bigInteger3);
            this.coord = 4;
        }

        protected Fp(BigInteger bigInteger, BigInteger bigInteger2, ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
            this.q = bigInteger;
            this.r = bigInteger2;
            this.infinity = new ECPoint.Fp(this, null, null);
            this.a = eCFieldElement;
            this.b = eCFieldElement2;
            this.coord = 4;
        }

        protected ECCurve cloneCurve() {
            return new Fp(this.q, this.r, this.a, this.b);
        }

        public boolean supportsCoordinateSystem(int n) {
            switch (n) {
                case 0: 
                case 1: 
                case 2: 
                case 4: {
                    return true;
                }
            }
            return false;
        }

        public BigInteger getQ() {
            return this.q;
        }

        public int getFieldSize() {
            return this.q.bitLength();
        }

        public ECFieldElement fromBigInteger(BigInteger bigInteger) {
            return new ECFieldElement.Fp(this.q, this.r, bigInteger);
        }

        protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, boolean bl) {
            return new ECPoint.Fp((ECCurve)this, eCFieldElement, eCFieldElement2, bl);
        }

        public ECPoint importPoint(ECPoint eCPoint) {
            if (this != eCPoint.getCurve() && this.getCoordinateSystem() == 2 && !eCPoint.isInfinity()) {
                switch (eCPoint.getCurve().getCoordinateSystem()) {
                    case 2: 
                    case 3: 
                    case 4: {
                        return new ECPoint.Fp(this, this.fromBigInteger(eCPoint.x.toBigInteger()), this.fromBigInteger(eCPoint.y.toBigInteger()), new ECFieldElement[]{this.fromBigInteger(eCPoint.zs[0].toBigInteger())}, eCPoint.withCompression);
                    }
                }
            }
            return super.importPoint(eCPoint);
        }

        protected ECPoint decompressPoint(int n, BigInteger bigInteger) {
            ECFieldElement eCFieldElement = this.fromBigInteger(bigInteger);
            ECFieldElement eCFieldElement2 = eCFieldElement.multiply(eCFieldElement.square().add(this.a)).add(this.b);
            ECFieldElement eCFieldElement3 = eCFieldElement2.sqrt();
            if (eCFieldElement3 == null) {
                throw new RuntimeException("Invalid point compression");
            }
            BigInteger bigInteger2 = eCFieldElement3.toBigInteger();
            if (bigInteger2.testBit(0) != (n == 1)) {
                eCFieldElement3 = this.fromBigInteger(this.q.subtract(bigInteger2));
            }
            return new ECPoint.Fp((ECCurve)this, eCFieldElement, eCFieldElement3, true);
        }

        public ECPoint getInfinity() {
            return this.infinity;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Fp)) {
                return false;
            }
            Fp fp = (Fp)object;
            return this.q.equals(fp.q) && this.a.equals(fp.a) && this.b.equals(fp.b);
        }

        public int hashCode() {
            return this.a.hashCode() ^ this.b.hashCode() ^ this.q.hashCode();
        }
    }

    public class Config {
        protected int coord;
        protected ECMultiplier multiplier;

        Config(int n, ECMultiplier eCMultiplier) {
            this.coord = n;
            this.multiplier = eCMultiplier;
        }

        public Config setCoordinateSystem(int n) {
            this.coord = n;
            return this;
        }

        public Config setMultiplier(ECMultiplier eCMultiplier) {
            this.multiplier = eCMultiplier;
            return this;
        }

        public ECCurve create() {
            if (!ECCurve.this.supportsCoordinateSystem(this.coord)) {
                throw new IllegalStateException("unsupported coordinate system");
            }
            ECCurve eCCurve = ECCurve.this.cloneCurve();
            if (eCCurve == ECCurve.this) {
                throw new IllegalStateException("implementation returned current curve");
            }
            eCCurve.coord = this.coord;
            eCCurve.multiplier = this.multiplier;
            return eCCurve;
        }
    }
}

