/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider.asymmetric.edec;

import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.interfaces.EdECPrivateKey;
import java.security.interfaces.EdECPublicKey;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.Signer;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import org.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import org.bouncycastle.crypto.params.Ed448PrivateKeyParameters;
import org.bouncycastle.crypto.params.Ed448PublicKeyParameters;
import org.bouncycastle.crypto.signers.Ed25519Signer;
import org.bouncycastle.crypto.signers.Ed448Signer;
import org.bouncycastle.jcajce.provider.asymmetric.edec.BCEdDSAPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.edec.BCEdDSAPublicKey;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.BigIntegers;

public class SignatureSpi
extends java.security.SignatureSpi {
    private static final byte[] EMPTY_CONTEXT = new byte[0];
    private final String algorithm;
    private Signer signer;

    SignatureSpi(String string) {
        this.algorithm = string;
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        AsymmetricKeyParameter asymmetricKeyParameter;
        if (publicKey instanceof BCEdDSAPublicKey) {
            asymmetricKeyParameter = ((BCEdDSAPublicKey)publicKey).engineGetKeyParameters();
        } else if (publicKey instanceof EdECPublicKey) {
            EdECPublicKey edECPublicKey = (EdECPublicKey)publicKey;
            byte[] byArray = Arrays.reverse((byte[])BigIntegers.asUnsignedByteArray(edECPublicKey.getPoint().getY()));
            asymmetricKeyParameter = byArray.length == 57 ? new Ed448PublicKeyParameters(byArray, 0) : new Ed25519PublicKeyParameters(byArray, 0);
        } else {
            throw new InvalidKeyException("cannot identify EdDSA public key");
        }
        this.signer = asymmetricKeyParameter instanceof Ed448PublicKeyParameters ? this.getSigner("Ed448") : this.getSigner("Ed25519");
        this.signer.init(false, asymmetricKeyParameter);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        void var2_6;
        if (privateKey instanceof BCEdDSAPrivateKey) {
            AsymmetricKeyParameter asymmetricKeyParameter = ((BCEdDSAPrivateKey)privateKey).engineGetKeyParameters();
        } else {
            if (!(privateKey instanceof EdECPrivateKey)) throw new InvalidKeyException("cannot identify EdDSA private key");
            EdECPrivateKey edECPrivateKey = (EdECPrivateKey)privateKey;
            if (!edECPrivateKey.getBytes().isPresent()) throw new InvalidKeyException("cannot use other provider EdDSA private key");
            byte[] byArray = edECPrivateKey.getBytes().get();
            if (byArray.length == 57) {
                Ed448PrivateKeyParameters ed448PrivateKeyParameters = new Ed448PrivateKeyParameters(byArray, 0);
            } else {
                Ed25519PrivateKeyParameters ed25519PrivateKeyParameters = new Ed25519PrivateKeyParameters(byArray, 0);
            }
        }
        this.signer = var2_6 instanceof Ed448PrivateKeyParameters ? this.getSigner("Ed448") : this.getSigner("Ed25519");
        this.signer.init(true, (CipherParameters)var2_6);
    }

    private Signer getSigner(String string) throws InvalidKeyException {
        if (this.algorithm != null && !string.equals(this.algorithm)) {
            throw new InvalidKeyException("inappropriate key for " + this.algorithm);
        }
        if (string.equals("Ed448")) {
            return new Ed448Signer(EMPTY_CONTEXT);
        }
        return new Ed25519Signer();
    }

    protected void engineUpdate(byte by) throws SignatureException {
        this.signer.update(by);
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
        this.signer.update(byArray, n, n2);
    }

    protected byte[] engineSign() throws SignatureException {
        try {
            return this.signer.generateSignature();
        }
        catch (CryptoException cryptoException) {
            throw new SignatureException(cryptoException.getMessage());
        }
    }

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        return this.signer.verifySignature(byArray);
    }

    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    protected Object engineGetParameter(String string) throws InvalidParameterException {
        throw new UnsupportedOperationException("engineGetParameter unsupported");
    }

    protected AlgorithmParameters engineGetParameters() {
        return null;
    }
}

