/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.transfer.artifact.resolve.internal;

import java.util.List;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.transfer.artifact.ArtifactCoordinate;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolver;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolverException;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResult;
import org.apache.maven.shared.transfer.artifact.resolve.internal.Invoker;
import org.apache.maven.shared.transfer.artifact.resolve.internal.Maven30ArtifactResult;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.resolution.ArtifactDescriptorException;
import org.sonatype.aether.resolution.ArtifactDescriptorRequest;
import org.sonatype.aether.resolution.ArtifactDescriptorResult;
import org.sonatype.aether.resolution.ArtifactRequest;
import org.sonatype.aether.resolution.ArtifactResolutionException;
import org.sonatype.aether.util.artifact.DefaultArtifact;

@Component(role=ArtifactResolver.class, hint="maven3")
class Maven30ArtifactResolver
implements ArtifactResolver {
    @Requirement
    private RepositorySystem repositorySystem;
    @Requirement
    private ArtifactHandlerManager artifactHandlerManager;

    Maven30ArtifactResolver() {
    }

    @Override
    public ArtifactResult resolveArtifact(ProjectBuildingRequest buildingRequest, org.apache.maven.artifact.Artifact mavenArtifact) throws ArtifactResolverException {
        Artifact aetherArtifact = (Artifact)Invoker.invoke(RepositoryUtils.class, "toArtifact", org.apache.maven.artifact.Artifact.class, (Object)mavenArtifact);
        return this.resolveArtifact(buildingRequest, aetherArtifact);
    }

    @Override
    public ArtifactResult resolveArtifact(ProjectBuildingRequest buildingRequest, ArtifactCoordinate coordinate) throws ArtifactResolverException {
        DefaultArtifact aetherArtifact = new DefaultArtifact(coordinate.getGroupId(), coordinate.getArtifactId(), coordinate.getClassifier(), coordinate.getExtension(), coordinate.getVersion());
        return this.resolveArtifact(buildingRequest, aetherArtifact);
    }

    private ArtifactResult resolveArtifact(ProjectBuildingRequest buildingRequest, Artifact aetherArtifact) throws ArtifactResolverException {
        List aetherRepositories = (List)Invoker.invoke(RepositoryUtils.class, "toRepos", List.class, buildingRequest.getRemoteRepositories());
        RepositorySystemSession session = (RepositorySystemSession)Invoker.invoke(buildingRequest, "getRepositorySession");
        try {
            ArtifactDescriptorRequest descriptorRequest = new ArtifactDescriptorRequest(aetherArtifact, aetherRepositories, null);
            ArtifactDescriptorResult descriptorResult = this.repositorySystem.readArtifactDescriptor(session, descriptorRequest);
            ArtifactRequest request = new ArtifactRequest(descriptorResult.getArtifact(), aetherRepositories, null);
            return new Maven30ArtifactResult(this.repositorySystem.resolveArtifact(session, request));
        }
        catch (ArtifactDescriptorException e) {
            throw new ArtifactResolverException(e.getMessage(), e);
        }
        catch (ArtifactResolutionException e) {
            throw new ArtifactResolverException(e.getMessage(), e);
        }
    }
}

