/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.filtering;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Set;
import org.apache.maven.shared.filtering.AbstractFilterReaderLineEnding;
import org.apache.maven.shared.filtering.BoundedReader;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.Interpolator;
import org.codehaus.plexus.interpolation.RecursionInterceptor;
import org.codehaus.plexus.interpolation.SimpleRecursionInterceptor;
import org.codehaus.plexus.interpolation.multi.DelimiterSpecification;

public class MultiDelimiterInterpolatorFilterReaderLineEnding
extends AbstractFilterReaderLineEnding {
    private Interpolator interpolator;
    private RecursionInterceptor recursionInterceptor;
    private String replaceData = null;
    private int replaceIndex = 0;
    public static final String DEFAULT_BEGIN_TOKEN = "${";
    public static final String DEFAULT_END_TOKEN = "}";
    private boolean interpolateWithPrefixPattern = true;
    private String beginToken;
    private String endToken;
    private boolean supportMultiLineFiltering;
    private static final int MAXIMUM_BUFFER_SIZE = 8192;
    private boolean eof = false;

    public MultiDelimiterInterpolatorFilterReaderLineEnding(Reader in, Interpolator interpolator, boolean supportMultiLineFiltering) {
        this(in, interpolator, new SimpleRecursionInterceptor(), supportMultiLineFiltering);
    }

    public MultiDelimiterInterpolatorFilterReaderLineEnding(Reader in, Interpolator interpolator, RecursionInterceptor ri, boolean supportMultiLineFiltering) {
        super(new BufferedReader(in, 8192));
        this.interpolator = interpolator;
        this.interpolator.setCacheAnswers(true);
        this.recursionInterceptor = ri;
        this.delimiters.add(DelimiterSpecification.DEFAULT_SPEC);
        this.supportMultiLineFiltering = supportMultiLineFiltering;
        this.calculateMarkLength();
    }

    public boolean removeDelimiterSpec(String delimiterSpec) {
        return this.delimiters.remove(DelimiterSpecification.parse(delimiterSpec));
    }

    public AbstractFilterReaderLineEnding setDelimiterSpecs(Set<String> specs) {
        this.delimiters.clear();
        for (String spec : specs) {
            this.delimiters.add(DelimiterSpecification.parse(spec));
            this.markLength += spec.length() * 2;
        }
        return this;
    }

    @Override
    public long skip(long n) throws IOException, IllegalArgumentException {
        if (n < 0L) {
            throw new IllegalArgumentException("skip value is negative");
        }
        for (long i = 0L; i < n; ++i) {
            if (this.read() != -1) continue;
            return i;
        }
        return n;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        for (int i = 0; i < len; ++i) {
            int ch = this.read();
            if (ch == -1) {
                if (i == 0) {
                    return -1;
                }
                return i;
            }
            cbuf[off + i] = (char)ch;
        }
        return len;
    }

    @Override
    public int read() throws IOException {
        int endTokenSize;
        if (this.replaceIndex > 0) {
            return this.replaceData.charAt(this.replaceData.length() - this.replaceIndex--);
        }
        if (this.eof) {
            return -1;
        }
        BoundedReader in = new BoundedReader(this.in, this.markLength);
        int ch = in.read();
        if (ch == -1 || ch == 10 && !this.supportMultiLineFiltering) {
            return ch;
        }
        boolean inEscape = this.useEscape && ch == this.getEscapeString().charAt(0);
        StringBuilder key = new StringBuilder();
        if (inEscape) {
            for (int i = 0; i < this.getEscapeString().length(); ++i) {
                key.append((char)ch);
                if (ch != this.getEscapeString().charAt(i) || ch == -1 || ch == 10 && !this.supportMultiLineFiltering) {
                    in.reset();
                    inEscape = false;
                    key.setLength(0);
                    break;
                }
                ch = in.read();
            }
        }
        int max = 0;
        for (DelimiterSpecification spec : this.delimiters) {
            String begin = spec.getBegin();
            if (begin.length() < max) continue;
            for (int i = 0; i < begin.length() && ch == begin.charAt(i) && ch != -1 && (ch != 10 || this.supportMultiLineFiltering); ++i) {
                if (i == begin.length() - 1) {
                    this.beginToken = spec.getBegin();
                    this.endToken = spec.getEnd();
                }
                ch = in.read();
            }
            in.reset();
            in.skip(key.length());
            ch = in.read();
        }
        if (inEscape) {
            if (this.beginToken != null && !this.isPreserveEscapeString()) {
                key.setLength(0);
            }
            this.beginToken = null;
            this.endToken = null;
            key.append((char)ch);
            this.replaceData = key.toString();
            this.replaceIndex = key.length();
            return this.read();
        }
        if (this.beginToken == null || this.beginToken.length() == 0 || this.endToken == null || this.endToken.length() == 0) {
            in.reset();
            return in.read();
        }
        key.append(this.beginToken);
        in.reset();
        in.skip(this.beginToken.length());
        ch = in.read();
        int end = endTokenSize = this.endToken.length();
        while (ch != -1) {
            if (ch == 10 && !this.supportMultiLineFiltering) {
                key.append((char)ch);
                break;
            }
            key.append((char)ch);
            if (ch == this.endToken.charAt(endTokenSize - end)) {
                if (--end == 0) {
                    break;
                }
            } else {
                end = endTokenSize;
            }
            ch = in.read();
        }
        this.beginToken = null;
        this.endToken = null;
        String value = null;
        if (end == 0) {
            try {
                if (this.interpolateWithPrefixPattern) {
                    value = this.interpolator.interpolate(key.toString(), "", this.recursionInterceptor);
                }
                value = this.interpolator.interpolate(key.toString(), this.recursionInterceptor);
            }
            catch (InterpolationException e) {
                IllegalArgumentException error = new IllegalArgumentException(e.getMessage());
                error.initCause(e);
                throw error;
            }
        } else {
            in.reset();
            return in.read();
        }
        if (value != null) {
            this.replaceData = value;
            this.replaceIndex = value.length();
        } else {
            this.replaceData = key.toString();
            this.replaceIndex = key.length();
        }
        if (ch == -1) {
            this.eof = true;
        }
        return this.read();
    }

    public boolean isInterpolateWithPrefixPattern() {
        return this.interpolateWithPrefixPattern;
    }

    public void setInterpolateWithPrefixPattern(boolean interpolateWithPrefixPattern) {
        this.interpolateWithPrefixPattern = interpolateWithPrefixPattern;
    }

    public RecursionInterceptor getRecursionInterceptor() {
        return this.recursionInterceptor;
    }

    public AbstractFilterReaderLineEnding setRecursionInterceptor(RecursionInterceptor givenRecursionInterceptor) {
        this.recursionInterceptor = givenRecursionInterceptor;
        return this;
    }
}

