/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.assembly.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.ListIterator;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugins.assembly.AssemblerConfigurationSource;
import org.apache.maven.plugins.assembly.format.AssemblyFormattingException;
import org.apache.maven.plugins.assembly.model.Assembly;
import org.apache.maven.plugins.assembly.utils.InterpolationConstants;
import org.apache.maven.plugins.assembly.utils.ProjectUtils;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.Os;
import org.codehaus.plexus.interpolation.fixed.FixedStringSearchInterpolator;
import org.codehaus.plexus.interpolation.fixed.MapBasedValueSource;
import org.codehaus.plexus.interpolation.fixed.PrefixedObjectValueSource;
import org.codehaus.plexus.interpolation.fixed.PrefixedPropertiesValueSource;
import org.codehaus.plexus.interpolation.fixed.PropertiesBasedValueSource;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.StringUtils;

public final class AssemblyFormatUtils {
    private AssemblyFormatUtils() {
    }

    public static String getDistributionName(Assembly assembly, AssemblerConfigurationSource configSource) {
        String finalName = configSource.getFinalName();
        boolean appendAssemblyId = configSource.isAssemblyIdAppended();
        String distributionName = finalName;
        if (appendAssemblyId) {
            distributionName = finalName + "-" + assembly.getId();
        }
        return distributionName;
    }

    @Nonnull
    public static FixedStringSearchInterpolator finalNameInterpolator(String finalName) {
        Properties specialExpressionOverrides = new Properties();
        if (finalName == null) {
            return FixedStringSearchInterpolator.empty();
        }
        specialExpressionOverrides.setProperty("finalName", finalName);
        specialExpressionOverrides.setProperty("build.finalName", finalName);
        return FixedStringSearchInterpolator.create(new PropertiesBasedValueSource(specialExpressionOverrides));
    }

    @Nonnull
    public static FixedStringSearchInterpolator moduleProjectInterpolator(MavenProject moduleProject) {
        if (moduleProject != null) {
            return FixedStringSearchInterpolator.createWithPermittedNulls(new PrefixedObjectValueSource("module.", moduleProject), new PrefixedPropertiesValueSource("module.properties.", moduleProject.getProperties()), moduleProject.getArtifact() != null ? new PrefixedObjectValueSource("module.", moduleProject.getArtifact()) : null);
        }
        return FixedStringSearchInterpolator.empty();
    }

    public static FixedStringSearchInterpolator moduleArtifactInterpolator(Artifact moduleArtifact) {
        if (moduleArtifact != null) {
            String groupIdPath = moduleArtifact.getGroupId().replace('.', '/');
            return FixedStringSearchInterpolator.create(new MapBasedValueSource(Collections.singletonMap("module.groupIdPath", groupIdPath)), new PrefixedObjectValueSource("module.", moduleArtifact), new PrefixedObjectValueSource("module.", moduleArtifact.getArtifactHandler()), new PrefixedObjectValueSource("module.handler.", moduleArtifact.getArtifactHandler()));
        }
        return FixedStringSearchInterpolator.empty();
    }

    @Nonnull
    public static FixedStringSearchInterpolator artifactProjectInterpolator(MavenProject artifactProject) {
        if (artifactProject != null) {
            PrefixedObjectValueSource vs = null;
            if (artifactProject.getArtifact() != null) {
                vs = new PrefixedObjectValueSource("artifact.", artifactProject.getArtifact());
            }
            String groupIdPath = artifactProject.getGroupId().replace('.', '/');
            return FixedStringSearchInterpolator.createWithPermittedNulls(new MapBasedValueSource(Collections.singletonMap("artifact.groupIdPath", groupIdPath)), new PrefixedObjectValueSource("artifact.", artifactProject), new PrefixedPropertiesValueSource("artifact.properties.", artifactProject.getProperties()), vs);
        }
        return FixedStringSearchInterpolator.empty();
    }

    @Nonnull
    public static FixedStringSearchInterpolator artifactInterpolator(@Nonnull Artifact artifact) {
        String groupIdPath = artifact.getGroupId().replace('.', '/');
        return FixedStringSearchInterpolator.create(new MapBasedValueSource(Collections.singletonMap("artifact.groupIdPath", groupIdPath)), new PrefixedObjectValueSource("artifact.", artifact), new PrefixedObjectValueSource("artifact.", artifact.getArtifactHandler()), new PrefixedObjectValueSource("artifact.handler.", artifact.getArtifactHandler()));
    }

    @Nonnull
    public static FixedStringSearchInterpolator classifierRules(Artifact artifact) {
        Properties specialRules = new Properties();
        String classifier = ProjectUtils.getClassifier(artifact);
        if (classifier != null) {
            specialRules.setProperty("dashClassifier?", "-" + classifier);
            specialRules.setProperty("dashClassifier", "-" + classifier);
        } else {
            specialRules.setProperty("dashClassifier?", "");
            specialRules.setProperty("dashClassifier", "");
        }
        return FixedStringSearchInterpolator.create(new PropertiesBasedValueSource(specialRules));
    }

    public static String getOutputDirectory(String output, MavenProject artifactProject, String finalName, AssemblerConfigurationSource configSource) throws AssemblyFormattingException {
        return AssemblyFormatUtils.getOutputDirectory(output, finalName, configSource, AssemblyFormatUtils.moduleProjectInterpolator(null), AssemblyFormatUtils.artifactProjectInterpolator(artifactProject));
    }

    private static FixedStringSearchInterpolator executionPropertiesInterpolator(AssemblerConfigurationSource configSource) {
        Properties userProperties;
        MavenSession session;
        if (configSource != null && (session = configSource.getMavenSession()) != null && (userProperties = session.getExecutionProperties()) != null) {
            return FixedStringSearchInterpolator.create(new PropertiesBasedValueSource(userProperties));
        }
        return FixedStringSearchInterpolator.empty();
    }

    private static FixedStringSearchInterpolator mainProjectOnlyInterpolator(MavenProject mainProject) {
        if (mainProject != null) {
            return FixedStringSearchInterpolator.create(new PrefixedObjectValueSource(InterpolationConstants.PROJECT_PREFIXES, mainProject, true));
        }
        return FixedStringSearchInterpolator.empty();
    }

    @Nonnull
    public static String fixRelativeRefs(@Nonnull String src) {
        String value = src;
        String[] separators = new String[]{"/", "\\"};
        String finalSep = null;
        for (String sep : separators) {
            if (value.endsWith(sep)) {
                finalSep = sep;
            }
            if (!value.contains("." + sep)) continue;
            ArrayList<String> parts = new ArrayList<String>();
            parts.addAll(Arrays.asList(value.split(sep.replace("\\", "\\\\"))));
            ListIterator it = parts.listIterator();
            while (it.hasNext()) {
                String part = (String)it.next();
                if (".".equals(part)) {
                    it.remove();
                    continue;
                }
                if (!"..".equals(part)) continue;
                it.remove();
                if (!it.hasPrevious()) continue;
                it.previous();
                it.remove();
            }
            value = StringUtils.join(parts.iterator(), sep);
        }
        if (finalSep != null && value.length() > 0 && !value.endsWith(finalSep)) {
            value = value + finalSep;
        }
        return value;
    }

    public static String evaluateFileNameMapping(String expression, @Nonnull Artifact artifact, @Nullable MavenProject mainProject, @Nullable Artifact moduleArtifact, @Nonnull AssemblerConfigurationSource configSource, FixedStringSearchInterpolator moduleProjectInterpolator, FixedStringSearchInterpolator artifactProjectInterpolator) throws AssemblyFormattingException {
        String value = expression;
        FixedStringSearchInterpolator interpolator = FixedStringSearchInterpolator.create(AssemblyFormatUtils.moduleArtifactInterpolator(moduleArtifact), moduleProjectInterpolator, AssemblyFormatUtils.artifactInterpolator(artifact), artifactProjectInterpolator, AssemblyFormatUtils.mainProjectOnlyInterpolator(mainProject), AssemblyFormatUtils.classifierRules(artifact), AssemblyFormatUtils.executionPropertiesInterpolator(configSource), configSource.getMainProjectInterpolator(), configSource.getCommandLinePropsInterpolator(), configSource.getEnvInterpolator());
        value = interpolator.interpolate(value);
        value = StringUtils.replace(value, "//", "/");
        value = StringUtils.replace(value, "\\\\", "\\");
        value = AssemblyFormatUtils.fixRelativeRefs(value);
        return value;
    }

    public static String getOutputDirectory(String output, String finalName, AssemblerConfigurationSource configSource, FixedStringSearchInterpolator moduleProjectIntrpolator, FixedStringSearchInterpolator artifactProjectInterpolator) throws AssemblyFormattingException {
        FixedStringSearchInterpolator interpolator;
        String value = output;
        if (value == null) {
            value = "";
        }
        if ((value = (interpolator = FixedStringSearchInterpolator.create(AssemblyFormatUtils.finalNameInterpolator(finalName), moduleProjectIntrpolator, artifactProjectInterpolator, AssemblyFormatUtils.executionPropertiesInterpolator(configSource), configSource.getMainProjectInterpolator(), configSource.getCommandLinePropsInterpolator(), configSource.getEnvInterpolator())).interpolate(value)).length() > 0 && !value.endsWith("/") && !value.endsWith("\\")) {
            value = value + "/";
        }
        if (value.length() > 0 && (value.startsWith("/") || value.startsWith("\\"))) {
            value = value.substring(1);
        }
        value = StringUtils.replace(value, "//", "/");
        value = StringUtils.replace(value, "\\\\", "\\");
        value = AssemblyFormatUtils.fixRelativeRefs(value);
        return value;
    }

    public static void warnForPlatformSpecifics(Logger logger, String destDirectory) {
        if (Os.isFamily("windows")) {
            if (AssemblyFormatUtils.isUnixRootReference(destDirectory)) {
                logger.error("OS=Windows and the assembly descriptor contains a *nix-specific root-relative reference (starting with slash): " + destDirectory);
            } else if (AssemblyFormatUtils.isWindowsPath(destDirectory)) {
                logger.warn("The assembly descriptor contains a Windows-specific directory reference (with a drive letter). This is not portable and will fail on non-Windows: " + destDirectory);
            }
        } else if (AssemblyFormatUtils.isWindowsPath(destDirectory)) {
            logger.error("OS=Non-Windows and the assembly descriptor contains a Windows-specific directory reference (with a drive letter): " + destDirectory);
        } else if (AssemblyFormatUtils.isUnixRootReference(destDirectory)) {
            logger.warn("The assembly descriptor contains a *nix-specific root-relative reference (starting with slash). This is not portable and might fail on Windows: " + destDirectory);
        }
    }

    static boolean isWindowsPath(String destDirectory) {
        return destDirectory != null && destDirectory.length() >= 2 && destDirectory.charAt(1) == ':';
    }

    static boolean isUnixRootReference(String destDirectory) {
        return destDirectory != null && destDirectory.startsWith("/");
    }
}

