/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.assembly.interpolation;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.maven.plugins.assembly.AssemblerConfigurationSource;
import org.apache.maven.plugins.assembly.model.io.xpp3.AssemblyXpp3Reader;
import org.apache.maven.plugins.assembly.model.io.xpp3.ComponentXpp3Reader;
import org.apache.maven.plugins.assembly.resolved.AssemblyId;
import org.apache.maven.plugins.assembly.utils.AssemblyFileUtils;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.interpolation.InterpolationPostProcessor;
import org.codehaus.plexus.interpolation.fixed.FixedStringSearchInterpolator;
import org.codehaus.plexus.interpolation.fixed.InterpolationState;
import org.codehaus.plexus.interpolation.object.FieldBasedObjectInterpolator;
import org.codehaus.plexus.logging.Logger;

public class AssemblyInterpolator {
    private static final Set<String> INTERPOLATION_BLACKLIST;

    public static AssemblyXpp3Reader.ContentTransformer assemblyInterpolator(final FixedStringSearchInterpolator interpolator, final InterpolationState is, final Logger logger) {
        final HashSet<String> blacklistFields = new HashSet<String>(FieldBasedObjectInterpolator.DEFAULT_BLACKLISTED_FIELD_NAMES);
        blacklistFields.addAll(INTERPOLATION_BLACKLIST);
        return new AssemblyXpp3Reader.ContentTransformer(){

            @Override
            public String transform(String source, String contextDescription) {
                if (blacklistFields.contains(contextDescription)) {
                    return source;
                }
                String interpolated = interpolator.interpolate(source, is);
                if (!source.equals(interpolated) && logger.isDebugEnabled()) {
                    logger.debug("Field " + contextDescription + " source: " + source + " interpolated to: " + interpolated);
                }
                return interpolated;
            }
        };
    }

    public static ComponentXpp3Reader.ContentTransformer componentInterpolator(final FixedStringSearchInterpolator interpolator, final InterpolationState is, final Logger logger) {
        final HashSet<String> blacklistFields = new HashSet<String>(FieldBasedObjectInterpolator.DEFAULT_BLACKLISTED_FIELD_NAMES);
        blacklistFields.addAll(INTERPOLATION_BLACKLIST);
        return new ComponentXpp3Reader.ContentTransformer(){

            @Override
            public String transform(String source, String contextDescription) {
                if (blacklistFields.contains(contextDescription)) {
                    return source;
                }
                String interpolated = interpolator.interpolate(source, is);
                if (!source.equals(interpolated)) {
                    logger.debug("Field " + contextDescription + " source: " + source + " interpolated to: " + interpolated);
                }
                return interpolated;
            }
        };
    }

    public static void checkErrors(AssemblyId assemblyId, InterpolationState interpolationState, Logger logger) {
        if (interpolationState.asList() != null && interpolationState.asList().size() > 0 && logger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("One or more minor errors occurred while interpolating the assembly with ID: ").append(assemblyId).append(":\n");
            List warnings = interpolationState.asList();
            for (Object warning : warnings) {
                sb.append('\n').append(warning);
            }
            sb.append("\n\nThese values were SKIPPED, but the assembly process will continue.\n");
            logger.debug(sb.toString());
        }
    }

    public static FixedStringSearchInterpolator fullInterpolator(MavenProject project, @Nonnull FixedStringSearchInterpolator projectIp, AssemblerConfigurationSource configSource) {
        FixedStringSearchInterpolator fixedStringSearchInterpolator = FixedStringSearchInterpolator.create(configSource.getRepositoryInterpolator(), configSource.getCommandLinePropsInterpolator(), configSource.getEnvInterpolator(), projectIp);
        return fixedStringSearchInterpolator.withPostProcessor(new PathTranslatingPostProcessor(project.getBasedir()));
    }

    static {
        HashSet<String> blacklist = new HashSet<String>();
        blacklist.add("outputFileNameMapping");
        blacklist.add("outputDirectoryMapping");
        blacklist.add("outputDirectory");
        INTERPOLATION_BLACKLIST = blacklist;
    }

    private static final class PathTranslatingPostProcessor
    implements InterpolationPostProcessor {
        private final File basedir;

        PathTranslatingPostProcessor(File basedir) {
            this.basedir = basedir;
        }

        @Override
        public Object execute(String expression, Object value) {
            String path = String.valueOf(value);
            return AssemblyFileUtils.makePathRelativeTo(path, this.basedir);
        }
    }
}

