/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.assembly.format;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.input.ReaderInputStream;
import org.apache.maven.plugins.assembly.AssemblerConfigurationSource;
import org.apache.maven.plugins.assembly.format.AssemblyFormattingException;
import org.apache.maven.plugins.assembly.utils.AssemblyFileUtils;
import org.apache.maven.plugins.assembly.utils.LineEndings;
import org.apache.maven.plugins.assembly.utils.LineEndingsUtils;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.filtering.MavenReaderFilterRequest;
import org.codehaus.plexus.components.io.functions.InputStreamTransformer;
import org.codehaus.plexus.components.io.resources.PlexusIoResource;

public class ReaderFormatter {
    private static Reader createReaderFilter(@Nonnull Reader source, String escapeString, List<String> delimiters, AssemblerConfigurationSource configSource, boolean isPropertiesFile, Properties additionalProperties) throws IOException {
        try {
            MavenReaderFilterRequest filterRequest = new MavenReaderFilterRequest(source, true, configSource.getProject(), configSource.getFilters(), isPropertiesFile, configSource.getMavenSession(), additionalProperties);
            filterRequest.setEscapeString(escapeString);
            if (delimiters != null && !delimiters.isEmpty()) {
                LinkedHashSet<String> delims = new LinkedHashSet<String>();
                for (String delim : delimiters) {
                    if (delim == null) {
                        delims.add("${*}");
                        continue;
                    }
                    delims.add(delim);
                }
                filterRequest.setDelimiters(delims);
            } else {
                filterRequest.setDelimiters(filterRequest.getDelimiters());
            }
            filterRequest.setInjectProjectBuildFilters(configSource.isIncludeProjectBuildFilters());
            return configSource.getMavenReaderFilter().filter(filterRequest);
        }
        catch (MavenFilteringException e) {
            IOException ioe = new IOException("Error filtering file '" + source + "': " + e.getMessage(), e);
            throw ioe;
        }
    }

    private static boolean isForbiddenFiletypes(PlexusIoResource plexusIoResource) {
        String fileName = plexusIoResource.getName().toLowerCase();
        return fileName.endsWith(".zip") || fileName.endsWith(".jar");
    }

    private static void checkifFileTypeIsAppropriateForLineEndingTransformation(PlexusIoResource plexusIoResource) throws IOException {
        if (ReaderFormatter.isForbiddenFiletypes(plexusIoResource)) {
            throw new IOException("Cannot transform line endings on this kind of file: " + plexusIoResource.getName() + "\nDoing so is more or less guaranteed to destroy the file, and it indicates a problem with your assembly descriptor.\nThis error message is new as of 2.5.3. \nEarlier versions of assembly-plugin will silently destroy your file. Fix your descriptor");
        }
    }

    @Nullable
    public static InputStreamTransformer getFileSetTransformers(final AssemblerConfigurationSource configSource, final boolean isFiltered, final Set<String> nonFilteredFileExtensions, String fileSetLineEnding) throws AssemblyFormattingException {
        boolean transformLineEndings;
        final LineEndings lineEndingToUse = LineEndingsUtils.getLineEnding(fileSetLineEnding);
        boolean bl = transformLineEndings = !LineEndings.keep.equals((Object)lineEndingToUse);
        if (transformLineEndings || isFiltered) {
            return new InputStreamTransformer(){

                @Override
                @Nonnull
                public InputStream transform(@Nonnull PlexusIoResource plexusIoResource, @Nonnull InputStream inputStream) throws IOException {
                    String fileName = plexusIoResource.getName();
                    for (String extension : nonFilteredFileExtensions) {
                        if (!fileName.endsWith('.' + extension)) continue;
                        return inputStream;
                    }
                    InputStream result = inputStream;
                    if (isFiltered) {
                        boolean isPropertyFile = AssemblyFileUtils.isPropertyFile(plexusIoResource.getName());
                        String encoding = isPropertyFile ? "ISO-8859-1" : configSource.getEncoding();
                        InputStreamReader source = encoding != null ? new InputStreamReader(inputStream, encoding) : new InputStreamReader(inputStream);
                        Reader filtered = ReaderFormatter.createReaderFilter(source, configSource.getEscapeString(), configSource.getDelimiters(), configSource, isPropertyFile, configSource.getAdditionalProperties());
                        InputStream inputStream2 = result = encoding != null ? new ReaderInputStream(filtered, encoding) : new ReaderInputStream(filtered);
                    }
                    if (transformLineEndings) {
                        ReaderFormatter.checkifFileTypeIsAppropriateForLineEndingTransformation(plexusIoResource);
                        result = LineEndingsUtils.lineEndingConverter(result, lineEndingToUse);
                    }
                    return result;
                }
            };
        }
        return null;
    }
}

