/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.assembly.archive.task;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugins.assembly.AssemblerConfigurationSource;
import org.apache.maven.plugins.assembly.archive.ArchiveCreationException;
import org.apache.maven.plugins.assembly.format.AssemblyFormattingException;
import org.apache.maven.plugins.assembly.utils.AssemblyFormatUtils;
import org.apache.maven.plugins.assembly.utils.TypeConversionUtils;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.util.DefaultArchivedFileSet;
import org.codehaus.plexus.archiver.util.DefaultFileSet;
import org.codehaus.plexus.components.io.functions.InputStreamTransformer;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

public class AddArtifactTask {
    public static final String[] DEFAULT_INCLUDES_ARRAY = new String[]{"**/*"};
    private final Artifact artifact;
    private final Logger logger;
    private final InputStreamTransformer transformer;
    private final Charset encoding;
    private int directoryMode = -1;
    private int fileMode = -1;
    private boolean unpack = false;
    private List<String> includes;
    private List<String> excludes;
    private boolean usingDefaultExcludes = true;
    private MavenProject project;
    private MavenProject moduleProject;
    private Artifact moduleArtifact;
    private String outputDirectory;
    private String outputFileNameMapping;

    public AddArtifactTask(Artifact artifact, Logger logger, InputStreamTransformer transformer, Charset encoding) {
        this.artifact = artifact;
        this.logger = logger;
        this.transformer = transformer;
        this.encoding = encoding;
    }

    public AddArtifactTask(Artifact artifact, Logger logger, Charset encoding) {
        this(artifact, logger, null, encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Archiver archiver, AssemblerConfigurationSource configSource) throws ArchiveCreationException, AssemblyFormattingException {
        if (this.artifactIsArchiverDestination(archiver)) {
            this.artifact.setFile(this.moveArtifactSomewhereElse(configSource));
        }
        String destDirectory = AssemblyFormatUtils.getOutputDirectory(this.outputDirectory, configSource.getFinalName(), configSource, AssemblyFormatUtils.moduleProjectInterpolator(this.moduleProject), AssemblyFormatUtils.artifactProjectInterpolator(this.project));
        boolean fileModeSet = false;
        boolean dirModeSet = false;
        int oldDirMode = archiver.getOverrideDirectoryMode();
        int oldFileMode = archiver.getOverrideFileMode();
        if (this.fileMode != -1) {
            archiver.setFileMode(this.fileMode);
            fileModeSet = true;
        }
        if (this.directoryMode != -1) {
            archiver.setDirectoryMode(this.directoryMode);
            dirModeSet = true;
        }
        try {
            if (this.unpack) {
                this.unpacked(archiver, destDirectory);
            } else {
                this.asFile(archiver, configSource, destDirectory);
            }
        }
        finally {
            if (dirModeSet) {
                archiver.setDirectoryMode(oldDirMode);
            }
            if (fileModeSet) {
                archiver.setFileMode(oldFileMode);
            }
        }
    }

    private void asFile(Archiver archiver, AssemblerConfigurationSource configSource, String destDirectory) throws AssemblyFormattingException, ArchiveCreationException {
        String tempMapping = AssemblyFormatUtils.evaluateFileNameMapping(this.outputFileNameMapping, this.artifact, configSource.getProject(), this.moduleArtifact, configSource, AssemblyFormatUtils.moduleProjectInterpolator(this.moduleProject), AssemblyFormatUtils.artifactProjectInterpolator(this.project));
        String outputLocation = destDirectory + tempMapping;
        try {
            File artifactFile = this.artifact.getFile();
            this.logger.debug("Adding artifact: " + this.artifact.getId() + " with file: " + artifactFile + " to assembly location: " + outputLocation + ".");
            if (this.fileMode != -1) {
                archiver.addFile(artifactFile, outputLocation, this.fileMode);
            } else {
                archiver.addFile(artifactFile, outputLocation);
            }
        }
        catch (ArchiverException e) {
            throw new ArchiveCreationException("Error adding file '" + this.artifact.getId() + "' to archive: " + e.getMessage(), e);
        }
    }

    private void unpacked(Archiver archiver, String destDirectory) throws ArchiveCreationException {
        Object[] includesArray;
        String outputLocation = destDirectory;
        if (outputLocation.length() > 0 && !outputLocation.endsWith("/")) {
            outputLocation = outputLocation + "/";
        }
        if ((includesArray = TypeConversionUtils.toStringArray(this.includes)) == null) {
            includesArray = DEFAULT_INCLUDES_ARRAY;
        }
        Object[] excludesArray = TypeConversionUtils.toStringArray(this.excludes);
        try {
            File artifactFile = this.artifact.getFile();
            if (artifactFile == null) {
                this.logger.warn("Skipping artifact: " + this.artifact.getId() + "; it does not have an associated file or directory.");
            } else if (artifactFile.isDirectory()) {
                this.logger.debug("Adding artifact directory contents for: " + this.artifact + " to: " + outputLocation);
                DefaultFileSet fs = DefaultFileSet.fileSet(artifactFile);
                fs.setIncludes((String[])includesArray);
                fs.setExcludes((String[])excludesArray);
                fs.setPrefix(outputLocation);
                fs.setStreamTransformer(this.transformer);
                fs.setUsingDefaultExcludes(this.usingDefaultExcludes);
                archiver.addFileSet(fs);
            } else {
                this.logger.debug("Unpacking artifact contents for: " + this.artifact + " to: " + outputLocation);
                this.logger.debug("includes:\n" + StringUtils.join(includesArray, "\n") + "\n");
                this.logger.debug("excludes:\n" + (excludesArray == null ? "none" : StringUtils.join(excludesArray, "\n")) + "\n");
                DefaultArchivedFileSet afs = DefaultArchivedFileSet.archivedFileSet(artifactFile);
                afs.setIncludes((String[])includesArray);
                afs.setExcludes((String[])excludesArray);
                afs.setPrefix(outputLocation);
                afs.setStreamTransformer(this.transformer);
                afs.setUsingDefaultExcludes(this.usingDefaultExcludes);
                archiver.addArchivedFileSet(afs, this.encoding);
            }
        }
        catch (ArchiverException e) {
            throw new ArchiveCreationException("Error adding file-set for '" + this.artifact.getId() + "' to archive: " + e.getMessage(), e);
        }
    }

    private File moveArtifactSomewhereElse(AssemblerConfigurationSource configSource) throws ArchiveCreationException {
        File tempRoot = configSource.getTemporaryRootDirectory();
        File tempArtifactFile = new File(tempRoot, this.artifact.getFile().getName());
        this.logger.warn("Artifact: " + this.artifact.getId() + " references the same file as the assembly destination file. Moving it to a temporary location for inclusion.");
        try {
            FileUtils.copyFile(this.artifact.getFile(), tempArtifactFile);
        }
        catch (IOException e) {
            throw new ArchiveCreationException("Error moving artifact file: '" + this.artifact.getFile() + "' to temporary location: " + tempArtifactFile + ". Reason: " + e.getMessage(), e);
        }
        return tempArtifactFile;
    }

    private boolean artifactIsArchiverDestination(Archiver archiver) {
        return this.artifact.getFile() != null && archiver.getDestFile() != null && this.artifact.getFile().equals(archiver.getDestFile());
    }

    public void setDirectoryMode(int directoryMode) {
        this.directoryMode = directoryMode;
    }

    public void setFileMode(int fileMode) {
        this.fileMode = fileMode;
    }

    public void setExcludes(List<String> excludes) {
        this.excludes = excludes;
    }

    public void setUsingDefaultExcludes(boolean usingDefaultExcludes) {
        this.usingDefaultExcludes = usingDefaultExcludes;
    }

    public void setIncludes(List<String> includes) {
        this.includes = includes;
    }

    public void setUnpack(boolean unpack) {
        this.unpack = unpack;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public void setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public void setFileNameMapping(String outputFileNameMapping) {
        this.outputFileNameMapping = outputFileNameMapping;
    }

    public void setOutputDirectory(String outputDirectory, String defaultOutputDirectory) {
        this.setOutputDirectory(outputDirectory == null ? defaultOutputDirectory : outputDirectory);
    }

    public void setFileNameMapping(String outputFileNameMapping, String defaultOutputFileNameMapping) {
        this.setFileNameMapping(outputFileNameMapping == null ? defaultOutputFileNameMapping : outputFileNameMapping);
    }

    public void setModuleProject(MavenProject moduleProject) {
        this.moduleProject = moduleProject;
    }

    public void setModuleArtifact(Artifact moduleArtifact) {
        this.moduleArtifact = moduleArtifact;
    }
}

