/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.assembly.archive.phase;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugins.assembly.AssemblerConfigurationSource;
import org.apache.maven.plugins.assembly.InvalidAssemblerConfigurationException;
import org.apache.maven.plugins.assembly.archive.ArchiveCreationException;
import org.apache.maven.plugins.assembly.archive.phase.AssemblyArchiverPhase;
import org.apache.maven.plugins.assembly.archive.phase.PhaseOrder;
import org.apache.maven.plugins.assembly.format.AssemblyFormattingException;
import org.apache.maven.plugins.assembly.format.ReaderFormatter;
import org.apache.maven.plugins.assembly.model.Assembly;
import org.apache.maven.plugins.assembly.model.FileItem;
import org.apache.maven.plugins.assembly.utils.AssemblyFileUtils;
import org.apache.maven.plugins.assembly.utils.AssemblyFormatUtils;
import org.apache.maven.plugins.assembly.utils.TypeConversionUtils;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.components.io.functions.ContentSupplier;
import org.codehaus.plexus.components.io.functions.InputStreamTransformer;
import org.codehaus.plexus.components.io.resources.PlexusIoFileResource;
import org.codehaus.plexus.components.io.resources.PlexusIoResource;
import org.codehaus.plexus.components.io.resources.ResourceFactory;
import org.codehaus.plexus.logging.AbstractLogEnabled;

@Component(role=AssemblyArchiverPhase.class, hint="file-items")
public class FileItemAssemblyPhase
extends AbstractLogEnabled
implements AssemblyArchiverPhase,
PhaseOrder {
    @Override
    public void execute(Assembly assembly, Archiver archiver, AssemblerConfigurationSource configSource) throws ArchiveCreationException, AssemblyFormattingException, InvalidAssemblerConfigurationException {
        List<FileItem> fileList = assembly.getFiles();
        File basedir = configSource.getBasedir();
        for (FileItem fileItem : fileList) {
            String outputDirectory1;
            String outputDirectory;
            String sourcePath;
            if (fileItem.getSource() != null ^ fileItem.getSources().isEmpty()) {
                throw new InvalidAssemblerConfigurationException("Misconfigured file: one of source or sources must be set");
            }
            String destName = fileItem.getDestName();
            if (fileItem.getSource() != null) {
                sourcePath = fileItem.getSource();
            } else if (destName != null) {
                sourcePath = fileItem.getSources().get(0);
            } else {
                throw new InvalidAssemblerConfigurationException("Misconfigured file: specify destName when using sources");
            }
            File source = new File(sourcePath);
            String sourceName = source.getName();
            if (!AssemblyFileUtils.isAbsolutePath(source)) {
                source = new File(basedir, sourcePath);
            }
            if (destName == null) {
                destName = sourceName;
            }
            String target = (outputDirectory = AssemblyFormatUtils.getOutputDirectory(outputDirectory1 = fileItem.getOutputDirectory(), configSource.getFinalName(), configSource, AssemblyFormatUtils.moduleProjectInterpolator(configSource.getProject()), AssemblyFormatUtils.artifactProjectInterpolator(null))).endsWith("/") || outputDirectory.endsWith("\\") ? outputDirectory + destName : (outputDirectory.length() < 1 ? destName : outputDirectory + "/" + destName);
            try {
                PlexusIoResource restoUse;
                InputStreamTransformer fileSetTransformers = ReaderFormatter.getFileSetTransformers(configSource, fileItem.isFiltered(), Collections.emptySet(), fileItem.getLineEnding());
                if (!fileItem.getSources().isEmpty()) {
                    ArrayList<InputStream> content = new ArrayList<InputStream>(fileItem.getSources().size());
                    for (String contentSourcePath : fileItem.getSources()) {
                        File contentSource = new File(contentSourcePath);
                        if (!AssemblyFileUtils.isAbsolutePath(contentSource)) {
                            contentSource = new File(basedir, contentSourcePath);
                        }
                        content.add(new FileInputStream(contentSource));
                    }
                    String name = PlexusIoFileResource.getName(source);
                    restoUse = ResourceFactory.createResource(source, name, this.getContentSupplier(content), fileSetTransformers);
                } else {
                    restoUse = ResourceFactory.createResource(source, fileSetTransformers);
                }
                int mode = TypeConversionUtils.modeToInt(fileItem.getFileMode(), this.getLogger());
                archiver.addResource(restoUse, target, mode);
            }
            catch (IOException | ArchiverException e) {
                throw new ArchiveCreationException("Error adding file to archive: " + e.getMessage(), e);
            }
        }
    }

    @Override
    public int order() {
        return 10;
    }

    private ContentSupplier getContentSupplier(final Collection<InputStream> contentStreams) {
        return new ContentSupplier(){

            @Override
            public InputStream getContents() throws IOException {
                return new SequenceInputStream(Collections.enumeration(contentStreams));
            }
        };
    }
}

