/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.assembly.archive.archiver;

import java.io.File;
import org.apache.maven.plugins.assembly.archive.archiver.PrefixedFileSet;
import org.codehaus.plexus.archiver.ArchivedFileSet;
import org.codehaus.plexus.components.io.filemappers.FileMapper;
import org.codehaus.plexus.components.io.fileselectors.FileSelector;
import org.codehaus.plexus.components.io.functions.InputStreamTransformer;

class PrefixedArchivedFileSet
implements ArchivedFileSet {
    private static final FileMapper[] EMPTY_FILE_MAPPERS_ARRAY = new FileMapper[0];
    private final String rootPrefix;
    private final ArchivedFileSet fileSet;
    private final FileSelector[] selectors;

    PrefixedArchivedFileSet(ArchivedFileSet fileSet, String rootPrefix, FileSelector[] selectors) {
        this.fileSet = fileSet;
        this.selectors = selectors;
        this.rootPrefix = rootPrefix.length() > 0 && !rootPrefix.endsWith("/") ? rootPrefix + "/" : rootPrefix;
    }

    @Override
    public File getArchive() {
        return this.fileSet.getArchive();
    }

    @Override
    public String[] getExcludes() {
        return this.fileSet.getExcludes();
    }

    @Override
    public FileSelector[] getFileSelectors() {
        return PrefixedFileSet.combineSelectors(this.fileSet.getFileSelectors(), this.selectors);
    }

    @Override
    public String[] getIncludes() {
        return this.fileSet.getIncludes();
    }

    @Override
    public String getPrefix() {
        String prefix = this.fileSet.getPrefix();
        if (prefix.startsWith("/")) {
            prefix = prefix.length() > 1 ? prefix.substring(1) : "";
        }
        return this.rootPrefix + prefix;
    }

    @Override
    public boolean isCaseSensitive() {
        return this.fileSet.isCaseSensitive();
    }

    @Override
    public boolean isIncludingEmptyDirectories() {
        return this.fileSet.isIncludingEmptyDirectories();
    }

    @Override
    public boolean isUsingDefaultExcludes() {
        return this.fileSet.isUsingDefaultExcludes();
    }

    @Override
    public InputStreamTransformer getStreamTransformer() {
        return this.fileSet.getStreamTransformer();
    }

    @Override
    public FileMapper[] getFileMappers() {
        return EMPTY_FILE_MAPPERS_ARRAY;
    }
}

