/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.assembly.archive.archiver;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.maven.plugins.assembly.archive.archiver.PrefixedArchivedFileSet;
import org.apache.maven.plugins.assembly.archive.archiver.PrefixedFileSet;
import org.apache.maven.plugins.assembly.filter.ContainerDescriptorHandler;
import org.codehaus.plexus.archiver.ArchiveEntry;
import org.codehaus.plexus.archiver.ArchiveFinalizer;
import org.codehaus.plexus.archiver.ArchivedFileSet;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.archiver.FinalizerEnabled;
import org.codehaus.plexus.archiver.ResourceIterator;
import org.codehaus.plexus.archiver.util.DefaultArchivedFileSet;
import org.codehaus.plexus.archiver.util.DefaultFileSet;
import org.codehaus.plexus.components.io.fileselectors.FileInfo;
import org.codehaus.plexus.components.io.fileselectors.FileSelector;
import org.codehaus.plexus.components.io.resources.PlexusIoResource;
import org.codehaus.plexus.components.io.resources.PlexusIoResourceCollection;
import org.codehaus.plexus.logging.Logger;

public class AssemblyProxyArchiver
implements Archiver {
    private final Archiver delegate;
    private final ThreadLocal<Boolean> inPublicApi = new ThreadLocal();
    private final Logger logger;
    private final String assemblyWorkPath;
    private String rootPrefix;
    private FileSelector[] selectors;
    private boolean forced;
    private boolean useJvmChmod;

    public AssemblyProxyArchiver(String rootPrefix, Archiver delegate, List<ContainerDescriptorHandler> containerDescriptorHandlers, List<FileSelector> extraSelectors, List<ArchiveFinalizer> extraFinalizers, File assemblyWorkDir, Logger logger) {
        FinalizerEnabled finalizer;
        this.rootPrefix = rootPrefix;
        this.delegate = delegate;
        this.assemblyWorkPath = assemblyWorkDir.getAbsolutePath().replace('\\', '/');
        this.logger = logger;
        if (!"".equals(rootPrefix) && !rootPrefix.endsWith("/")) {
            this.rootPrefix = this.rootPrefix + "/";
        }
        ArrayList<FileSelector> selectors = new ArrayList<FileSelector>();
        FinalizerEnabled finalizerEnabled = finalizer = delegate instanceof FinalizerEnabled ? (FinalizerEnabled)((Object)delegate) : null;
        if (containerDescriptorHandlers != null) {
            for (ContainerDescriptorHandler handler : containerDescriptorHandlers) {
                selectors.add(handler);
                if (finalizer == null) continue;
                finalizer.addArchiveFinalizer(handler);
            }
        }
        if (extraSelectors != null) {
            selectors.addAll(extraSelectors);
        }
        if (extraFinalizers != null && finalizer != null) {
            for (ArchiveFinalizer extraFinalizer : extraFinalizers) {
                finalizer.addArchiveFinalizer(extraFinalizer);
            }
        }
        if (!selectors.isEmpty()) {
            this.selectors = selectors.toArray(new FileSelector[selectors.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addArchivedFileSet(@Nonnull File archiveFile, String prefix, String[] includes, String[] excludes) {
        this.inPublicApi.set(Boolean.TRUE);
        try {
            DefaultArchivedFileSet fs = new DefaultArchivedFileSet(archiveFile);
            fs.setIncludes(includes);
            fs.setExcludes(excludes);
            fs.setPrefix(this.rootPrefix + prefix);
            fs.setFileSelectors(this.selectors);
            this.debug("Adding archived file-set in: " + archiveFile + " to archive location: " + fs.getPrefix());
            this.delegate.addArchivedFileSet(fs);
        }
        finally {
            this.inPublicApi.set(null);
        }
    }

    private void debug(String message) {
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addArchivedFileSet(@Nonnull File archiveFile, String prefix) {
        this.inPublicApi.set(Boolean.TRUE);
        try {
            DefaultArchivedFileSet fs = new DefaultArchivedFileSet(archiveFile);
            fs.setPrefix(this.rootPrefix + prefix);
            fs.setFileSelectors(this.selectors);
            this.debug("Adding archived file-set in: " + archiveFile + " to archive location: " + fs.getPrefix());
            this.delegate.addArchivedFileSet(fs);
        }
        finally {
            this.inPublicApi.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addArchivedFileSet(File archiveFile, String[] includes, String[] excludes) {
        this.inPublicApi.set(Boolean.TRUE);
        try {
            DefaultArchivedFileSet fs = new DefaultArchivedFileSet(archiveFile);
            fs.setIncludes(includes);
            fs.setExcludes(excludes);
            fs.setPrefix(this.rootPrefix);
            fs.setFileSelectors(this.selectors);
            this.debug("Adding archived file-set in: " + archiveFile + " to archive location: " + fs.getPrefix());
            this.delegate.addArchivedFileSet(fs);
        }
        finally {
            this.inPublicApi.set(null);
        }
    }

    @Override
    public void addArchivedFileSet(@Nonnull File archiveFile) {
        this.inPublicApi.set(Boolean.TRUE);
        try {
            DefaultArchivedFileSet fs = new DefaultArchivedFileSet(archiveFile);
            fs.setPrefix(this.rootPrefix);
            fs.setFileSelectors(this.selectors);
            this.debug("Adding archived file-set in: " + archiveFile + " to archive location: " + fs.getPrefix());
            this.delegate.addArchivedFileSet(fs);
        }
        finally {
            this.inPublicApi.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDirectory(@Nonnull File directory, String prefix, String[] includes, String[] excludes) {
        this.inPublicApi.set(Boolean.TRUE);
        try {
            DefaultFileSet fs = new DefaultFileSet();
            fs.setDirectory(directory);
            fs.setIncludes(includes);
            fs.setExcludes(excludes);
            fs.setPrefix(this.rootPrefix + prefix);
            fs.setFileSelectors(this.selectors);
            this.debug("Adding directory file-set in: " + directory + " to archive location: " + fs.getPrefix());
            this.doAddFileSet(fs);
        }
        finally {
            this.inPublicApi.set(null);
        }
    }

    @Override
    public void addSymlink(String symlinkName, String symlinkDestination) {
        this.inPublicApi.set(Boolean.TRUE);
        try {
            this.delegate.addSymlink(symlinkName, symlinkDestination);
        }
        finally {
            this.inPublicApi.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSymlink(String symlinkName, int permissions, String symlinkDestination) {
        this.inPublicApi.set(Boolean.TRUE);
        try {
            this.delegate.addSymlink(symlinkName, permissions, symlinkDestination);
        }
        finally {
            this.inPublicApi.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDirectory(@Nonnull File directory, String prefix) {
        this.inPublicApi.set(Boolean.TRUE);
        try {
            DefaultFileSet fs = new DefaultFileSet();
            fs.setDirectory(directory);
            fs.setPrefix(this.rootPrefix + prefix);
            fs.setFileSelectors(this.selectors);
            this.debug("Adding directory file-set in: " + directory + " to archive location: " + fs.getPrefix());
            this.doAddFileSet(fs);
        }
        finally {
            this.inPublicApi.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDirectory(@Nonnull File directory, String[] includes, String[] excludes) {
        this.inPublicApi.set(Boolean.TRUE);
        try {
            DefaultFileSet fs = new DefaultFileSet();
            fs.setDirectory(directory);
            fs.setIncludes(includes);
            fs.setExcludes(excludes);
            fs.setPrefix(this.rootPrefix);
            fs.setFileSelectors(this.selectors);
            this.debug("Adding directory file-set in: " + directory + " to archive location: " + fs.getPrefix());
            this.doAddFileSet(fs);
        }
        finally {
            this.inPublicApi.set(null);
        }
    }

    @Override
    public void addDirectory(@Nonnull File directory) {
        this.inPublicApi.set(Boolean.TRUE);
        try {
            DefaultFileSet fs = new DefaultFileSet();
            fs.setDirectory(directory);
            fs.setPrefix(this.rootPrefix);
            fs.setFileSelectors(this.selectors);
            this.debug("Adding directory file-set in: " + directory + " to archive location: " + fs.getPrefix());
            this.doAddFileSet(fs);
        }
        finally {
            this.inPublicApi.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFile(@Nonnull File inputFile, @Nonnull String destFileName, int permissions) {
        if (this.acceptFile(inputFile)) {
            this.inPublicApi.set(Boolean.TRUE);
            try {
                this.debug("Adding file: " + inputFile + " to archive location: " + this.rootPrefix + destFileName);
                this.delegate.addFile(inputFile, this.rootPrefix + destFileName, permissions);
            }
            finally {
                this.inPublicApi.set(null);
            }
        }
    }

    @Override
    public void addFile(@Nonnull File inputFile, @Nonnull String destFileName) {
        if (this.acceptFile(inputFile)) {
            this.inPublicApi.set(Boolean.TRUE);
            try {
                this.debug("Adding file: " + inputFile + " to archive location: " + this.rootPrefix + destFileName);
                this.delegate.addFile(inputFile, this.rootPrefix + destFileName);
            }
            finally {
                this.inPublicApi.set(null);
            }
        }
    }

    @Override
    public void createArchive() throws IOException {
        this.inPublicApi.set(Boolean.TRUE);
        try {
            this.delegate.setForced(this.forced);
            this.delegate.createArchive();
        }
        finally {
            this.inPublicApi.set(null);
        }
    }

    @Override
    public int getDefaultDirectoryMode() {
        this.inPublicApi.set(Boolean.TRUE);
        try {
            int n = this.delegate.getDefaultDirectoryMode();
            return n;
        }
        finally {
            this.inPublicApi.set(null);
        }
    }

    @Override
    public void setDefaultDirectoryMode(int mode) {
        this.inPublicApi.set(Boolean.TRUE);
        try {
            this.delegate.setDefaultDirectoryMode(mode);
        }
        finally {
            this.inPublicApi.set(null);
        }
    }

    @Override
    public int getDefaultFileMode() {
        this.inPublicApi.set(Boolean.TRUE);
        try {
            int n = this.delegate.getDefaultFileMode();
            return n;
        }
        finally {
            this.inPublicApi.set(null);
        }
    }

    @Override
    public void setDefaultFileMode(int mode) {
        this.inPublicApi.set(Boolean.TRUE);
        try {
            this.delegate.setDefaultFileMode(mode);
        }
        finally {
            this.inPublicApi.set(null);
        }
    }

    @Override
    public File getDestFile() {
        this.inPublicApi.set(Boolean.TRUE);
        try {
            File file = this.delegate.getDestFile();
            return file;
        }
        finally {
            this.inPublicApi.set(null);
        }
    }

    @Override
    public void setDestFile(File destFile) {
        this.inPublicApi.set(Boolean.TRUE);
        try {
            this.delegate.setDestFile(destFile);
        }
        finally {
            this.inPublicApi.set(null);
        }
    }

    @Override
    public Map<String, ArchiveEntry> getFiles() {
        this.inPublicApi.set(Boolean.TRUE);
        try {
            Map<String, ArchiveEntry> map = this.delegate.getFiles();
            return map;
        }
        finally {
            this.inPublicApi.set(null);
        }
    }

    @Override
    public boolean getIncludeEmptyDirs() {
        this.inPublicApi.set(Boolean.TRUE);
        try {
            boolean bl = this.delegate.getIncludeEmptyDirs();
            return bl;
        }
        finally {
            this.inPublicApi.set(null);
        }
    }

    @Override
    public void setIncludeEmptyDirs(boolean includeEmptyDirs) {
        this.inPublicApi.set(Boolean.TRUE);
        try {
            this.delegate.setIncludeEmptyDirs(includeEmptyDirs);
        }
        finally {
            this.inPublicApi.set(null);
        }
    }

    @Override
    public boolean isForced() {
        this.inPublicApi.set(Boolean.TRUE);
        try {
            boolean bl = this.delegate.isForced();
            return bl;
        }
        finally {
            this.inPublicApi.set(null);
        }
    }

    @Override
    public void setForced(boolean forced) {
        this.inPublicApi.set(Boolean.TRUE);
        try {
            this.forced = forced;
            this.delegate.setForced(forced);
        }
        finally {
            this.inPublicApi.set(null);
        }
    }

    @Override
    public boolean isSupportingForced() {
        this.inPublicApi.set(Boolean.TRUE);
        try {
            boolean bl = this.delegate.isSupportingForced();
            return bl;
        }
        finally {
            this.inPublicApi.set(null);
        }
    }

    @Override
    public void setDotFileDirectory(File dotFileDirectory) {
        throw new UnsupportedOperationException("Undocumented feature of plexus-archiver; this is not yet supported.");
    }

    @Override
    public void addArchivedFileSet(ArchivedFileSet fileSet) {
        this.inPublicApi.set(Boolean.TRUE);
        try {
            PrefixedArchivedFileSet fs = new PrefixedArchivedFileSet(fileSet, this.rootPrefix, this.selectors);
            this.debug("Adding archived file-set in: " + fileSet.getArchive() + " to archive location: " + fs.getPrefix());
            this.delegate.addArchivedFileSet(fs);
        }
        finally {
            this.inPublicApi.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addArchivedFileSet(ArchivedFileSet archivedFileSet, Charset charset) {
        this.inPublicApi.set(Boolean.TRUE);
        try {
            PrefixedArchivedFileSet fs = new PrefixedArchivedFileSet(archivedFileSet, this.rootPrefix, this.selectors);
            this.debug("Adding archived file-set in: " + archivedFileSet.getArchive() + " to archive location: " + fs.getPrefix());
            this.delegate.addArchivedFileSet(fs, charset);
        }
        finally {
            this.inPublicApi.set(null);
        }
    }

    @Override
    public void addFileSet(@Nonnull FileSet fileSet) {
        this.inPublicApi.set(Boolean.TRUE);
        try {
            PrefixedFileSet fs = new PrefixedFileSet(fileSet, this.rootPrefix, this.selectors);
            this.debug("Adding file-set in: " + fileSet.getDirectory() + " to archive location: " + fs.getPrefix());
            this.doAddFileSet(fs);
        }
        finally {
            this.inPublicApi.set(null);
        }
    }

    private void doAddFileSet(FileSet fs) {
        String fsPath = fs.getDirectory().getAbsolutePath().replace('\\', '/');
        if (fsPath.equals(this.assemblyWorkPath)) {
            this.logger.debug("SKIPPING fileset with source directory matching assembly working-directory: " + fsPath);
        } else if (this.assemblyWorkPath.startsWith(fsPath)) {
            ArrayList<String> newEx = new ArrayList<String>();
            if (fs.getExcludes() != null) {
                newEx.addAll(Arrays.asList(fs.getExcludes()));
            }
            String workDirExclude = this.assemblyWorkPath.substring(fsPath.length() + 1);
            this.logger.debug("Adding exclude for assembly working-directory: " + workDirExclude + "\nFile-Set source directory: " + fsPath);
            newEx.add(workDirExclude);
            ArrayList<String> newIn = new ArrayList<String>();
            if (fs.getIncludes() != null) {
                for (String include : fs.getIncludes()) {
                    if (include.startsWith(workDirExclude)) continue;
                    newIn.add(include);
                }
            }
            DefaultFileSet dfs = new DefaultFileSet();
            dfs.setCaseSensitive(fs.isCaseSensitive());
            dfs.setDirectory(fs.getDirectory());
            dfs.setExcludes(newEx.toArray(new String[newEx.size()]));
            dfs.setFileSelectors(fs.getFileSelectors());
            dfs.setIncludes(newIn.toArray(new String[newIn.size()]));
            dfs.setIncludingEmptyDirectories(fs.isIncludingEmptyDirectories());
            dfs.setPrefix(fs.getPrefix());
            dfs.setStreamTransformer(fs.getStreamTransformer());
            this.delegate.addFileSet(dfs);
        } else {
            this.delegate.addFileSet(fs);
        }
    }

    private boolean acceptFile(File inputFile) {
        if (!Boolean.TRUE.equals(this.inPublicApi.get()) && this.selectors != null) {
            DefaultFileInfo fileInfo = new DefaultFileInfo(inputFile);
            for (FileSelector selector : this.selectors) {
                try {
                    if (selector.isSelected(fileInfo)) continue;
                    return false;
                }
                catch (IOException e) {
                    throw new ArchiverException("Error processing file: " + inputFile + " using selector: " + selector, e);
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addResource(PlexusIoResource resource, String destFileName, int permissions) {
        File file = new File(resource.getName());
        if (this.acceptFile(file)) {
            this.inPublicApi.set(Boolean.TRUE);
            try {
                this.delegate.addResource(resource, this.rootPrefix + destFileName, permissions);
            }
            finally {
                this.inPublicApi.set(null);
            }
        }
    }

    @Override
    public void addResources(PlexusIoResourceCollection resources) {
        this.inPublicApi.set(Boolean.TRUE);
        try {
            this.delegate.addResources(resources);
        }
        finally {
            this.inPublicApi.set(null);
        }
    }

    @Override
    @Nonnull
    public ResourceIterator getResources() {
        return this.delegate.getResources();
    }

    @Override
    public String getDuplicateBehavior() {
        return this.delegate.getDuplicateBehavior();
    }

    @Override
    public void setDuplicateBehavior(String duplicate) {
        this.inPublicApi.set(Boolean.TRUE);
        try {
            this.delegate.setDuplicateBehavior(duplicate);
        }
        finally {
            this.inPublicApi.set(null);
        }
    }

    @Override
    public int getDirectoryMode() {
        return this.delegate.getDirectoryMode();
    }

    @Override
    public void setDirectoryMode(int mode) {
        this.inPublicApi.set(Boolean.TRUE);
        try {
            this.delegate.setDirectoryMode(mode);
        }
        finally {
            this.inPublicApi.set(null);
        }
    }

    @Override
    public int getFileMode() {
        return this.delegate.getFileMode();
    }

    @Override
    public void setFileMode(int mode) {
        this.inPublicApi.set(Boolean.TRUE);
        try {
            this.delegate.setFileMode(mode);
        }
        finally {
            this.inPublicApi.set(null);
        }
    }

    @Override
    public int getOverrideDirectoryMode() {
        return this.delegate.getOverrideDirectoryMode();
    }

    @Override
    public int getOverrideFileMode() {
        return this.delegate.getOverrideFileMode();
    }

    @Override
    public boolean isUseJvmChmod() {
        return this.useJvmChmod;
    }

    @Override
    public void setUseJvmChmod(boolean useJvmChmod) {
        this.useJvmChmod = useJvmChmod;
    }

    @Override
    public boolean isIgnorePermissions() {
        return this.delegate.isIgnorePermissions();
    }

    @Override
    public void setIgnorePermissions(boolean ignorePermissions) {
        this.delegate.setIgnorePermissions(ignorePermissions);
    }

    @Override
    public void setLastModifiedDate(Date lastModifiedDate) {
        this.delegate.setLastModifiedDate(lastModifiedDate);
    }

    @Override
    public Date getLastModifiedDate() {
        return this.delegate.getLastModifiedDate();
    }

    @Override
    public void setFilenameComparator(Comparator<String> filenameComparator) {
        this.delegate.setFilenameComparator(filenameComparator);
    }

    @Override
    public void configureReproducible(Date outputTimestamp) {
        this.delegate.configureReproducible(outputTimestamp);
    }

    @Override
    public void setOverrideUid(int uid) {
        this.delegate.setOverrideUid(uid);
    }

    @Override
    public void setOverrideUserName(String userName) {
        this.delegate.setOverrideUserName(userName);
    }

    @Override
    public int getOverrideUid() {
        return this.delegate.getOverrideUid();
    }

    @Override
    public String getOverrideUserName() {
        return this.delegate.getOverrideUserName();
    }

    @Override
    public void setOverrideGid(int gid) {
        this.delegate.setOverrideGid(gid);
    }

    @Override
    public void setOverrideGroupName(String groupName) {
        this.delegate.setOverrideGroupName(groupName);
    }

    @Override
    public int getOverrideGid() {
        return this.delegate.getOverrideGid();
    }

    @Override
    public String getOverrideGroupName() {
        return this.delegate.getOverrideGroupName();
    }

    private static final class DefaultFileInfo
    implements FileInfo {
        private final File inputFile;

        DefaultFileInfo(File inputFile) {
            this.inputFile = inputFile;
        }

        @Override
        public InputStream getContents() throws IOException {
            return new FileInputStream(this.inputFile);
        }

        @Override
        public String getName() {
            return this.inputFile.getName();
        }

        @Override
        public boolean isDirectory() {
            return this.inputFile.isDirectory();
        }

        @Override
        public boolean isFile() {
            return this.inputFile.isFile();
        }

        @Override
        public boolean isSymbolicLink() {
            return false;
        }
    }
}

